//+------------------------------------------------------------------+
//|                                                         info.mq4 |
//|                                      Copyright  2006, komposter |
//|                                      mailto:komposterius@mail.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, komposter - modified by Ramiro Alonso V2.0"
#property link      "mailto:komposterius@mail.ru"

color lastusedColor = Black;
double lastusedFontSize = 9.0;
string lastusedFont = "Arial";
bool TwoColumns = true;

/////////////////////////////////////////////////////////////////////////////////
// void info_init()
//
// Creation of object to display information
/////////////////////////////////////////////////////////////////////////////////
void info_init(bool Columns)
{
   TwoColumns = Columns;
	for ( int row = 0; row <= 4; row ++ )
	{
		_LabelCreate( StringConcatenate( "InfoLabel_0", row ),   4, 15 + 15*row );
		if(TwoColumns)
		{
		   _LabelCreate( StringConcatenate( "InfoLabel_1", row ), 270, 15 + 15*row );
		}
	}
}

/////////////////////////////////////////////////////////////////////////////////
// void _LabelCreate ( string _Name, int _XDistance, int _YDistance, int _Corner = 0 )
//
// Creation of TextLabel named as _Name.
// Coordinates: x= _XDistance, y= _YDistance, corner = _Corner.
/////////////////////////////////////////////////////////////////////////////////
void _LabelCreate ( string _Name, int _XDistance, int _YDistance, int _Corner = 0 )
{
	int _GetLastError;

	if ( !ObjectCreate( _Name, OBJ_LABEL, 0, 0, 0 ) )
	{
		_GetLastError = GetLastError();
		if ( _GetLastError != 4200 )
		{
			Print( "ObjectCreate( \"", _Name, "\", OBJ_LABEL,0,0,0 ) - Error #", _GetLastError );
			return(-1);
		}
	}
	if ( !ObjectSet( _Name, OBJPROP_CORNER, _Corner ) )
	{
		_GetLastError = GetLastError();
		Print( "ObjectSet( \"", _Name, "\", OBJPROP_CORNER, ", _Corner, 
													" ) - Error #", _GetLastError );
	}
	if ( !ObjectSet( _Name, OBJPROP_XDISTANCE, _XDistance ) )
	{
		_GetLastError = GetLastError();
		Print( "ObjectSet( \"", _Name, "\", OBJPROP_XDISTANCE, ", _XDistance, 
															" ) - Error #", _GetLastError );
	}
	if ( !ObjectSet( _Name, OBJPROP_YDISTANCE, _YDistance ) )
	{
		_GetLastError = GetLastError();
		Print( "ObjectSet( \"", _Name, "\", OBJPROP_YDISTANCE, ", _YDistance, 
															" ) - Error #", _GetLastError );
	}
	if ( !ObjectSetText ( _Name, "", 10 ) )
	{
		_GetLastError = GetLastError();
		Print( "ObjectSetText( \"", _Name, "\", \"\", 10 ) - Error #", _GetLastError );
	}
}

/////////////////////////////////////////////////////////////////////////////////
// void info_deinit()
//
// Deleted of objects created by the info_init() function.
/////////////////////////////////////////////////////////////////////////////////
void info_deinit()
{
	int _GetLastError;
	for ( int row = 0; row <= 4; row ++ )
	{
		if ( !ObjectDelete( StringConcatenate( "InfoLabel_0", row ) ) )
		{
			_GetLastError = GetLastError();
			Print( "ObjectDelete( \"", StringConcatenate( "InfoLabel_0", row ), 
															"\" ) - Error #", _GetLastError );
		}
		if(TwoColumns==true)
		{
		    if ( !ObjectDelete( StringConcatenate( "InfoLabel_1", row ) ) )
		    {
			   _GetLastError = GetLastError();
			   Print( "ObjectDelete( \"", StringConcatenate( "InfoLabel_1", row ), 
															"\" ) - Error #", _GetLastError );
		    }
		}
	}
}

void info( int LabelNumber, string Text, color Color = -1, 
			  double FontSize = -1.0, string Font = "-1" )
{
	//---- Define the object name
	string LabelName;
	if ( LabelNumber < 10 )
		LabelName = StringConcatenate( "InfoLabel_0", LabelNumber );
	else
		LabelName = StringConcatenate( "InfoLabel_" , LabelNumber );

	//---- if the additional parameters were not defined, 
	//---- set the last usded values for them.
	if ( Color < 0 ) Color = lastusedColor;
	if ( FontSize < 0 ) FontSize = lastusedFontSize;
	if ( Font == "-1" ) Font = lastusedFont;

	//---- save the last used values.
	lastusedColor = Color;
	lastusedFontSize = FontSize;
	lastusedFont = Font;

	//---- Display the next text
   if ( !ObjectSetText( LabelName, Text, FontSize, Font, Color ) )
   {
     	int _GetLastError = GetLastError();
	   Print( "ObjectSetText( \"", LabelName,"\", \"", Text, "\", ", FontSize, ", ", Font, 
													", ", Color, " ) - Error #", _GetLastError );
	}
	
	//---- redraw the objects
	ObjectsRedraw();
}

//This final function clear the entire information.
void info_clear()
{
	for ( int n = 0;  n < 5;  n ++ ) info( n, " " );
	if(TwoColumns==true)
	{
	  for (     n = 10; n < 15; n ++ ) info( n, " " );
	}
}