//+------------------------------------------------------------------+
//|                                                          log.mq4 |
//|                                      Copyright  2006, komposter |
//|                                      mailto:komposterius@mail.ru |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, komposter - modified by Ramiro Alonso"
#property link      "mailto:komposterius@mail.ru"

int log_handle = -1;

//+------------------------------------------------------------------+
// void log_open( string ExpertName = "Expert" )
//
// Function that opens the expert's separate log file.
// Directory in wich the file will be created:
// "...\MetaTrader 4\experts\files\logs\ExpertName\"
// The file name is the date of the file record appeared as "YYYY.MM.DD"
//+------------------------------------------------------------------+
void log_open( string ExpertName)
{
	string log_name = "logs\Log_"+ExpertName+" (" + Symbol() + ", " + 
                   strPeriod( Period() ) + ")\Start_"+ TimeToStr( LocalTime(),
                   TIME_DATE ) + ".txt";
	log_handle = FileOpen ( log_name, FILE_READ | FILE_WRITE, " " );
	
	if ( log_handle < 0 )
	{
		int _GetLastError = GetLastError();
		Print( "FileOpen( ", log_name, ", FILE_READ | FILE_WRITE, \" \" ) - Error #", 
																								_GetLastError );
		return(-1);
	}
}
string strPeriod( int intPeriod )
{
	switch ( intPeriod )
	{
		case PERIOD_MN1: return("Monthly");
		case PERIOD_W1:  return("Weekly");
		case PERIOD_D1:  return("Daily");
		case PERIOD_H4:  return("H4");
		case PERIOD_H1:  return("H1");
		case PERIOD_M30: return("M30");
		case PERIOD_M15: return("M15");
		case PERIOD_M5:  return("M5");
		case PERIOD_M1:  return("M1");
		default:		     return("UnknownPeriod");
	}
}

//+------------------------------------------------------------------+
// log_close()
// Function that closes the expert's native log file.
//+------------------------------------------------------------------+
void log_close()
{
	if ( log_handle > 0 ) FileClose( log_handle );
}

//+------------------------------------------------------------------+
// log( string text )
//
// The function that writes the text line into the expert's native log file.
//+------------------------------------------------------------------+
void log( string text )
{
	int _GetLastError = 0;
	
	if ( log_handle < 0 )
	{
		Print( "Log write error! Text: ", text );
		return(-1);
	}
	
	//---- Move the file pointer to the end of file
	if ( !FileSeek ( log_handle, 0, SEEK_END ) )
	{
		_GetLastError = GetLastError();
		Print( "FileSeek ( " + log_handle + ", 0, SEEK_END ) - Error #", _GetLastError );
		return(-1);
	}

	//---- If the line to be written by the expert is not the line feed character, 
   //---- add the recording time at the beginning of the line
	if ( text != "\n" && text != "\r\n" )
		text = StringConcatenate( TimeToStr(LocalTime(),TIME_DATE)," ",
		TimeToStr(LocalTime(),TIME_SECONDS), " - ", text );

	if ( FileWrite ( log_handle, text ) < 0 )
	{
		_GetLastError = GetLastError();
		Print( "FileWrite ( ", log_handle, ", ", text, " ) - Error #", _GetLastError );
		return(-1);
	}
	
	//---- Save the written text on the disk
	FileFlush( log_handle );
}

