; OCRs a quote from oanda ratepanel, fontsize 11, black, all numbers, dot and pipettes
; based on IFalcons code and autoIt-forum
; returns a string

Func _OCRnum($Ax, $Ay, $Dx, $Dy)  
	
	$width = $Dx - $Ax
	$length = $Dy - $Ay
	
	If $width < 1 Then $width = 10		; prevent _OCRnum() from crashing
	If $length < 1 Then $length = 10	; prevent _OCRnum() from crashing
	
	Dim $char[$width][$length]
	
	For $xwidth = 0 To $width - 1
		For $xlength = 0 To $length - 1
			$char[$xwidth][$xlength] = Hex(PixelGetColor($Ax, $Ay), 6)
			$Ay = $Ay + 1
		Next
		$Ax = $Ax + 1
		$Ay = $Ay - $length
	Next

	$p = 1
	Dim $row[$width]
	For $xwidth = 0 To $width - 1
		
		For $xlength = 0 To $length - 1
			If $char[$xwidth][$xlength] = "000000" or $char[$xwidth][$xlength] = "AA2222" Then
				If $p = 1 Then
					$div = $xwidth
					$p += 2
				EndIf
				$x = $xwidth - $div
				$row[$x] +=1
				
			EndIf
			
		Next
	Next
	
	Dim $result
	$xwidth = 0
	While $xwidth <= ($width - 6)
		Select
		Case $row[$xwidth] = 1 And $row[$xwidth+1] = ""
			$result &= "."
			$xwidth += 2
		Case $row[$xwidth] = 1 And $row[$xwidth+1] = 1 And ($row[$xwidth+2] = 8 Or $row[$xwidth+2] = 7)
			$result &= "1"
			$xwidth += 6
		Case $row[$xwidth] = 2 And $row[$xwidth+1] = 3 And $row[$xwidth+2] = 3 And $row[$xwidth+3] = 3 And ($row[$xwidth+4] = 4 Or $row[$xwidth+4] = 3)
			$result &= "2"
			$xwidth += 6
		Case $row[$xwidth] = 2 And $row[$xwidth+1] = 2 And $row[$xwidth+2] = 3 And $row[$xwidth+3] = 3 And ($row[$xwidth+4] = 5 Or $row[$xwidth+4] = 4)
			$result &= "3"
			$xwidth += 6
		Case $row[$xwidth] = 2 And $row[$xwidth+1] = 3 And $row[$xwidth+2] = 2 And $row[$xwidth+3] = 8 And $row[$xwidth+4] = 1
			$result &= "4"
			$xwidth += 6
		Case $row[$xwidth] = 2 And $row[$xwidth+1] = 2 And $row[$xwidth+2] = 2 And $row[$xwidth+3] = 2 And $row[$xwidth+4] = 7 And $row[$xwidth+5] = 1
			$result &= "4"
			$xwidth += 6
		Case $row[$xwidth] = 3 And $row[$xwidth+1] = 4 And $row[$xwidth+2] = 3 And $row[$xwidth+3] = 3 And $row[$xwidth+4] = 4
			$result &= "5"
			$xwidth += 6
		Case ($row[$xwidth] = 6 Or $row[$xwidth] = 5) And $row[$xwidth+1] = 3 And $row[$xwidth+2] = 3 And $row[$xwidth+3] = 3 And ($row[$xwidth+4] = 4 Or $row[$xwidth+4] = 3)
			$result &= "6"
			$xwidth += 6
		Case $row[$xwidth] = 1 And ($row[$xwidth+1] = 4 Or $row[$xwidth+1] = 3) And $row[$xwidth+2] = 3 And $row[$xwidth+3] = 3 And $row[$xwidth+4] = 1
			$result &= "7"
			$xwidth += 6
		Case $row[$xwidth] = 5 And $row[$xwidth+1] = 3 And $row[$xwidth+2] = 3 And $row[$xwidth+3] = 3 And $row[$xwidth+4] = 5
			$result &= "8"
			$xwidth += 6
		Case $row[$xwidth] = 4 And $row[$xwidth+1] = 3 And $row[$xwidth+2] = 3 And $row[$xwidth+3] = 3 And $row[$xwidth+4] = 4
			$result &= "8"
			$xwidth += 6
		Case $row[$xwidth] = 4 And $row[$xwidth+1] = 3 And $row[$xwidth+2] = 3 And $row[$xwidth+3] = 3 And $row[$xwidth+4] = 6
			$result &= "9"
			$xwidth += 6
		Case $row[$xwidth] = 4 And $row[$xwidth+1] = 3 And $row[$xwidth+2] = 3 And $row[$xwidth+3] = 3 And $row[$xwidth+4] = 5
			$result &= "9"
			$xwidth += 6
		Case ($row[$xwidth] = 6 Or $row[$xwidth] = 5) And $row[$xwidth+1] = 2 And $row[$xwidth+2] = 2 And $row[$xwidth+3] = 2 And ($row[$xwidth+4] = 6 Or $row[$xwidth+4] = 5)
			$result &= "0"
			$xwidth += 6
		Case Else
			$xwidth += 1
		EndSelect
	WEnd
	
	Return $result

EndFunc 


Func _OCRpair($Ax, $Ay, $Dx, $Dy)  ; OCRs letters from Oandas pulldownmenu
	
	$width = $Dx - $Ax
	$length = $Dy - $Ay
	
	Dim $char[$width][$length]
	
	For $xwidth = 0 To $width - 1
		For $xlength = 0 To $length - 1
			$char[$xwidth][$xlength] = Hex(PixelGetColor($Ax, $Ay), 6)
			$Ay = $Ay + 1
		Next
		$Ax = $Ax + 1
		$Ay = $Ay - $length
	Next

	$p = 1
	Dim $row[$width]
	For $xwidth = 0 To $width - 1
		
		For $xlength = 0 To $length - 1
			If $char[$xwidth][$xlength] = "000000" or $char[$xwidth][$xlength] = "AA2222" Then
				If $p = 1 Then
					$div = $xwidth
					$p += 2
				EndIf
				$x = $xwidth - $div
				$row[$x] +=1
				
			EndIf
			
		Next
	Next
	
	Dim $result
	$xwidth = 0
	While $xwidth <= ($width - 1)
		Select		
		Case $row[$xwidth] = 7 And $row[$xwidth+1] = 1 And $row[$xwidth+2] = 1 And $row[$xwidth+3] = 1 And $row[$xwidth+4] = 1 And $row[$xwidth+5] = 7
			$result &= "U"
			$xwidth += 7
		Case $row[$xwidth] = 3 And $row[$xwidth+1] = 3 And $row[$xwidth+2] = 3 And $row[$xwidth+3] = 3 And $row[$xwidth+4] = 3 And $row[$xwidth+5] = 3
			$result &= "S"
			$xwidth += 7
		Case $row[$xwidth] = 8 And $row[$xwidth+1] = 2 And $row[$xwidth+2] = 2 And $row[$xwidth+3] = 2 And $row[$xwidth+4] = 2 And $row[$xwidth+5] = 4
			$result &= "D"
			$xwidth += 7
		Case $row[$xwidth] = 2 And $row[$xwidth+1] = 1 And $row[$xwidth+2] = 1 And $row[$xwidth+3] = 7
			$result &= "J"
			$xwidth += 5
		Case $row[$xwidth] = 8 And $row[$xwidth+1] = 2 And $row[$xwidth+2] = 2 And $row[$xwidth+3] = 2 And $row[$xwidth+4] = 3
			$result &= "P"
			$xwidth += 6
		Case $row[$xwidth] = 1 And $row[$xwidth+1] = 2 And $row[$xwidth+2] = 1 And $row[$xwidth+3] = 4 And $row[$xwidth+4] = 1 And $row[$xwidth+5] = 2 And $row[$xwidth+6] = 1
			$result &= "Y"
			$xwidth += 8
		Case $row[$xwidth] = 4 And $row[$xwidth+1] = 2 And $row[$xwidth+2] = 2 And $row[$xwidth+3] = 2 And $row[$xwidth+4] = 3 And $row[$xwidth+5] = 3 And $row[$xwidth+6] = 2
			$result &= "G"
			$xwidth += 8
		Case $row[$xwidth] = 8 And $row[$xwidth+1] = 3 And $row[$xwidth+2] = 3 And $row[$xwidth+3] = 3 And $row[$xwidth+4] = 3 And $row[$xwidth+5] = 5
			$result &= "B"
			$xwidth += 7
		Case $row[$xwidth] = 4 And $row[$xwidth+1] = 2 And $row[$xwidth+2] = 2 And $row[$xwidth+3] = 2 And $row[$xwidth+4] = 2 And $row[$xwidth+5] = 2
			$result &= "C"
			$xwidth += 7
		Case $row[$xwidth] = 8 And $row[$xwidth+1] = 1 And $row[$xwidth+2] = 1 And $row[$xwidth+3] = 1 And $row[$xwidth+4] = 1 And $row[$xwidth+5] = 8
			$result &= "H"
			$xwidth += 7
		Case $row[$xwidth] = 8 And $row[$xwidth+1] = 2 And $row[$xwidth+2] = 2 And $row[$xwidth+3] = 2 And $row[$xwidth+4] = 1
			$result &= "F"
			$xwidth += 6
		Case $row[$xwidth] = 8 And $row[$xwidth+1] = 3 And $row[$xwidth+2] = 3 And $row[$xwidth+3] = 3 And $row[$xwidth+4] = 3
			$result &= "E"
			$xwidth += 6
		Case $row[$xwidth] = 8 And $row[$xwidth+1] = 2 And $row[$xwidth+2] = 2 And $row[$xwidth+3] = 3 And $row[$xwidth+4] = 4 And $row[$xwidth+5] = 3
			$result &= "R"
			$xwidth += 7
		Case Else
			$xwidth += 1
		EndSelect
	WEnd
	
	Return $result
EndFunc 