#cs--------------------------------------------------------------------------------------------------
#
#	FxTradePad 
#
#ce--------------------------------------------------------------------------------------------------

Dim $fxpversion = "0.13"

#include <GUIConstants.au3>
#include <OAOcr4.au3>
#include <misc.au3>
#include <GuiEdit.au3>
#include <GuiTab.au3>
#include <Date.au3>

Opt("WinTitleMatchMode",2)
Opt("MouseCoordMode",0)		

Dim $polltime = 300 ; scan every x ms for new quotes

Dim $qty = "100000"
Dim $acc  = ""
Dim $qsl = "15"
Dim $qtp = "20"
Dim $bid 
Dim $bids = "x.xx"
Dim $bidb = "xx"
Dim $bidp = "x"
Dim $ask 
Dim $asks = "x.xx"
Dim $askb = "xx"
Dim $askp = "x"

Dim $NAV
Dim $bid1
Dim $bid2
Dim $ask1
Dim $ask2

Dim $locked
Dim $aPair
Dim $pair1 = 1

Dim $pr ;percent risk

; _SetupOcrCoordinates() stores coordinates for OCR in these variables

Dim $xBid1=0, $xBid2=0
Dim $xAsk1=0, $xAsk2=0
Dim $xChart1=0, $xChart2=0
Dim $xNAV1=0, $xNAV2=0

Dim $yGBP1=0, $yGBP2=0
Dim $yEUR1=0, $yEUR2=0
Dim $yYEN1=0, $yYEN2=0
Dim $yCHF1=0, $yCHF2=0
Dim $yChart1=0, $yChart2=0
Dim $yNAV1=0, $yNAV2=0

Dim $by, $ay  ; current y coordinates to scan (x-coordinats stay the same always)

#cs------------------------------------------------------------------
#
#  GUI creation
#
#ce------------------------------------------------------------------

;Trade tab
$gui = GUICreate("FxTradePad v" & $fxpversion, 277,140,-1,-1,-1,$WS_EX_TOPMOST)

$tab=GUICtrlCreateTab (0,0, 277,200)

$tab1=GUICtrlCreateTabitem ("Trade")

$buttonsell = GUICtrlCreateButton($bidb, 50, 30, 65, 50)
GUICtrlSetFont($buttonsell, 40)
GuiCtrlSetBkColor($buttonsell, 0x6EC8FF)
$labelbids = GUICtrlCreateLabel($bids, 25, 65)
$labelbidp = GUICtrlCreateLabel($bidp, 117, 29)

$buttonbuy  = GUICtrlCreateButton($askb, 160, 30, 65, 50)
GUICtrlSetFont($buttonbuy, 40)
GuiCtrlSetBkColor($buttonbuy, 0x6EC8FF)
$labelasks = GUICtrlCreateLabel($asks, 135, 65)
$labelaskp = GUICtrlCreateLabel($askp, 227, 29)

$buttonqty1 = GUICtrlCreateButton("1K", 176, 93, 20, 16)
$buttonqty2 = GUICtrlCreateButton("10K", 201, 93, 25, 16)
$buttonqty3 = GUICtrlCreateButton("100K", 231, 93, 35, 16)
$buttonqtyc = GUICtrlCreateButton("CLEAR", 9, 93, 45, 16)

$inputQty = GUICtrlCreateInput($qty, 106, 91, 65, 18, $ES_NUMBER & $ES_CENTER)
GUICtrlCreateLabel("Quantity:", 58, 93)

$cbsl = GUICtrlCreateCheckbox("SL:", 9, 113)
GUICtrlSetState($cbsl, $GUI_CHECKED)
$inputsl = GUICtrlCreateInput($qsl, 48,114, 50, 18, $ES_NUMBER & $ES_CENTER)
GUICtrlCreateUpdown($inputsl)

$cbtp = GUICtrlCreateCheckbox("TP:", 106, 113)
GUICtrlSetState($cbtp, $GUI_CHECKED)
$inputtp = GUICtrlCreateInput($qtp, 146,114, 50, 18, $ES_NUMBER & $ES_CENTER)
GUICtrlCreateUpdown($inputtp)

$buttonlock  = GUICtrlCreateButton("LOCK PAD", 201, 114, 65, 18)

GUICtrlCreateGroup("", 3, 80, 271, 58)

$buttonBid = GUICtrlCreateButton("BID", 3, 46, 43, 18)
$buttonAsk = GUICtrlCreateButton("ASK", 229, 46, 43, 18)

;Pos.Sizing tab
$tabSize=GUICtrlCreateTabitem ("Pos.Sizing")
$cbPS = GUICtrlCreateCheckbox("Use Positionsizing - Percent Risk", 15, 35)
$inputpr = GUICtrlCreateInput($pr, 70,60, 30, 18, $ES_NUMBER & $ES_CENTER)
GUICtrlCreateLabel("Risk", 40, 62)
GUICtrlCreateLabel("percent of NAV per trade", 110, 62)
GUICtrlCreateLabel("Warning: Use with EUR accounts only", 40, 100)
;Log tab
$tab1=GUICtrlCreateTabitem ("Log")
$logedit = GUICtrlCreateEdit("FxTradePad Version " & $fxpversion & @CRLF & @CRLF, 3,25, 270, 112, $ES_MULTILINE+$ES_READONLY+$ES_AUTOVSCROLL+$ES_WANTRETURN+$WS_VSCROLL)

;Setup tab
$tab0=GUICtrlCreateTabitem ("Setup")
$inputacc   = GUICtrlCreateInput($acc, 185, 45, 80, 18, $ES_CENTER)
GUICtrlCreateLabel("Window Title:", 185, 28)

$buttonsave = GUICtrlCreateButton("Save Settings", 185, 105, 80, 25)
$buttonlog = GUICtrlCreateButton("Save Log", 185, 75, 80, 25)
$buttonocr = GUICtrlCreateButton("Setup OCR...", 10, 50, 80, 25)
$inputx1 = GUICtrlCreateInput("10", 50, 80, 30, 18, $ES_NUMBER & $ES_CENTER)
GUICtrlCreateLabel("Start X:", 10, 83)
$inputx2 = GUICtrlCreateInput("60", 50, 105, 30, 18, $ES_NUMBER & $ES_CENTER)
GUICtrlCreateLabel("End X:", 10, 108)
$inputy1 = GUICtrlCreateInput("75", 130, 80, 30, 18, $ES_NUMBER & $ES_CENTER)
GUICtrlCreateLabel("Start Y:", 90, 83)
$inputy2 = GUICtrlCreateInput("600", 130, 105, 30, 18, $ES_NUMBER & $ES_CENTER)
GUICtrlCreateLabel("End Y:", 90, 108)
GUICtrlCreateGroup("OCR", 5, 30, 165, 100)


#cs------------------------------------------------------------------
#
#  Read and set settings from .ini file
#
#ce------------------------------------------------------------------

If FileExists(@ScriptDir & "\FxTradePad.ini") Then
	$file = FileOpen(@ScriptDir & "\FxTradePad.ini", 0)

	GUICtrlSetData($inputsl, FileReadLine($file, 1))
	GUICtrlSetData($inputtp, FileReadLine($file, 2))
	GUICtrlSetState($cbsl, FileReadLine($file, 3))
	GUICtrlSetState($cbtp, FileReadLine($file, 4))
	GUICtrlSetData($inputacc, FileReadLine($file, 5))
	If FileReadLine($file, 6) = 1 Then 
		_Lock ()
	EndIf
	
	$xbid1 = FileReadLine($file, 7)
	$xbid2 = FileReadLine($file, 8)
	$xask1 = FileReadLine($file, 9)
	$xask2 = FileReadLine($file, 10)
	$xChart1 = FileReadLine($file, 11)
	$xChart2 = FileReadLine($file, 12)
	
	$yChart1 = FileReadLine($file, 13)
	$yChart2 = FileReadLine($file, 14)
	$yGBP1 = FileReadLine($file, 15)
	$yGBP2 = FileReadLine($file, 16)
	$yEUR1 = FileReadLine($file, 17)
	$yEUR2 = FileReadLine($file, 18)
	$yYEN1 = FileReadLine($file, 19)
	$yYEN2 = FileReadLine($file, 20)
	$yCHF1 = FileReadLine($file, 21)
	$yCHF2 = FileReadLine($file, 22)
	
	GUICtrlSetData($inputQty, FileReadLine($file, 23))
	
	$xNAV1 = FileReadLine($file, 24)
	$xNAV2 = FileReadLine($file, 25)
	$yNAV1 = FileReadLine($file, 26)
	$yNAV2 = FileReadLine($file, 27)
	
	GUICtrlSetState($cbPS, FileReadLine($file, 28))
	GUICtrlSetData($inputpr, FileReadLine($file, 29))
	
	FileClose($file)
Else
	_PutLog("Init: Cannot find .ini file")
EndIf

#cs------------------------------------------------------------------
#
#  Show GUI
#
#ce------------------------------------------------------------------

GUISetState(@SW_SHOW, $gui)

#cs--------------------------------------------------------------------
#
#  Start scanning for quotes
#
#ce--------------------------------------------------------------------

AdlibEnable("_UpdateQuoteBoard", $polltime)
_PutLog("Scanning at " & $polltime & "ms")

If GUICtrlRead($cbPS) = 1 Then
	_CalcSize()
	_TogglePS()
EndIf

#cs--------------------------------------------------------------------
#
# Main GUI loop
#
#ce--------------------------------------------------------------------

While 1
	$msg = GUIGetMsg()
	Select
		Case $msg = $buttonbuy And _TestOCR() = 1
			_MktBuy()
		Case $msg = $buttonsell And _TestOCR() = 1
			_MktSell()
		Case $msg = $buttonBid And _TestOCR() = 1
			_LimitSell()
		Case $msg = $buttonAsk And _TestOCR() = 1
			_LimitBuy()
		Case $msg = $buttonqty1
			GUICtrlSetData($inputQty, GUICtrlRead($inputQty) + 1000)
		Case $msg = $buttonqty2
			GUICtrlSetData($inputQty, GUICtrlRead($inputQty) + 10000)
		Case $msg = $buttonqty3
			GUICtrlSetData($inputQty, GUICtrlRead($inputQty) + 100000)
		Case $msg = $buttonqtyc
			GUICtrlSetData($inputQty, "0")
		Case $msg = $buttonlock
			_Lock()
		Case $msg = $buttonsave
			_SaveSettings()
		Case $msg = $buttonocr
			$ocr_err = _SetupOcrCoord()
		Case $msg = $buttonlog
			_SaveLog()
		Case $msg = $cbPS
			_TogglePS()
		Case $msg = $inputpr
			If GUICtrlRead($cbPS) = 1 Then
				_CalcSize()
			EndIf
		Case $msg = $inputsl
			If GUICtrlRead($cbPS) = 1 Then
				_CalcSize()
			EndIf
		Case $msg = $GUI_EVENT_CLOSE
			_SaveSettings()
			ExitLoop
	EndSelect
WEnd


#cs--------------------------------------------------------------------
#
#  Checks what chart is active, OCRs the respective bid/ask quotes and 
#  draws the quotes into GUI
#
#ce--------------------------------------------------------------------
Func _UpdateQuoteBoard()
	;$time = TimerInit()	
	_CheckActiveChart()  ; check if user switched to another chart and update OCR coordinates accordingly
	$bid2 = $bid1
	$bid1 = _OCRnum($xBid1, $by, $xBid2, $ay)
	If $bid1 <> $bid2 Then	; only update when rates changed to prevent flickering
		If StringTrimRight($bid1, 6) = 0 Then ; check for USD/CHF
			$bids= StringTrimRight($bid1, 2)
			$bidb= StringMid($bid1, 5, 2)
			$bidp= ""
		Else
			$bids= StringTrimRight($bid1, 3)
			$bidb= StringMid($bid1, 5, 2)
			$bidp= StringTrimLeft($bid1, 6)
		EndIf
		GUICtrlSetData($labelbids, $bids)
		GUICtrlSetData($buttonsell, $bidb)
		GUICtrlSetData($labelbidp, $bidp)
		;GUICtrlSetData($inputasell, $bid1)  ; for testing
	EndIf
	$ask2 = $ask1
	$ask1 = _OCRnum($xAsk1, $by, $xAsk2, $ay)		
	If $ask1 <> $ask2 Then		; only update when rates changed to prevent flickering
		If StringTrimRight($ask1, 6) = 0 Then
			$asks= StringTrimRight($ask1, 2)
			$askb= StringMid($ask1, 5, 2)
			$askp= ""			
		Else	
			$asks= StringTrimRight($ask1, 3)
			$askb= StringMid($ask1, 5, 2)
			$askp= StringTrimLeft($ask1, 6)
		EndIf
		GUICtrlSetData($labelasks, $asks)
		GUICtrlSetData($buttonbuy, $askb)
		GUICtrlSetData($labelaskp, $askp)
		;GUICtrlSetData($inputabuy, $ask1)  ; for testing
	EndIf
	;MsgBox(0, "QuoteBoard", TimerDiff($time))
EndFunc


#cs-------------------------------------------------------------------------------
#
#  Checks what chart is active and sets the coordinates for OCR accordingly
#
#ce-------------------------------------------------------------------------------
Func _CheckActiveChart()  
	;$time = TimerInit()
	$pair = PixelChecksum($xChart1, $yChart1, $xChart2, $yChart2) ; coordinates of the dropdown menu to select charts
	
	If $pair <> $pair1 Then
		Select
			Case $pair = "4004047934"   ; "GBPUSD" found
				$by = $yGBP1				; y-coord above quote 419
				$ay = $yGBP2
				$aPair = "GBP/USD"
			Case $pair = "736488510" 	; "EURUSD" found
				$by = $yEUR1				; y-coord above quote
				$ay = $yEUR2				; y-coord under quote
				$aPair = "EUR/USD"
			Case $pair = "3173132305" 	; "USDJPY" found
				$by = $yYEN1				; y-coord above quote
				$ay = $yYEN2				; y-coord under quote
				$aPair = "USD/JPY"
			Case $pair = "3126857004" 	; "USDCHF" found
				$by = $yCHF1				; y-coord above quote
				$ay = $yCHF2				; y-coord under quote
				$aPair = "USD/CHF"
		EndSelect
		If GUICtrlRead($cbPS) = 1 Then
			_CalcSize()
		EndIf
	EndIf
	$pair1 = $pair
	;MsgBox(0, "Time PixelChecksum", TimerDiff($time))	
EndFunc


#cs-------------------------------------------------------------------------------
#
#  Displays the limit-BUY GUI, populates its listview with items(2 digit quotes),
#  waits for input, calls _Offer() to place the order and returns to the main GUI
#
#ce-------------------------------------------------------------------------------
Func _LimitBuy()
	
	Dim $quote = ""
	
	$dll = DllOpen("user32.dll")
	
	AdlibDisable()
	_Lock()
	GUISetState(@SW_DISABLE, $gui)
	
	$guiBid = GUICreate("",27,300,277, -97, $WS_POPUP+$DS_SETFOREGROUND, $WS_EX_CLIENTEDGE+$WS_EX_TOPMOST+$WS_EX_MDICHILD, $gui)

	$listview = GuiCtrlCreateListView ("col1",0,0,35,400,$LVS_NOCOLUMNHEADER);,$LVS_SORTDESCENDING)
	GuiCtrlSetBkColor($listview, 0x6EC8FF)
	
	$item1=GuiCtrlCreateListViewItem(_FixPipPlus($askb+10),$listview)
	$item2=GuiCtrlCreateListViewItem(_FixPipPlus($askb+9),$listview)
	$item3=GuiCtrlCreateListViewItem(_FixPipPlus($askb+8),$listview)
	$item4=GuiCtrlCreateListViewItem(_FixPipPlus($askb+7),$listview)
	$item5=GuiCtrlCreateListViewItem(_FixPipPlus($askb+6),$listview)
	$item6=GuiCtrlCreateListViewItem(_FixPipPlus($askb+5),$listview)
	$item7=GuiCtrlCreateListViewItem(_FixPipPlus($askb+4),$listview)
	$item8=GuiCtrlCreateListViewItem(_FixPipPlus($askb+3),$listview)
	$item9=GuiCtrlCreateListViewItem(_FixPipPlus($askb+2),$listview)
	$item10=GuiCtrlCreateListViewItem(_FixPipPlus($askb+1),$listview)
	
	$item11=GuiCtrlCreateListViewItem("EX",$listview)
	GuiCtrlSetBkColor($item11, 0xFFFFFF)
		
	$item12=GuiCtrlCreateListViewItem(_FixPipMinus($askb-1),$listview)
	$item13=GuiCtrlCreateListViewItem(_FixPipMinus($askb-2),$listview)
	$item14=GuiCtrlCreateListViewItem(_FixPipMinus($askb-3),$listview)
	$item15=GuiCtrlCreateListViewItem(_FixPipMinus($askb-4),$listview)
	$item16=GuiCtrlCreateListViewItem(_FixPipMinus($askb-5),$listview)
	$item17=GuiCtrlCreateListViewItem(_FixPipMinus($askb-6),$listview)
	$item18=GuiCtrlCreateListViewItem(_FixPipMinus($askb-7),$listview)
	$item19=GuiCtrlCreateListViewItem(_FixPipMinus($askb-8),$listview)
	$item20=GuiCtrlCreateListViewItem(_FixPipMinus($askb-9),$listview)
	$item21=GuiCtrlCreateListViewItem(_FixPipMinus($askb-10),$listview)

	
	GUISetState(@SW_SHOW, $guiBid)
	
	While Not _IsPressed("01", $dll)  ; while no mouse left click
		$msg1 = GUIGetMsg()
		Select
		Case $msg1 = $item1
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.001, ($asks & $askb) + 0.1)
			;MsgBox(0, "Test", _Iif($ask1 < 10, ($asks & $askb) + 0.001, ($asks & $askb) + 0.1))
			ExitLoop
		Case $msg1 = $item2
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.0009, ($asks & $askb) + 0.09)
			ExitLoop
		Case $msg1 = $item3
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.0008, ($asks & $askb) + 0.08)
			ExitLoop
		Case $msg1 = $item4
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.0007, ($asks & $askb) + 0.07)
			ExitLoop
		Case $msg1 = $item5
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.0006, ($asks & $askb) + 0.06)
			ExitLoop
		Case $msg1 = $item6
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.0005, ($asks & $askb) + 0.05)
			ExitLoop
		Case $msg1 = $item7
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.0004, ($asks & $askb) + 0.04)
			ExitLoop
		Case $msg1 = $item8
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.0003, ($asks & $askb) + 0.03)
			ExitLoop
		Case $msg1 = $item9
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.0002, ($asks & $askb) + 0.02)
			ExitLoop
		Case $msg1 = $item10
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.0001, ($asks & $askb) + 0.01)
			ExitLoop

		Case $msg1 = $item11
			$quote = ""
			ExitLoop
			
		Case $msg1 = $item12
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.0001, ($bids & $bidb) - 0.01)
			ExitLoop
		Case $msg1 = $item13
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.0002, ($bids & $bidb) - 0.02)
			ExitLoop
		Case $msg1 = $item14
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.0003, ($bids & $bidb) - 0.03)
			ExitLoop
		Case $msg1 = $item15
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.0004, ($bids & $bidb) - 0.04)
			ExitLoop
		Case $msg1 = $item16
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.0005, ($bids & $bidb) - 0.05)
			ExitLoop
		Case $msg1 = $item17
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.0006, ($bids & $bidb) - 0.06)
			ExitLoop
		Case $msg1 = $item18
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.0007, ($bids & $bidb) - 0.07)
			ExitLoop
		Case $msg1 = $item19
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.0008, ($bids & $bidb) - 0.08)
			ExitLoop
		Case $msg1 = $item20
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.0009, ($bids & $bidb) - 0.09)
			ExitLoop
		Case $msg1 = $item21
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.001, ($bids & $bidb) - 0.10)
			ExitLoop	
		EndSelect
	WEnd
	GUIDelete($guiBid)
	If $quote <> "" Then
		_Offer($quote)
	EndIf
	
	DllClose($dll)
	GUISetState(@SW_ENABLE, $gui)
	_Lock()
	AdlibEnable("_UpdateQuoteBoard", $polltime)
	WinActivate("TradePad")
EndFunc


#cs-------------------------------------------------------------------------------
#
#  Submits a limit-BUY order
#  Parameter is a quote *without* pipettes, i.e. 1.2794 or 117.23
#
#ce-------------------------------------------------------------------------------
Func _Offer($askquote)
	;$time = TimerInit()
	AdlibDisable()
	;$askquote = $quote
	$acc = GUICtrlRead($inputacc)
	If WinExists($acc) Then
		WinActivate($acc)
		WinWaitActive($acc)
		Send("{F4}")
		WinWait("Limit Order")
		If Not WinActive("Limit Order") Then WinActivate("Limit Order")
		WinWaitActive("Limit Order","")
		Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & GUICtrlRead($inputQty))
		MouseClick("left",240,180,1,0)
		Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & $askquote)
		
		MouseClick("left",140,210,1,0) ;bounds
		MouseClick("left",140,235,1,0) ;bounds

		If GUICtrlRead($cbsl) = 1 Then  ; set SL
			MouseClick("left",140,270,1,0)	
			If $ask1 < 10 Then
				$asl=$askquote - (GUICtrlRead($inputsl) / 10000)
				Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & $asl)
			EndIf
			If $ask1 > 50 Then
				$asl=$askquote - (GUICtrlRead($inputsl) / 100)
				Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & $asl)
			EndIf
		EndIf
		If GUICtrlRead($cbtp) == 1 Then ;set TP
			MouseClick("left",140,290,1,0)
			If $ask1 < 10 Then
				$atp=$askquote + (GUICtrlRead($inputtp) / 10000)
				Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & $atp)
			EndIf
			If $ask1 > 50 Then
				$atp=$askquote + (GUICtrlRead($inputtp) / 100)
				Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & $atp)
			EndIf
		EndIf
		MouseClick("left",185,505,1,0) ; submit order 465
	EndIf
	AdlibEnable("_UpdateQuoteBoard", $polltime)
	;MsgBox(0, "MktSell", TimerDiff($time))
EndFunc


#cs-------------------------------------------------------------------------------
#
#  Displays the limit-sell GUI, populates its listview with items(2 digit quotes),
#  waits for input, calls _Bid() to place the order and returns to the main GUI
#
#ce-------------------------------------------------------------------------------
Func _LimitSell()
	
	Dim $quote
	
	$dll = DllOpen("user32.dll")
	
	AdlibDisable()
	_Lock()
	GUISetState(@SW_DISABLE, $gui)
	
	$guiBid = GUICreate("",27,300,-32, -97, $WS_POPUP+$DS_SETFOREGROUND, $WS_EX_CLIENTEDGE+$WS_EX_TOPMOST+$WS_EX_MDICHILD, $gui)

	$listview = GuiCtrlCreateListView ("col1",0,0,35,400,$LVS_NOCOLUMNHEADER);,$LVS_SORTDESCENDING)
	GuiCtrlSetBkColor($listview, 0xFFC86E)
	
	$item1=GuiCtrlCreateListViewItem(_FixPipPlus($bidb+10),$listview)
	$item2=GuiCtrlCreateListViewItem(_FixPipPlus($bidb+9),$listview)
	$item3=GuiCtrlCreateListViewItem(_FixPipPlus($bidb+8),$listview)
	$item4=GuiCtrlCreateListViewItem(_FixPipPlus($bidb+7),$listview)
	$item5=GuiCtrlCreateListViewItem(_FixPipPlus($bidb+6),$listview)
	$item6=GuiCtrlCreateListViewItem(_FixPipPlus($bidb+5),$listview)
	$item7=GuiCtrlCreateListViewItem(_FixPipPlus($bidb+4),$listview)
	$item8=GuiCtrlCreateListViewItem(_FixPipPlus($bidb+3),$listview)
	$item9=GuiCtrlCreateListViewItem(_FixPipPlus($bidb+2),$listview)
	$item10=GuiCtrlCreateListViewItem(_FixPipPlus($bidb+1),$listview)
	
	$item11=GuiCtrlCreateListViewItem("EX",$listview)
	GuiCtrlSetBkColor($item11, 0xFFFFFF)
		
	$item12=GuiCtrlCreateListViewItem(_FixPipMinus($bidb-1),$listview)
	$item13=GuiCtrlCreateListViewItem(_FixPipMinus($bidb-2),$listview)
	$item14=GuiCtrlCreateListViewItem(_FixPipMinus($bidb-3),$listview)
	$item15=GuiCtrlCreateListViewItem(_FixPipMinus($bidb-4),$listview)
	$item16=GuiCtrlCreateListViewItem(_FixPipMinus($bidb-5),$listview)
	$item17=GuiCtrlCreateListViewItem(_FixPipMinus($bidb-6),$listview)
	$item18=GuiCtrlCreateListViewItem(_FixPipMinus($bidb-7),$listview)
	$item19=GuiCtrlCreateListViewItem(_FixPipMinus($bidb-8),$listview)
	$item20=GuiCtrlCreateListViewItem(_FixPipMinus($bidb-9),$listview)
	$item21=GuiCtrlCreateListViewItem(_FixPipMinus($bidb-10),$listview)

	
	GUISetState(@SW_SHOW, $guiBid)
	
	While Not _IsPressed("01", $dll)  ; while no mouse left click
		$msg1 = GUIGetMsg()
		Select
		Case $msg1 = $item1
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.001, ($asks & $askb) + 0.1)
			;MsgBox(0, "Test", _Iif($ask1 < 10, ($asks & $askb) + 0.001, ($asks & $askb) + 0.1))
			ExitLoop
		Case $msg1 = $item2
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.0009, ($asks & $askb) + 0.09)
			ExitLoop
		Case $msg1 = $item3
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.0008, ($asks & $askb) + 0.08)
			ExitLoop
		Case $msg1 = $item4
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.0007, ($asks & $askb) + 0.07)
			ExitLoop
		Case $msg1 = $item5
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.0006, ($asks & $askb) + 0.06)
			ExitLoop
		Case $msg1 = $item6
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.0005, ($asks & $askb) + 0.05)
			ExitLoop
		Case $msg1 = $item7
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.0004, ($asks & $askb) + 0.04)
			ExitLoop
		Case $msg1 = $item8
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.0003, ($asks & $askb) + 0.03)
			ExitLoop
		Case $msg1 = $item9
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.0002, ($asks & $askb) + 0.02)
			ExitLoop
		Case $msg1 = $item10
			$quote = _Iif($ask1 < 10, ($asks & $askb) + 0.0001, ($asks & $askb) + 0.01)
			ExitLoop

		Case $msg1 = $item11
			$quote = ""
			ExitLoop
			
		Case $msg1 = $item12
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.0001, ($bids & $bidb) - 0.01)
			ExitLoop
		Case $msg1 = $item13
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.0002, ($bids & $bidb) - 0.02)
			ExitLoop
		Case $msg1 = $item14
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.0003, ($bids & $bidb) - 0.03)
			ExitLoop
		Case $msg1 = $item15
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.0004, ($bids & $bidb) - 0.04)
			ExitLoop
		Case $msg1 = $item16
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.0005, ($bids & $bidb) - 0.05)
			ExitLoop
		Case $msg1 = $item17
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.0006, ($bids & $bidb) - 0.06)
			ExitLoop
		Case $msg1 = $item18
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.0007, ($bids & $bidb) - 0.07)
			ExitLoop
		Case $msg1 = $item19
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.0008, ($bids & $bidb) - 0.08)
			ExitLoop
		Case $msg1 = $item20
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.0009, ($bids & $bidb) - 0.09)
			ExitLoop
		Case $msg1 = $item21
			$quote = _Iif($ask1 < 10, ($bids & $bidb) - 0.0010, ($bids & $bidb) - 0.10)
			ExitLoop	
		EndSelect
	WEnd
	GUIDelete($guiBid)
	If $quote <> "" Then
		_Bid($quote)
	EndIf
	
	DllClose($dll)
	GUISetState(@SW_ENABLE, $gui)
	_Lock()
	WinActivate("TradePad")
	AdlibEnable("_UpdateQuoteBoard", $polltime)
EndFunc


#cs-------------------------------------------------------------------------------
#
#  Submits a limit-sell order
#  Parameter is a quote *without* pipettes, i.e. 1.2794 or 117.23
#
#ce-------------------------------------------------------------------------------
Func _Bid($bidquote)
	;$time = TimerInit()
	AdlibDisable()
	;$bidquote = StringMid($bid1, 1, 4) & $quote
	;$bidquote = $quote
	$acc = GUICtrlRead($inputacc)
	If WinExists($acc) Then
		WinActivate($acc)
		WinWaitActive($acc)
		Send("{F5}")
		WinWait("Limit Order")
		If Not WinActive("Limit Order") Then WinActivate("Limit Order")
		WinWaitActive("Limit Order","")
		Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & GUICtrlRead($inputQty))	; enter amount
		MouseClick("left",240,180,1,0)
		Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & $bidquote) ; enter price
		
		MouseClick("left",140,210,1,0) ;bounds
		MouseClick("left",140,235,1,0) ;bounds

		If GUICtrlRead($cbsl) = 1 Then  ; set SL
			MouseClick("left",140,270,1,0)	
			If $bid1 < 10 Then
				$asl=$bidquote + (GUICtrlRead($inputsl) / 10000)
				Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & $asl)
			EndIf
			If $bid1 > 50 Then
				$asl=$bidquote + (GUICtrlRead($inputsl) / 100)
				Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & $asl)
			EndIf
		EndIf
		If GUICtrlRead($cbtp) == 1 Then		;set tp
			MouseClick("left",140,290,1,0)
			If $bid1 < 10 Then
				$atp=$bidquote - (GUICtrlRead($inputtp) / 10000)
				Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & $atp)
			EndIf
			If $bid1 > 50 Then
				$atp=$bidquote - (GUICtrlRead($inputtp) / 100)
				Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & $atp)
			EndIf
		EndIf
		MouseClick("left",185,505,1,0) ; submit order 465
	EndIf
	AdlibEnable("_UpdateQuoteBoard", $polltime)
	;MsgBox(0, "MktSell Time", TimerDiff($time))
EndFunc


#cs-------------------------------------------------------------------------------
#
#  Submits a Market-SELL-order
#  Parameter is a quote *without* pipettes, i.e. 1.2794 or 117.23
#
#ce-------------------------------------------------------------------------------
Func _MktSell() ; submits a marketsellorder
	;$time = TimerInit()
	AdlibDisable()
	$acc = GUICtrlRead($inputacc)
	If WinExists($acc) Then
		WinActivate($acc)
		WinWaitActive($acc)
		Send("{F3}")
		
		WinWait("Market Order")
		If Not WinActive("Market Order") Then WinActivate("Market Order")
		WinWaitActive("Market Order","")
		Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & GUICtrlRead($inputQty))
		If GUICtrlRead($cbsl) = 1 Then  ; set SL
			If $bid1 < 10 Then	; check if  not usd/jpy
				MouseClick("left",230,270,1,0)
				$asl=$bid1 + (GUICtrlRead($inputsl) / 10000)
				Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & $asl)
			EndIf
			If $bid1 > 50 Then 	; check if  usd/jpy
				MouseClick("left",230,270,1,0)
				$asl=$bid1 + (GUICtrlRead($inputsl) / 100)
				Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & $asl)
			EndIf
		Else
			MouseClick("left",150,270,1,0) ; turn SL off
		EndIf
		If GUICtrlRead($cbtp) == 1 Then
			If $bid1 < 10 Then	; check if  not usd/jpy
				MouseClick("left",230,300,1,0)
				$atp=$bid1 - (GUICtrlRead($inputtp) / 10000)
				Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & $atp)
			EndIf
			If $bid1 > 50 Then	; check if usd/jpy
				MouseClick("left",230,300,1,0)
				$atp=$bid1 - (GUICtrlRead($inputtp) / 100)
				Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & $atp)
			EndIf
		Else
			MouseClick("left", 150,300,1,0) ; turn off TP
		EndIf
		MouseClick("left",185,505,1,0) ; submit order
	EndIf
	_PutLog("Sold " & $aPair & " @ " & $bid1)
	AdlibEnable("_UpdateQuoteBoard", $polltime)
	;MsgBox(0, "MktSell", TimerDiff($time))
EndFunc

#cs-------------------------------------------------------------------------------
#
#  Submits a Market-BUY-order
#  Parameter is a quote *without* pipettes, i.e. 1.2794 or 117.23
#
#ce-------------------------------------------------------------------------------
Func _MktBuy()
	;$time = TimerInit()
	AdlibDisable()
	$acc = GUICtrlRead($inputacc)
	If WinExists($acc) Then
		WinActivate($acc)
		WinWaitActive($acc)
		Send("{F2}")
		WinWait("Market Order")
		If Not WinActive("Market Order") Then WinActivate("Market Order")
		WinWaitActive("Market Order","")
		Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & GUICtrlRead($inputQty))
		If GUICtrlRead($cbsl) = 1 Then 
			If $ask1 < 10 Then
				MouseClick("left",230,270,1,0)
				$asl=$ask1 - (GUICtrlRead($inputsl) / 10000)
				Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & $asl)
			EndIf
			If $ask1 > 50 Then
				MouseClick("left",230,270,1,0)
				$asl=$ask1 - (GUICtrlRead($inputsl) / 100)
				Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & $asl)
			EndIf
		Else
			MouseClick("left",150,270,1,0)
		EndIf
		If GUICtrlRead($cbtp) == 1 Then
			If $ask1 < 10 Then
				MouseClick("left",230,300,1,0)
				$atp=$ask1 + (GUICtrlRead($inputtp) / 10000)
				Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & $atp)
			EndIf
			If $ask1 > 50 Then
				MouseClick("left",230,300,1,0)
				$atp=$ask1 + (GUICtrlRead($inputtp) / 100)
				Send("{SHIFTDOWN}{HOME}{SHIFTUP}" & $atp)
			EndIf
		Else
			MouseClick("left", 150,300,1,0)
		EndIf
		MouseClick("left",185,505,1,0) ; submit
	EndIf
	_PutLog("Bought " & $aPair & " @ " & $ask1)
	AdlibEnable("_UpdateQuoteBoard", $polltime)
	;MsgBox(0, "MktSell", TimerDiff($time))
EndFunc


#cs-------------------------------------------------------------------------------
#
#  Locks or Unlocks the tradebuttons
#
#ce-------------------------------------------------------------------------------
Func _Lock() ; locks and unlocks the trade-buttons
	Select
		Case $locked = 0
			$locked = 1
			GUICtrlSetState($buttonsell, $GUI_DISABLE)
			GUICtrlSetState($buttonbuy, $GUI_DISABLE)
			GUICtrlSetState($buttonAsk, $GUI_DISABLE)
			GUICtrlSetState($buttonBid, $GUI_DISABLE)
			GUICtrlSetState($buttonqty1, $GUI_DISABLE)
			GUICtrlSetState($buttonqty2, $GUI_DISABLE)
			GUICtrlSetState($buttonqty3, $GUI_DISABLE)
			GUICtrlSetState($buttonqtyc, $GUI_DISABLE)
			GUICtrlSetState($inputQty, $GUI_DISABLE)
			GUICtrlSetState($inputsl, $GUI_DISABLE)
			GUICtrlSetState($cbsl, $GUI_DISABLE)
			GUICtrlSetState($inputtp, $GUI_DISABLE)
			GUICtrlSetState($cbtp, $GUI_DISABLE)
			GUICtrlSetData($buttonlock, "UNLOCK")
			_PutLog("GUI locked")
		Case $locked = 1
			$locked = 0
			GUICtrlSetState($buttonsell, $GUI_ENABLE)
			GUICtrlSetState($buttonbuy, $GUI_ENABLE)
			GUICtrlSetState($buttonAsk, $GUI_ENABLE)
			GUICtrlSetState($buttonBid, $GUI_ENABLE)
			If GUICtrlRead($cbPS) <> 1 Then
				GUICtrlSetState($buttonqty1, $GUI_ENABLE)
				GUICtrlSetState($buttonqty2, $GUI_ENABLE)
				GUICtrlSetState($buttonqty3, $GUI_ENABLE)
				GUICtrlSetState($buttonqtyc, $GUI_ENABLE)
				GUICtrlSetState($inputQty, $GUI_ENABLE)
			EndIf
			GUICtrlSetState($inputsl, $GUI_ENABLE)
			GUICtrlSetState($cbsl, $GUI_ENABLE)
			GUICtrlSetState($inputtp, $GUI_ENABLE)
			GUICtrlSetState($cbtp, $GUI_ENABLE)
			GUICtrlSetData($buttonlock, "LOCK PAD")
			_PutLog("GUI unlocked")
	EndSelect
EndFunc


#cs-------------------------------------------------------------------------------
#
#  fix single-digit quote for Limit-sell/buy
#
#ce-------------------------------------------------------------------------------
Func _FixPipMinus($pip) 
	Dim $res
	Select
		Case $pip < 10 And $pip >= 0
			$res = "0" & $pip
		Case $pip < 0
			$res = 100 + $pip
		Case $pip > 9
			$res = $pip
	EndSelect
	return($res)
EndFunc

Func _FixPipPlus($pip) ;fix single-digit quote for Limit-sell/buy 
	Dim $res
	Select
		Case $pip > 100 And $pip < 110
			$res = "0" & $pip-100
		Case $pip = 100
			$res = "00"
		Case $pip < 10 And $pip >= 0
			$res = "0" & $pip
		Case $pip > 109
			$res = $pip-100
		Case Else 
			$res = $pip
	EndSelect
	return($res)
EndFunc


#cs-------------------------------------------------------------------------------
#
#  Scans Oanda window on startup for the coordinates for OCR
#
#ce-------------------------------------------------------------------------------
Func _SetupOcrCoordinates()			; scans for OCR coordinats on the screen
	;For $x = 10 to 70
		For $y = 75 to 600
			$sum = PixelChecksum(13, $y, 58, $y+9)
			Select
				Case $sum = 2110743562 ; found "account"
					$yChart1 = $y
					$yChart2 = $y + 9
				Case $sum = 577395342 Or $sum = 2663776926 ; found GBPUSD
					$yGBP1 = $y
					$yGBP2 = $y + 9
				Case $sum = 3176333982 Or $sum = 680286862 ; found EURUSD
					$yEUR1 = $y
					$yEUR2 = $y + 9
				Case $sum = 2785316262 Or $sum = 1361457274  ; found USDJPY
					$yYEN1 = $y
					$yYEN2 = $y + 9
				Case $sum = 2442927063 Or $sum = 2885777064  ; found USDCHF
					$yCHF1 = $y
					$yCHF2 = $y + 9
			EndSelect
		Next
	;Next	
	If $yChart1 = 0 Or $yGBP1 = 0 Or $yEUR1 = 0 Or $yYEN1 = 0 Or $yCHF1 = 0 Then  ;  check if everything is found
		;MsgBox(0, "FxTradePad", "Cannot see Oanda's Quotelist!")
		_PutLog("OCR: Cannot find quotelist")
		return(-1)
	Else
		Return(1)
	EndIf
EndFunc

#cs-------------------------------------------------------------------------------
#
#  Scans Oanda window on startup for the coordinates for OCR  *NEW*
#
#ce-------------------------------------------------------------------------------
Func _SetupOcrCoord()

	Local $x = 0
	Local $y = 0
	Local $sum
	Local $x1 = GUICtrlRead($inputx1)
	Local $x2 = GUICtrlRead($inputx2)
	Local $y1 = GUICtrlRead($inputy1)
	Local $y2 = GUICtrlRead($inputy2)

	_PutLog("OCR: Setting up..")
	
	_GUICtrlTabSetCurFocus($tab, 2)
	
	AdlibDisable()
	
	$xBid1 = 0
	$xBid2 = 0
	$xAsk1 = 0
	$xAsk2 = 0
	$xChart1 = 0
	$xChart2 = 0
	
	$yChart1 = 0
	$yChart2 = 0
	$yGBP1 = 0
	$yGBP2 = 0
	$yEUR1 = 0
	$yEUR2 = 0
	$yYEN1 = 0
	$yYEN2 = 0
	$yCHF1 = 0
	$yCHF2 = 0
	
	For $x = $x1 to $x2
		GUICtrlSetData ($logedit, "Scanning x = " & $x & "..", 1)
		For $y = $y1 to $y2
			$sum = PixelChecksum($x, $y, 58, $y+9)
			Select
				Case $sum = 2110743562 ; found "account"
					$yChart1 = $y
					$yChart2 = $y + 9
					$yNAV1 = $y + 79
					$yNAV2 = $y + 89
					_PutLog("found chart & NAV")
				Case $sum = 577395342 Or $sum = 2663776926 ; found GBPUSD
					$yGBP1 = $y
					$yGBP2 = $y + 9
					_PutLog("found gbp")
				Case $sum = 3176333982 Or $sum = 680286862 ; found EURUSD
					$yEUR1 = $y
					$yEUR2 = $y + 9
					_PutLog("found eur")
				Case $sum = 2785316262 Or $sum = 1361457274  ; found USDJPY
					$yYEN1 = $y
					$yYEN2 = $y + 9
					_PutLog("found yen")
				Case $sum = 2442927063 Or $sum = 2885777064  ; found USDCHF
					$yCHF1 = $y
					$yCHF2 = $y + 9
					_PutLog("found chf")
			EndSelect
			If $yChart1 <> 0 And $yGBP1 <> 0 And $yEUR1 <> 0 And $yYEN1 <> 0 And $yCHF1 <> 0 Then
				ExitLoop(2)
			EndIf
		Next
		GUICtrlSetData ($logedit, " Done" & @CRLF, 1)
	Next	
	If $yChart1 = 0 Or $yGBP1 = 0 Or $yEUR1 = 0 Or $yYEN1 = 0 Or $yCHF1 = 0 Then  ;  check if everything is found
		_PutLog("OCR: Setup failed")
		AdlibEnable("_UpdateQuoteBoard", $polltime)
		return(-1)
	Else
		$xBid1 = $x+87
		$xBid2 = $x+127
		$xAsk1 = $x+142
		$xAsk2 = $x+182
		$xChart1 = $x+242
		$xChart2 = $x+287
		$xNAV1 = $x+145
		$xNAV2 = $x+221
		GUICtrlSetData ($logedit, @CRLF, 1)
		_PutLog("OCR: found Charts @ " & $xChart1 & "," & $yChart1)
		_PutLog("OCR: found GBP @    " & $xBid1 & "," & $yGBP1)
		_PutLog("OCR: found EUR @    " & $xBid1 & "," & $yEUR1)
		_PutLog("OCR: found YEN @    " & $xBid1 & "," & $yYEN1)
		_PutLog("OCR: found CHF @    " & $xBid1 & "," & $yCHF1)
		_PutLog("OCR: Setup success")
		AdlibEnable("_UpdateQuoteBoard", $polltime)
		Return(1)
	EndIf
EndFunc

#cs-------------------------------------------------------------------------------
#
#  Saves settings to FxTradePad.ini
#
#ce-------------------------------------------------------------------------------

Func _SaveSettings()
	$file = FileOpen(@ScriptDir & "\FxTradePad.ini", 2)
	If $file = -1 Then
		_PutLog("_SaveSettings: error opening file")
		Return(-1)
	EndIf
	
	FileWriteLine($file, GUICtrlRead($inputsl))
	FileWriteLine($file, GUICtrlRead($inputtp))
	FileWriteLine($file, GUICtrlRead($cbsl))
	FileWriteLine($file, GUICtrlRead($cbtp))
	FileWriteLine($file, GUICtrlRead($inputacc))
	FileWriteLine($file, $locked)
	
	FileWriteLine($file, $xbid1)
	FileWriteLine($file, $xbid2)
	FileWriteLine($file, $xask1)
	FileWriteLine($file, $xask2)
	FileWriteLine($file, $xChart1)
	FileWriteLine($file, $xChart2)
	
	FileWriteLine($file, $yChart1)
	FileWriteLine($file, $yChart2)
	FileWriteLine($file, $yGBP1)
	FileWriteLine($file, $yGBP2)
	FileWriteLine($file, $yEUR1)
	FileWriteLine($file, $yEUR2)
	FileWriteLine($file, $yYEN1)
	FileWriteLine($file, $yYEN2)
	FileWriteLine($file, $yCHF1)
	FileWriteLine($file, $yCHF2)
	
	FileWriteLine($file, GUICtrlRead($inputQty))

	FileWriteLine($file, $xNAV1)
	FileWriteLine($file, $xNAV2)
	FileWriteLine($file, $yNAV1)
	FileWriteLine($file, $yNAV2)
	
	FileWriteLine($file, GUICtrlRead($cbPS))
	FileWriteLine($file, GUICtrlRead($inputpr))

	$err = FileClose($file)
	If $err = 0 Then 
		_PutLog("_SaveSettings: error closing file")
		Return(-1)
	EndIf
	_PutLog("Wrote settings to FxTradePad.ini")
EndFunc

#cs-------------------------------------------------------------------------------
#
#  Test if OCR is currently working
#
#ce-------------------------------------------------------------------------------

Func _TestOCR()
	If StringIsFloat($bid1) <> 1 And StringIsFloat($ask1) <> 1 Then
		return(-1)
	Else
		Return(1)
	EndIf
EndFunc

#cs-------------------------------------------------------------------------------
#
#  Writes text into the log-edit
#
#ce-------------------------------------------------------------------------------

Func _PutLog($text)
	GUICtrlSetData ($logedit, @HOUR & ":" & @MIN & ":" & @SEC & "  " & $text & @CRLF, 1)
	_GUICtrlEditLineScroll($logedit, 0, 1)
EndFunc

#cs-------------------------------------------------------------------------------
#
#  Saves the log to a file
#
#ce-------------------------------------------------------------------------------

Func _SaveLog()
	Local $file
	Local $err
	Local $filename = @YEAR & "." & @MON & "." & @MDAY & "." & @HOUR & "." & @MIN & "." & @SEC & "." & "FxTradePad.log"
	
	$file = FileOpen($filename, 2)
	$err = FileWrite($file, GUICtrlRead($logedit))
	
	If $err = 0 Then
		_PutLog("Error writing log")
	EndIf
	
	FileClose($file)
EndFunc

#cs-------------------------------------------------------------------------------
#
#  Returns the current NAV
#
#ce-------------------------------------------------------------------------------

Func _GetNAV()
	$NAV = _OCRnum($xNAV1, $yNAV1, $xNAV2, $yNAV2)
	;MsgBox(0,0,$NAV & "E")
	If StringIsFloat($NAV) = 1 Then
		Return($NAV)
	Else
		Return(-1)
	EndIf
EndFunc

#cs-------------------------------------------------------------------------------
#
#  Returns amount according to percent risk
#
#ce-------------------------------------------------------------------------------

Func _CalcSize()
	If GUICtrlRead($inputpr) = 0 Or GUICtrlRead($inputpr) = "" Then
		_PutLog("Pos.Sizing: Percent risk input is zero")
		Return(-1)
	EndIf
	If GUICtrlRead($inputsl) = 0 Or GUICtrlRead($inputsl) = "" Then
		_PutLog("Pos.Sizing: Stop-loss input is zero")
		Return(-1)
	EndIf

	Local $NAVinUSD = _GetNAV() * _OCRnum($xbid1, $yEUR1, $xbid2, $yEUR2)
	Local $riskInUSD = ($NAVinUSD/100) * GUICtrlRead($inputpr)
	Local $pipvalue = 0
	
	Select
		Case $aPair = "EUR/USD" Or $aPair = "GBP/USD"
			$pipvalue = 10
			$quantity = Floor(($riskInUSD / (GUICtrlRead($inputsl) * $pipvalue)) * 100000)
			;MsgBox(0,0,"NAVinUSD: " & $NAVinUSD & @CRLF & "RiskInUSD: " & $riskInUSD & @CRLF & "Amount: " & $quantity)
			;Return($quantity)
			GUICtrlSetData($inputQty, $quantity)
		Case $aPair = "USD/JPY"
			$pipvalue = 1000 / _OCRnum($xbid1, $yYEN1, $xbid2, $yYEN2)
			$quantity = Floor(($riskInUSD / (GUICtrlRead($inputsl) * $pipvalue)) * 100000)
			;MsgBox(0,0,"NAVinUSD: " & $NAVinUSD & @CRLF & "RiskInUSD: " & $riskInUSD & @CRLF & "Amount: " & $quantity & @CRLF & "pipvalue: " & $pipvalue)
			;Return($quantity)
			GUICtrlSetData($inputQty, $quantity)
		Case $aPair = "USD/CHF"
			$pipvalue = 10 / _OCRnum($xBid1, $yCHF1, $xBid2, $yCHF2)
			$quantity = Floor(($riskInUSD / (GUICtrlRead($inputsl) * $pipvalue)) * 100000)
			;MsgBox(0,0,"NAVinUSD: " & $NAVinUSD & @CRLF & "RiskInUSD: " & $riskInUSD & @CRLF & "Amount: " & $quantity & @CRLF & "pipvalue: " & $pipvalue)
			;Return($quantity)
			GUICtrlSetData($inputQty, $quantity)
		Case Else
			_PutLog("Pos.Sizing: Cannot determine actual Chart")
			Return(-1)
	EndSelect
EndFunc

Func _TogglePS()
	Select
		Case GUICtrlRead($cbPS) = 1
			GUICtrlSetState($buttonqty1, $GUI_DISABLE)
			GUICtrlSetState($buttonqty2, $GUI_DISABLE)
			GUICtrlSetState($buttonqty3, $GUI_DISABLE)
			GUICtrlSetState($buttonqtyc, $GUI_DISABLE)
			GUICtrlSetState($inputQty, $GUI_DISABLE)
			_CalcSize()
		Case GUICtrlRead($cbPS) <> 1
			GUICtrlSetState($buttonqty1, $GUI_ENABLE)
			GUICtrlSetState($buttonqty2, $GUI_ENABLE)
			GUICtrlSetState($buttonqty3, $GUI_ENABLE)
			GUICtrlSetState($buttonqtyc, $GUI_ENABLE)
			GUICtrlSetState($inputQty, $GUI_ENABLE)
	EndSelect
EndFunc

; for testing only

Func _PixelCheck()
	$sum = PixelChecksum(13, 452, 58, 461)
	MsgBox(0, "Checksum", $sum)
EndFunc

Func _testOCRtime()
	AdlibDisable()
	$time = TimerInit()
	$bid1 = _OCRnum($xBid1, $by, $xBid2, $ay)
	$ask1 = _OCRnum($xAsk1, $by, $xAsk2, $ay)
	MsgBox(0, "QuoteBoard", TimerDiff($time))
	AdlibEnable("_UpdateQuoteBoard", $polltime)
EndFunc


;Func _UpdatePairCoordinates()	; Checks what chart is active and sets the coordinates for OCR accordingly
;	;$time = TimerInit()
;	$pair = _OCRpair("255", "223", "300", "232")
;	Select
;		Case $pair = "GBPUSD" ; "4004047934"
;			$by = 419
;			$ay = 432
;		Case $pair = "EURUSD" ; "736488510"
;			$by = 437
;			$ay = 446
;		Case $pair = "USDJPY" ; "3173132305"
;			$by = 452
;			$ay = 461
;		Case $pair = "USDCHF" ; "3126857004"
;			$by = 467
;			$ay = 476
;	EndSelect
;	;$timedif = TimerDiff($time)
;	;MsgBox(0, "Time PixelChecksum", $timedif)	
;EndFunc



; TO-DO
;
; Error handles
; Performance


; BUGS
; OCR crasht abundzu