home = "#{ENV['HOMEDRIVE']}" + "#{ENV['HOMEPATH']}" + "\\Desktop"  #HomePfade

## Konstanten##
AusgangsDatei = "input.htm" # Name der AusgangsDatei
ZielDatei = "output.csv" # Name der Zieldatei
TRENNZEICHEN = ';'

## sonstiges##
pfadAusgangsDatei = home + "\\" + AusgangsDatei # Pfade + Dateiname
pfadZielDatei = home + "\\" + ZielDatei # Pfade + Dateiname


file = File.open(pfadAusgangsDatei)

rohtext = Array.new # von der html datei werden alle zeilen eingelesen
filter1 = Array.new # hier werden nur die Zeilen mit den Transaktionen aufgefhrt >> immer nohc in HTML-Tabellenform / ohne AnfangsTags...


### raw script  ###
file.each do |line|
  rohtext << line
end
file.close



### filter1 ##  ###########################################
# Ready: Table Rows extracted >>   <tr bgc..>...</tr>  for each Row                                        #
#####################################################
def filterEins(rohtext) 
  @istData = false       # Abfrage ob es sich den Tabellenbereich handelt
  @isRowSet = false    # wird auf true gesetzt wenn Daten einer Transaktion zusammengefat werden sollen
  test = ''
  
  infilter1 = Array.new
  
  rohtext.each do |line|
    
    # Abfrage ob es sich den Tabellenbereich handelt
    if(line.include? '<table')
      @isData = true
    end
    
    if(line.include?'</table>') 
      @isData = false
    end
    
    
    if(@isData)
      infilter1 << line.chomp.gsub('&nbsp;',' ').gsub('&auml;ndern','aendern').gsub('schlie&szlig;en','schliessen').gsub('ausgef&uuml;hrt','ausgefuehrt')
    end
    
  end
  

  x = infilter1.join.split('<tr')
  x.delete_if {|c| c.include? "table"}
  
  x.each_index do|c| 
    x[c] =  "<tr" + x[c]
  end 
  
  infilter1 = x
  
  return infilter1
  
end


filter1 = filterEins(rohtext)



###TableCleaner###########################################
#  lscht die HTML-TabellenTags                                                                                   #
#####################################################
def tableLineCleaner(before)
  
  tableLine = Array.new # enspricht Spter die jeweilige Zeile in der csv-Datei
  sonstiges = Array.new  # alles ws 'Margin ndern' 'Geld' ect im Stamm enthlt wird hier reingeschoben: Einzahlungen, Zinsen, ect...
  
  before.each do |line|
    a = ''
    
    
    
    ##  Wenn in den Tags 'balance' auftaucht wird die geanze Zeile dem Array balance bergeben
    if(line.include? 'Margin' or line.include? 'Zinsen' or line.include? 'Geld') 
      sonstiges << line      
      next
    end
    
    line.slice!(line.index('<')..line.index('>'))
    
    # Ticket
    a << line.slice!(line.index('>')+1..line.index('<', 10)-1) + TRENNZEICHEN
    
    line.slice!(0..line.index('<', 50 ))
    
    # Date Time
    a << line.slice!(line.index('>')+1..line.index('<', 25)-1).strip + TRENNZEICHEN
    
    line.slice!(0..line.index('duration'))
    
    # Dauer >> wird nicht gespeichert
    #a << line.slice!(line.index('>')+1..line.index('<')-1).strip + TRENNZEICHEN
    
    line.slice!(0..line.index('transaction'))
    
    # Transaction
    a << line.slice!(line.index('>')+1..line.index('<')-1).strip + TRENNZEICHEN
    
    line.slice!(0..line.index('pair'))
    
    # pair
    a << line.slice!(line.index('>')+1..line.index('<')-1).strip + TRENNZEICHEN
    
    line.slice!(0..line.index('price'))
    
    # Price
    a << line.slice!(line.index('>')+1..line.index('<')-1).strip + TRENNZEICHEN
   
    
    line.slice!(0..line.index('units'))
    
    # 
    a << line.slice!(line.index('>')+1..line.index('<')-1).strip + TRENNZEICHEN


    line.slice!(0..line.index('stop_loss'))
    
    # 
    a << line.slice!(line.index('>')+1..line.index('<')-1).strip + TRENNZEICHEN
    
    
    line.slice!(0..line.index('take_profit'))
    
    # 
    a << line.slice!(line.index('>')+1..line.index('<')-1).strip + TRENNZEICHEN


    line.slice!(0..line.index('tran_link'))
    
    if(line.include? 'hilite')
      line.slice!(0..line.index('hilite'))
    end
    
    
    #####################
    #puts line
    #####################
    # 
    a << line.slice!(line.index('>')+1..line.index('<')-1).strip + TRENNZEICHEN
    
    line.slice!(0..line.index('lower_bound'))
    
    # 
    a << line.slice!(line.index('>')+1..line.index('<')-1).strip + TRENNZEICHEN

    line.slice!(0..line.index('upper_bound'))
    
    # 
    a << line.slice!(line.index('>')+1..line.index('<')-1).strip + TRENNZEICHEN
    
    line.slice!(0..line.index('interest'))
    
    # 
    a << line.slice!(line.index('>')+1..line.index('<')-1).strip + TRENNZEICHEN

    line.slice!(0..line.index('pl'))
    
    # 
    a << line.slice!(line.index('>')+1..line.index('<')-1).strip + TRENNZEICHEN
    


    line.slice!(0..line.index('amount'))
    line.slice!(0..line.index('span'))
    
    #
    a << line.slice!(line.index('>')+1..line.index('<')-1).strip + TRENNZEICHEN
    
   
    line.slice!(0..line.index('balance'))
    
    

    # 
    a << line.slice!(line.index('>')+1..line.index('<')-1).strip
    
    tableLine << a
    
  end
  
  
  
  return tableLine
end

output = tableLineCleaner(filter1)




###TradeSequenzer#########################################
#  fgt die Trades zusammen                                                                                          #
#####################################################
def tradeSequenzer(before)
  
  
  # wenn kein TransaktionLink gesetzt wurde dann wird Trade gelogt >> sollte viel zu kompliziert werden
  # besser ist zu achten, wann Profit einen Wert ausweist, dann wird Trade gesetzt und wg der Dauer wird in der historie zurck gegangen bis TransaktionLink
  # mit Ticketnummer  berein stimmt  >> sollte auch von der Performance ok sein
  #

  hilfsDatenZeit = Hash.new
  hilfsDatenTrans =  Hash.new
  hilfsDatenPreis =  Hash.new
  tradeList = Array.new
  laufendeNR = 0
  
  # erste Zeile, die Beschriftung
  tradeList << ('Nr.' + TRENNZEICHEN + 'Info' + TRENNZEICHEN + 'OpenTime' + TRENNZEICHEN + 'Type' + TRENNZEICHEN + 'Size' + TRENNZEICHEN + 'Item' + TRENNZEICHEN + 'Price' + TRENNZEICHEN + 'SL' + TRENNZEICHEN + 'TP' + TRENNZEICHEN + 'CloseTime' + TRENNZEICHEN + 'Price' + TRENNZEICHEN + 'Taxes' + TRENNZEICHEN + 'Profit' + TRENNZEICHEN + 'Account'+ TRENNZEICHEN + 'G=1 V=-1 BE=0' + TRENNZEICHEN + 'Pips_Punkte' + TRENNZEICHEN + 'Time')
  
  
  before.each_index do |line|
    
    trade = Array.new
    
    a = before[line].split(TRENNZEICHEN)
    key =  a[0]
    
    hilfsDatenZeit[key] = a[1]
    hilfsDatenTrans[key] = a[2]
    hilfsDatenPreis[key] = a[4]
    
    if( (a[12].to_f + a[11].to_f)==a[13].to_f and a[13] != '' )
      
      
      ### laufende NR. #######################################
      laufendeNR = laufendeNR + 1
      trade << laufendeNR
      
      ### Info  ###########################################
      
      trans = a[2]
      if(trans == 'Stopp-Loss')
        info = '[sl]'
      elsif(trans == 'Take-Profit')
        info = '[tp]'
      else
        info = '-'
      end
      
      trade << info
      
      
      
      #trade << a[0]  # Ticket
      
      ### DatumZeit ########################################
      data1 = hilfsDatenZeit[a[8]]  # DatumZeitEinstieg
      
      tag = data1.slice((data1.index(':')-6 )..(data1.index(':')-4))
      mon = data1.slice(0..(data1.index(':')-7)).strip
      jahr = data1.slice((data1.index(':')+7 )..(data1.index(':')+11))
      
      name = {'January' => 1, 'February' => 2, 'March' => 3, 'May' => 5, 'June' => 6, 'July' => 7, 'October' => 10, 'December' => 12, 'Januar' => 1, 'Februar' => 2, 'M' => 3, 'April' =>4, 'Mai' => 5, 'Juni' => 6, 'Juli' => 7, 'August' => 8, 'September' => 9, 'Oktober' => 10, 'November' => 11, 'Dezember' => 12 }
      
      mon = name[mon]
      if(mon.to_i  < 10)
        if(tag.to_i < 10)
          datum = '0' + tag.to_i.to_s + '.' + '0' + mon.to_s + '.' + jahr.to_s
        else
          datum = tag.to_i.to_s + '.' + '0' + mon.to_s + '.' + jahr.to_s
        end
      else
        if(tag.to_i  < 10)
          datum = '0' + tag.to_i.to_s + '.' + mon.to_s + '.' + jahr.to_s
        else
          datum = tag.to_i.to_s + '.' + mon.to_s + '.' + jahr.to_s
        end
      end
      
      zeit = data1.slice((data1.index(':')-2 )..(data1.index(':')+5))
      
      tradeOpen = datum + ' ' + zeit
      trade << tradeOpen
      
      
      ### BuySell ########################################
      type = ''
      tradeIN = hilfsDatenPreis[a[8]].sub(',','').sub('.','').to_i   # EinstigsPreis
      tradeOUT = a[4].sub(',','').sub('.','').to_i  # AusstiegsPreis
      tradePL = a[13].sub(',','').sub('.','').to_i  # GewinnVerlust
      
      
      
      if(tradeIN<tradeOUT) #LongGewinn und ShortVerlust
        if(tradePL>0) # LongGewinn
          type = 'long'
        else # ShortVerlust
          type = 'short'
        end
      else #ShortGewinn und LongVerlust
        if(tradePL>0) #ShortGewinn   >> Stimmt
          type = 'short'
        else # LongVerlust
          type = 'long'
        end
      end
      
      trade << type 
      
      
      ###       ############################################
      trade << a[5].sub(',','')  #Stckzahl
      trade << a[3].sub(',','').sub('.',',')  # Basiswert
      trade << hilfsDatenPreis[a[8]].sub(',','').sub('.',',')  # EinstigsPreis
      trade << a[6].sub(',','').sub('.',',')  # StoppLoss
      trade << a[7].sub(',','').sub('.',',')  # TakeProfit
      
      
      ### DatumZeit ########################################
      data1 =  a[1]  # DatumZeitAusstieg
      
      tag = data1.slice((data1.index(':')-6 )..(data1.index(':')-4))
      mon = data1.slice(0..(data1.index(':')-7)).strip
      jahr = data1.slice((data1.index(':')+7 )..(data1.index(':')+11))
      
      mon = name[mon]
      if(mon.to_i  < 10)
        if(tag.to_i < 10)
          datum = '0' + tag.to_i.to_s + '.' + '0' + mon.to_s + '.' + jahr.to_s
        else
          datum = tag.to_i.to_s + '.' + '0' + mon.to_s + '.' + jahr.to_s
        end
      else
        if(tag.to_i  < 10)
          datum = '0' + tag.to_i.to_s + '.' + mon.to_s + '.' + jahr.to_s
        else
          datum = tag.to_i.to_s + '.' + mon.to_s + '.' + jahr.to_s
        end
      end
      
      zeit = data1.slice((data1.index(':')-2 )..(data1.index(':')+5))
      tradeClose = datum + ' ' + zeit
      trade << tradeClose
      
      
      ###       ############################################
      trade << a[4].sub(',','').sub('.',',')  # AusstiegsPreis
      trade << a[11].sub('.',',')  # Finanzierung
      trade << a[13].sub(',','').sub('.',',')  # GewinnVerlust
      trade << a[14].sub(',','').sub('.',',')  # Kontostand
      
      
      #######Status G=1 V=-1 BE=0  #####################################################
      #  Status ist bei einem GewinnTrade 1  bei einem VerlustTrade -1  und bei einem BreackEvenTrade 0         
      profit = a[13].sub(',','').sub('.','').to_i
      if(profit > 0)
        status = 1
      elsif(profit < 0)
        status = -1
      else
        status = 0
      end
      
      trade << status
      
      ######  pips:  ################################################################
      # pips: wieviel pips/punkte wurden gemacht                                                                                    
      pips = 0
      tradeIN = hilfsDatenPreis[a[8]].sub(',','').to_f   # EinstigsPreis
      tradeOUT = a[4].sub(',','').to_f  # AusstiegsPreis
      
      if(status = 1)
        if(type == 'long')
          pips = tradeOUT - tradeIN
        elsif(type == 'short')
          pips = tradeIN - tradeOUT
        else
          pips = '???'
        end
      elsif(status = - 1)
        if(type == 'long')
          pips = tradeOUT - tradeIN
        elsif(type == 'short')
          pips = tradeIN - tradeOUT
        else
          pips ='???'
        end
      else
        pips = '0'
      end
      
      pips = (pips*100000).round.to_f/100000
      
      basiswert = a[3].sub(',','').sub('.',',')  # Basiswert
      if(basiswert.include?('/'))
        #Whrung
        if( a[4].sub(',','').sub('.',',').to_f<50 ) # filtert  EURJPY und USDJPY raus
          zzz = pips.to_f*10000
        else
          zzz = pips.to_f*100
        end
      else
        #Indizes
        zzz = pips.to_f
        
      end
      pips = zzz
      
      trade << pips.to_s.sub('.',',')
      
      
      ######  zeitOpen:  #######################################################################
      ## zeitOpen:  wie lang war die Position offen?  zwei TimeObjekte werden erstellt und '08.05.2008 19:48'  im Stile   2008  05  08  19  48 bergeben
      
      c = tradeOpen 
      d = tradeClose
     
      s1 =  c[6..9].to_i
      s2 =  c[3..4].to_i
      s3 =  c[0..1].to_i
      s4 =  c[11..12].to_i
      s5 =  c[14..15].to_i
      
      t1 =  d[6..9].to_i
      t2 =  d[3..4].to_i
      t3 =  d[0..1].to_i
      t4 =  d[11..12].to_i
      t5 =  d[14..15].to_i
      
      
      tOpen = DateTime.new(s1, s2, s3, s4, s5)
      tCloce = DateTime.new(t1, t2, t3, t4, t5)
      
      delta = (tCloce - tOpen) * 1440 # Differenz wird in Tagen angegeben daher mal 1440 (Minuten pro Tag)
      
      #ist die Dauer unter einer Minute wrde das Script 0 ausgeben >> auf eine Minute aufgerundet
      if(delta==0)
        delta = 1
      end
      
      trade << delta.to_s
      
      
      ############################################################
      tradeList << trade.join(';')
    end
    
    
  
  end
  
  return tradeList
end


tradeSequenze = tradeSequenzer(output)




### makeCSV#############################################
### speichert die Datei ab                                                                                           #
#####################################################
def makeCSV(text, dateiPfad)

  if File.exist?(dateiPfad)
    ex = "Datei ist da..."
    zielDatei = File.open(dateiPfad, "w")
  else
    ex = "Datei fehlt..."
    zielDatei = File.new(dateiPfad, "w")
  end  
  
  zielDatei.puts text
  zielDatei.close

end



makeCSV(tradeSequenze, pfadZielDatei)

