//+------------------------------------------------------------------+
//|                                                  RSI_to_File.mq4 |
//|                      Copyright  2007, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.ru/ |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.ru/"

#property show_inputs
string SymbolsArray[3]={"","EURUSD","EURJPY"};
IndicatorDigits(Digits+5);
 
//+------------------------------------------------------------------+
//| string SymbolByNumber                                            |
//+------------------------------------------------------------------+
string GetSymbolString(int Number)
  {
//----
   string res="";
   res=SymbolsArray[Number];   
//----
   return(res);
  }

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int PeriodNumber(int number)
   {
   int per_min;
   switch (number)
      {
      //case 0: per_min=PERIOD_M1;break;
      //case 1: per_min=PERIOD_M5;break;
      //case 2: per_min=PERIOD_M15;break;
      //case 3: per_min=PERIOD_M30;break;
      //case 4: per_min=PERIOD_H1;break;
      //case 5: per_min=PERIOD_H4;break;
      case 6: per_min=PERIOD_D1;break;
      default: per_min=PERIOD_D1;break;
      }
   return(per_min);   
   }

//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
void RSI_output(string SymbolName,int PeriodMinutes)
   {
   int size=iBars(SymbolName,PeriodMinutes);
//----
   if (size==0) return;
   int handle=FileOpen(SymbolName+PeriodMinutes+"_RSI.csv",FILE_WRITE|FILE_CSV);
   if (handle<0) return;
   FileWrite(handle,"Time seconds;Time;Open;Low;High;Close;Volume;RSI;ATR;ADX;+DI;-DI;5MA;13MA;25MA;50MA;100MA;150MA;200MA;Stoch-Main;Stoch-Signal;CCI;MACD-Main;MACD-Signal");
   for (int i=size-1;i>=0;i--)
      {
      FileWrite(handle,iTime(SymbolName,PeriodMinutes,i),TimeToStr(iTime(SymbolName,PeriodMinutes,i))
         ,iOpen(SymbolName,PeriodMinutes,i),iLow(SymbolName,PeriodMinutes,i),iHigh(SymbolName,PeriodMinutes,i)
         ,iClose(SymbolName,PeriodMinutes,i),iVolume(SymbolName,PeriodMinutes,i),iCustom(SymbolName,PeriodMinutes,"RSI",0,i),iATR(SymbolName,PeriodMinutes,14,i)
         ,iADX(SymbolName,PeriodMinutes,16,PRICE_CLOSE,MODE_MAIN,i),iADX(SymbolName,PeriodMinutes,16,PRICE_CLOSE,MODE_PLUSDI,i)
         ,iADX(SymbolName,PeriodMinutes,16,PRICE_CLOSE,MODE_MINUSDI,i),iMA(SymbolName,PeriodMinutes,5,0,MODE_EMA,PRICE_CLOSE,i)
         ,iMA(SymbolName,PeriodMinutes,13,0,MODE_EMA,PRICE_CLOSE,i),iMA(SymbolName,PeriodMinutes,25,0,MODE_EMA,PRICE_CLOSE,i)
         ,iMA(SymbolName,PeriodMinutes,50,0,MODE_EMA,PRICE_CLOSE,i),iMA(SymbolName,PeriodMinutes,100,0,MODE_EMA,PRICE_CLOSE,i)
         ,iMA(SymbolName,PeriodMinutes,150,0,MODE_EMA,PRICE_CLOSE,i),iMA(SymbolName,PeriodMinutes,200,0,MODE_EMA,PRICE_CLOSE,i)
         ,iCustom(SymbolName,PeriodMinutes,"Stochastic",15,7,9,MODE_EMA,PRICE_CLOSE,MODE_MAIN,i)
         ,iCustom(SymbolName,PeriodMinutes,"Stochastic",15,7,9,MODE_EMA,PRICE_CLOSE,MODE_SIGNAL,i)
         ,iCustom(SymbolName,PeriodMinutes,"CCI",14,PRICE_CLOSE,MODE_MAIN,i),iCustom(SymbolName,PeriodMinutes,"Zero Lag MACD",12,24,9,PRICE_CLOSE,MODE_MAIN,i)
         ,iCustom(SymbolName,PeriodMinutes,"Zero Lag MACD",12,24,9,PRICE_CLOSE,MODE_SIGNAL,i));
      }
   FileClose(handle);      
//----
   return;
   }
//+------------------------------------------------------------------+
//| script program start function                                    |
//+------------------------------------------------------------------+
int start()
  {
  int SymbolCounter,PeriodCounter; 
//----
   for (SymbolCounter=1;SymbolCounter<13;SymbolCounter++)
      {
      for (PeriodCounter=2;PeriodCounter<=6;PeriodCounter++)
         {
         //Print("NewBar on ",GetSymbolString(SymbolCounter),PeriodNumber(PeriodCounter),"M");
         RSI_output(GetSymbolString(SymbolCounter),PeriodNumber(PeriodCounter));
         }
      }
   
//----
   return(0);
  }
//+------------------------------------------------------------------+