//+------------------------------------------------------------------+
//|                                               Export_history.mq4 |
//|                      Copyright  2007, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"
#property show_inputs
extern   datetime   FromDateTime    = D'2011.06.16 00:00';
extern   datetime   ThruDateTime    = D'2019.12.31 00:00';
//+------------------------------------------------------------------+
//| script program start function                                    |
//+------------------------------------------------------------------+
int start()
  {
// Repeat the following line of code for each currency pair and timeframe, and then press F5 to recompile (or restart MT4)
// First parameter must be a valid currency pair, e.g. GBPUSD
// Second parameter must be valid timeframe, i.e. one of 1, 5, 15, 30, 60 (=H1), 240 (=H4), 1440 (daily), 10080 (weekly), 43200 (monthly) 
// To use the currently displayed chart: Export(Symbol(),Period());
  Export("EURUSD",1);  // This will produce 1 minute history for EURUSD
  Export("GBPUSD",1); 
//input more pairs here  

//  
  return(0);
  }
//  
int Export(string pair, int tf)
{
  string fname = pair + /*"," + tf +*/ ".csv";
 
  //string fname = "TF-1" + tf + "\\" + pair + "," + tf + ".csv";  // change to output to different folders
  int handle = FileOpen(fname, FILE_CSV|FILE_WRITE, ",");
  if(handle>0)
    {
     //FileWrite(handle,"Date,Time,Open,Low,High,Close,Volume");    // header
     //for(int i=0; i<iBars(pair,tf); i++) //change to reverse date output
     for(int i=iBars(pair,tf)-1; i>=0; i--)
       {
       datetime dtval = iTime(pair,tf,i);
       if (dtval < FromDateTime || dtval > ThruDateTime)   continue;
       string date1 = TimeToStr(iTime(pair,tf,i),TIME_DATE);
       date1 = StringSubstr(date1,0,4) + "." + StringSubstr(date1,5,2) + "." + StringSubstr(date1,8,2) ;
       string time1 = TimeToStr(iTime(pair,tf,i),TIME_MINUTES);
       FileWrite(handle, pair, date1, time1, iOpen(pair,tf,i), iHigh(pair,tf,i), iLow(pair,tf,i), iClose(pair,tf,i), iVolume(pair,tf,i) );
       }
     FileClose(handle);
     Comment("History export complete");
    }
//----
   return(0);
  }

