//+------------------------------------------------------------------+
//|                                             weekly_open_line.mq4 |
//|                      Copyright  2010, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2010, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"

#property indicator_chart_window
#property indicator_buffers 4
#property indicator_color1 Green
#property indicator_color2 Red
#property indicator_color3 Blue
#property indicator_color4 Orange


//---- input parameters
//---- buffers
extern bool M30=false;
extern bool Hourly=true;
extern bool Hourly4=false;
extern bool Daily=false;
extern bool Weekly=false;
extern bool Monthly=false;

double PrevHiBuffer[];
double PrevLoBuffer[];
double PrevMidBuffer[];
double NowOpBuffer[];
double PrevHi, PrevLo, PrevMid, NowOp;


int init()
  {
   string short_name;
   
   SetIndexStyle(0,DRAW_LINE);
   SetIndexLabel(0,"PrevHi");
   SetIndexStyle(1,DRAW_LINE);
   SetIndexLabel(1,"PrevLo");
   SetIndexStyle(2,DRAW_LINE);
   SetIndexLabel(2,"PrevMid");
   SetIndexStyle(3,DRAW_LINE);
   SetIndexLabel(3,"NowOp");
   
   SetIndexBuffer(0, PrevHiBuffer);
   SetIndexBuffer(1, PrevLoBuffer);
   SetIndexBuffer(2, PrevMidBuffer);
   SetIndexBuffer(3, NowOpBuffer);
   
   /*short_name="Prev Hi-Lo levels";
   IndicatorShortName(short_name);
   SetIndexLabel(0, short_name);*/
   SetIndexDrawBegin(0,1);
   
   
   return(0);
  }


//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
   ObjectsDeleteAll();  
   ObjectDelete("PrevHi");
   ObjectDelete("PrevLo");
   ObjectDelete("PrevMid");
   ObjectDelete("NowOp");
   
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+

        
  
  
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
  
   int limit, i, timeframe;
   
   if(Monthly)
      timeframe= PERIOD_MN1;
   else if(Weekly)
      timeframe= PERIOD_W1;
   else if(Daily)
      timeframe= PERIOD_D1;
   else if(Hourly4)
      timeframe= PERIOD_H4;
   else if(Hourly)
      timeframe= PERIOD_H1;
   else if(M30)
      timeframe= PERIOD_M30;
      
   limit=(Bars-IndicatorCounted()-1);
 
   for(i=limit; i>=0; i--)
      {
      // What daily/time bar corresponds to this chart's bar?
      int i_time = iBarShift(NULL, timeframe, Time[i]);
      // Get yesterdays daily/pretime high
      PrevHi = iHigh(NULL, timeframe, i_time+1);
      PrevLo = iLow(NULL, timeframe, i_time+1);
      PrevMid=(PrevHi + PrevLo)/2;
      NowOp  =iOpen(NULL, timeframe, i_time);
        
      PrevHiBuffer [i]=PrevHi;
      PrevLoBuffer [i]=PrevLo;
      PrevMidBuffer[i]=PrevMid;
      NowOpBuffer  [i]=NowOp;
      }
    
      
   return(0);

  }


