
// "Z" by astro (ver 02102012)

#import "Z.dll"
	void Zinstall(int, int& sig[]);
	void Zuninstall(int);
#import
#import "user32.dll"
	bool GetClientRect(int, int& rect[]);
#import

int sig[1];
int rect[4];
int hwnd;
int ototal;
int timeShift;
extern double lots = 0.1;//initial allotment;
extern double dpst = 5000;//initial deposit
double eqty0, eqty1, eqtyPL, eqtyPC, dayPL, dayPC;
double sprd, ask, bid;
color colPL;
string Eqty = "eqy";
string EqtyPCT = "epct";
string EqtyPL = "epl";
string EqtyPC = "epc";
string DayPL = "dpl";
string DayPC = "dpc";
string QAsk = "ask";
string QBid = "bid";
string CL = "cl";
string CP = "cp";
string CA = "ca";
string LC = "lc";
string LTS = "lts";
string Sprd = "sprd";
string padding[10] = {"", "   ", "      ", "         ", "            ", "               ", "                  ",
					"                     ", "                        ", "                           "};
double pvRecip[6] = {0, 0, 0, 1000, 0, 10000};

int init() {
	hwnd = WindowHandle(Symbol(), Period());
	Zinstall(hwnd, sig);
	makeControls();
	updateControls();
	WindowRedraw();
}

int deinit() {
	Zuninstall(hwnd);
	ObjectDelete(Eqty);
	ObjectDelete(EqtyPCT);
	ObjectDelete(EqtyPL);
	ObjectDelete(EqtyPC);
	ObjectDelete(DayPL);
	ObjectDelete(DayPC);
	ObjectDelete(QBid);
	ObjectDelete(QAsk);
	ObjectDelete(CL);
	ObjectDelete(CP);
	ObjectDelete(CA);
	ObjectDelete(LC);
	ObjectDelete(LTS);
	ObjectDelete(Sprd);
	for (int i = 1; i <= 10; i ++)
		ObjectDelete(StringConcatenate("", i));
}

int start() {
	if (sig[0] != 0) lbuttondown(sig[0]);
	updateControls();
}

void lbuttondown(int crd) {
		sig[0] = 0;
		int mx = crd & 0xFFFF;
		int my = crd >> 16 & 0x7FFF;
		GetClientRect(hwnd, rect);
		int cx = rect[2] - 40;
		int cy = rect[3];
		if ((mx <= cx) && (mx >= cx - 60) && (my <= 69) && (my >= 34)) buy();
		else if ((mx <= cx - 80) && (mx >= cx - 137) && (my <= 69) && (my >= 34)) sell();
		else if (mx <= cx - 10 && mx >= cx - 30 && my <= 97 && my >= 84) closeAll();
		else if (mx <= cx - 63 && mx >= cx - 83 && my <= 97 && my >= 84) closeInProfit();
		else if (mx <= cx - 108 && mx >= cx - 128 && my <= 97 && my >= 84) closeInLoss();
		else if (mx <= cx - 127 && mx >= cx - 132 && my <= 14) lots = 0.0;
		else if (mx <= cx - 112 && mx >= cx - 117 && my <= 14) lots += 0.01;
		else if (mx <= cx - 92 && mx >= cx - 102 && my <= 14) lots += 0.1;
		else if (mx <= cx - 64 && mx >= cx - 82 && my <= 14) lots += 1.0;
		else if (ototal > 0) {
			if (mx >= cx - 128 && mx <= cx)
				if (my >= 104 && my <= 104 + ototal * 14) {
					int i = (my - 104) / 14;
					close1(i);
				}
		}
		//Print(mx, " : ", my, " in 0@0 - ", cx, "@", cy);
}

void makeControls() {
	eqty0 = AccountEquity();
	eqty1 = eqty0;
	eqtyPL = eqty1 - dpst;
	eqtyPC = eqtyPL / dpst * 100;
	if (eqtyPL < 0) colPL = OrangeRed; else colPL = MediumSeaGreen;
	crtLbl(Eqty, 3, 70, 1, DoubleToStr(eqty1, 2), "Arial", 10, Lavender);
	crtLbl(EqtyPCT, 3, 1, 1, StringConcatenate(DoubleToStr(eqty1 / dpst * 100, 2), "%"), "Arial", 10, Lavender);
	crtLbl(EqtyPL, 3, 70, 16, DoubleToStr(eqtyPL, 2), "Arial", 10, colPL);
	crtLbl(EqtyPC, 3, 1, 16, StringConcatenate(DoubleToStr(eqtyPC, 2), "%"), "Arial", 10, colPL);
	crtLbl(DayPL, 3, 70, 32, DoubleToStr(dayPL, 2), "Arial", 10, MediumSeaGreen);
	crtLbl(DayPC, 3, 1, 32, StringConcatenate(DoubleToStr(dayPC, 2), "%"), "Arial", 10, MediumSeaGreen);
	crtLbl(QBid, 1, 75, 15, StringSubstr(DoubleToStr(Bid, Digits), StringLen(DoubleToStr(Bid, Digits)) - 3, 2), "Arial Black", 36, White);
	crtLbl(QAsk, 1, 1, 15, StringSubstr(DoubleToStr(Ask, Digits), StringLen(DoubleToStr(Ask, Digits)) - 3, 2), "Arial Black", 36, White);
	crtLbl(CL, 1, 105, 73, "CL", "Arial Black", 14, Lavender);
	crtLbl(CP, 1, 60, 73, "CP", "Arial Black", 14, Lavender);
	crtLbl(CA, 1, 10, 73, "CA", "Arial Black", 14, Lavender);
	crtLbl(LC, 1, 55, 0, "0 1 10 100 ", "Courier New", 8,Gray);
	crtLbl(LTS, 1, 25, 0, "100", "Courier New", 8, Tomato); 
	sprd = (Ask - Bid) * pvRecip[Digits];
	timeShift = 4 * 60 * Period();
	ObjectCreate(Sprd, OBJ_TEXT, 0, Time[0] + timeShift, Ask);
	ObjectSetText(Sprd, DoubleToStr(sprd, 1), 8, "Arial", White);
	bid = Bid;
	ask = Ask;
	for (int i = 1; i <= 10; i ++){
		crtLbl(i, 1, 5, 90 + i * 14, "L9999 1.29155 -99999.99", "Calibri", 8, Lavender);
		ObjectSet(StringConcatenate("", i), OBJPROP_TIMEFRAMES, -1);
	}
	//scan orders
	string side;
	color clr;
	int j = 1;
	for(i = 0;i < OrdersTotal(); i++){
		OrderSelect(i, SELECT_BY_POS);
		if (OrderSymbol() == Symbol()) {
			if (OrderProfit() + OrderCommission() >= 0) clr = MediumSeaGreen; else clr = Tomato;
			if (OrderType() == OP_BUY) side = "L"; else if (OrderType() == OP_SELL) side = "S";
			ObjectSetText(StringConcatenate("", j), StringConcatenate(side, makeOrderString(OrderTicket())), 8, "Calibri", clr);
			ObjectSet(StringConcatenate("", j), OBJPROP_TIMEFRAMES, 0);
			j++;
		}
	}
	ototal = j - 1;
}

void updateControls() {
	if (eqty1 != AccountEquity()) {
		eqty1 = AccountEquity();
		ObjectSetText(Eqty, DoubleToStr(eqty1, 2), 10, "Arial", Lavender);
		ObjectSetText(EqtyPCT, StringConcatenate(DoubleToStr(eqty1 / dpst * 100, 2), "%"), 10, "Arial", Lavender);
		eqtyPL = eqty1 - dpst;
		eqtyPC = eqtyPL / dpst * 100;
		if (eqtyPL < 0) colPL = Tomato; else colPL = MediumSeaGreen;
		ObjectSetText(EqtyPL, DoubleToStr(eqtyPL, 2), 10, "Arial", colPL);
		ObjectSetText(EqtyPC, StringConcatenate(DoubleToStr(eqtyPC, 2), "%"), 10, "Arial", colPL);
		dayPL = eqty1 - eqty0;
		if (eqty0 > 0) dayPC = dayPL / eqty0 * 100;
		if (dayPL < 0) colPL = Tomato; else colPL = MediumSeaGreen;
		ObjectSetText(DayPL, DoubleToStr(dayPL, 2), 10, "Arial", colPL);
		ObjectSetText(DayPC, StringConcatenate(DoubleToStr(dayPC, 2), "%"), 10, "Arial", colPL);
	}
	if (bid != Bid) {
		if (Bid < bid) colPL = Red; else colPL = MediumSeaGreen;
		ObjectSetText(QBid, StringSubstr(DoubleToStr(Bid, Digits), StringLen(DoubleToStr(Bid, Digits)) - 3, 2), 36, "Arial Black", colPL);
		bid = Bid;
	}
	if (ask != Ask) {
		if (Ask < ask) colPL = Red; else colPL = MediumSeaGreen;
		ObjectSetText(QAsk, StringSubstr(DoubleToStr(Ask, Digits), StringLen(DoubleToStr(Ask, Digits)) - 3, 2), 36, "Arial Black", colPL);
		ask = Ask;
	}
	ObjectSetText(LTS, DoubleToStr(lots * 100, 0), 8, "Courier New", Tomato);
	sprd = (Ask - Bid) * pvRecip[Digits];
	ObjectMove(Sprd, 0, Time[0] + timeShift, Ask);
	ObjectSetText(Sprd, DoubleToStr(sprd, 1), 8, "Arial", White);
	string side;
	color clr;
	for (int i = 1; i <= ototal; i++) ObjectSet(StringConcatenate("", i), OBJPROP_TIMEFRAMES, -1);
	int j = 1; ototal = 0;
	for(i = 0;i < OrdersTotal(); i++){
		OrderSelect(i, SELECT_BY_POS);
		if (OrderSymbol() == Symbol()) {
			if (OrderProfit() + OrderCommission() >= 0) clr = MediumSeaGreen; else clr = Tomato;
			if (OrderType() == OP_BUY) side = "L"; else if (OrderType() == OP_SELL) side = "S";
			ObjectSetText(StringConcatenate("", j), StringConcatenate(side, makeOrderString(OrderTicket())), 8, "Calibri", clr);
			ObjectSet(StringConcatenate("", j), OBJPROP_TIMEFRAMES, 0);
			j++;
		}
	}
	ototal = j - 1;
}

void buy(){
	int ticket = OrderSend(Symbol(), OP_BUY, lots, Ask, 0, 0, 0);
	if (ticket != -1)
		if (ototal < 10) {
			ototal++;
			ObjectSetText(StringConcatenate("", ototal), StringConcatenate("L", makeOrderString(ticket)), 8, "Calibri", Tomato);
			ObjectSet(StringConcatenate("", ototal), OBJPROP_TIMEFRAMES, 0);
		}
}

void sell(){
	int ticket = OrderSend(Symbol(), OP_SELL, lots, Bid, 0, 0, 0);
	if (ticket != -1)
		if (ototal < 10) {
			ototal++;
			ObjectSetText(StringConcatenate("", ototal), StringConcatenate("S", makeOrderString(ticket)), 8, "Calibri", Tomato);
			ObjectSet(StringConcatenate("", ototal), OBJPROP_TIMEFRAMES, 0);
		}
}

void closeAll(){
	int i, j, ototal2 = ototal;
	for(i = OrdersTotal() - 1; i >= 0; i--)
	{
		OrderSelect(i, SELECT_BY_POS);
		if (OrderSymbol() == Symbol()) {
			switch(OrderType())
			{
				case OP_BUY: 
					OrderClose(OrderTicket(), OrderLots(), Bid, 1);
					break;
				case OP_SELL:
					OrderClose(OrderTicket(), OrderLots(), Ask, 1);
			}
		}
	}
	//rescan
	for (i = 1; i <= ototal2; i++) ObjectSet(StringConcatenate("", i), OBJPROP_TIMEFRAMES, -1);
	string side;
	j = 1; ototal = 0;
	for(i = 0; i < OrdersTotal(); i++){
		OrderSelect(i, SELECT_BY_POS);
		if (OrderSymbol() == Symbol()) {
			if (OrderType() == OP_BUY) side = "L"; else if (OrderType() == OP_SELL) side = "S";
			ObjectSetText(StringConcatenate("", j), StringConcatenate(side, makeOrderString(OrderTicket())), 8, "Calibri", Tomato);
			ObjectSet(StringConcatenate("", j), OBJPROP_TIMEFRAMES, 0);
			j++;
		}
	}
	ototal = j - 1;
}

void closeInProfit(){
	int i, j, ototal2 = ototal;
	for(i = OrdersTotal() - 1; i >= 0; i--)
	{
		OrderSelect(i, SELECT_BY_POS);
		if (OrderSymbol() == Symbol()) {
			switch(OrderType())
			{
				case OP_BUY:
					if (OrderProfit() + OrderCommission() >= 0) OrderClose( OrderTicket(), OrderLots(), Bid, 1);
					break;
				case OP_SELL:
					if (OrderProfit() + OrderCommission() >= 0)	OrderClose( OrderTicket(), OrderLots(), Ask, 1);
			}
		}
	}
	//rescan
	for (i = 1; i <= ototal2; i++) ObjectSet(StringConcatenate("", i), OBJPROP_TIMEFRAMES, -1);
	string side;
	j = 1; ototal = 0;
	for(i = 0; i < OrdersTotal(); i++){
		OrderSelect(i, SELECT_BY_POS);
		if (OrderSymbol() == Symbol()) {
			if (OrderType() == OP_BUY) side = "L"; else if (OrderType() == OP_SELL) side = "S";
			ObjectSetText(StringConcatenate("", j), StringConcatenate(side, makeOrderString(OrderTicket())), 8, "Calibri", Tomato);
			ObjectSet(StringConcatenate("", j), OBJPROP_TIMEFRAMES, 0);
			j++;
		}
	}
	ototal = j - 1;
}

void closeInLoss(){
	int i, j, ototal2 = ototal;
	for(i = OrdersTotal() - 1; i >= 0; i--)
	{
		OrderSelect(i, SELECT_BY_POS);
		if (OrderSymbol() == Symbol()) {
			switch(OrderType())
			{
				case OP_BUY:
					if (OrderProfit() + OrderCommission() < 0) OrderClose( OrderTicket(), OrderLots(), Bid, 1);
					break;
				case OP_SELL:
					if (OrderProfit() + OrderCommission() < 0) OrderClose( OrderTicket(), OrderLots(), Ask, 1);
			}
		}
	}
	//rescan
	for (i = 1; i <= ototal2; i++) ObjectSet(StringConcatenate("", i), OBJPROP_TIMEFRAMES, -1);
	string side;
	j = 1; ototal = 0;
	for(i = 0; i < OrdersTotal(); i++){
		OrderSelect(i, SELECT_BY_POS);
		if (OrderSymbol() == Symbol()) {
			if (OrderType() == OP_BUY) side = "L"; else if (OrderType() == OP_SELL) side = "S";
			ObjectSetText(StringConcatenate("", j), StringConcatenate(side, makeOrderString(OrderTicket())), 8, "Calibri", Tomato);
			ObjectSet(StringConcatenate("", j), OBJPROP_TIMEFRAMES, 0);
			j++;
		}
	}
	ototal = j - 1;
}

void close1(int i){
	int pos, j, ototal2 = ototal;
	pos = 0;
	for(j = 0; j < OrdersTotal(); j++){
		OrderSelect(j, SELECT_BY_POS);
		if (OrderSymbol() == Symbol()) {
			if (pos == i) {
				switch(OrderType())
				{
					case OP_BUY:
						OrderClose(OrderTicket(), OrderLots(), Bid, 1);
						break;
					case OP_SELL:
						OrderClose(OrderTicket(), OrderLots(), Ask, 1);
				}
			}
			pos++;
		}
	}
	//rescan
	for (i = 1; i <= ototal2; i++) ObjectSet(StringConcatenate("", i), OBJPROP_TIMEFRAMES, -1);
	string side;
	j = 1; ototal = 0;
	for(i = 0; i < OrdersTotal(); i++){
		OrderSelect(i, SELECT_BY_POS);
		if (OrderSymbol() == Symbol()) {
			if (OrderType() == OP_BUY) side = "L"; else if (OrderType() == OP_SELL) side = "S";
			ObjectSetText(StringConcatenate("", j), StringConcatenate(side, makeOrderString(OrderTicket())), 8, "Calibri", Tomato);
			ObjectSet(StringConcatenate("", j), OBJPROP_TIMEFRAMES, 0);
			j++;
		}
	}
	ototal = j - 1;
}

int crtLbl(string lblname, int corner, int xOffset, int yOffset, string text, string fontName, int fontSize, color txtColor) {
	ObjectCreate(lblname, OBJ_LABEL, 0, 0, 0);
	ObjectSet(lblname, OBJPROP_CORNER, corner);
	ObjectSet(lblname, OBJPROP_XDISTANCE, xOffset); 
	ObjectSet(lblname, OBJPROP_YDISTANCE, yOffset);
	ObjectSet(lblname, OBJPROP_BACK, false);
	ObjectSetText(lblname, text, fontSize, fontName, txtColor);   
}

string makeOrderString(int ticket){
	OrderSelect(ticket, SELECT_BY_TICKET);
	string orderString = DoubleToStr(OrderLots() * 100, 0);
	int len = StringLen(orderString);
	string openPrice = DoubleToStr(OrderOpenPrice(), 5);
	string profitLoss = DoubleToStr(MathAbs(OrderProfit() + OrderCommission()), 2);
	int len1 = StringLen(profitLoss);
	return(StringConcatenate(padding[4 - len], orderString, " ", openPrice, " ", padding[9 - len1], profitLoss));
}