// Z.cpp : Defines the exported functions for the DLL application.
//

#include "stdafx.h"
#include <map>
using namespace std;

#define DLLExport extern "C" __declspec(dllexport)

DLLExport void Zinstall(HWND hWnd, int* ip);
DLLExport void Zuninstall(HWND hWnd);

LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam);

int imsg;
bool firstRun = true;

class ThreadData {
public:
	int* ip;
	LONG mt4WndProc;
	ThreadData(int* _ip, LONG _wp) {
		ip = _ip;
		mt4WndProc = _wp;
	}
	~ThreadData() {
		delete this;
	}
};

map<HWND, ThreadData*> threadData;

DLLExport void Zinstall(HWND hWnd, int* ip)
{
	if (firstRun) {
		imsg = RegisterWindowMessageA("MetaTrader4_Internal_Message");
		firstRun = false;
	}
	threadData[hWnd] = new ThreadData(ip, SetWindowLong(hWnd, GWL_WNDPROC, (LONG)&WndProc));
}

DLLExport void Zuninstall(HWND hWnd)
{
	SetWindowLong(hWnd, GWL_WNDPROC, threadData[hWnd]->mt4WndProc);
	threadData.erase(hWnd);
}

LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam)
{
	map<HWND, ThreadData*>::iterator i;
	i = threadData.find(hWnd);
	switch (msg)
	{
		case WM_LBUTTONDOWN:
		{
			*((*i).second->ip) = lParam | 0x80000000;
			CallWindowProc((WNDPROC)(*i).second->mt4WndProc, hWnd, imsg, 2, 0);
		}
	}
	return CallWindowProc((WNDPROC)(*i).second->mt4WndProc, hWnd, msg, wParam, lParam);
}
