(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[   1659691,      32212]
NotebookOptionsPosition[   1647914,      31846]
NotebookOutlinePosition[   1648363,      31863]
CellTagsIndexPosition[   1648320,      31860]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["GeorgM Candletalk - Datenexploration", "Title",
 CellChangeTimes->{{3.6166511845689597`*^9, 3.616651209029803*^9}, 
   3.616675743180876*^9, 3.6166760301319804`*^9}],

Cell["\<\



Datum: 10.8.2014
Letzte \[CapitalADoubleDot]nderung: 10.8.2014, 18:19 UIhr


Autor: Kr\[UDoubleDot]mel.

GeorgM hat mit Hilfe von PT alias Norbert Gundeler eine Exceltabelle online \
gestellt, die ich mir als Ascii runtergeladen (bzw. rauskopiert)  habe und \
mal einige Untersuchungen anstellen m\[ODoubleDot]chte. \
\>", "Text",
 CellChangeTimes->{{3.616651237156652*^9, 3.6166513763640966`*^9}, {
   3.616666569395561*^9, 3.616666609347231*^9}, 3.616675743180876*^9, 
   3.6166760301319804`*^9, {3.6166763509795437`*^9, 3.616676355082351*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"in", " ", "homePath", " ", "liegen", " ", "Mathematica"}], "-", 
    RowBox[{
    "Notebookdatei", " ", "und", " ", "Textdatei", " ", "mit", " ", "den", 
     " ", "Daten"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
   "homePath", " ", "=", " ", 
    "\"\<C:\\\\Users\\\\Ich\\\\Mathematica_Notebooks\\\\otherPplStuff\\\\\>\"\
"}], ";"}], " "}]], "Input",
 CellChangeTimes->{{3.61665140116814*^9, 3.616651518654747*^9}, {
   3.616651549402401*^9, 3.6166515666560316`*^9}, {3.616651652986583*^9, 
   3.616651653875785*^9}, {3.6166516897246475`*^9, 3.6166517363531294`*^9}, 
   3.6166518258816867`*^9, {3.616652580559013*^9, 3.6166526185450797`*^9}, 
   3.616675743180876*^9, 3.6166760301319804`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"Daten", " ", "einlesen"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"preData", "=", " ", 
     RowBox[{"Import", " ", "[", 
      RowBox[{
       RowBox[{"homePath", " ", "<>", " ", "\"\<georgMData.txt\>\""}], ",", 
       "\"\<Table\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{"colNames", "=", 
    RowBox[{"First", "[", "preData", "]"}]}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data", "=", 
     RowBox[{"Rest", "[", "preData", "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.61665140116814*^9, 3.616651518654747*^9}, {
   3.616651549402401*^9, 3.6166515666560316`*^9}, {3.616651652986583*^9, 
   3.616651653875785*^9}, {3.6166516897246475`*^9, 3.616651708585081*^9}, {
   3.6166518333072996`*^9, 3.6166518933206053`*^9}, {3.6166526223982863`*^9, 
   3.616652627827096*^9}, 3.616675743180876*^9, 3.6166760301319804`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"\<\"Tage\"\>", ",", "\<\"Volatilit\[ADoubleDot]t\"\>", 
   ",", "\<\"G/V\"\>", ",", "\<\"G/V_kumuliert\"\>", ",", "\<\"Saldo\"\>"}], 
  "}"}]], "Output",
 CellChangeTimes->{3.616651893851006*^9, 3.616652420190731*^9, 
  3.6166526317427025`*^9, 3.616670839831462*^9, 3.616672118869709*^9, 
  3.6166722542623467`*^9, 3.6166731801259737`*^9, 3.616675743180876*^9, 
  3.6166759580022535`*^9, 3.6166760301319804`*^9, 3.6166763620087633`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Spaltenkonstanten", " ", "definieren"}], ",", " ", 
    RowBox[{
    "damit", " ", "der", " ", "Code", " ", "lesbarer", " ", "wird"}]}], 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"volaCol", "=", "2"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dateCol", "=", "1"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"gVCol", "=", "3"}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6166523706034436`*^9, 3.6166523870458727`*^9}, {
   3.6166525528845644`*^9, 3.616652572712199*^9}, 3.616675743180876*^9, 
   3.6166760301319804`*^9}],

Cell["\<\


Ich plotte mal f\[UDoubleDot]r einen ersten \[CapitalUDoubleDot]berblick die \
2 mMn wichtigsten Spalten Volatility versus G/V:\
\>", "Text",
 CellChangeTimes->{{3.616666625087659*^9, 3.616666658175317*^9}, 
   3.616675743180876*^9, 3.6166760301319804`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"data", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", 
      RowBox[{"volaCol", ";;", "gVCol"}]}], "]"}], "]"}], ",", " ", 
   RowBox[{"AxesOrigin", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"10", ",", "0"}], "}"}]}], ",", " ", 
   RowBox[{"ImageSize", "\[Rule]", "600"}], ",", " ", 
   RowBox[{"AspectRatio", " ", "\[Rule]", " ", 
    RowBox[{"1", "/", "2"}]}], ",", 
   RowBox[{"AxesLabel", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{"\"\<Volatilit\[ADoubleDot]t\>\"", ",", "\"\<G/V\>\""}], 
     "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.616652431453951*^9, 3.616652540622943*^9}, 
   3.616673169143554*^9, 3.616675743180876*^9, 3.6166760301319804`*^9}],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJy9m9uOVUUQhjvGB5hLLpfGCy+4MITghBBsGEHFBAbkEI5uN3NghqMoIESx
o17oC3g9j+Aj9CP4CDyED+CB9bepr+hVe2Ni30z++au7qw+rurq69lvz++c2
30gprbyZ0t9/X5b3czJlQVzOZoPzbp6UTwerxe9Z3No78PJvvQX5nj6jfFmH
/FXgMxbXe+P/j4x/z0P/U5avN+ur5Uc827Dtl7PT+tcvbHv1DvRREb5q5dl/
eg68kV/dv/jT4Afo+860/g7ftfLlC9v+7IHF3D/d9g9In2wx+DbfHb6NV3j/
dHth/Uie+AbqO32qwWUL/NzybJ/fT5v/Xn/7gCP9iU+gPsen/dPrH5j6O34L
7anI/szAn7P182418sMc/amM+LcfrXy+aXH6BFjj1/e9jfrST9/fTjb4j1/B
Hxrx2ohH+1Ly2L70l/x+YH7/27Z+Gu0fsbN3Y//5IfSR/sIqAW797VSrL+2Z
ivDX4G+gPuTbfsF8/Nu/xfmRbT8/Rn3137NXWG/at2VxOgMe9vSvFTI4P7P6
t+9P67mF8axDfsPi8gC8iubntu2/XLS4lQVx1n7ozQ/G/+LLOslXfO/lluVn
D6DvmuXD9aH+W5CHPiXyZz4P+lsJ6m9befoXrfS+N6x/ytP9Nf9M8pdRH/L5
DuR737v6O237b+Pp+hfT+pbreZJ3878DefTv6qss6z+oP7f+0/2V21ae583s
fp3sr9mLznzSny9fWpzWbH9lDryovVtwvorOo56/s2R7jpf//rr+nPb/ov7t
YcpXy39q+bqkfpyPvAl9I39U+133sU3opyIM/dx6oD93XtwAHrLFuK+wftuv
oz0ZsB/zNYsjfzOdBFbpzR/5CEf7kfx7wLpP9+rLrvb2h+zla+offc/lc9t+
2QA/szjj/piOQz/sx/QR2vvQYq8v6vM+NYc+uxa7+9hFYMUzhFdQn/cTru81
8LxfqfTwYdTn/EHejSfa79F+5fxDvt2/evLwj4an2eB0APXvWlyD82f2lcUF
9oDnnTv/6H9Ln549xH1h7/kor+9y3M/tPiJ71/GPCu8Xut92xtv8rUX9D55X
H9VXy2u+t6d5199qoA++58j+Mb7h9jP16fnfIz/7j/YwfWrrlytRe+D5l/EL
+r/wx2Zf2fbyzPLOP7tg2y+Mb1yAPO39BYtb6dy32n7s+PMufrwKHvq5+xX3
P/1F2N/C+xr9W+3/9v1O9+fOJxcPRn2cP/RnOL7h66C9e5ZvRRjrnw6i/iWM
55jFFeNJ+6z+6SiwyoL+k/MfsH7Uf8D9vzJ+wP1BDH89674U1V/0POT4Htv2
3fnC9cT40rkR63z4aZTT+aH4gOIYOl+FjwH/ZHH5BvWfWr4+RH0V8ToPOvG+
+q3lV35G+xuWr9uWZ395C/0F8chy0/Llbjb6tfhfmy/qM91f8y87fH0wzXO+
2/26jYc4TetzFf3L/xpx84c0nzuWT48t5vq48e1aHK1Pi9+JH6blWxHmfIMv
m9O8wxzf20H/UX3yHA/xyZf12/d8PBvsxsP5Yn9XLD88sbj+gP5Rv5034s8D
B/O/9PsA99N8yfoR1nnX4Vd+qf/81XwP32WD3XsJ3g9UGj5k+RYvhX1u9mfH
9q/7WMPnLS73x//rPDhSLcb7SgVu/obi+fIXe/HiZfG4Xzg/6YMRy39QHEz3
nR6+HvAqIy7yxzp8e+8acd6E/DuWb/dj+gMdfaL4aRgf5PsK5bX+h8ELB+9R
Lp7+H9+rajTfwXo1f1v6wx917ztXLOZ9PPKvQv+L7wvwf/PFafl23vbGC3+1
lQ5278/Mz2D+APNpHlrs7pOQH7bA9/ZvJ97U3l97/jX3s84z1Uc+T8b8M97T
CrHmW/oI3wFWfFLf7wz83PJcv3zb8hntufwirWen/wq+IL/AxaNWgVU69z9X
X+9t0ucAsOx6x97QnqZdi7PiCZ3x0j60+FzuyB9Ce9H58dTiPc3HgvbKjVc8
/TOed8KXIc/15/wF9jLrftRp3/V/qqMf97Ow4jvCq8Csz/GQVzxc879h5cvl
EXfu54wHtfttJz7DfIJWRvzikZVv/lQvHhWcl/9+NyPP94UjFrd41Fj/91Jt
O9if9E/KNdv/oPjfov4FMfShf5AQT1z2/HTnxSeBfsxP7Onficd03x+lP8br
/Jm7Hf272Lbnzmvmv2J86zxfaa95fqgsGr9aNt8yeh+m/DHwXI/PKtoHhj4V
74GM57p8P+oH/etNi917Ad+X3kV9xndVevHL68vJt/ie8Jrlo/etMB+C73FR
PgX1j9Yf75XOP5N9V//PwDP/St+D2pP96+2XOepTnu+j1J/5qph/yrv5PTot
z/lx9fm+7/QDj/dnt5853jPgLwGzv2XznYP87P8d8z2R/AAe3zvXs/kj0fnS
4/l+QH3WAx44L/v+yvyhg3la/jTk2b7yk0a89wzyH1ue+SbO3nyG/rk+yKdI
VyymfXDfA+0fzw+8X7l8BeZnPLZ4WXtegvmlfi2e3pVH/1xPzJc730+i/eD7
b+8zne9lD/rv3bJ8Ds7TzP0KPsItX1287j2a/3MWV8qzfc4v9wfymwbsx73g
vN17YvnE/KPAfjAfg/vF5Q/SP1u3fJRPWXcsn3v5pp39Gf1eh/lX7X4svAoc
+P/tvbhrDyxu90ONF/c5tz9hDznf3O9uPrA/Xnw/8vKPVoBxH27+tXjm78Ae
1XsWF8YzT1ic9Pu03n5CPsAA/43x2QH5CryPv9jCeJgvsmnlXT4z71PA7T1M
/uNDiwvu0+33E9KH/kHwvYT+OfMH8X2VS+DRfoTp7yes/wz2zOmHfCF33iB+
G/k7JbAXLj8UmN+ju3/SH+N5T/njwLQ3bI/3i+D3bS3/TOOBP0H/0sVz+XvF
j9FeNF+8/9LfQr5uKx35MN8e2J0PwfmfOB/MT43yr93vByGPfL3E9TwPedhT
57+AHxhfp78Q+Vdz8PBPw3xHYvYPftn4gYuX0N/n/grGy3xx8vmR5cPf+yLf
1Md7oC/HC/ur9/yuPPPtOd4gnpDetfq63+fS32F97l/MF/0TJ099Gf9ZAw6+
vxn9A+azf2j5gvtE4fd3Au2hv9fAfwLv+VgB
     "]]}, {}},
  AspectRatio->NCache[
    Rational[1, 2], 0.5],
  Axes->True,
  AxesLabel->{
    FormBox["\"Volatilit\[ADoubleDot]t\"", TraditionalForm], 
    FormBox["\"G/V\"", TraditionalForm]},
  AxesOrigin->{10, 0},
  ImageSize->600,
  PlotRange->{{10, 38.}, {-549., 770.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.616652462061205*^9, 3.616652540966143*^9}, 
   3.616670839925062*^9, 3.616672118994509*^9, 3.616672254387147*^9, 
   3.6166731886903887`*^9, 3.616675743180876*^9, 3.616675958127054*^9, 
   3.61667603014198*^9, 3.6166763621491632`*^9}]
}, Open  ]],

Cell["\<\
In 2 D gef\[ADoubleDot]llt mir das nicht so gut,da die Punktewolken keine \
echten sind, sondern auf den Vola-Werte zu sehr verschmiert. Der Listplot ist \
daher nicht so gut geeignet. 


Ich schau mir das daher in 3-D an, da sieht man auch die Anzahl pro \
Kombination/ Wertepaar Vola/GV. \
\>", "Text",
 CellChangeTimes->{{3.61665269269201*^9, 3.616652753844117*^9}, {
   3.6166666619349236`*^9, 3.6166666863489666`*^9}, 3.616675743180876*^9, 
   3.61667603014198*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Histogram3D", "[", 
  RowBox[{
   RowBox[{"data", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", 
      RowBox[{"volaCol", ";;", "gVCol"}]}], "]"}], "]"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", "600"}], ",", " ", 
   RowBox[{"AxesLabel", " ", "\[Rule]", " ", 
    RowBox[{"{", 
     RowBox[{
     "\"\<Volatilit\[ADoubleDot]t\>\"", ",", "\"\<G/V\>\"", ",", 
      "\"\<Freq [N]\>\""}], "}"}]}], ",", 
   RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Speed\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.61665276119173*^9, 3.616652766402139*^9}, {
   3.6166527973681936`*^9, 3.6166528380062647`*^9}, {3.6166545821985283`*^9, 
   3.6166547301335883`*^9}, 3.6166549061798973`*^9, 3.616657189981487*^9, 
   3.6166731950395994`*^9, 3.616675743180876*^9, 3.61667603014198*^9}],

Cell[BoxData[
 Graphics3DBox[
  {RGBColor[0.5, 0.5, 1], EdgeForm[GrayLevel[0.5]], {}, 
   {RGBColor[0.5, 0.5, 1], EdgeForm[GrayLevel[0.5]], 
    CuboidBox[{18., -650., 0.}, {20., -600., 1.}], 
    CuboidBox[{18., -450., 0.}, {20., -400., 2.}], 
    CuboidBox[{18., -400., 0.}, {20., -350., 3.}], 
    CuboidBox[{18., -350., 0.}, {20., -300., 2.}], 
    CuboidBox[{18., -300., 0.}, {20., -250., 7.}], 
    CuboidBox[{18., -250., 0.}, {20., -200., 12.}], 
    CuboidBox[{18., -200., 0.}, {20., -150., 36.}], 
    CuboidBox[{18., -150., 0.}, {20., -100., 37.}], 
    CuboidBox[{18., -100., 0.}, {20., -50., 18.}], 
    CuboidBox[{18., -50., 0.}, {20., 0., 31.}], 
    CuboidBox[{18., 0., 0.}, {20., 50., 167.}], 
    CuboidBox[{18., 50., 0.}, {20., 100., 97.}], 
    CuboidBox[{18., 100., 0.}, {20., 150., 42.}], 
    CuboidBox[{18., 150., 0.}, {20., 200., 20.}], 
    CuboidBox[{18., 200., 0.}, {20., 250., 8.}], 
    CuboidBox[{18., 250., 0.}, {20., 300., 1.}], 
    CuboidBox[{18., 300., 0.}, {20., 350., 1.}], 
    CuboidBox[{18., 350., 0.}, {20., 400., 1.}], 
    CuboidBox[{18., 500., 0.}, {20., 550., 1.}], 
    CuboidBox[{22., -550., 0.}, {24., -500., 1.}], 
    CuboidBox[{22., -500., 0.}, {24., -450., 1.}], 
    CuboidBox[{22., -400., 0.}, {24., -350., 1.}], 
    CuboidBox[{22., -350., 0.}, {24., -300., 4.}], 
    CuboidBox[{22., -300., 0.}, {24., -250., 7.}], 
    CuboidBox[{22., -250., 0.}, {24., -200., 17.}], 
    CuboidBox[{22., -200., 0.}, {24., -150., 21.}], 
    CuboidBox[{22., -150., 0.}, {24., -100., 26.}], 
    CuboidBox[{22., -100., 0.}, {24., -50., 13.}], 
    CuboidBox[{22., -50., 0.}, {24., 0., 23.}], 
    CuboidBox[{22., 0., 0.}, {24., 50., 59.}], 
    CuboidBox[{22., 50., 0.}, {24., 100., 60.}], 
    CuboidBox[{22., 100., 0.}, {24., 150., 32.}], 
    CuboidBox[{22., 150., 0.}, {24., 200., 6.}], 
    CuboidBox[{22., 200., 0.}, {24., 250., 18.}], 
    CuboidBox[{22., 250., 0.}, {24., 300., 11.}], 
    CuboidBox[{22., 300., 0.}, {24., 350., 2.}], 
    CuboidBox[{22., 350., 0.}, {24., 400., 2.}], 
    CuboidBox[{22., 400., 0.}, {24., 450., 4.}], 
    CuboidBox[{22., 450., 0.}, {24., 500., 2.}], 
    CuboidBox[{26., -250., 0.}, {28., -200., 1.}], 
    CuboidBox[{26., -200., 0.}, {28., -150., 10.}], 
    CuboidBox[{26., -150., 0.}, {28., -100., 6.}], 
    CuboidBox[{26., -100., 0.}, {28., -50., 1.}], 
    CuboidBox[{26., -50., 0.}, {28., 0., 3.}], 
    CuboidBox[{26., 0., 0.}, {28., 50., 14.}], 
    CuboidBox[{26., 50., 0.}, {28., 100., 17.}], 
    CuboidBox[{26., 100., 0.}, {28., 150., 4.}], 
    CuboidBox[{26., 150., 0.}, {28., 200., 5.}], 
    CuboidBox[{26., 200., 0.}, {28., 250., 5.}], 
    CuboidBox[{26., 400., 0.}, {28., 450., 1.}], 
    CuboidBox[{28., -1500., 0.}, {30., -1450., 1.}], 
    CuboidBox[{28., -400., 0.}, {30., -350., 1.}], 
    CuboidBox[{28., -250., 0.}, {30., -200., 2.}], 
    CuboidBox[{28., -200., 0.}, {30., -150., 7.}], 
    CuboidBox[{28., -150., 0.}, {30., -100., 4.}], 
    CuboidBox[{28., -100., 0.}, {30., -50., 2.}], 
    CuboidBox[{28., -50., 0.}, {30., 0., 4.}], 
    CuboidBox[{28., 0., 0.}, {30., 50., 12.}], 
    CuboidBox[{28., 50., 0.}, {30., 100., 9.}], 
    CuboidBox[{28., 100., 0.}, {30., 150., 2.}], 
    CuboidBox[{28., 150., 0.}, {30., 200., 5.}], 
    CuboidBox[{28., 200., 0.}, {30., 250., 2.}], 
    CuboidBox[{28., 250., 0.}, {30., 300., 1.}], 
    CuboidBox[{28., 300., 0.}, {30., 350., 2.}], 
    CuboidBox[{28., 450., 0.}, {30., 500., 1.}], 
    CuboidBox[{28., 600., 0.}, {30., 650., 1.}], 
    CuboidBox[{30., -50., 0.}, {32., 0., 1.}], 
    CuboidBox[{32., -500., 0.}, {34., -450., 1.}], 
    CuboidBox[{32., -250., 0.}, {34., -200., 1.}], 
    CuboidBox[{32., -200., 0.}, {34., -150., 5.}], 
    CuboidBox[{32., -100., 0.}, {34., -50., 1.}], 
    CuboidBox[{32., -50., 0.}, {34., 0., 1.}], 
    CuboidBox[{32., 0., 0.}, {34., 50., 9.}], 
    CuboidBox[{32., 50., 0.}, {34., 100., 1.}], 
    CuboidBox[{32., 100., 0.}, {34., 150., 2.}], 
    CuboidBox[{32., 150., 0.}, {34., 200., 2.}], 
    CuboidBox[{32., 200., 0.}, {34., 250., 5.}], 
    CuboidBox[{32., 250., 0.}, {34., 300., 1.}], 
    CuboidBox[{32., 300., 0.}, {34., 350., 2.}], 
    CuboidBox[{32., 450., 0.}, {34., 500., 1.}]}, {}, {}},
  AutomaticImageSize->True,
  Axes->{True, True, True},
  AxesLabel->{
    FormBox["\"Volatilit\[ADoubleDot]t\"", TraditionalForm], 
    FormBox["\"G/V\"", TraditionalForm], 
    FormBox["\"Freq [N]\"", TraditionalForm]},
  BoxRatios->{1, 1, 0.4},
  ImageSize->600,
  Lighting->"Neutral",
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{18., 34.}, {-1500., 650.}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.1]}},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{-1.3962600523028983`, -2.661474291211293, 1.5546743914930785`},
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{{3.616654704175143*^9, 3.6166547307575893`*^9}, 
   3.6166549072718997`*^9, 3.6166571912294893`*^9, 3.616666701683793*^9, 
   3.6166708402370625`*^9, 3.6166721194313097`*^9, 3.6166722547615476`*^9, 
   3.616673196412402*^9, 3.6166757431964755`*^9, 3.616675958641855*^9, 
   3.6166760301519804`*^9, 3.6166763626795645`*^9}]
}, Open  ]],

Cell["\<\
F\[UDoubleDot]r die h\[ODoubleDot]heren Vola-Werte hat man eindeutig zu wenig \
Daten, f\[UDoubleDot]r die niedrigen Volawerte sieht es eher nach 2 \
ineinanderverschobenen Verteilungen pro Vola-Rasterpunkt aus. Theoretisch k\
\[ODoubleDot]nnte man da einen Stopp reinpacken und so die ollen Verluste \
vermeiden. Praktisch kann ich das leider nicht machen, da ich nicht wei\[SZ], \
wie gro\[SZ] Intraday der Buchverlust geworden ist, bevor das Tagesergebnis \
generiert wurde. Da ich auch nicht wei\[SZ], wie das Tagesergebnis \
zustandegekommen ist (ein oder mehrere Trades), lassen sich an der Stelle \
keine weiteren Ideen ableiten, da mir die Informationen fehlen. 


Ein einfaches vola-unabh\[ADoubleDot]ngiges Histogramm zeigt etwas \
\[ADoubleDot]hnliches: \
\>", "Text",
 CellChangeTimes->{{3.616662655107886*^9, 3.6166628705910645`*^9}, {
   3.6166667334922495`*^9, 3.6166667730383186`*^9}, 3.6166757431964755`*^9, 
   3.6166760301519804`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Histogram", "[", 
  RowBox[{
   RowBox[{"data", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", " ", "gVCol"}], "]"}], "]"}], ",", "Automatic", ",", 
   " ", "\"\<Probability\>\"", ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<G/V\>\"", ",", "\"\<Probability\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6166574596591606`*^9, 3.616657478223193*^9}, {
   3.61665754488211*^9, 3.616657552245323*^9}, {3.6166628759730735`*^9, 
   3.6166629029455214`*^9}, 3.6166757431964755`*^9, 3.6166760301519804`*^9}],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
   EdgeForm[Opacity[0.7]], {}, 
   {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
    EdgeForm[Opacity[0.7]], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-1500., 0.}, {-1450., 0.0009615384615384616}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{22., 29.633540372670808`}, {93.42352242442273, 
         95.01758749559224}}],
       StatusArea[#, 0.0009615384615384616]& ,
       TagBoxNote->"0.0009615384615384616"],
      StyleBox["0.0009615384615384616`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0009615384615384616, {
        GrayLevel[0]}], 
      "Tooltip"]& ], {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, {}, 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-850., 0.}, {-800., 0.0009615384615384616}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{108.2360248447205, 115.86956521739131`}, {
         93.42352242442273, 95.01758749559224}}],
       StatusArea[#, 0.0009615384615384616]& ,
       TagBoxNote->"0.0009615384615384616"],
      StyleBox["0.0009615384615384616`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0009615384615384616, {
        GrayLevel[0]}], "Tooltip"]& ], {}, {}, {}, 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-650., 0.}, {-600., 0.0009615384615384616}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{134.77018633540374`, 142.40372670807454`}, {
         93.42352242442273, 95.01758749559224}}],
       StatusArea[#, 0.0009615384615384616]& ,
       TagBoxNote->"0.0009615384615384616"],
      StyleBox["0.0009615384615384616`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0009615384615384616, {
        GrayLevel[0]}], "Tooltip"]& ], {}, 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-550., 0.}, {-500., 0.0009615384615384616}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{148.03726708074535`, 155.67080745341616`}, {
         93.42352242442273, 95.01758749559224}}],
       StatusArea[#, 0.0009615384615384616]& ,
       TagBoxNote->"0.0009615384615384616"],
      StyleBox["0.0009615384615384616`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0009615384615384616, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-500., 0.}, {-450., 0.0019230769230769232`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{154.67080745341616`, 162.30434782608697`}, {
         92.82945735325322, 95.01758749559224}}],
       StatusArea[#, 0.0019230769230769232`]& ,
       TagBoxNote->"0.0019230769230769232"],
      StyleBox["0.0019230769230769232`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0019230769230769232`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-450., 0.}, {-400., 0.0019230769230769232`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{161.30434782608697`, 168.93788819875778`}, {
         92.82945735325322, 95.01758749559224}}],
       StatusArea[#, 0.0019230769230769232`]& ,
       TagBoxNote->"0.0019230769230769232"],
      StyleBox["0.0019230769230769232`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0019230769230769232`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-400., 0.}, {-350., 0.007692307692307693}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{167.93788819875778`, 175.57142857142858`}, {
         89.26506692623614, 95.01758749559224}}],
       StatusArea[#, 0.007692307692307693]& ,
       TagBoxNote->"0.007692307692307693"],
      StyleBox["0.007692307692307693`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.007692307692307693, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-350., 0.}, {-300., 0.006730769230769231}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{174.57142857142858`, 182.2049689440994}, {
         89.85913199740565, 95.01758749559224}}],
       StatusArea[#, 0.006730769230769231]& ,
       TagBoxNote->"0.006730769230769231"],
      StyleBox["0.006730769230769231`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.006730769230769231, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-300., 0.}, {-250., 0.016346153846153847`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{181.2049689440994, 188.8385093167702}, {
         83.91848128571054, 95.01758749559224}}],
       StatusArea[#, 0.016346153846153847`]& ,
       TagBoxNote->"0.016346153846153847"],
      StyleBox["0.016346153846153847`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.016346153846153847`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-250., 0.}, {-200., 0.03365384615384615}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{187.8385093167702, 195.472049689441}, {
         73.22531000465935, 95.01758749559224}}],
       StatusArea[#, 0.03365384615384615]& ,
       TagBoxNote->"0.03365384615384615"],
      StyleBox["0.03365384615384615`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.03365384615384615, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-200., 0.}, {-150., 0.08557692307692308}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{194.472049689441, 202.10559006211182`}, {
         41.145796161505736`, 95.01758749559224}}],
       StatusArea[#, 0.08557692307692308]& ,
       TagBoxNote->"0.08557692307692308"],
      StyleBox["0.08557692307692308`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.08557692307692308, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-150., 0.}, {-100., 0.07115384615384615}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{201.10559006211182`, 208.73913043478262`}, {
         50.05677222904841, 95.01758749559224}}],
       StatusArea[#, 0.07115384615384615]& ,
       TagBoxNote->"0.07115384615384615"],
      StyleBox["0.07115384615384615`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.07115384615384615, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-100., 0.}, {-50., 0.0375}, "RoundingRadius" -> 0]},
        ImageSizeCache->{{207.73913043478262`, 215.37267080745343`}, {
         70.84904971998131, 95.01758749559224}}],
       StatusArea[#, 0.0375]& ,
       TagBoxNote->"0.0375"],
      StyleBox["0.0375`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0375, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-50., 0.}, {0., 0.06634615384615385}, "RoundingRadius" -> 
          0]},
        ImageSizeCache->{{214.37267080745343`, 222.00621118012424`}, {
         53.02709758489596, 95.01758749559224}}],
       StatusArea[#, 0.06634615384615385]& ,
       TagBoxNote->"0.06634615384615385"],
      StyleBox["0.06634615384615385`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.06634615384615385, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{0., 0.}, {50., 0.2798076923076923}, "RoundingRadius" -> 
          0]},
        ImageSizeCache->{{221.00621118012424`, 
         228.63975155279505`}, {-78.85534821473553, 95.01758749559224}}],
       StatusArea[#, 0.2798076923076923]& ,
       TagBoxNote->"0.2798076923076923"],
      StyleBox["0.2798076923076923`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.2798076923076923, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{50., 0.}, {100., 0.17692307692307693`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{227.63975155279505`, 
         235.27329192546586`}, {-15.290385599597826`, 95.01758749559224}}],
       StatusArea[#, 0.17692307692307693`]& ,
       TagBoxNote->"0.17692307692307693"],
      StyleBox["0.17692307692307693`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.17692307692307693`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{100., 0.}, {150., 0.0798076923076923}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{234.27329192546586`, 241.90683229813666`}, {
         44.71018658852281, 95.01758749559224}}],
       StatusArea[#, 0.0798076923076923]& ,
       TagBoxNote->"0.0798076923076923"],
      StyleBox["0.0798076923076923`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0798076923076923, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{150., 0.}, {200., 0.03942307692307692}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{240.90683229813666`, 248.54037267080747`}, {
         69.66091957764228, 95.01758749559224}}],
       StatusArea[#, 0.03942307692307692]& ,
       TagBoxNote->"0.03942307692307692"],
      StyleBox["0.03942307692307692`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.03942307692307692, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{200., 0.}, {250., 0.05096153846153846}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{247.54037267080747`, 255.17391304347828`}, {
         62.53213872360814, 95.01758749559224}}],
       StatusArea[#, 0.05096153846153846]& ,
       TagBoxNote->"0.05096153846153846"],
      StyleBox["0.05096153846153846`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.05096153846153846, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{250., 0.}, {300., 0.013461538461538462`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{254.17391304347828`, 261.8074534161491}, {
         85.70067649921909, 95.01758749559224}}],
       StatusArea[#, 0.013461538461538462`]& ,
       TagBoxNote->"0.013461538461538462"],
      StyleBox["0.013461538461538462`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.013461538461538462`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{300., 0.}, {350., 0.008653846153846154}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{260.8074534161491, 268.4409937888199}, {
         88.67100185506663, 95.01758749559224}}],
       StatusArea[#, 0.008653846153846154]& ,
       TagBoxNote->"0.008653846153846154"],
      StyleBox["0.008653846153846154`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.008653846153846154, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{350., 0.}, {400., 0.0028846153846153848`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{267.4409937888199, 275.0745341614907}, {
         92.23539228208371, 95.01758749559224}}],
       StatusArea[#, 0.0028846153846153848`]& ,
       TagBoxNote->"0.0028846153846153848"],
      StyleBox["0.0028846153846153848`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0028846153846153848`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{400., 0.}, {450., 0.006730769230769231}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{274.0745341614907, 281.7080745341615}, {
         89.85913199740565, 95.01758749559224}}],
       StatusArea[#, 0.006730769230769231]& ,
       TagBoxNote->"0.006730769230769231"],
      StyleBox["0.006730769230769231`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.006730769230769231, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{450., 0.}, {500., 0.0038461538461538464`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{280.7080745341615, 288.3416149068323}, {
         91.6413272109142, 95.01758749559224}}],
       StatusArea[#, 0.0038461538461538464`]& ,
       TagBoxNote->"0.0038461538461538464"],
      StyleBox["0.0038461538461538464`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0038461538461538464`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{500., 0.}, {550., 0.0009615384615384616}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{287.3416149068323, 294.97515527950316`}, {
         93.42352242442273, 95.01758749559224}}],
       StatusArea[#, 0.0009615384615384616]& ,
       TagBoxNote->"0.0009615384615384616"],
      StyleBox["0.0009615384615384616`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0009615384615384616, {
        GrayLevel[0]}], "Tooltip"]& ], {}, 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{600., 0.}, {650., 0.0028846153846153848`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{300.60869565217394`, 308.2422360248447}, {
         92.23539228208371, 95.01758749559224}}],
       StatusArea[#, 0.0028846153846153848`]& ,
       TagBoxNote->"0.0028846153846153848"],
      StyleBox["0.0028846153846153848`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0028846153846153848`, {
        GrayLevel[0]}], "Tooltip"]& ], {}, {}, 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{750., 0.}, {800., 0.0009615384615384616}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{320.5093167701864, 328.14285714285717`}, {
         93.42352242442273, 95.01758749559224}}],
       StatusArea[#, 0.0009615384615384616]& ,
       TagBoxNote->"0.0009615384615384616"],
      StyleBox["0.0009615384615384616`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0009615384615384616, {
        GrayLevel[0]}], "Tooltip"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"G/V\"", TraditionalForm], 
    FormBox["\"Probability\"", TraditionalForm]},
  AxesOrigin->{-1500., 0},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  PlotRange->{{-1500., 800.}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.1]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.6166574788939943`*^9, 3.6166575530565243`*^9, 
  3.6166629038035226`*^9, 3.616670840549063*^9, 3.6166721198525105`*^9, 
  3.6166722551047482`*^9, 3.6166732015448112`*^9, 3.6166757432432756`*^9, 
  3.6166759589850554`*^9, 3.6166760301719804`*^9, 3.6166763631475654`*^9}]
}, Open  ]],

Cell["\<\
Irgendwie verleitet diese mehrgipflige Verteilung zum Abschneiden links. Geht \
aber leider nicht, da keine Informationen \[UDoubleDot]ber \
Intratrade-Drawdowns vorliegen. Muss also ohne weitergehen *grummel*.
Aber der Erwartungswert ist tats\[ADoubleDot]chlich positiv ? Oder ?\
\>", "Text",
 CellChangeTimes->{{3.616662913241539*^9, 3.616663054484187*^9}, 
   3.6166757432432756`*^9, 3.6166760301719804`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Median", "[", 
  RowBox[{"data", "[", 
   RowBox[{"[", 
    RowBox[{";;", ",", " ", "gVCol"}], "]"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.6166630334241505`*^9, 3.616663041146164*^9}, 
   3.6166757432432756`*^9, 3.6166760301719804`*^9}],

Cell[BoxData["0"], "Output",
 CellChangeTimes->{3.6166630416141644`*^9, 3.616670840658263*^9, 
  3.6166721199461107`*^9, 3.616672255198348*^9, 3.6166757432432756`*^9, 
  3.6166759591878557`*^9, 3.6166760301719804`*^9, 3.616676363225566*^9}]
}, Open  ]],

Cell["\<\
Ok, 50% aller Werte sind kleiner gleich 0. Die 0 trennt perfekt, tzz, das \
findet man so auch selten. Der Mittelwert d\[UDoubleDot]rfte aber leicht \
rechts verschoben sein, der sackt ja regelm\[ADoubleDot]\[SZ]ig in die \
Richtung vom Verteilungspeak.\
\>", "Text",
 CellChangeTimes->{{3.616662913241539*^9, 3.616663025702137*^9}, {
   3.6166630599441967`*^9, 3.6166631389427357`*^9}, 3.616666788466746*^9, 
   3.6166757432432756`*^9, 3.6166760301719804`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"data", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", " ", "gVCol"}], "]"}], "]"}], "]"}], " ", "//", 
  "N"}]], "Input",
 CellChangeTimes->{{3.616663103546273*^9, 3.6166631047318754`*^9}, {
   3.6166631445275455`*^9, 3.6166631489111533`*^9}, 3.6166757432432756`*^9, 
   3.6166760301719804`*^9}],

Cell[BoxData["6.667307692307692`"], "Output",
 CellChangeTimes->{{3.6166631457131476`*^9, 3.616663149441554*^9}, 
   3.616670840720663*^9, 3.6166721200085106`*^9, 3.6166722552919483`*^9, 
   3.6166757432432756`*^9, 3.616675959265856*^9, 3.6166760301719804`*^9, 
   3.616676363287966*^9}]
}, Open  ]],

Cell["\<\
Na ja, 6,6 Punkte ist ja besser als nichts. Man m\[UDoubleDot]sste es \
schaffen, die dicken Verluste links abzuschneiden, die Verteilung sieht so \
schlecht gar nicht aus. Ich schau mal weiter... \
\>", "Text",
 CellChangeTimes->{{3.6166631545895634`*^9, 3.616663219641677*^9}, {
   3.6166632613561506`*^9, 3.61666326642616*^9}, {3.6166668035519724`*^9, 
   3.6166668191207995`*^9}, 3.6166757432432756`*^9, 3.6166760301719804`*^9}],

Cell["\<\

Kumulierte Dichteverteilung ( zum Nachlesen, was man daraus ableiten kann : \
http://www.statistics4u.info/fundstat_germ/cc_cumulative_frqdist.html  ):\
\>", "Text",
 CellChangeTimes->{{3.616662913241539*^9, 3.616663025702137*^9}, {
   3.6166630599441967`*^9, 3.6166630948570585`*^9}, {3.616663272728571*^9, 
   3.6166633079222326`*^9}, {3.6166633686843395`*^9, 3.616663377155154*^9}, {
   3.6166668345024266`*^9, 3.6166668394632354`*^9}, 3.6166757432432756`*^9, 
   3.6166760301719804`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Histogram", "[", 
  RowBox[{
   RowBox[{"data", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", " ", "gVCol"}], "]"}], "]"}], ",", "Automatic", ",", 
   " ", "\"\<CDF\>\""}], "]"}]], "Input",
 CellChangeTimes->{{3.6166575601077366`*^9, 3.616657564038944*^9}, 
   3.6166757432432756`*^9, 3.6166760301719804`*^9}],

Cell[BoxData[
 GraphicsBox[
  {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
   EdgeForm[Opacity[0.7]], {}, 
   {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
    EdgeForm[Opacity[0.7]], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-1500., 0.}, {-1450., 0.0009615384615384616}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{15.5, 23.802218278615783`}, {95.34087496194917, 
         96.52385474233894}}],
       StatusArea[#, 0.0009615384615384616]& ,
       TagBoxNote->"0.0009615384615384616"],
      StyleBox["0.0009615384615384616`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0009615384615384616, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-1450., 0.}, {-1400., 0.0009615384615384616}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{22.802218278615783`, 31.104436557231566`}, {
         95.34087496194917, 96.52385474233894}}],
       StatusArea[#, 0.0009615384615384616]& ,
       TagBoxNote->"0.0009615384615384616"],
      StyleBox["0.0009615384615384616`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0009615384615384616, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-1400., 0.}, {-1350., 0.0009615384615384616}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{30.104436557231566`, 38.40665483584738}, {
         95.34087496194917, 96.52385474233894}}],
       StatusArea[#, 0.0009615384615384616]& ,
       TagBoxNote->"0.0009615384615384616"],
      StyleBox["0.0009615384615384616`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0009615384615384616, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-1350., 0.}, {-1300., 0.0009615384615384616}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{37.40665483584738, 45.70887311446316}, {
         95.34087496194917, 96.52385474233894}}],
       StatusArea[#, 0.0009615384615384616]& ,
       TagBoxNote->"0.0009615384615384616"],
      StyleBox["0.0009615384615384616`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0009615384615384616, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-1300., 0.}, {-1250., 0.0009615384615384616}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{44.70887311446316, 53.01109139307897}, {
         95.34087496194917, 96.52385474233894}}],
       StatusArea[#, 0.0009615384615384616]& ,
       TagBoxNote->"0.0009615384615384616"],
      StyleBox["0.0009615384615384616`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0009615384615384616, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-1250., 0.}, {-1200., 0.0009615384615384616}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{52.01109139307897, 60.31330967169475}, {
         95.34087496194917, 96.52385474233894}}],
       StatusArea[#, 0.0009615384615384616]& ,
       TagBoxNote->"0.0009615384615384616"],
      StyleBox["0.0009615384615384616`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0009615384615384616, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-1200., 0.}, {-1150., 0.0009615384615384616}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{59.31330967169475, 67.61552795031054}, {
         95.34087496194917, 96.52385474233894}}],
       StatusArea[#, 0.0009615384615384616]& ,
       TagBoxNote->"0.0009615384615384616"],
      StyleBox["0.0009615384615384616`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0009615384615384616, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-1150., 0.}, {-1100., 0.0009615384615384616}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{66.61552795031054, 74.91774622892635}, {
         95.34087496194917, 96.52385474233894}}],
       StatusArea[#, 0.0009615384615384616]& ,
       TagBoxNote->"0.0009615384615384616"],
      StyleBox["0.0009615384615384616`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0009615384615384616, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-1100., 0.}, {-1050., 0.0009615384615384616}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{73.91774622892635, 82.21996450754213}, {
         95.34087496194917, 96.52385474233894}}],
       StatusArea[#, 0.0009615384615384616]& ,
       TagBoxNote->"0.0009615384615384616"],
      StyleBox["0.0009615384615384616`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0009615384615384616, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-1050., 0.}, {-1000., 0.0009615384615384616}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{81.21996450754213, 89.52218278615791}, {
         95.34087496194917, 96.52385474233894}}],
       StatusArea[#, 0.0009615384615384616]& ,
       TagBoxNote->"0.0009615384615384616"],
      StyleBox["0.0009615384615384616`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0009615384615384616, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-1000., 0.}, {-950., 0.0009615384615384616}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{88.52218278615791, 96.82440106477372}, {
         95.34087496194917, 96.52385474233894}}],
       StatusArea[#, 0.0009615384615384616]& ,
       TagBoxNote->"0.0009615384615384616"],
      StyleBox["0.0009615384615384616`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0009615384615384616, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-950., 0.}, {-900., 0.0009615384615384616}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{95.82440106477372, 104.1266193433895}, {
         95.34087496194917, 96.52385474233894}}],
       StatusArea[#, 0.0009615384615384616]& ,
       TagBoxNote->"0.0009615384615384616"],
      StyleBox["0.0009615384615384616`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0009615384615384616, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-900., 0.}, {-850., 0.0009615384615384616}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{103.1266193433895, 111.4288376220053}, {
         95.34087496194917, 96.52385474233894}}],
       StatusArea[#, 0.0009615384615384616]& ,
       TagBoxNote->"0.0009615384615384616"],
      StyleBox["0.0009615384615384616`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0009615384615384616, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-850., 0.}, {-800., 0.0019230769230769232`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{110.4288376220053, 118.7310559006211}, {
         95.1578951815594, 96.52385474233894}}],
       StatusArea[#, 0.0019230769230769232`]& ,
       TagBoxNote->"0.0019230769230769232"],
      StyleBox["0.0019230769230769232`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0019230769230769232`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-800., 0.}, {-750., 0.0019230769230769232`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{117.7310559006211, 126.0332741792369}, {
         95.1578951815594, 96.52385474233894}}],
       StatusArea[#, 0.0019230769230769232`]& ,
       TagBoxNote->"0.0019230769230769232"],
      StyleBox["0.0019230769230769232`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0019230769230769232`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-750., 0.}, {-700., 0.0019230769230769232`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{125.0332741792369, 133.3354924578527}, {
         95.1578951815594, 96.52385474233894}}],
       StatusArea[#, 0.0019230769230769232`]& ,
       TagBoxNote->"0.0019230769230769232"],
      StyleBox["0.0019230769230769232`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0019230769230769232`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-700., 0.}, {-650., 0.0019230769230769232`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{132.3354924578527, 140.63771073646848`}, {
         95.1578951815594, 96.52385474233894}}],
       StatusArea[#, 0.0019230769230769232`]& ,
       TagBoxNote->"0.0019230769230769232"],
      StyleBox["0.0019230769230769232`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0019230769230769232`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-650., 0.}, {-600., 0.0028846153846153848`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{139.63771073646848`, 147.93992901508426`}, {
         94.97491540116961, 96.52385474233894}}],
       StatusArea[#, 0.0028846153846153848`]& ,
       TagBoxNote->"0.0028846153846153848"],
      StyleBox["0.0028846153846153848`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0028846153846153848`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-600., 0.}, {-550., 0.0028846153846153848`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{146.93992901508426`, 155.24214729370007`}, {
         94.97491540116961, 96.52385474233894}}],
       StatusArea[#, 0.0028846153846153848`]& ,
       TagBoxNote->"0.0028846153846153848"],
      StyleBox["0.0028846153846153848`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0028846153846153848`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-550., 0.}, {-500., 0.0038461538461538464`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{154.24214729370007`, 162.54436557231585`}, {
         94.79193562077984, 96.52385474233894}}],
       StatusArea[#, 0.0038461538461538464`]& ,
       TagBoxNote->"0.0038461538461538464"],
      StyleBox["0.0038461538461538464`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0038461538461538464`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-500., 0.}, {-450., 0.0057692307692307696`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{161.54436557231585`, 169.84658385093167`}, {
         94.4259760600003, 96.52385474233894}}],
       StatusArea[#, 0.0057692307692307696`]& ,
       TagBoxNote->"0.0057692307692307696"],
      StyleBox["0.0057692307692307696`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.0057692307692307696`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-450., 0.}, {-400., 0.007692307692307693}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{168.84658385093167`, 177.14880212954745`}, {
         94.06001649922075, 96.52385474233894}}],
       StatusArea[#, 0.007692307692307693]& ,
       TagBoxNote->"0.007692307692307693"],
      StyleBox["0.007692307692307693`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.007692307692307693, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-400., 0.}, {-350., 0.015384615384615385`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{176.14880212954745`, 184.45102040816323`}, {
         92.59617825610255, 96.52385474233894}}],
       StatusArea[#, 0.015384615384615385`]& ,
       TagBoxNote->"0.015384615384615385"],
      StyleBox["0.015384615384615385`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.015384615384615385`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-350., 0.}, {-300., 0.022115384615384617`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{183.45102040816323`, 191.75323868677904`}, {
         91.31531979337413, 96.52385474233894}}],
       StatusArea[#, 0.022115384615384617`]& ,
       TagBoxNote->"0.022115384615384617"],
      StyleBox["0.022115384615384617`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.022115384615384617`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-300., 0.}, {-250., 0.038461538461538464`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{190.75323868677904`, 199.05545696539482`}, {
         88.20466352674796, 96.52385474233894}}],
       StatusArea[#, 0.038461538461538464`]& ,
       TagBoxNote->"0.038461538461538464"],
      StyleBox["0.038461538461538464`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.038461538461538464`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-250., 0.}, {-200., 0.07211538461538462}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{198.05545696539482`, 206.35767524401064`}, {
         81.80037121310585, 96.52385474233894}}],
       StatusArea[#, 0.07211538461538462]& ,
       TagBoxNote->"0.07211538461538462"],
      StyleBox["0.07211538461538462`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.07211538461538462, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-200., 0.}, {-150., 0.1576923076923077}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{205.35767524401064`, 213.65989352262642`}, {
         65.5151707584159, 96.52385474233894}}],
       StatusArea[#, 0.1576923076923077]& ,
       TagBoxNote->"0.1576923076923077"],
      StyleBox["0.1576923076923077`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.1576923076923077, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-150., 0.}, {-100., 0.22884615384615387`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{212.65989352262642`, 220.9621118012422}, {
         51.97466700957259, 96.52385474233894}}],
       StatusArea[#, 0.22884615384615387`]& ,
       TagBoxNote->"0.22884615384615387"],
      StyleBox["0.22884615384615387`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.22884615384615387`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-100., 0.}, {-50., 0.26634615384615384`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{219.9621118012422, 228.264330079858}, {
         44.83845557437139, 96.52385474233894}}],
       StatusArea[#, 0.26634615384615384`]& ,
       TagBoxNote->"0.26634615384615384"],
      StyleBox["0.26634615384615384`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.26634615384615384`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{-50., 0.}, {0., 0.33269230769230773`}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{227.264330079858, 235.5665483584738}, {
         32.21285072747693, 96.52385474233894}}],
       StatusArea[#, 0.33269230769230773`]& ,
       TagBoxNote->"0.33269230769230773"],
      StyleBox["0.33269230769230773`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.33269230769230773`, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{0., 0.}, {50., 0.6125}, "RoundingRadius" -> 0]},
        ImageSizeCache->{{234.5665483584738, 
         242.86876663708958`}, {-21.034265365947462`, 96.52385474233894}}],
       StatusArea[#, 0.6125]& ,
       TagBoxNote->"0.6125"],
      StyleBox["0.6125`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.6125, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{50., 0.}, {100., 0.789423076923077}, "RoundingRadius" -> 
          0]},
        ImageSizeCache->{{241.86876663708958`, 
         250.1709849157054}, {-54.70254495766601, 96.52385474233894}}],
       StatusArea[#, 0.789423076923077]& ,
       TagBoxNote->"0.789423076923077"],
      StyleBox["0.789423076923077`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.789423076923077, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{100., 0.}, {150., 0.8692307692307693}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{249.1709849157054, 
         257.4732031943212}, {-69.88986673001726, 96.52385474233894}}],
       StatusArea[#, 0.8692307692307693]& ,
       TagBoxNote->"0.8692307692307693"],
      StyleBox["0.8692307692307693`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.8692307692307693, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{150., 0.}, {200., 0.9086538461538463}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{256.4732031943212, 
         264.77542147293696`}, {-77.39203772599804, 96.52385474233894}}],
       StatusArea[#, 0.9086538461538463]& ,
       TagBoxNote->"0.9086538461538463"],
      StyleBox["0.9086538461538463`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.9086538461538463, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{200., 0.}, {250., 0.9596153846153846}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{263.77542147293696`, 
         272.07763975155274`}, {-87.08996608665608, 96.52385474233894}}],
       StatusArea[#, 0.9596153846153846]& ,
       TagBoxNote->"0.9596153846153846"],
      StyleBox["0.9596153846153846`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.9596153846153846, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{250., 0.}, {300., 0.9730769230769232}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{271.07763975155274`, 
         279.3798580301686}, {-89.65168301211294, 96.52385474233894}}],
       StatusArea[#, 0.9730769230769232]& ,
       TagBoxNote->"0.9730769230769232"],
      StyleBox["0.9730769230769232`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.9730769230769232, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{300., 0.}, {350., 0.9817307692307693}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{278.3798580301686, 
         286.68207630878436`}, {-91.2985010356209, 96.52385474233894}}],
       StatusArea[#, 0.9817307692307693]& ,
       TagBoxNote->"0.9817307692307693"],
      StyleBox["0.9817307692307693`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.9817307692307693, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{350., 0.}, {400., 0.9846153846153847}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{285.68207630878436`, 
         293.98429458740014`}, {-91.84744037679023, 96.52385474233894}}],
       StatusArea[#, 0.9846153846153847]& ,
       TagBoxNote->"0.9846153846153847"],
      StyleBox["0.9846153846153847`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.9846153846153847, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{400., 0.}, {450., 0.9913461538461539}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{292.98429458740014`, 
         301.2865128660159}, {-93.12829883951865, 96.52385474233894}}],
       StatusArea[#, 0.9913461538461539]& ,
       TagBoxNote->"0.9913461538461539"],
      StyleBox["0.9913461538461539`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.9913461538461539, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{450., 0.}, {500., 0.9951923076923077}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{300.2865128660159, 
         308.58873114463177`}, {-93.86021796107774, 96.52385474233894}}],
       StatusArea[#, 0.9951923076923077]& ,
       TagBoxNote->"0.9951923076923077"],
      StyleBox["0.9951923076923077`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.9951923076923077, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{500., 0.}, {550., 0.9961538461538462}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{307.58873114463177`, 
         315.89094942324755`}, {-94.04319774146752, 96.52385474233894}}],
       StatusArea[#, 0.9961538461538462]& ,
       TagBoxNote->"0.9961538461538462"],
      StyleBox["0.9961538461538462`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.9961538461538462, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{550., 0.}, {600., 0.9961538461538462}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{314.89094942324755`, 
         323.19316770186333`}, {-94.04319774146752, 96.52385474233894}}],
       StatusArea[#, 0.9961538461538462]& ,
       TagBoxNote->"0.9961538461538462"],
      StyleBox["0.9961538461538462`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.9961538461538462, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{600., 0.}, {650., 0.9990384615384615}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{322.19316770186333`, 
         330.4953859804791}, {-94.59213708263682, 96.52385474233894}}],
       StatusArea[#, 0.9990384615384615]& ,
       TagBoxNote->"0.9990384615384615"],
      StyleBox["0.9990384615384615`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.9990384615384615, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{650., 0.}, {700., 0.9990384615384615}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{329.4953859804791, 
         337.7976042590949}, {-94.59213708263682, 96.52385474233894}}],
       StatusArea[#, 0.9990384615384615]& ,
       TagBoxNote->"0.9990384615384615"],
      StyleBox["0.9990384615384615`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.9990384615384615, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{700., 0.}, {750., 0.9990384615384615}, 
          "RoundingRadius" -> 0]},
        ImageSizeCache->{{336.7976042590949, 
         345.0998225377107}, {-94.59213708263682, 96.52385474233894}}],
       StatusArea[#, 0.9990384615384615]& ,
       TagBoxNote->"0.9990384615384615"],
      StyleBox["0.9990384615384615`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[0.9990384615384615, {
        GrayLevel[0]}], "Tooltip"]& ], 
    TagBox[
     TooltipBox[
      TagBox[
       DynamicBox[{
         FEPrivate`If[
          CurrentValue["MouseOver"], 
          EdgeForm[{
            GrayLevel[0.5], 
            AbsoluteThickness[1.5], 
            Opacity[0.66]}], {}, {}], 
         RectangleBox[{750., 0.}, {800., 1.}, "RoundingRadius" -> 0]},
        ImageSizeCache->{{344.0998225377107, 
         352.40204081632646`}, {-94.77511686302661, 96.52385474233894}}],
       StatusArea[#, 1.]& ,
       TagBoxNote->"1."],
      StyleBox["1.`", {
        GrayLevel[0]}, StripOnInput -> False]],
     Annotation[#, 
      Style[1., {
        GrayLevel[0]}], "Tooltip"]& ]}, {}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesOrigin->{-1500., 0.},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  PlotRange->{{-1500., 800.}, {All, All}},
  PlotRangePadding->{{
     Scaled[0.02], 
     Scaled[0.02]}, {
     Scaled[0.02], 
     Scaled[0.1]}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.616657564896945*^9, 3.6166708410326643`*^9, 
  3.6166721203361115`*^9, 3.616672255635149*^9, 3.616675743258876*^9, 
  3.6166759596246567`*^9, 3.61667603018198*^9, 3.6166763636467667`*^9}]
}, Open  ]],

Cell["\<\
Na, da sieht man auch gut, dass 50% aller Tage kleiner/gleich 0 enden. \
\>", "Text",
 CellChangeTimes->{{3.616657812828181*^9, 3.6166578521402497`*^9}, {
   3.6166633864683704`*^9, 3.616663493312958*^9}, 3.616666886122917*^9, 
   3.616675743258876*^9, 3.61667603018198*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Quantile", "[", 
  RowBox[{
   RowBox[{"data", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", " ", "gVCol"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.25", ",", "0.5", ",", "0.75"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6166669580858436`*^9, 3.616666994761508*^9}, 
   3.616675743258876*^9, 3.61667603018198*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "70"}], ",", "0", ",", "72"}], "}"}]], "Output",
 CellChangeTimes->{{3.6166669713926673`*^9, 3.616666995401109*^9}, 
   3.616670841173064*^9, 3.6166721204297113`*^9, 3.6166722557287493`*^9, 
   3.616675743258876*^9, 3.616675959718257*^9, 3.61667603018198*^9, 
   3.6166763637091665`*^9}]
}, Open  ]],

Cell["\<\
25% aller Werte liegen unter -70, 50% liegen unter/gleich 0 (ok, und f\
\[UDoubleDot]r Optimisten: 50% liegen \[UDoubleDot]ber/gleich 0), 25% aller \
Werte sind gr\[ODoubleDot]\[SZ]er als 72 Punkte. 
Wenn man diie Geb\[UDoubleDot]hren mit einrechnet, verschiebt sich das ganz \
nat\[UDoubleDot]rlich leicht. Man muss also an der Verteilung links was \
machen, da kommt man nicht drum herum.  \
\>", "Text",
 CellChangeTimes->{{3.616667010720336*^9, 3.616667180869835*^9}, 
   3.616675743258876*^9, 3.61667603018198*^9}],

Cell["\<\


\
\>", "Text",
 CellChangeTimes->{{3.616657812828181*^9, 3.6166578521402497`*^9}, {
   3.6166633864683704`*^9, 3.616663493312958*^9}, 3.616666886122917*^9, 
   3.616675743258876*^9, 3.61667603018198*^9}],

Cell[CellGroupData[{

Cell["Anteile Gewinner/Verlierer/0-Tage", "Subsubtitle",
 CellChangeTimes->{{3.6166634799749346`*^9, 3.6166634891165504`*^9}, 
   3.616675743258876*^9, 3.61667603018198*^9}],

Cell["Ich suche mal die Gewinner-, Verlierer- und GV-0-Tage raus.", "Text",
 CellChangeTimes->{{3.616657812828181*^9, 3.6166578521402497`*^9}, {
   3.6166633864683704`*^9, 3.616663497868166*^9}, 3.616675743258876*^9, 
   3.6166760301919804`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"winners", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", "gVCol"}], "]"}], "]"}], ",", 
     RowBox[{
      RowBox[{"#", ">", "0"}], "&"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"losers", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", "gVCol"}], "]"}], "]"}], ",", 
     RowBox[{
      RowBox[{"#", "<", "0"}], "&"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"zeros", "=", 
   RowBox[{"Select", "[", 
    RowBox[{
     RowBox[{"data", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", "gVCol"}], "]"}], "]"}], ",", 
     RowBox[{
      RowBox[{"#", "==", "0"}], "&"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6166577484312677`*^9, 3.6166578042013655`*^9}, {
   3.616657896600328*^9, 3.6166579006095347`*^9}, 3.616675743258876*^9, 
   3.6166760301919804`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"numberOfWinners", "=", " ", 
  RowBox[{"Length", "[", "winners", "]"}]}]], "Input",
 CellChangeTimes->{{3.616657594692998*^9, 3.616657744921262*^9}, 
   3.616657901795137*^9, 3.616675743258876*^9, 3.6166760301919804`*^9}],

Cell[BoxData["483"], "Output",
 CellChangeTimes->{{3.6166576428970823`*^9, 3.6166577370744476`*^9}, 
   3.616657916037962*^9, 3.6166708412822647`*^9, 3.616672120616912*^9, 
   3.61667225585355*^9, 3.616675743258876*^9, 3.6166759598118567`*^9, 
   3.6166760301919804`*^9, 3.6166763640055666`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"numberOfLosers", "=", " ", 
  RowBox[{"Length", "[", "losers", "]"}]}]], "Input",
 CellChangeTimes->{
  3.6166577277924314`*^9, {3.616657858349061*^9, 3.6166578664454746`*^9}, 
   3.616657902996339*^9, 3.616675743258876*^9, 3.6166760301919804`*^9}],

Cell[BoxData["346"], "Output",
 CellChangeTimes->{3.616657867100676*^9, 3.616657916115962*^9, 
  3.6166708413446646`*^9, 3.6166721206793118`*^9, 3.61667225591595*^9, 
  3.616675743258876*^9, 3.6166759598898573`*^9, 3.6166760301919804`*^9, 
  3.6166763640835667`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"numberOfZeros", "=", " ", 
  RowBox[{"Length", "[", "zeros", "]"}]}]], "Input",
 CellChangeTimes->{{3.6166578729662867`*^9, 3.6166579072551465`*^9}, {
   3.6166584322116685`*^9, 3.6166584395436816`*^9}, 3.616675743258876*^9, 
   3.6166760301919804`*^9}],

Cell[BoxData["211"], "Output",
 CellChangeTimes->{{3.616657907941548*^9, 3.6166579161783624`*^9}, {
   3.6166584327576694`*^9, 3.616658440776084*^9}, 3.6166708414070644`*^9, 
   3.6166721207261124`*^9, 3.6166722559783497`*^9, 3.616675743258876*^9, 
   3.6166759599678574`*^9, 3.6166760301919804`*^9, 3.6166763641459675`*^9}]
}, Open  ]],

Cell["\<\

Gesamtdatenl\[ADoubleDot]nge: \
\>", "Text",
 CellChangeTimes->{{3.6166581717380114`*^9, 3.616658181410028*^9}, 
   3.616675743258876*^9, 3.6166760301919804`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NData", "=", " ", 
  RowBox[{"Length", "[", 
   RowBox[{"data", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "gVCol"}], "]"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.61665814279996*^9, 3.616658166512002*^9}, 
   3.616675743258876*^9, 3.6166760301919804`*^9}],

Cell[BoxData["1040"], "Output",
 CellChangeTimes->{3.616658166902003*^9, 3.616670841469465*^9, 
  3.616672120788512*^9, 3.61667225604075*^9, 3.616675743258876*^9, 
  3.616675960030257*^9, 3.6166760301919804`*^9, 3.6166763642083673`*^9}]
}, Open  ]],

Cell["\<\

Jetzt ist die Frage, ob man die 0-Trades aus der Rechnung \
wegl\[ADoubleDot]sst oder den \[OpenCurlyDoubleQuote]Gewinnern\
\[CloseCurlyDoubleQuote] hinzurechnet. Man kann aber auch gemein sein und den \
Verlierern hinzurechnen, denn unter Ber\[UDoubleDot]cksichtung etwaiger Geb\
\[UDoubleDot]hren werden aus den neutralen Werten ja negative (0 minus Geb\
\[UDoubleDot]hren). 

 
Ich bestimme die Prozente mal separat, das ist am fairsten, finde ich. Die \
0-Tage kann man streng genommen auch weglassen, denn die tragen weder zum \
Gewinnteil noch zum Verlustteil was bei, sondern bl\[ADoubleDot]hen nur k\
\[UDoubleDot]nstlich auf. \
\>", "Text",
 CellChangeTimes->{
  3.616658186355237*^9, {3.6166582342005205`*^9, 3.6166583454755163`*^9}, {
   3.6166635088193855`*^9, 3.6166636143067703`*^9}, 3.6166757432744756`*^9, 
   3.6166760301919804`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"100", " ", "*", "  ", 
   RowBox[{"numberOfWinners", "/", "NData"}]}], "  ", "//", "N"}]], "Input",
 CellChangeTimes->{{3.6166581324883423`*^9, 3.6166581596011896`*^9}, 
   3.6166583341342964`*^9, {3.6166583768627715`*^9, 3.6166583936796007`*^9}, 
   3.6166757432744756`*^9, 3.6166760301919804`*^9}],

Cell[BoxData["46.44230769230769`"], "Output",
 CellChangeTimes->{{3.6166583849435854`*^9, 3.6166583941944017`*^9}, 
   3.616670841531865*^9, 3.616672120850912*^9, 3.61667225610315*^9, 
   3.6166757432744756`*^9, 3.6166759601550574`*^9, 3.6166760301919804`*^9, 
   3.6166763642863674`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"100", " ", "*", "  ", 
   RowBox[{"numberOfLosers", "/", "NData"}]}], "  ", "//", "N"}]], "Input",
 CellChangeTimes->{{3.6166581324883423`*^9, 3.6166581596011896`*^9}, 
   3.6166583341342964`*^9, {3.6166583768627715`*^9, 3.616658405052021*^9}, 
   3.6166757432744756`*^9, 3.6166760301919804`*^9}],

Cell[BoxData["33.26923076923077`"], "Output",
 CellChangeTimes->{3.616658405676022*^9, 3.616670841594265*^9, 
  3.6166721209133124`*^9, 3.61667225616555*^9, 3.6166757432744756`*^9, 
  3.6166759602330575`*^9, 3.6166760301919804`*^9, 3.6166763643487673`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"100", " ", "*", "  ", 
   RowBox[{"numberOfZeros", "/", "NData"}]}], "  ", "//", "N"}]], "Input",
 CellChangeTimes->{{3.6166584086556273`*^9, 3.6166584277812605`*^9}, 
   3.616675743290076*^9, 3.6166760301919804`*^9}],

Cell[BoxData["20.28846153846154`"], "Output",
 CellChangeTimes->{3.616658443786889*^9, 3.616670841656665*^9, 
  3.616672120975713*^9, 3.61667225622795*^9, 3.616675743290076*^9, 
  3.6166759603110576`*^9, 3.6166760301919804`*^9, 3.6166763644111676`*^9}]
}, Open  ]],

Cell["\<\



Wie sieht die Struktur der Handelstagsergebnisse aus ? Erkennt man eine \
Systematik ?\
\>", "Text",
 CellChangeTimes->{{3.61665798318048*^9, 3.6166580199185443`*^9}, {
   3.6166581150631113`*^9, 3.616658123299926*^9}, 3.616675743290076*^9, 
   3.6166760301919804`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"data", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", " ", "gVCol"}], "]"}], "]"}], ",", " ", 
   RowBox[{"ImageSize", "\[Rule]", " ", "600"}], ",", " ", 
   RowBox[{"AspectRatio", " ", "\[Rule]", " ", 
    RowBox[{"1", "/", "3"}]}], ",", 
   RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Speed\>\""}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Tag\>\"", ",", " ", "\"\<G/V\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6166579439932113`*^9, 3.61665794900082*^9}, {
   3.6166585851855373`*^9, 3.616658678317701*^9}, {3.616667406259031*^9, 
   3.6166674122650414`*^9}, 3.616673210514827*^9, 3.616675743290076*^9, 
   3.6166760301919804`*^9}],

Cell[BoxData[
 GraphicsBox[{
   {Opacity[0], PointBox[{{0.4545454545454546, 0.}}]}, 
   {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
    EdgeForm[Opacity[0.7]], {}, 
    {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
     EdgeForm[Opacity[0.7]], {}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{3.5454545454545454`, 0.}, {4.454545454545454, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{4.545454545454545, 0.}, {5.454545454545454, 210.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{6.545454545454545, 0.}, {7.454545454545454, -20.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{7.545454545454545, 0.}, {8.454545454545453, -16.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{8.545454545454545, 0.}, {9.454545454545453, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{9.545454545454545, 0.}, {10.454545454545453`, -198.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{12.545454545454545`, 0.}, {13.454545454545453`, -66.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{13.545454545454545`, 0.}, {14.454545454545453`, -108.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{14.545454545454545`, 0.}, {15.454545454545453`, -62.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{15.545454545454545`, 0.}, {16.454545454545453`, 246.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{16.545454545454543`, 0.}, {17.454545454545453`, 80.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{17.545454545454543`, 0.}, {18.454545454545453`, 52.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{18.545454545454543`, 0.}, {19.454545454545453`, -158.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{19.545454545454543`, 0.}, {20.454545454545453`, 80.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{20.545454545454543`, 0.}, {21.454545454545453`, -163.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{21.545454545454543`, 0.}, {22.454545454545453`, -70.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{23.545454545454543`, 0.}, {24.454545454545453`, -142.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], 
      RectangleBox[{24.545454545454543`, 0.}, {25.454545454545453`, 230.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{26.545454545454543`, 0.}, {27.454545454545453`, -108.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{27.545454545454543`, 0.}, {28.454545454545453`, 80.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{28.545454545454543`, 0.}, {29.454545454545453`, 480.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{29.545454545454543`, 0.}, {30.454545454545453`, 160.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{31.545454545454543`, 0.}, {32.45454545454545, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{32.54545454545455, 0.}, {33.45454545454545, -8.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{33.54545454545455, 0.}, {34.45454545454545, -10.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{36.54545454545455, 0.}, {37.45454545454545, -232.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{37.54545454545455, 0.}, {38.45454545454545, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{38.54545454545455, 0.}, {39.45454545454545, 262.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{39.54545454545455, 0.}, {40.45454545454545, 70.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{42.54545454545455, 0.}, {43.45454545454545, 10.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{44.54545454545455, 0.}, {45.45454545454545, -70.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{46.54545454545455, 0.}, {47.45454545454545, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{47.54545454545455, 0.}, {48.45454545454545, 14.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{50.54545454545455, 0.}, {51.45454545454545, 60.},
       RoundingRadius->0]}, {}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{54.54545454545455, 0.}, {55.45454545454545, 120.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{55.54545454545455, 0.}, {56.45454545454545, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], 
      RectangleBox[{56.54545454545455, 0.}, {57.45454545454545, -14.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{57.54545454545455, 0.}, {58.45454545454545, 180.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{58.54545454545455, 0.}, {59.45454545454545, -144.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{60.54545454545455, 0.}, {61.45454545454545, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{61.54545454545455, 0.}, {62.45454545454545, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{62.54545454545455, 0.}, {63.45454545454545, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{63.54545454545455, 0.}, {64.45454545454545, 6.},
       RoundingRadius->0]}, {}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{67.54545454545455, 0.}, {68.45454545454545, 42.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{68.54545454545455, 0.}, {69.45454545454545, 120.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{69.54545454545455, 0.}, {70.45454545454545, -10.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{70.54545454545455, 0.}, {71.45454545454545, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{71.54545454545455, 0.}, {72.45454545454545, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{72.54545454545455, 0.}, {73.45454545454545, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{73.54545454545455, 0.}, {74.45454545454545, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{74.54545454545455, 0.}, {75.45454545454545, -180.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{76.54545454545455, 0.}, {77.45454545454545, -130.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{77.54545454545455, 0.}, {78.45454545454545, 72.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{78.54545454545455, 0.}, {79.45454545454545, -210.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{79.54545454545455, 0.}, {80.45454545454545, 145.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{81.54545454545455, 0.}, {82.45454545454545, -630.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{82.54545454545455, 0.}, {83.45454545454545, -154.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{83.54545454545455, 0.}, {84.45454545454545, -50.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{84.54545454545455, 0.}, {85.45454545454545, 120.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{85.54545454545455, 0.}, {86.45454545454545, -190.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{86.54545454545455, 0.}, {87.45454545454545, -130.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{87.54545454545455, 0.}, {88.45454545454545, 200.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{88.54545454545455, 0.}, {89.45454545454545, -1469.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{89.54545454545455, 0.}, {90.45454545454545, -22.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{90.54545454545455, 0.}, {91.45454545454545, -160.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], 
      RectangleBox[{91.54545454545455, 0.}, {92.45454545454545, 150.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{92.54545454545455, 0.}, {93.45454545454545, 14.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{93.54545454545455, 0.}, {94.45454545454545, 160.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{94.54545454545455, 0.}, {95.45454545454545, -184.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{95.54545454545455, 0.}, {96.45454545454545, 240.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{96.54545454545455, 0.}, {97.45454545454545, 240.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{97.54545454545455, 0.}, {98.45454545454545, -158.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{98.54545454545455, 0.}, {99.45454545454545, -292.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{99.54545454545455, 0.}, {100.45454545454545`, 200.},
       RoundingRadius->0]}, {}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{103.54545454545455`, 0.}, {104.45454545454545`, -200.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{104.54545454545455`, 0.}, {105.45454545454545`, 80.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{106.54545454545455`, 0.}, {107.45454545454545`, 320.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{107.54545454545455`, 0.}, {108.45454545454545`, -120.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{109.54545454545455`, 0.}, {110.45454545454545`, -180.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{110.54545454545455`, 0.}, {111.45454545454545`, 160.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{111.54545454545455`, 0.}, {112.45454545454545`, 200.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{112.54545454545455`, 0.}, {113.45454545454545`, 340.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{113.54545454545455`, 0.}, {114.45454545454545`, -356.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{114.54545454545455`, 0.}, {115.45454545454545`, 320.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{116.54545454545455`, 0.}, {117.45454545454545`, -184.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{117.54545454545455`, 0.}, {118.45454545454545`, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{118.54545454545455`, 0.}, {119.45454545454545`, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{119.54545454545455`, 0.}, {120.45454545454545`, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{120.54545454545455`, 0.}, {121.45454545454545`, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{121.54545454545455`, 0.}, {122.45454545454545`, 62.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{122.54545454545455`, 0.}, {123.45454545454545`, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{123.54545454545455`, 0.}, {124.45454545454545`, -2.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{124.54545454545455`, 0.}, {125.45454545454545`, 420.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{125.54545454545455`, 0.}, {126.45454545454545`, -10.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{126.54545454545455`, 0.}, {127.45454545454545`, -182.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{127.54545454545455`, 0.}, {128.45454545454547`, 64.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{128.54545454545456`, 0.}, {129.45454545454547`, 160.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{129.54545454545456`, 0.}, {130.45454545454547`, 264.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{131.54545454545456`, 0.}, {132.45454545454547`, -218.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{132.54545454545456`, 0.}, {133.45454545454547`, -90.},
       RoundingRadius->0]}, {}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{136.54545454545456`, 0.}, {137.45454545454547`, -202.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{137.54545454545456`, 0.}, {138.45454545454547`, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{138.54545454545456`, 0.}, {139.45454545454547`, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{139.54545454545456`, 0.}, {140.45454545454547`, -286.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{140.54545454545456`, 0.}, {141.45454545454547`, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{141.54545454545456`, 0.}, {142.45454545454547`, -214.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{142.54545454545456`, 0.}, {143.45454545454547`, 196.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{143.54545454545456`, 0.}, {144.45454545454547`, -262.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{144.54545454545456`, 0.}, {145.45454545454547`, 38.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{145.54545454545456`, 0.}, {146.45454545454547`, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{146.54545454545456`, 0.}, {147.45454545454547`, 70.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{148.54545454545456`, 0.}, {149.45454545454547`, 178.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{149.54545454545456`, 0.}, {150.45454545454547`, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{150.54545454545456`, 0.}, {151.45454545454547`, -196.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{152.54545454545456`, 0.}, {153.45454545454547`, 124.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{153.54545454545456`, 0.}, {154.45454545454547`, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{154.54545454545456`, 0.}, {155.45454545454547`, -4.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{156.54545454545456`, 0.}, {157.45454545454547`, 184.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{157.54545454545456`, 0.}, {158.45454545454547`, -142.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{159.54545454545456`, 0.}, {160.45454545454547`, 80.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{160.54545454545456`, 0.}, {161.45454545454547`, 160.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{161.54545454545456`, 0.}, {162.45454545454547`, -32.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{163.54545454545456`, 0.}, {164.45454545454547`, -198.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{164.54545454545456`, 0.}, {165.45454545454547`, 100.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{166.54545454545456`, 0.}, {167.45454545454547`, -226.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{167.54545454545456`, 0.}, {168.45454545454547`, 80.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{169.54545454545456`, 0.}, {170.45454545454547`, -60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{170.54545454545456`, 0.}, {171.45454545454547`, -142.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{171.54545454545456`, 0.}, {172.45454545454547`, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{172.54545454545456`, 0.}, {173.45454545454547`, -262.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{174.54545454545456`, 0.}, {175.45454545454547`, 118.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{176.54545454545456`, 0.}, {177.45454545454547`, 124.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{177.54545454545456`, 0.}, {178.45454545454547`, 204.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{178.54545454545456`, 0.}, {179.45454545454547`, -136.},
       RoundingRadius->0]}, {}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{182.54545454545456`, 0.}, {183.45454545454547`, 60.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{184.54545454545456`, 0.}, {185.45454545454547`, 126.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{185.54545454545456`, 0.}, {186.45454545454547`, -70.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{187.54545454545456`, 0.}, {188.45454545454547`, 220.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{188.54545454545456`, 0.}, {189.45454545454547`, -190.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{189.54545454545456`, 0.}, {190.45454545454547`, -251.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{191.54545454545456`, 0.}, {192.45454545454547`, 420.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{192.54545454545456`, 0.}, {193.45454545454547`, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{193.54545454545456`, 0.}, {194.45454545454547`, 210.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{194.54545454545456`, 0.}, {195.45454545454547`, 280.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{195.54545454545456`, 0.}, {196.45454545454547`, -38.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{196.54545454545456`, 0.}, {197.45454545454547`, -148.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{197.54545454545456`, 0.}, {198.45454545454547`, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{198.54545454545456`, 0.}, {199.45454545454547`, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{199.54545454545456`, 0.}, {200.45454545454547`, 70.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{201.54545454545456`, 0.}, {202.45454545454547`, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{202.54545454545456`, 0.}, {203.45454545454547`, -156.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{203.54545454545456`, 0.}, {204.45454545454547`, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{204.54545454545456`, 0.}, {205.45454545454547`, 70.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{206.54545454545456`, 0.}, {207.45454545454547`, 60.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{208.54545454545456`, 0.}, {209.45454545454547`, -160.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{211.54545454545456`, 0.}, {212.45454545454547`, 120.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{212.54545454545456`, 0.}, {213.45454545454547`, 100.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{213.54545454545456`, 0.}, {214.45454545454547`, 70.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{215.54545454545456`, 0.}, {216.45454545454547`, 26.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{216.54545454545456`, 0.}, {217.45454545454547`, -70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{217.54545454545456`, 0.}, {218.45454545454547`, 54.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{218.54545454545456`, 0.}, {219.45454545454547`, -166.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{221.54545454545456`, 0.}, {222.45454545454547`, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{222.54545454545456`, 0.}, {223.45454545454547`, 170.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{223.54545454545456`, 0.}, {224.45454545454547`, 120.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{224.54545454545456`, 0.}, {225.45454545454547`, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{225.54545454545456`, 0.}, {226.45454545454547`, -136.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{226.54545454545456`, 0.}, {227.45454545454547`, -174.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{228.54545454545456`, 0.}, {229.45454545454547`, -160.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{229.54545454545456`, 0.}, {230.45454545454547`, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{230.54545454545456`, 0.}, {231.45454545454547`, 120.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{231.54545454545456`, 0.}, {232.45454545454547`, -90.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{232.54545454545456`, 0.}, {233.45454545454547`, -120.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{233.54545454545456`, 0.}, {234.45454545454547`, 8.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{234.54545454545456`, 0.}, {235.45454545454547`, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{235.54545454545456`, 0.}, {236.45454545454547`, -90.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{236.54545454545456`, 0.}, {237.45454545454547`, 210.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{237.54545454545456`, 0.}, {238.45454545454547`, -145.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{238.54545454545456`, 0.}, {239.45454545454547`, -113.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{239.54545454545456`, 0.}, {240.45454545454547`, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{240.54545454545456`, 0.}, {241.45454545454547`, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{241.54545454545456`, 0.}, {242.45454545454547`, 44.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{243.54545454545456`, 0.}, {244.45454545454547`, 120.},
       RoundingRadius->0]}, {}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{247.54545454545456`, 0.}, {248.45454545454547`, 60.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{249.54545454545456`, 0.}, {250.45454545454547`, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{250.54545454545456`, 0.}, {251.45454545454547`, 16.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{251.54545454545456`, 0.}, {252.45454545454547`, -20.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{253.54545454545456`, 0.}, {254.45454545454547`, 28.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{255.54545454545456`, 0.}, {256.4545454545455, -264.},
       RoundingRadius->0]}, {}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{259.54545454545456`, 0.}, {260.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{260.54545454545456`, 0.}, {261.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{261.54545454545456`, 0.}, {262.4545454545455, -126.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{262.54545454545456`, 0.}, {263.4545454545455, 164.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{263.54545454545456`, 0.}, {264.4545454545455, 132.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{264.54545454545456`, 0.}, {265.4545454545455, -234.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{265.54545454545456`, 0.}, {266.4545454545455, -36.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{266.54545454545456`, 0.}, {267.4545454545455, -136.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{267.54545454545456`, 0.}, {268.4545454545455, 46.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{268.54545454545456`, 0.}, {269.4545454545455, 41.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{270.54545454545456`, 0.}, {271.4545454545455, -70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{271.54545454545456`, 0.}, {272.4545454545455, -144.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{272.54545454545456`, 0.}, {273.4545454545455, 144.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{273.54545454545456`, 0.}, {274.4545454545455, 210.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{274.54545454545456`, 0.}, {275.4545454545455, 180.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{275.54545454545456`, 0.}, {276.4545454545455, 88.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{276.54545454545456`, 0.}, {277.4545454545455, -16.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{277.54545454545456`, 0.}, {278.4545454545455, 4.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{278.54545454545456`, 0.}, {279.4545454545455, -132.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{279.54545454545456`, 0.}, {280.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{280.54545454545456`, 0.}, {281.4545454545455, -112.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{281.54545454545456`, 0.}, {282.4545454545455, 42.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{284.54545454545456`, 0.}, {285.4545454545455, -26.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{285.54545454545456`, 0.}, {286.4545454545455, -36.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{287.54545454545456`, 0.}, {288.4545454545455, 180.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{288.54545454545456`, 0.}, {289.4545454545455, 44.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{290.54545454545456`, 0.}, {291.4545454545455, 60.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{292.54545454545456`, 0.}, {293.4545454545455, 40.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{293.54545454545456`, 0.}, {294.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{294.54545454545456`, 0.}, {295.4545454545455, -210.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{295.54545454545456`, 0.}, {296.4545454545455, 40.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{296.54545454545456`, 0.}, {297.4545454545455, -192.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{297.54545454545456`, 0.}, {298.4545454545455, 402.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{298.54545454545456`, 0.}, {299.4545454545455, -18.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{299.54545454545456`, 0.}, {300.4545454545455, -232.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{300.54545454545456`, 0.}, {301.4545454545455, -150.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{301.54545454545456`, 0.}, {302.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{302.54545454545456`, 0.}, {303.4545454545455, 310.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{303.54545454545456`, 0.}, {304.4545454545455, -114.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{304.54545454545456`, 0.}, {305.4545454545455, 210.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{305.54545454545456`, 0.}, {306.4545454545455, 210.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{306.54545454545456`, 0.}, {307.4545454545455, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{307.54545454545456`, 0.}, {308.4545454545455, -18.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{309.54545454545456`, 0.}, {310.4545454545455, 320.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{310.54545454545456`, 0.}, {311.4545454545455, -490.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{311.54545454545456`, 0.}, {312.4545454545455, -136.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{312.54545454545456`, 0.}, {313.4545454545455, 8.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{313.54545454545456`, 0.}, {314.4545454545455, 80.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{314.54545454545456`, 0.}, {315.4545454545455, -188.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{315.54545454545456`, 0.}, {316.4545454545455, 74.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{316.54545454545456`, 0.}, {317.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{317.54545454545456`, 0.}, {318.4545454545455, -226.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{318.54545454545456`, 0.}, {319.4545454545455, 60.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{320.54545454545456`, 0.}, {321.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{321.54545454545456`, 0.}, {322.4545454545455, -46.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{323.54545454545456`, 0.}, {324.4545454545455, -190.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{325.54545454545456`, 0.}, {326.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{326.54545454545456`, 0.}, {327.4545454545455, -24.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{327.54545454545456`, 0.}, {328.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{328.54545454545456`, 0.}, {329.4545454545455, 46.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{329.54545454545456`, 0.}, {330.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{330.54545454545456`, 0.}, {331.4545454545455, 16.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{331.54545454545456`, 0.}, {332.4545454545455, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{332.54545454545456`, 0.}, {333.4545454545455, 180.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{334.54545454545456`, 0.}, {335.4545454545455, -192.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{336.54545454545456`, 0.}, {337.4545454545455, -262.},
       RoundingRadius->0]}, {}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{340.54545454545456`, 0.}, {341.4545454545455, -54.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{341.54545454545456`, 0.}, {342.4545454545455, -106.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{343.54545454545456`, 0.}, {344.4545454545455, -2.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{344.54545454545456`, 0.}, {345.4545454545455, 18.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{345.54545454545456`, 0.}, {346.4545454545455, 72.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{346.54545454545456`, 0.}, {347.4545454545455, -138.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{347.54545454545456`, 0.}, {348.4545454545455, 280.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{348.54545454545456`, 0.}, {349.4545454545455, -310.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{349.54545454545456`, 0.}, {350.4545454545455, 130.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{350.54545454545456`, 0.}, {351.4545454545455, -148.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{351.54545454545456`, 0.}, {352.4545454545455, 86.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{352.54545454545456`, 0.}, {353.4545454545455, -156.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{353.54545454545456`, 0.}, {354.4545454545455, -84.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{354.54545454545456`, 0.}, {355.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{355.54545454545456`, 0.}, {356.4545454545455, 86.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{357.54545454545456`, 0.}, {358.4545454545455, 196.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{358.54545454545456`, 0.}, {359.4545454545455, -226.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{359.54545454545456`, 0.}, {360.4545454545455, -142.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{360.54545454545456`, 0.}, {361.4545454545455, 210.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{361.54545454545456`, 0.}, {362.4545454545455, -24.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{362.54545454545456`, 0.}, {363.4545454545455, -154.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{363.54545454545456`, 0.}, {364.4545454545455, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{364.54545454545456`, 0.}, {365.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{365.54545454545456`, 0.}, {366.4545454545455, -154.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{366.54545454545456`, 0.}, {367.4545454545455, -132.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{367.54545454545456`, 0.}, {368.4545454545455, 180.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{368.54545454545456`, 0.}, {369.4545454545455, 280.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{369.54545454545456`, 0.}, {370.4545454545455, -46.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{370.54545454545456`, 0.}, {371.4545454545455, 490.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{371.54545454545456`, 0.}, {372.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{372.54545454545456`, 0.}, {373.4545454545455, -136.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{373.54545454545456`, 0.}, {374.4545454545455, -160.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{374.54545454545456`, 0.}, {375.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{375.54545454545456`, 0.}, {376.4545454545455, -148.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{376.54545454545456`, 0.}, {377.4545454545455, -90.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{377.54545454545456`, 0.}, {378.4545454545455, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{378.54545454545456`, 0.}, {379.4545454545455, -322.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{379.54545454545456`, 0.}, {380.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{380.54545454545456`, 0.}, {381.4545454545455, -244.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{382.54545454545456`, 0.}, {383.4545454545455, -144.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{383.54545454545456`, 0.}, {384.4545454545455, 20.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{384.54545454545456`, 0.}, {385.4545454545455, 94.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{385.54545454545456`, 0.}, {386.4545454545455, 34.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{386.54545454545456`, 0.}, {387.4545454545455, -166.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{387.54545454545456`, 0.}, {388.4545454545455, -6.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{388.54545454545456`, 0.}, {389.4545454545455, -30.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{391.54545454545456`, 0.}, {392.4545454545455, 120.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{392.54545454545456`, 0.}, {393.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{393.54545454545456`, 0.}, {394.4545454545455, -156.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{394.54545454545456`, 0.}, {395.4545454545455, -144.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{395.54545454545456`, 0.}, {396.4545454545455, -274.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{396.54545454545456`, 0.}, {397.4545454545455, -206.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{397.54545454545456`, 0.}, {398.4545454545455, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{398.54545454545456`, 0.}, {399.4545454545455, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{399.54545454545456`, 0.}, {400.4545454545455, 102.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{400.54545454545456`, 0.}, {401.4545454545455, -250.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{401.54545454545456`, 0.}, {402.4545454545455, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{402.54545454545456`, 0.}, {403.4545454545455, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{403.54545454545456`, 0.}, {404.4545454545455, 60.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{405.54545454545456`, 0.}, {406.4545454545455, 120.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{406.54545454545456`, 0.}, {407.4545454545455, -360.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{407.54545454545456`, 0.}, {408.4545454545455, 210.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{408.54545454545456`, 0.}, {409.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{409.54545454545456`, 0.}, {410.4545454545455, -280.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{410.54545454545456`, 0.}, {411.4545454545455, -72.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{411.54545454545456`, 0.}, {412.4545454545455, 640.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{412.54545454545456`, 0.}, {413.4545454545455, -4.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{413.54545454545456`, 0.}, {414.4545454545455, 40.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{414.54545454545456`, 0.}, {415.4545454545455, 34.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{415.54545454545456`, 0.}, {416.4545454545455, 640.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{416.54545454545456`, 0.}, {417.4545454545455, -392.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{417.54545454545456`, 0.}, {418.4545454545455, 400.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{418.54545454545456`, 0.}, {419.4545454545455, 300.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{420.54545454545456`, 0.}, {421.4545454545455, -190.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{422.54545454545456`, 0.}, {423.4545454545455, -460.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{423.54545454545456`, 0.}, {424.4545454545455, 770.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{424.54545454545456`, 0.}, {425.4545454545455, -166.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{425.54545454545456`, 0.}, {426.4545454545455, 190.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{427.54545454545456`, 0.}, {428.4545454545455, -178.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{428.54545454545456`, 0.}, {429.4545454545455, 200.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{430.54545454545456`, 0.}, {431.4545454545455, 156.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{431.54545454545456`, 0.}, {432.4545454545455, 236.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{432.54545454545456`, 0.}, {433.4545454545455, 340.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{433.54545454545456`, 0.}, {434.4545454545455, -34.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{434.54545454545456`, 0.}, {435.4545454545455, -190.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{435.54545454545456`, 0.}, {436.4545454545455, 200.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{436.54545454545456`, 0.}, {437.4545454545455, -70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{437.54545454545456`, 0.}, {438.4545454545455, 200.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{438.54545454545456`, 0.}, {439.4545454545455, -268.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{439.54545454545456`, 0.}, {440.4545454545455, 200.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{440.54545454545456`, 0.}, {441.4545454545455, 400.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{441.54545454545456`, 0.}, {442.4545454545455, -38.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{442.54545454545456`, 0.}, {443.4545454545455, -2.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{444.54545454545456`, 0.}, {445.4545454545455, 200.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{445.54545454545456`, 0.}, {446.4545454545455, 110.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{446.54545454545456`, 0.}, {447.4545454545455, -214.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{447.54545454545456`, 0.}, {448.4545454545455, 310.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{448.54545454545456`, 0.}, {449.4545454545455, -202.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{449.54545454545456`, 0.}, {450.4545454545455, -352.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{450.54545454545456`, 0.}, {451.4545454545455, -166.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{451.54545454545456`, 0.}, {452.4545454545455, 200.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{452.54545454545456`, 0.}, {453.4545454545455, 214.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{453.54545454545456`, 0.}, {454.4545454545455, -178.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{454.54545454545456`, 0.}, {455.4545454545455, 200.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{455.54545454545456`, 0.}, {456.4545454545455, -286.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{456.54545454545456`, 0.}, {457.4545454545455, -8.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{457.54545454545456`, 0.}, {458.4545454545455, 200.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{459.54545454545456`, 0.}, {460.4545454545455, -68.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{461.54545454545456`, 0.}, {462.4545454545455, -172.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{464.54545454545456`, 0.}, {465.4545454545455, -160.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{465.54545454545456`, 0.}, {466.4545454545455, 9.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{468.54545454545456`, 0.}, {469.4545454545455, -160.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{470.54545454545456`, 0.}, {471.4545454545455, 200.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{471.54545454545456`, 0.}, {472.4545454545455, 200.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{472.54545454545456`, 0.}, {473.4545454545455, -44.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{473.54545454545456`, 0.}, {474.4545454545455, 36.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{474.54545454545456`, 0.}, {475.4545454545455, -172.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{475.54545454545456`, 0.}, {476.4545454545455, -8.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{477.54545454545456`, 0.}, {478.4545454545455, -104.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{478.54545454545456`, 0.}, {479.4545454545455, -370.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{479.54545454545456`, 0.}, {480.4545454545455, 600.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{481.54545454545456`, 0.}, {482.4545454545455, -322.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{482.54545454545456`, 0.}, {483.4545454545455, -80.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{483.54545454545456`, 0.}, {484.4545454545455, -68.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{485.54545454545456`, 0.}, {486.4545454545455, 200.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{488.54545454545456`, 0.}, {489.4545454545455, 200.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{489.54545454545456`, 0.}, {490.4545454545455, 150.},
       RoundingRadius->0]}, {}, {}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{494.54545454545456`, 0.}, {495.4545454545455, 20.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{496.54545454545456`, 0.}, {497.4545454545455, -802.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{497.54545454545456`, 0.}, {498.4545454545455, 466.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{498.54545454545456`, 0.}, {499.4545454545455, 240.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{499.54545454545456`, 0.}, {500.4545454545455, 200.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{501.54545454545456`, 0.}, {502.4545454545455, 22.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{502.54545454545456`, 0.}, {503.4545454545455, -198.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{503.54545454545456`, 0.}, {504.4545454545455, 40.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{504.54545454545456`, 0.}, {505.4545454545455, -202.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{505.54545454545456`, 0.}, {506.4545454545455, 44.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{506.54545454545456`, 0.}, {507.4545454545455, 80.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{507.54545454545456`, 0.}, {508.4545454545455, 252.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{508.54545454545456`, 0.}, {509.4545454545455, -28.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{509.54545454545456`, 0.}, {510.4545454545455, -200.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{510.54545454545456`, 0.}, {511.4545454545455, -206.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{511.54545454545456`, 0.}, {512.4545454545455, -90.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{512.5454545454546, 0.}, {513.4545454545455, 130.},
       RoundingRadius->0]}, {}, {}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{517.5454545454546, 0.}, {518.4545454545455, -80.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{519.5454545454546, 0.}, {520.4545454545455, -6.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{520.5454545454546, 0.}, {521.4545454545455, 80.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{521.5454545454546, 0.}, {522.4545454545455, 80.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{522.5454545454546, 0.}, {523.4545454545455, 116.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{523.5454545454546, 0.}, {524.4545454545455, 80.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{525.5454545454546, 0.}, {526.4545454545455, -140.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{527.5454545454546, 0.}, {528.4545454545455, 240.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{528.5454545454546, 0.}, {529.4545454545455, -170.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{529.5454545454546, 0.}, {530.4545454545455, 10.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{530.5454545454546, 0.}, {531.4545454545455, 44.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{531.5454545454546, 0.}, {532.4545454545455, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{532.5454545454546, 0.}, {533.4545454545455, 80.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{533.5454545454546, 0.}, {534.4545454545455, 210.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{534.5454545454546, 0.}, {535.4545454545455, 280.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{535.5454545454546, 0.}, {536.4545454545455, 70.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{537.5454545454546, 0.}, {538.4545454545455, -216.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{538.5454545454546, 0.}, {539.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{539.5454545454546, 0.}, {540.4545454545455, 248.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{540.5454545454546, 0.}, {541.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{541.5454545454546, 0.}, {542.4545454545455, -188.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{542.5454545454546, 0.}, {543.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{543.5454545454546, 0.}, {544.4545454545455, -142.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{544.5454545454546, 0.}, {545.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{545.5454545454546, 0.}, {546.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{546.5454545454546, 0.}, {547.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{547.5454545454546, 0.}, {548.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{548.5454545454546, 0.}, {549.4545454545455, -142.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{550.5454545454546, 0.}, {551.4545454545455, 80.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{552.5454545454546, 0.}, {553.4545454545455, -46.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{553.5454545454546, 0.}, {554.4545454545455, 94.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{554.5454545454546, 0.}, {555.4545454545455, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{555.5454545454546, 0.}, {556.4545454545455, 107.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{556.5454545454546, 0.}, {557.4545454545455, -18.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{557.5454545454546, 0.}, {558.4545454545455, 210.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{558.5454545454546, 0.}, {559.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{559.5454545454546, 0.}, {560.4545454545455, 210.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], 
      RectangleBox[{560.5454545454546, 0.}, {561.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{561.5454545454546, 0.}, {562.4545454545455, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{562.5454545454546, 0.}, {563.4545454545455, -163.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{563.5454545454546, 0.}, {564.4545454545455, 89.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{564.5454545454546, 0.}, {565.4545454545455, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{565.5454545454546, 0.}, {566.4545454545455, -214.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{567.5454545454546, 0.}, {568.4545454545455, -200.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{570.5454545454546, 0.}, {571.4545454545455, -154.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{571.5454545454546, 0.}, {572.4545454545455, -10.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{572.5454545454546, 0.}, {573.4545454545455, -14.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{573.5454545454546, 0.}, {574.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{574.5454545454546, 0.}, {575.4545454545455, 300.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{575.5454545454546, 0.}, {576.4545454545455, -138.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{576.5454545454546, 0.}, {577.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{577.5454545454546, 0.}, {578.4545454545455, -177.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{578.5454545454546, 0.}, {579.4545454545455, 280.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{579.5454545454546, 0.}, {580.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{580.5454545454546, 0.}, {581.4545454545455, -36.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{581.5454545454546, 0.}, {582.4545454545455, -180.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{582.5454545454546, 0.}, {583.4545454545455, -250.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{583.5454545454546, 0.}, {584.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{584.5454545454546, 0.}, {585.4545454545455, -8.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{585.5454545454546, 0.}, {586.4545454545455, -66.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{586.5454545454546, 0.}, {587.4545454545455, -162.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{587.5454545454546, 0.}, {588.4545454545455, -150.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{590.5454545454546, 0.}, {591.4545454545455, -176.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{591.5454545454546, 0.}, {592.4545454545455, -224.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{592.5454545454546, 0.}, {593.4545454545455, 160.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{593.5454545454546, 0.}, {594.4545454545455, -130.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], 
      RectangleBox[{594.5454545454546, 0.}, {595.4545454545455, 144.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{595.5454545454546, 0.}, {596.4545454545455, -200.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{596.5454545454546, 0.}, {597.4545454545455, 218.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{597.5454545454546, 0.}, {598.4545454545455, 162.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{598.5454545454546, 0.}, {599.4545454545455, 80.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{599.5454545454546, 0.}, {600.4545454545455, -152.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{600.5454545454546, 0.}, {601.4545454545455, 160.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{601.5454545454546, 0.}, {602.4545454545455, -158.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{602.5454545454546, 0.}, {603.4545454545455, 122.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{603.5454545454546, 0.}, {604.4545454545455, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{604.5454545454546, 0.}, {605.4545454545455, 24.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{606.5454545454546, 0.}, {607.4545454545455, -144.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{607.5454545454546, 0.}, {608.4545454545455, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{608.5454545454546, 0.}, {609.4545454545455, -60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{609.5454545454546, 0.}, {610.4545454545455, -18.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{610.5454545454546, 0.}, {611.4545454545455, 28.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{611.5454545454546, 0.}, {612.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{612.5454545454546, 0.}, {613.4545454545455, 240.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{613.5454545454546, 0.}, {614.4545454545455, 208.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{614.5454545454546, 0.}, {615.4545454545455, -85.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{615.5454545454546, 0.}, {616.4545454545455, 160.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{616.5454545454546, 0.}, {617.4545454545455, 80.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{617.5454545454546, 0.}, {618.4545454545455, -114.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{618.5454545454546, 0.}, {619.4545454545455, 160.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{619.5454545454546, 0.}, {620.4545454545455, -22.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{620.5454545454546, 0.}, {621.4545454545455, 80.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{621.5454545454546, 0.}, {622.4545454545455, 80.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{622.5454545454546, 0.}, {623.4545454545455, 400.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{623.5454545454546, 0.}, {624.4545454545455, -149.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{625.5454545454546, 0.}, {626.4545454545455, 80.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{626.5454545454546, 0.}, {627.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{627.5454545454546, 0.}, {628.4545454545455, 80.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{628.5454545454546, 0.}, {629.4545454545455, -172.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{630.5454545454546, 0.}, {631.4545454545455, 100.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{631.5454545454546, 0.}, {632.4545454545455, -156.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{632.5454545454546, 0.}, {633.4545454545455, 240.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{633.5454545454546, 0.}, {634.4545454545455, 80.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{635.5454545454546, 0.}, {636.4545454545455, 186.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{636.5454545454546, 0.}, {637.4545454545455, 100.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], 
      RectangleBox[{638.5454545454546, 0.}, {639.4545454545455, -52.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{640.5454545454546, 0.}, {641.4545454545455, -200.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{641.5454545454546, 0.}, {642.4545454545455, 84.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{642.5454545454546, 0.}, {643.4545454545455, 24.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{644.5454545454546, 0.}, {645.4545454545455, -152.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{646.5454545454546, 0.}, {647.4545454545455, 4.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{647.5454545454546, 0.}, {648.4545454545455, -165.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{648.5454545454546, 0.}, {649.4545454545455, -102.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{649.5454545454546, 0.}, {650.4545454545455, 102.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{650.5454545454546, 0.}, {651.4545454545455, -24.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{651.5454545454546, 0.}, {652.4545454545455, 40.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{652.5454545454546, 0.}, {653.4545454545455, 490.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{653.5454545454546, 0.}, {654.4545454545455, -202.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{655.5454545454546, 0.}, {656.4545454545455, 350.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{656.5454545454546, 0.}, {657.4545454545455, 252.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{657.5454545454546, 0.}, {658.4545454545455, 210.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{658.5454545454546, 0.}, {659.4545454545455, -136.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{659.5454545454546, 0.}, {660.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{660.5454545454546, 0.}, {661.4545454545455, 26.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{661.5454545454546, 0.}, {662.4545454545455, -148.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{662.5454545454546, 0.}, {663.4545454545455, -28.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{663.5454545454546, 0.}, {664.4545454545455, -132.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{664.5454545454546, 0.}, {665.4545454545455, -538.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{665.5454545454546, 0.}, {666.4545454545455, -144.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{666.5454545454546, 0.}, {667.4545454545455, -170.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{667.5454545454546, 0.}, {668.4545454545455, 114.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{668.5454545454546, 0.}, {669.4545454545455, -306.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{669.5454545454546, 0.}, {670.4545454545455, 70.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{672.5454545454546, 0.}, {673.4545454545455, -128.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], 
      RectangleBox[{673.5454545454546, 0.}, {674.4545454545455, -142.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{674.5454545454546, 0.}, {675.4545454545455, 128.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{675.5454545454546, 0.}, {676.4545454545455, 210.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{676.5454545454546, 0.}, {677.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{677.5454545454546, 0.}, {678.4545454545455, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{678.5454545454546, 0.}, {679.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{679.5454545454546, 0.}, {680.4545454545455, 50.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{681.5454545454546, 0.}, {682.4545454545455, 60.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{684.5454545454546, 0.}, {685.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{685.5454545454546, 0.}, {686.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{686.5454545454546, 0.}, {687.4545454545455, 120.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{687.5454545454546, 0.}, {688.4545454545455, -130.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{688.5454545454546, 0.}, {689.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{689.5454545454546, 0.}, {690.4545454545455, 238.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{690.5454545454546, 0.}, {691.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{691.5454545454546, 0.}, {692.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{692.5454545454546, 0.}, {693.4545454545455, -70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{693.5454545454546, 0.}, {694.4545454545455, -154.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{694.5454545454546, 0.}, {695.4545454545455, -20.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{695.5454545454546, 0.}, {696.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{696.5454545454546, 0.}, {697.4545454545455, 277.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{697.5454545454546, 0.}, {698.4545454545455, -148.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{698.5454545454546, 0.}, {699.4545454545455, 82.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{700.5454545454546, 0.}, {701.4545454545455, -250.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{701.5454545454546, 0.}, {702.4545454545455, 140.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{702.5454545454546, 0.}, {703.4545454545455, 70.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{705.5454545454546, 0.}, {706.4545454545455, 120.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{706.5454545454546, 0.}, {707.4545454545455, 60.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{708.5454545454546, 0.}, {709.4545454545455, 34.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{709.5454545454546, 0.}, {710.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{710.5454545454546, 0.}, {711.4545454545455, -78.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{711.5454545454546, 0.}, {712.4545454545455, -120.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{713.5454545454546, 0.}, {714.4545454545455, -238.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{714.5454545454546, 0.}, {715.4545454545455, -154.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{715.5454545454546, 0.}, {716.4545454545455, -130.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{716.5454545454546, 0.}, {717.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{717.5454545454546, 0.}, {718.4545454545455, 120.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{718.5454545454546, 0.}, {719.4545454545455, 158.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{719.5454545454546, 0.}, {720.4545454545455, 180.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], 
      RectangleBox[{720.5454545454546, 0.}, {721.4545454545455, -18.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{721.5454545454546, 0.}, {722.4545454545455, 12.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{722.5454545454546, 0.}, {723.4545454545455, -142.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{724.5454545454546, 0.}, {725.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{725.5454545454546, 0.}, {726.4545454545455, -118.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{727.5454545454546, 0.}, {728.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{728.5454545454546, 0.}, {729.4545454545455, -72.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{729.5454545454546, 0.}, {730.4545454545455, 38.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{730.5454545454546, 0.}, {731.4545454545455, -150.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{731.5454545454546, 0.}, {732.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{732.5454545454546, 0.}, {733.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{733.5454545454546, 0.}, {734.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{734.5454545454546, 0.}, {735.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{735.5454545454546, 0.}, {736.4545454545455, -154.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{736.5454545454546, 0.}, {737.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{737.5454545454546, 0.}, {738.4545454545455, -118.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{738.5454545454546, 0.}, {739.4545454545455, 60.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{740.5454545454546, 0.}, {741.4545454545455, 42.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{741.5454545454546, 0.}, {742.4545454545455, -150.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{742.5454545454546, 0.}, {743.4545454545455, -100.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{743.5454545454546, 0.}, {744.4545454545455, -420.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{744.5454545454546, 0.}, {745.4545454545455, 38.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{745.5454545454546, 0.}, {746.4545454545455, 280.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{746.5454545454546, 0.}, {747.4545454545455, -174.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{748.5454545454546, 0.}, {749.4545454545455, 150.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{749.5454545454546, 0.}, {750.4545454545455, -172.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{750.5454545454546, 0.}, {751.4545454545455, -26.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{752.5454545454546, 0.}, {753.4545454545455, -10.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{753.5454545454546, 0.}, {754.4545454545455, 38.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{755.5454545454546, 0.}, {756.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{756.5454545454546, 0.}, {757.4545454545455, 30.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{758.5454545454546, 0.}, {759.4545454545455, 42.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{759.5454545454546, 0.}, {760.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{760.5454545454546, 0.}, {761.4545454545455, 16.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{762.5454545454546, 0.}, {763.4545454545455, 10.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{763.5454545454546, 0.}, {764.4545454545455, 88.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{764.5454545454546, 0.}, {765.4545454545455, 180.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{765.5454545454546, 0.}, {766.4545454545455, -26.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{766.5454545454546, 0.}, {767.4545454545455, 62.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], 
      RectangleBox[{767.5454545454546, 0.}, {768.4545454545455, 92.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{769.5454545454546, 0.}, {770.4545454545455, 60.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{772.5454545454546, 0.}, {773.4545454545455, 10.},
       RoundingRadius->0]}, {}, {}, {}, {}, {}, {}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{781.5454545454546, 0.}, {782.4545454545455, 46.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{783.5454545454546, 0.}, {784.4545454545455, 8.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{784.5454545454546, 0.}, {785.4545454545455, 12.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{785.5454545454546, 0.}, {786.4545454545455, 30.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{786.5454545454546, 0.}, {787.4545454545455, 102.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{787.5454545454546, 0.}, {788.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{788.5454545454546, 0.}, {789.4545454545455, 120.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{789.5454545454546, 0.}, {790.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{790.5454545454546, 0.}, {791.4545454545455, 136.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{792.5454545454546, 0.}, {793.4545454545455, 64.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{795.5454545454546, 0.}, {796.4545454545455, -186.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{797.5454545454546, 0.}, {798.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{798.5454545454546, 0.}, {799.4545454545455, -160.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{799.5454545454546, 0.}, {800.4545454545455, 20.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{800.5454545454546, 0.}, {801.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{801.5454545454546, 0.}, {802.4545454545455, -60.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{803.5454545454546, 0.}, {804.4545454545455, 54.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{804.5454545454546, 0.}, {805.4545454545455, -426.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{805.5454545454546, 0.}, {806.4545454545455, 48.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{806.5454545454546, 0.}, {807.4545454545455, -264.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{807.5454545454546, 0.}, {808.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{808.5454545454546, 0.}, {809.4545454545455, 78.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{809.5454545454546, 0.}, {810.4545454545455, 8.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{810.5454545454546, 0.}, {811.4545454545455, 4.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{811.5454545454546, 0.}, {812.4545454545455, 104.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{812.5454545454546, 0.}, {813.4545454545455, -174.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{813.5454545454546, 0.}, {814.4545454545455, 180.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{814.5454545454546, 0.}, {815.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{815.5454545454546, 0.}, {816.4545454545455, -130.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{816.5454545454546, 0.}, {817.4545454545455, -30.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{817.5454545454546, 0.}, {818.4545454545455, -210.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{818.5454545454546, 0.}, {819.4545454545455, -112.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{819.5454545454546, 0.}, {820.4545454545455, -352.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{820.5454545454546, 0.}, {821.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{821.5454545454546, 0.}, {822.4545454545455, -72.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{822.5454545454546, 0.}, {823.4545454545455, 38.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{823.5454545454546, 0.}, {824.4545454545455, -61.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{825.5454545454546, 0.}, {826.4545454545455, -130.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{826.5454545454546, 0.}, {827.4545454545455, -178.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{828.5454545454546, 0.}, {829.4545454545455, 130.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{829.5454545454546, 0.}, {830.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{830.5454545454546, 0.}, {831.4545454545455, 104.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{831.5454545454546, 0.}, {832.4545454545455, 120.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{832.5454545454546, 0.}, {833.4545454545455, -44.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{833.5454545454546, 0.}, {834.4545454545455, 60.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], 
      RectangleBox[{835.5454545454546, 0.}, {836.4545454545455, 190.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{836.5454545454546, 0.}, {837.4545454545455, 30.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{837.5454545454546, 0.}, {838.4545454545455, -133.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{838.5454545454546, 0.}, {839.4545454545455, 197.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{839.5454545454546, 0.}, {840.4545454545455, -138.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{841.5454545454546, 0.}, {842.4545454545455, -162.},
       RoundingRadius->0]}, {}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{845.5454545454546, 0.}, {846.4545454545455, -292.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{846.5454545454546, 0.}, {847.4545454545455, 32.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{847.5454545454546, 0.}, {848.4545454545455, 74.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{848.5454545454546, 0.}, {849.4545454545455, -300.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{850.5454545454546, 0.}, {851.4545454545455, 128.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{851.5454545454546, 0.}, {852.4545454545455, -208.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{852.5454545454546, 0.}, {853.4545454545455, 160.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{853.5454545454546, 0.}, {854.4545454545455, -169.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{854.5454545454546, 0.}, {855.4545454545455, -157.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{855.5454545454546, 0.}, {856.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{856.5454545454546, 0.}, {857.4545454545455, -378.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{857.5454545454546, 0.}, {858.4545454545455, 208.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{858.5454545454546, 0.}, {859.4545454545455, 140.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{860.5454545454546, 0.}, {861.4545454545455, -190.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{861.5454545454546, 0.}, {862.4545454545455, -178.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{862.5454545454546, 0.}, {863.4545454545455, -166.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{863.5454545454546, 0.}, {864.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{864.5454545454546, 0.}, {865.4545454545455, -66.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{865.5454545454546, 0.}, {866.4545454545455, 70.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{867.5454545454546, 0.}, {868.4545454545455, 206.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{868.5454545454546, 0.}, {869.4545454545455, -250.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{870.5454545454546, 0.}, {871.4545454545455, 130.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{871.5454545454546, 0.}, {872.4545454545455, -70.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], 
      RectangleBox[{873.5454545454546, 0.}, {874.4545454545455, 210.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{874.5454545454546, 0.}, {875.4545454545455, 240.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{875.5454545454546, 0.}, {876.4545454545455, 24.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{876.5454545454546, 0.}, {877.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{877.5454545454546, 0.}, {878.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{878.5454545454546, 0.}, {879.4545454545455, -274.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{879.5454545454546, 0.}, {880.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{880.5454545454546, 0.}, {881.4545454545455, 130.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{881.5454545454546, 0.}, {882.4545454545455, 350.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{882.5454545454546, 0.}, {883.4545454545455, -150.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{883.5454545454546, 0.}, {884.4545454545455, -162.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{884.5454545454546, 0.}, {885.4545454545455, 54.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{885.5454545454546, 0.}, {886.4545454545455, -166.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{886.5454545454546, 0.}, {887.4545454545455, -138.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{887.5454545454546, 0.}, {888.4545454545455, 130.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{888.5454545454546, 0.}, {889.4545454545455, -156.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{889.5454545454546, 0.}, {890.4545454545455, 510.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{890.5454545454546, 0.}, {891.4545454545455, 4.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{891.5454545454546, 0.}, {892.4545454545455, -24.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{892.5454545454546, 0.}, {893.4545454545455, -78.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{893.5454545454546, 0.}, {894.4545454545455, -46.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{894.5454545454546, 0.}, {895.4545454545455, -72.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{895.5454545454546, 0.}, {896.4545454545455, -246.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{896.5454545454546, 0.}, {897.4545454545455, 90.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{897.5454545454546, 0.}, {898.4545454545455, 43.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{898.5454545454546, 0.}, {899.4545454545455, 224.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{899.5454545454546, 0.}, {900.4545454545455, -166.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{900.5454545454546, 0.}, {901.4545454545455, -6.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{901.5454545454546, 0.}, {902.4545454545455, 274.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{902.5454545454546, 0.}, {903.4545454545455, -18.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{903.5454545454546, 0.}, {904.4545454545455, -241.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{904.5454545454546, 0.}, {905.4545454545455, 350.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{905.5454545454546, 0.}, {906.4545454545455, -183.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{906.5454545454546, 0.}, {907.4545454545455, -136.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{907.5454545454546, 0.}, {908.4545454545455, 170.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{908.5454545454546, 0.}, {909.4545454545455, 420.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{909.5454545454546, 0.}, {910.4545454545455, 280.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{910.5454545454546, 0.}, {911.4545454545455, 280.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{911.5454545454546, 0.}, {912.4545454545455, -370.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], 
      RectangleBox[{912.5454545454546, 0.}, {913.4545454545455, -300.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{913.5454545454546, 0.}, {914.4545454545455, -312.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{914.5454545454546, 0.}, {915.4545454545455, -182.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{915.5454545454546, 0.}, {916.4545454545455, 30.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{916.5454545454546, 0.}, {917.4545454545455, 70.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{918.5454545454546, 0.}, {919.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{919.5454545454546, 0.}, {920.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{920.5454545454546, 0.}, {921.4545454545455, -16.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{921.5454545454546, 0.}, {922.4545454545455, 200.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{922.5454545454546, 0.}, {923.4545454545455, -94.},
       RoundingRadius->0]}, {}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{926.5454545454546, 0.}, {927.4545454545455, -154.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{927.5454545454546, 0.}, {928.4545454545455, -240.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{928.5454545454546, 0.}, {929.4545454545455, -211.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{929.5454545454546, 0.}, {930.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{930.5454545454546, 0.}, {931.4545454545455, 84.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{931.5454545454546, 0.}, {932.4545454545455, 130.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{932.5454545454546, 0.}, {933.4545454545455, -8.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{933.5454545454546, 0.}, {934.4545454545455, 136.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{935.5454545454546, 0.}, {936.4545454545455, -252.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{937.5454545454546, 0.}, {938.4545454545455, 132.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{938.5454545454546, 0.}, {939.4545454545455, 130.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{939.5454545454546, 0.}, {940.4545454545455, -150.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{940.5454545454546, 0.}, {941.4545454545455, 34.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{941.5454545454546, 0.}, {942.4545454545455, 120.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{942.5454545454546, 0.}, {943.4545454545455, -132.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{943.5454545454546, 0.}, {944.4545454545455, 34.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{944.5454545454546, 0.}, {945.4545454545455, 36.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{945.5454545454546, 0.}, {946.4545454545455, 240.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{946.5454545454546, 0.}, {947.4545454545455, 120.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], 
      RectangleBox[{947.5454545454546, 0.}, {948.4545454545455, -172.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{948.5454545454546, 0.}, {949.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{949.5454545454546, 0.}, {950.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{950.5454545454546, 0.}, {951.4545454545455, -192.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{951.5454545454546, 0.}, {952.4545454545455, -113.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{952.5454545454546, 0.}, {953.4545454545455, 102.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{953.5454545454546, 0.}, {954.4545454545455, 24.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{954.5454545454546, 0.}, {955.4545454545455, 14.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{955.5454545454546, 0.}, {956.4545454545455, -48.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{956.5454545454546, 0.}, {957.4545454545455, 130.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{957.5454545454546, 0.}, {958.4545454545455, 130.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{958.5454545454546, 0.}, {959.4545454545455, 158.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{959.5454545454546, 0.}, {960.4545454545455, 78.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{960.5454545454546, 0.}, {961.4545454545455, -124.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{962.5454545454546, 0.}, {963.4545454545455, 78.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{963.5454545454546, 0.}, {964.4545454545455, 70.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{966.5454545454546, 0.}, {967.4545454545455, -250.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{967.5454545454546, 0.}, {968.4545454545455, -136.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{969.5454545454546, 0.}, {970.4545454545455, 100.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{970.5454545454546, 0.}, {971.4545454545455, 44.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{971.5454545454546, 0.}, {972.4545454545455, 120.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{973.5454545454546, 0.}, {974.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{974.5454545454546, 0.}, {975.4545454545455, 180.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{975.5454545454546, 0.}, {976.4545454545455, -54.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{976.5454545454546, 0.}, {977.4545454545455, -168.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{977.5454545454546, 0.}, {978.4545454545455, 80.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{978.5454545454546, 0.}, {979.4545454545455, -46.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{979.5454545454546, 0.}, {980.4545454545455, -138.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{980.5454545454546, 0.}, {981.4545454545455, -46.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], 
      RectangleBox[{981.5454545454546, 0.}, {982.4545454545455, 137.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{982.5454545454546, 0.}, {983.4545454545455, -208.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{983.5454545454546, 0.}, {984.4545454545455, 60.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{985.5454545454546, 0.}, {986.4545454545455, 150.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{986.5454545454546, 0.}, {987.4545454545455, -30.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{987.5454545454546, 0.}, {988.4545454545455, 180.},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{990.5454545454546, 0.}, {991.4545454545455, -208.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{992.5454545454546, 0.}, {993.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{993.5454545454546, 0.}, {994.4545454545455, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{994.5454545454546, 0.}, {995.4545454545455, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{995.5454545454546, 0.}, {996.4545454545455, -18.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{996.5454545454546, 0.}, {997.4545454545455, 48.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{997.5454545454546, 0.}, {998.4545454545455, 78.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{998.5454545454546, 0.}, {999.4545454545455, 60.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1000.5454545454546`, 0.}, {1001.4545454545455`, -126.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1002.5454545454546`, 0.}, {1003.4545454545455`, -340.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1003.5454545454546`, 0.}, {1004.4545454545455`, -70.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1005.5454545454546`, 0.}, {1006.4545454545455`, -24.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1006.5454545454546`, 0.}, {1007.4545454545455`, 180.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], 
      RectangleBox[{1007.5454545454546`, 0.}, {1008.4545454545455`, 18.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1008.5454545454546`, 0.}, {1009.4545454545455`, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1009.5454545454546`, 0.}, {1010.4545454545455`, 200.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1010.5454545454546`, 0.}, {1011.4545454545455`, 22.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1011.5454545454546`, 0.}, {1012.4545454545455`, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1012.5454545454546`, 0.}, {1013.4545454545455`, 28.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1013.5454545454546`, 0.}, {1014.4545454545455`, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1014.5454545454546`, 0.}, {1015.4545454545455`, 38.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1016.5454545454546`, 0.}, {1017.4545454545455`, -12.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1017.5454545454546`, 0.}, {1018.4545454545455`, 6.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1018.5454545454546`, 0.}, {1019.4545454545455`, 24.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1020.5454545454546`, 0.}, {1021.4545454545455`, -168.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1021.5454545454546`, 0.}, {1022.4545454545455`, -336.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1022.5454545454546`, 0.}, {1023.4545454545455`, 54.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1023.5454545454546`, 0.}, {1024.4545454545455`, -168.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1024.5454545454545`, 0.}, {1025.4545454545455`, 60.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1025.5454545454545`, 0.}, {1026.4545454545455`, -116.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1026.5454545454545`, 0.}, {1027.4545454545455`, -38.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1027.5454545454545`, 0.}, {1028.4545454545455`, 120.},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1029.5454545454545`, 0.}, {1030.4545454545455`, -163.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1030.5454545454545`, 0.}, {1031.4545454545455`, 42.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1031.5454545454545`, 0.}, {1032.4545454545455`, -40.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1032.5454545454545`, 0.}, {1033.4545454545455`, 188.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1033.5454545454545`, 0.}, {1034.4545454545455`, 82.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1034.5454545454545`, 0.}, {1035.4545454545455`, -42.},
       RoundingRadius->
        0]}, {}, {}, {}, {}, {}}, {}, {}}, {}, {{{{{}, {}, {}, {{}, {}}, {{}, \
{}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, \
{{}, {}}, {{}, {}}, {{}, {}}, {}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{}, {}, {{}, {}}, {}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {}, {}, {{}, {}}, {}, \
{}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {}, {}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {}, {}, {{}, {}}, \
{{}, {}}, {}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {}, {}, {}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, \
{}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, \
{}}, {}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, \
{{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {}, {}, {{}, {}}, {}, {{}, \
{}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {}, {{}, {}}, {}, {}, {{}, \
{}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {}, {}, \
{}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {}, {{}, {}}, \
{}, {}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {}, {}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {}, {{}, {}}, \
{}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {}, {{}, \
{}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {}, {{}, {}}, {}, {{}, {}}, {}, {}, {}, {{}, {}}, {{}, {}}, \
{}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {}, {{}, {}}, {}, {}, \
{{}, {}}, {{}, {}}, {}, {}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, \
{}}, {{}, {}}, {}, {{}, {}}, {}, {}, {{}, {}}, {{}, {}}, {}, {}, {}, {}, {{}, \
{}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {}, {}, {}, {}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {}, {}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, \
{{}, {}}, {}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {}, {{}, {}}, {}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {}, \
{}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {}, \
{{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {}, {}, {{}, {}}, {}, \
{}, {}, {}, {}, {}, {}, {}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {}, {}, {{}, {}}, \
{}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {}, {}, {}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, \
{}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {}, {}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, \
{}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {}, {}, {{}, {}}, {{}, {}}, \
{}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, \
{{}, {}}, {{}, {}}, {{}, {}}, {}, {}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {}, {{}, {}}, {{}, \
{}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {}, {}, \
{}, {}}, {}}, {}}, {}}, GraphicsGroupBox[
    {GrayLevel[0], 
     StyleBox[
      LineBox[{{{0.5454545454545454, 0.}, 
         Offset[{0, -4}, {0.5454545454545454, 0.}]}, {{1040.4545454545455`, 
         0.}, Offset[{0, -4}, {1040.4545454545455`, 0.}]}}],
      Antialiasing->False]}]},
  AspectRatio->NCache[
    Rational[1, 3], 0.3333333333333333],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"Tag\"", TraditionalForm], 
    FormBox["\"G/V\"", TraditionalForm]},
  AxesOrigin->{0.4545454545454546, 0},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  ImageSize->600,
  PlotRangePadding->Scaled[0.02],
  Ticks->{None, Automatic}]], "Output",
 CellChangeTimes->{3.6166579567540336`*^9, 3.616658630051216*^9, 
  3.6166586844953117`*^9, 3.616667419035453*^9, 3.6166708469762745`*^9, 
  3.6166721266073227`*^9, 3.61667226192196*^9, 3.616673216957638*^9, 
  3.6166757435084763`*^9, 3.616675966317068*^9, 3.616676030211981*^9, 
  3.6166763701675777`*^9}]
}, Open  ]],

Cell["\<\
Leider nein, eher die typische Vola-Clusterbildung, die man auch bei normalen \
Rendite-Untersuchungen vorfindet.  Ist ja doch immer recht \
auff\[ADoubleDot]llig und unterscheidet sich von echten normalverteilten \
Random-Daten. 

Mal zum Vergleich: (ich nehm die Daxdaten mal vorweg (das passt hier aber gut \
hin, Erkl\[ADoubleDot]rungen kommen weiter unten)\
\>", "Text",
 CellChangeTimes->{{3.6166580316341653`*^9, 3.616658070322233*^9}, {
   3.61666364262082*^9, 3.616663667627664*^9}, {3.61666721244429*^9, 
   3.616667250321157*^9}, 3.6166672963880377`*^9, {3.616667393435808*^9, 
   3.616667397819416*^9}, {3.6166674489407063`*^9, 3.6166674604691257`*^9}, {
   3.6166675461756763`*^9, 3.616667546487677*^9}, 3.6166757435084763`*^9, 
   3.616676030211981*^9, {3.616676260624185*^9, 3.6166762869726315`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"closeCol", "=", "4"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"startDate", "=", " ", 
   RowBox[{"data", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "dateCol"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"endDate", "=", " ", 
   RowBox[{
    RowBox[{"data", "[", 
     RowBox[{"[", 
      RowBox[{";;", ",", "dateCol"}], "]"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{"-", "1"}], "]"}], "]"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"daxData", "=", 
   RowBox[{"FinancialData", "[", 
    RowBox[{"\"\<^GDaxi\>\"", ",", "\"\<OHLCV\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"startDate", ",", "endDate"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"daxReturns", " ", "=", " ", 
   RowBox[{"Differences", "[", 
    RowBox[{"daxData", "[", 
     RowBox[{"[", 
      RowBox[{";;", ",", "2", ",", "closeCol"}], "]"}], "]"}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"BarChart", "[", 
  RowBox[{"daxReturns", ",", " ", 
   RowBox[{"ImageSize", "\[Rule]", " ", "600"}], ",", " ", 
   RowBox[{"AspectRatio", " ", "\[Rule]", " ", 
    RowBox[{"1", "/", "3"}]}], ",", 
   RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Speed\>\""}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Tag\>\"", ",", " ", "\"\<Dax-Close2Close-Return\>\""}], 
     "}"}]}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.6166673025968485`*^9, 3.6166673660889606`*^9}, 
   3.616667401251422*^9, {3.6166674669587374`*^9, 3.6166675346160564`*^9}, {
   3.6166722365407157`*^9, 3.616672244169129*^9}, 3.616673215428836*^9, 
   3.6166757435084763`*^9, 3.616676030211981*^9, {3.61667629176184*^9, 
   3.6166763272831025`*^9}}],

Cell[BoxData[
 GraphicsBox[{
   {Opacity[0], PointBox[{{0.4545454545454546, 0.}}]}, 
   {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
    EdgeForm[Opacity[0.7]], {}, 
    {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
     EdgeForm[Opacity[0.7]], 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{0.5454545454545454, 0.}, {1.4545454545454546`, -16.44000000000051},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1.5454545454545454`, 0.}, {2.4545454545454546`, 2.4700000000002547`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{2.5454545454545454`, 0.}, {3.4545454545454546`, -14.970000000000255`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{3.5454545454545454`, 0.}, {4.454545454545454, 18.25},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{4.545454545454545, 0.}, {5.454545454545454, 2.8900000000003274`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{5.545454545454545, 0.}, {6.454545454545454, -97.5},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{6.545454545454545, 0.}, {7.454545454545454, 20.140000000000327`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{7.545454545454545, 0.}, {8.454545454545453, 25.73999999999978},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{8.545454545454545, 0.}, {9.454545454545453, -112.90999999999985`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{9.545454545454545, 0.}, {10.454545454545453`, 42.57999999999993},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{10.545454545454545`, 0.}, {11.454545454545453`, 57.92999999999938},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{11.545454545454545`, 0.}, {12.454545454545453`, -124.94999999999982`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{12.545454545454545`, 0.}, {13.454545454545453`, -104.55999999999949`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{13.545454545454545`, 0.}, {14.454545454545453`, -51.650000000000546`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{14.545454545454545`, 0.}, {15.454545454545453`, -63.94999999999982},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{15.545454545454545`, 0.}, {16.454545454545453`, 37.5600000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{16.545454545454543`, 0.}, {17.454545454545453`, -25.730000000000473`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{17.545454545454543`, 0.}, {18.454545454545453`, -102.86999999999989`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{18.545454545454543`, 0.}, {19.454545454545453`, 68.46000000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{19.545454545454543`, 0.}, {20.454545454545453`, 45.6899999999996},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{20.545454545454543`, 0.}, {21.454545454545453`, 55.18000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{21.545454545454543`, 0.}, {22.454545454545453`, -37.56999999999971},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{22.545454545454543`, 0.}, {23.454545454545453`, -138.85000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{23.545454545454543`, 0.}, {24.454545454545453`, -98.89999999999964},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{24.545454545454543`, 0.}, {25.454545454545453`, 50.51000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{25.545454545454543`, 0.}, {26.454545454545453`, 13.409999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{26.545454545454543`, 0.}, {27.454545454545453`, 38.10999999999967},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{27.545454545454543`, 0.}, {28.454545454545453`, -32.4399999999996},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{28.545454545454543`, 0.}, {29.454545454545453`, -3.5399999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{29.545454545454543`, 0.}, {30.454545454545453`, 10.710000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{30.545454545454543`, 0.}, {31.454545454545453`, 81.01999999999953},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{31.545454545454543`, 0.}, {32.45454545454545, 56.220000000000255`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{32.54545454545455, 0.}, {33.45454545454545, 32.06999999999971},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{33.54545454545455, 0.}, {34.45454545454545, 41.64000000000033},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{34.54545454545455, 0.}, {35.45454545454545, -33.61000000000058},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{35.54545454545455, 0.}, {36.45454545454545, -84.36999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{36.54545454545455, 0.}, {37.45454545454545, 11.44000000000051},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{37.54545454545455, 0.}, {38.45454545454545, -83.18000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{38.54545454545455, 0.}, {39.45454545454545, 66.13000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{39.54545454545455, 0.}, {40.45454545454545, 115.05000000000018`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{40.54545454545455, 0.}, {41.45454545454545, 63.05000000000018},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{41.54545454545455, 0.}, {42.45454545454545, 41.31999999999971},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{42.54545454545455, 0.}, {43.45454545454545, -22.5600000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{43.54545454545455, 0.}, {44.45454545454545, 82.03999999999996},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{44.54545454545455, 0.}, {45.45454545454545, -1.449999999999818},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{45.54545454545455, 0.}, {46.45454545454545, 9.980000000000473},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{46.54545454545455, 0.}, {47.45454545454545, 50.82999999999993},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{47.54545454545455, 0.}, {48.45454545454545, -8.090000000000146},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{48.54545454545455, 0.}, {49.45454545454545, 16.479999999999563`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{49.54545454545455, 0.}, {50.45454545454545, -41.54999999999927},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{50.54545454545455, 0.}, {51.45454545454545, 67.42999999999938},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{51.54545454545455, 0.}, {52.45454545454545, 53.289999999999964`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{52.54545454545455, 0.}, {53.45454545454545, -11.969999999999345`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{53.54545454545455, 0.}, {54.45454545454545, -29.88000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{54.54545454545455, 0.}, {55.45454545454545, 5.069999999999709},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{55.54545454545455, 0.}, {56.45454545454545, 29.770000000000437`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{56.54545454545455, 0.}, {57.45454545454545, 21.729999999999563`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{57.54545454545455, 0.}, {58.45454545454545, 93.94999999999982},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{58.54545454545455, 0.}, {59.45454545454545, -12.899999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{59.54545454545455, 0.}, {60.45454545454545, 36.80000000000018},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{60.54545454545455, 0.}, {61.45454545454545, -14.400000000000546`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{61.54545454545455, 0.}, {62.45454545454545, 11.100000000000364`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{62.54545454545455, 0.}, {63.45454545454545, 82.01000000000022},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{64.54545454545455, 0.}, {65.45454545454545, 16.649999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{65.54545454545455, 0.}, {66.45454545454545, -29.800000000000182`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{66.54545454545455, 0.}, {67.45454545454545, -50.57999999999993},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{67.54545454545455, 0.}, {68.45454545454545, 77.86999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{68.54545454545455, 0.}, {69.45454545454545, 0.9899999999997817},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{69.54545454545455, 0.}, {70.45454545454545, -19.859999999999673`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{70.54545454545455, 0.}, {71.45454545454545, 47.56999999999971},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{71.54545454545455, 0.}, {72.45454545454545, 13.050000000000182`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{72.54545454545455, 0.}, {73.45454545454545, -110.55000000000018`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{73.54545454545455, 0.}, {74.45454545454545, -18.460000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{74.54545454545455, 0.}, {75.45454545454545, 101.78999999999996`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{75.54545454545455, 0.}, {76.45454545454545, -33.849999999999454`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{76.54545454545455, 0.}, {77.45454545454545, -61.659999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{77.54545454545455, 0.}, {78.45454545454545, 90.80999999999949},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{78.54545454545455, 0.}, {79.45454545454545, 72.57000000000062},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{79.54545454545455, 0.}, {80.45454545454545, -172.59000000000015`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{80.54545454545455, 0.}, {81.45454545454545, -75.17000000000007},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{81.54545454545455, 0.}, {82.45454545454545, 60.56999999999971},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{82.54545454545455, 0.}, {83.45454545454545, -9.210000000000036},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{83.54545454545455, 0.}, {84.45454545454545, 31.220000000000255`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{84.54545454545455, 0.}, {85.45454545454545, -160.0600000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{85.54545454545455, 0.}, {86.45454545454545, -48.409999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{86.54545454545455, 0.}, {87.45454545454545, -50.1899999999996},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{87.54545454545455, 0.}, {88.45454545454545, -193.17000000000007`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{88.54545454545455, 0.}, {89.45454545454545, 302.8199999999997},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{89.54545454545455, 0.}, {90.45454545454545, 19.800000000000182`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{90.54545454545455, 0.}, {91.45454545454545, 145.77999999999975`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{91.54545454545455, 0.}, {92.45454545454545, 68.48000000000047},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{92.54545454545455, 0.}, {93.45454545454545, -195.26000000000022`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{93.54545454545455, 0.}, {94.45454545454545, 10.210000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{94.54545454545455, 0.}, {95.45454545454545, 89.01000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{95.54545454545455, 0.}, {96.45454545454545, -167.26000000000022`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{96.54545454545455, 0.}, {97.45454545454545, -120.78999999999996`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{97.54545454545455, 0.}, {98.45454545454545, -38.63000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{98.54545454545455, 0.}, {99.45454545454545, -23.56999999999971},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{99.54545454545455, 0.}, {100.45454545454545`, -135.64000000000033`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{100.54545454545455`, 0.}, {101.45454545454545`, 87.98000000000047},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{101.54545454545455`, 0.}, {102.45454545454545`, 179.1199999999999},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{102.54545454545455`, 0.}, {103.45454545454545`, 9.039999999999964},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{103.54545454545455`, 0.}, {104.45454545454545`, 18.149999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{104.54545454545455`, 0.}, {105.45454545454545`, 16.94000000000051},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{105.54545454545455`, 0.}, {106.45454545454545`, -0.07000000000061846},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{106.54545454545455`, 0.}, {107.45454545454545`, 73.43000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{107.54545454545455`, 0.}, {108.45454545454545`, -115.75},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{108.54545454545455`, 0.}, {109.45454545454545`, -33.93000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{109.54545454545455`, 0.}, {110.45454545454545`, -36.399999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{110.54545454545455`, 0.}, {111.45454545454545`, 116.19999999999982`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{111.54545454545455`, 0.}, {112.45454545454545`, 71.84000000000015},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{112.54545454545455`, 0.}, {113.45454545454545`, -8.760000000000218},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{113.54545454545455`, 0.}, {114.45454545454545`, 77.17000000000007},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{114.54545454545455`, 0.}, {115.45454545454545`, 50.05000000000018},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{115.54545454545455`, 0.}, {116.45454545454545`, 15.859999999999673`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{116.54545454545455`, 0.}, {117.45454545454545`, 32.63000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{117.54545454545455`, 0.}, {118.45454545454545`, -6.5600000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{118.54545454545455`, 0.}, {119.45454545454545`, 75.99000000000069},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{119.54545454545455`, 0.}, {120.45454545454545`, -23.93000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{120.54545454545455`, 0.}, {121.45454545454545`, -64.51999999999953},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{121.54545454545455`, 0.}, {122.45454545454545`, -89.04000000000087},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{122.54545454545455`, 0.}, {123.45454545454545`, -44.8799999999992},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{123.54545454545455`, 0.}, {124.45454545454545`, 86.61999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{124.54545454545455`, 0.}, {125.45454545454545`, -205.1900000000005},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{125.54545454545455`, 0.}, {126.45454545454545`, 13.490000000000691`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{126.54545454545455`, 0.}, {127.45454545454545`, -108.09000000000015`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{127.54545454545455`, 0.}, {128.45454545454547`, -23.280000000000655`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{128.54545454545456`, 0.}, {129.45454545454547`, -17.949999999999818`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{129.54545454545456`, 0.}, {130.45454545454547`, 124.77999999999975`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{130.54545454545456`, 0.}, {131.45454545454547`, 51.88000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{131.54545454545456`, 0.}, {132.45454545454547`, 42.80000000000018},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{132.54545454545456`, 0.}, {133.45454545454547`, 29.579999999999927`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{133.54545454545456`, 0.}, {134.45454545454547`, 11.949999999999818`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{134.54545454545456`, 0.}, {135.45454545454547`, 113.94000000000051`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{135.54545454545456`, 0.}, {136.45454545454547`, 18.63000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{136.54545454545456`, 0.}, {137.45454545454547`, -60.400000000000546`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{137.54545454545456`, 0.}, {138.45454545454547`, -109.08999999999924`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{138.54545454545456`, 0.}, {139.45454545454547`, -31.160000000000764`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{139.54545454545456`, 0.}, {140.45454545454547`, -41.61999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{140.54545454545456`, 0.}, {141.45454545454547`, 22.890000000000327`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{141.54545454545456`, 0.}, {142.45454545454547`, 151.76999999999953`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{142.54545454545456`, 0.}, {143.45454545454547`, 24.19000000000051},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{143.54545454545456`, 0.}, {144.45454545454547`, 27.86999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{144.54545454545456`, 0.}, {145.45454545454547`, 13.100000000000364`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{145.54545454545456`, 0.}, {146.45454545454547`, -28.3700000000008},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{146.54545454545456`, 0.}, {147.45454545454547`, -44.23999999999978},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{147.54545454545456`, 0.}, {148.45454545454547`, 13.270000000000437`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{148.54545454545456`, 0.}, {149.45454545454547`, 144.15999999999985`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{149.54545454545456`, 0.}, {150.45454545454547`, 15.779999999999745`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{150.54545454545456`, 0.}, {151.45454545454547`, 23.420000000000073`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{151.54545454545456`, 0.}, {152.45454545454547`, 2.25},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{152.54545454545456`, 0.}, {153.45454545454547`, -73.94999999999982},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{153.54545454545456`, 0.}, {154.45454545454547`, 91.97000000000025},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{154.54545454545456`, 0.}, {155.45454545454547`, -65.35000000000036},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{155.54545454545456`, 0.}, {156.45454545454547`, -132.1800000000003},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{156.54545454545456`, 0.}, {157.45454545454547`, -18.899999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{157.54545454545456`, 0.}, {158.45454545454547`, -24.76000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{158.54545454545456`, 0.}, {159.45454545454547`, 0.15999999999985448`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{159.54545454545456`, 0.}, {160.45454545454547`, 95.82999999999993},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{160.54545454545456`, 0.}, {161.45454545454547`, -20.089999999999236`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{161.54545454545456`, 0.}, {162.45454545454547`, -111.18000000000029`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{162.54545454545456`, 0.}, {163.45454545454547`, -69.97000000000025},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{163.54545454545456`, 0.}, {164.45454545454547`, 5.75},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{164.54545454545456`, 0.}, {165.45454545454547`, -75.47000000000025},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{165.54545454545456`, 0.}, {166.45454545454547`, -35.9399999999996},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{166.54545454545456`, 0.}, {167.45454545454547`, 13.079999999999927`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{167.54545454545456`, 0.}, {168.45454545454547`, 38.590000000000146`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{168.54545454545456`, 0.}, {169.45454545454547`, -38.76000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{169.54545454545456`, 0.}, {170.45454545454547`, 12.8100000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{170.54545454545456`, 0.}, {171.45454545454547`, 158.67999999999938`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{171.54545454545456`, 0.}, {172.45454545454547`, -0.049999999999272404`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{172.54545454545456`, 0.}, {173.45454545454547`, 50.76999999999953},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{173.54545454545456`, 0.}, {174.45454545454547`, 20.420000000000073`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{174.54545454545456`, 0.}, {175.45454545454547`, -37.149999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{175.54545454545456`, 0.}, {176.45454545454547`, 46.54999999999927},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{176.54545454545456`, 0.}, {177.45454545454547`, 57.08000000000084},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{177.54545454545456`, 0.}, {178.45454545454547`, -6.75},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{178.54545454545456`, 0.}, {179.45454545454547`, 46.909999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{179.54545454545456`, 0.}, {180.45454545454547`, 13.729999999999563`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{180.54545454545456`, 0.}, {181.45454545454547`, -13.539999999999964`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{181.54545454545456`, 0.}, {182.45454545454547`, -12.220000000000255`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{182.54545454545456`, 0.}, {183.45454545454547`, -39.88999999999942},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{183.54545454545456`, 0.}, {184.45454545454547`, 84.81999999999971},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{184.54545454545456`, 0.}, {185.45454545454547`, -18.600000000000364`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{185.54545454545456`, 0.}, {186.45454545454547`, -67.64999999999964},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{186.54545454545456`, 0.}, {187.45454545454547`, -23.61999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{187.54545454545456`, 0.}, {188.45454545454547`, 113.59000000000015`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{188.54545454545456`, 0.}, {189.45454545454547`, -19.409999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{189.54545454545456`, 0.}, {190.45454545454547`, -2.800000000000182},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{190.54545454545456`, 0.}, {191.45454545454547`, -29.170000000000073`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{191.54545454545456`, 0.}, {192.45454545454547`, -17.899999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{192.54545454545456`, 0.}, {193.45454545454547`, -17.68000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{193.54545454545456`, 0.}, {194.45454545454547`, -77.13000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{194.54545454545456`, 0.}, {195.45454545454547`, 81.61999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{195.54545454545456`, 0.}, {196.45454545454547`, 54.899999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{196.54545454545456`, 0.}, {197.45454545454547`, 5.520000000000437},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{197.54545454545456`, 0.}, {198.45454545454547`, 15.420000000000073`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{198.54545454545456`, 0.}, {199.45454545454547`, 17.840000000000146`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{199.54545454545456`, 0.}, {200.45454545454547`, -4.940000000000509},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{200.54545454545456`, 0.}, {201.45454545454547`, 129.95000000000073`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{201.54545454545456`, 0.}, {202.45454545454547`, 20.75},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{202.54545454545456`, 0.}, {203.45454545454547`, 37.029999999999745`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{203.54545454545456`, 0.}, {204.45454545454547`, 24.329999999999927`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{204.54545454545456`, 0.}, {205.45454545454547`, -25.94000000000051},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{205.54545454545456`, 0.}, {206.45454545454547`, 33.86000000000058},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{206.54545454545456`, 0.}, {207.45454545454547`, 86.46000000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{207.54545454545456`, 0.}, {208.45454545454547`, -5.170000000000073},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{208.54545454545456`, 0.}, {209.45454545454547`, 33.36999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{209.54545454545456`, 0.}, {210.45454545454547`, -25.409999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{210.54545454545456`, 0.}, {211.45454545454547`, -45.80000000000018},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{211.54545454545456`, 0.}, {212.45454545454547`, 27.279999999999745`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{212.54545454545456`, 0.}, {213.45454545454547`, 6.0900000000001455`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{213.54545454545456`, 0.}, {214.45454545454547`, 3.4899999999997817`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{214.54545454545456`, 0.}, {215.45454545454547`, 49.45000000000073},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{215.54545454545456`, 0.}, {216.45454545454547`, -36.51000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{216.54545454545456`, 0.}, {217.45454545454547`, 116.88999999999942`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{217.54545454545456`, 0.}, {218.45454545454547`, 19.51000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{218.54545454545456`, 0.}, {219.45454545454547`, -3.699999999999818},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{219.54545454545456`, 0.}, {220.45454545454547`, 37.3100000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{220.54545454545456`, 0.}, {221.45454545454547`, -67.97000000000025},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{221.54545454545456`, 0.}, {222.45454545454547`, 3.569999999999709},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{222.54545454545456`, 0.}, {223.45454545454547`, 11.199999999999818`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{223.54545454545456`, 0.}, {224.45454545454547`, 55.5600000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{224.54545454545456`, 0.}, {225.45454545454547`, -126.93000000000029`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{225.54545454545456`, 0.}, {226.45454545454547`, 36.82999999999993},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{226.54545454545456`, 0.}, {227.45454545454547`, 132.03999999999996`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{227.54545454545456`, 0.}, {228.45454545454547`, 11.44000000000051},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{228.54545454545456`, 0.}, {229.45454545454547`, -21.5},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{229.54545454545456`, 0.}, {230.45454545454547`, -117.05000000000018`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{230.54545454545456`, 0.}, {231.45454545454547`, 118.80000000000018`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{231.54545454545456`, 0.}, {232.45454545454547`, 55.85999999999967},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{232.54545454545456`, 0.}, {233.45454545454547`, -30.68000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{233.54545454545456`, 0.}, {234.45454545454547`, -151.0099999999993},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{234.54545454545456`, 0.}, {235.45454545454547`, -9.480000000000473},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{235.54545454545456`, 0.}, {236.45454545454547`, 178.14000000000033`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{236.54545454545456`, 0.}, {237.45454545454547`, 90.97999999999956},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{237.54545454545456`, 0.}, {238.45454545454547`, -9.889999999999418},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{238.54545454545456`, 0.}, {239.45454545454547`, 6.6599999999998545`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{239.54545454545456`, 0.}, {240.45454545454547`, 47.529999999999745`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{240.54545454545456`, 0.}, {241.45454545454547`, -26.039999999999964`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{241.54545454545456`, 0.}, {242.45454545454547`, -11.710000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{242.54545454545456`, 0.}, {243.45454545454547`, 42.01000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{243.54545454545456`, 0.}, {244.45454545454547`, 23.220000000000255`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{244.54545454545456`, 0.}, {245.45454545454547`, -1.9900000000006912`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{245.54545454545456`, 0.}, {246.45454545454547`, -11.029999999999745`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{246.54545454545456`, 0.}, {247.45454545454547`, 8.029999999999745},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{247.54545454545456`, 0.}, {248.45454545454547`, -41.94999999999982},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{248.54545454545456`, 0.}, {249.45454545454547`, 36.150000000000546`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{249.54545454545456`, 0.}, {250.45454545454547`, 59.38999999999942},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{250.54545454545456`, 0.}, {251.45454545454547`, -10.069999999999709`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{251.54545454545456`, 0.}, {252.45454545454547`, -10.230000000000473`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{252.54545454545456`, 0.}, {253.45454545454547`, -86.96000000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{253.54545454545456`, 0.}, {254.45454545454547`, 1.3700000000008004`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{254.54545454545456`, 0.}, {255.45454545454547`, 23.36999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{255.54545454545456`, 0.}, {256.4545454545455, -81.28000000000065},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{257.54545454545456`, 0.}, {258.4545454545455, 75.55000000000018},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{258.54545454545456`, 0.}, {259.4545454545455, -14.389999999999418`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{259.54545454545456`, 0.}, {260.4545454545455, -35.530000000000655`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{260.54545454545456`, 0.}, {261.4545454545455, 41.57000000000062},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{261.54545454545456`, 0.}, {262.4545454545455, -33.55000000000018},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{262.54545454545456`, 0.}, {263.4545454545455, -90.77999999999975},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{263.54545454545456`, 0.}, {264.4545454545455, 84.50999999999931},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{264.54545454545456`, 0.}, {265.4545454545455, 127.21000000000004`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{265.54545454545456`, 0.}, {266.4545454545455, 6.329999999999927},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{266.54545454545456`, 0.}, {267.4545454545455, 0.5900000000001455},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{267.54545454545456`, 0.}, {268.4545454545455, 2.360000000000582},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{268.54545454545456`, 0.}, {269.4545454545455, 65.38999999999942},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{269.54545454545456`, 0.}, {270.4545454545455, -60.6899999999996},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{270.54545454545456`, 0.}, {271.4545454545455, -58.48999999999978},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{271.54545454545456`, 0.}, {272.4545454545455, 38.149999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{272.54545454545456`, 0.}, {273.4545454545455, 5.350000000000364},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{273.54545454545456`, 0.}, {274.4545454545455, -8.760000000000218},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{274.54545454545456`, 0.}, {275.4545454545455, 68.34000000000015},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{275.54545454545456`, 0.}, {276.4545454545455, 28.229999999999563`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{276.54545454545456`, 0.}, {277.4545454545455, -52.779999999999745`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{277.54545454545456`, 0.}, {278.4545454545455, -25.32000000000062},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{278.54545454545456`, 0.}, {279.4545454545455, 106.79000000000087`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{279.54545454545456`, 0.}, {280.4545454545455, -0.6000000000003638},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{280.54545454545456`, 0.}, {281.4545454545455, 10.010000000000218`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{281.54545454545456`, 0.}, {282.4545454545455, 22.529999999999745`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{282.54545454545456`, 0.}, {283.4545454545455, 67.40999999999985},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{283.54545454545456`, 0.}, {284.4545454545455, 39.61999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{284.54545454545456`, 0.}, {285.4545454545455, -2.3400000000001455`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{285.54545454545456`, 0.}, {286.4545454545455, 19.38000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{286.54545454545456`, 0.}, {287.4545454545455, 30.920000000000073`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{287.54545454545456`, 0.}, {288.4545454545455, 25.43000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{288.54545454545456`, 0.}, {289.4545454545455, 3.4099999999998545`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{289.54545454545456`, 0.}, {290.4545454545455, 14.260000000000218`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{290.54545454545456`, 0.}, {291.4545454545455, -8.789999999999964},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{291.54545454545456`, 0.}, {292.4545454545455, 21.300000000000182`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{292.54545454545456`, 0.}, {293.4545454545455, -105.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{293.54545454545456`, 0.}, {294.4545454545455, -3.4600000000000364`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{294.54545454545456`, 0.}, {295.4545454545455, -123.75},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{295.54545454545456`, 0.}, {296.4545454545455, -64.10000000000036},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{296.54545454545456`, 0.}, {297.4545454545455, 54.67000000000007},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{297.54545454545456`, 0.}, {298.4545454545455, 87.14999999999964},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{298.54545454545456`, 0.}, {299.4545454545455, -49.01999999999953},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{299.54545454545456`, 0.}, {300.4545454545455, -42.18000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{300.54545454545456`, 0.}, {301.4545454545455, 44.840000000000146`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{301.54545454545456`, 0.}, {302.4545454545455, -47.0600000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{302.54545454545456`, 0.}, {303.4545454545455, -16.969999999999345`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{303.54545454545456`, 0.}, {304.4545454545455, 2.819999999999709},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{304.54545454545456`, 0.}, {305.4545454545455, -32.94999999999982},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{305.54545454545456`, 0.}, {306.4545454545455, -68.71000000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{306.54545454545456`, 0.}, {307.4545454545455, -81.60000000000036},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{307.54545454545456`, 0.}, {308.4545454545455, -114.85999999999967`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{308.54545454545456`, 0.}, {309.4545454545455, -218.97000000000025`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{309.54545454545456`, 0.}, {310.4545454545455, -133.8199999999997},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{310.54545454545456`, 0.}, {311.4545454545455, 143.03999999999996`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{311.54545454545456`, 0.}, {312.4545454545455, 7.519999999999527},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{312.54545454545456`, 0.}, {313.4545454545455, 151.72000000000025`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{313.54545454545456`, 0.}, {314.4545454545455, -35.149999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{314.54545454545456`, 0.}, {315.4545454545455, 23.479999999999563`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{315.54545454545456`, 0.}, {316.4545454545455, 129.1300000000001},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{316.54545454545456`, 0.}, {317.4545454545455, 12.779999999999745`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{317.54545454545456`, 0.}, {318.4545454545455, -7.729999999999563},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{318.54545454545456`, 0.}, {319.4545454545455, -4.190000000000509},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{319.54545454545456`, 0.}, {320.4545454545455, 122.71000000000004`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{320.54545454545456`, 0.}, {321.4545454545455, -15.839999999999236`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{321.54545454545456`, 0.}, {322.4545454545455, 138.5},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{322.54545454545456`, 0.}, {323.4545454545455, -4.480000000000473},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{323.54545454545456`, 0.}, {324.4545454545455, -0.019999999999527063`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{324.54545454545456`, 0.}, {325.4545454545455, 39.79999999999927},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{325.54545454545456`, 0.}, {326.4545454545455, -36.32999999999993},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{326.54545454545456`, 0.}, {327.4545454545455, 38.24000000000069},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{327.54545454545456`, 0.}, {328.4545454545455, -12.160000000000764`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{328.54545454545456`, 0.}, {329.4545454545455, -101.94999999999982`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{329.54545454545456`, 0.}, {330.4545454545455, 75.0600000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{330.54545454545456`, 0.}, {331.4545454545455, -31.409999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{331.54545454545456`, 0.}, {332.4545454545455, 31.729999999999563`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{332.54545454545456`, 0.}, {333.4545454545455, -151.4399999999996},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{333.54545454545456`, 0.}, {334.4545454545455, 12.460000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{334.54545454545456`, 0.}, {335.4545454545455, 209.8799999999992},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{335.54545454545456`, 0.}, {336.4545454545455, 46.30000000000018},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{337.54545454545456`, 0.}, {338.4545454545455, 61.02000000000044},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{338.54545454545456`, 0.}, {339.4545454545455, 48.4399999999996},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{339.54545454545456`, 0.}, {340.4545454545455, 70.27000000000044},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{340.54545454545456`, 0.}, {341.4545454545455, 39.23999999999978},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{341.54545454545456`, 0.}, {342.4545454545455, 13.180000000000291`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{342.54545454545456`, 0.}, {343.4545454545455, -26.94000000000051},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{343.54545454545456`, 0.}, {344.4545454545455, -126.76999999999953`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{344.54545454545456`, 0.}, {345.4545454545455, 3.0299999999997453`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{345.54545454545456`, 0.}, {346.4545454545455, 115.28999999999996`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{346.54545454545456`, 0.}, {347.4545454545455, -81.72999999999956},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{347.54545454545456`, 0.}, {348.4545454545455, 91.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{348.54545454545456`, 0.}, {349.4545454545455, -6.470000000000255},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{349.54545454545456`, 0.}, {350.4545454545455, -51.100000000000364`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{350.54545454545456`, 0.}, {351.4545454545455, -40.63999999999942},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{351.54545454545456`, 0.}, {352.4545454545455, -15.770000000000437`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{352.54545454545456`, 0.}, {353.4545454545455, -130.89000000000033`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{353.54545454545456`, 0.}, {354.4545454545455, 46.88000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{354.54545454545456`, 0.}, {355.4545454545455, 54.69999999999982},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{355.54545454545456`, 0.}, {356.4545454545455, -91.40999999999985},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{356.54545454545456`, 0.}, {357.4545454545455, -145.29999999999927`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{357.54545454545456`, 0.}, {358.4545454545455, 29.139999999999418`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{358.54545454545456`, 0.}, {359.4545454545455, 20.279999999999745`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{359.54545454545456`, 0.}, {360.4545454545455, -56.849999999999454`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{360.54545454545456`, 0.}, {361.4545454545455, 49.38000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{361.54545454545456`, 0.}, {362.4545454545455, -3.1700000000000728`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{362.54545454545456`, 0.}, {363.4545454545455, 133.38999999999942`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{363.54545454545456`, 0.}, {364.4545454545455, -76.25999999999931},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{364.54545454545456`, 0.}, {365.4545454545455, -143.3100000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{365.54545454545456`, 0.}, {366.4545454545455, 34.909999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{366.54545454545456`, 0.}, {367.4545454545455, -24.460000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{367.54545454545456`, 0.}, {368.4545454545455, 18.68000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{368.54545454545456`, 0.}, {369.4545454545455, -43.02000000000044},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{369.54545454545456`, 0.}, {370.4545454545455, 99.43000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{370.54545454545456`, 0.}, {371.4545454545455, -89.76000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{371.54545454545456`, 0.}, {372.4545454545455, 15.240000000000691`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{372.54545454545456`, 0.}, {373.4545454545455, 119.64999999999964`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{373.54545454545456`, 0.}, {374.4545454545455, -89.71000000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{374.54545454545456`, 0.}, {375.4545454545455, -4.880000000000109},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{375.54545454545456`, 0.}, {376.4545454545455, 53.850000000000364`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{376.54545454545456`, 0.}, {377.4545454545455, -13.840000000000146`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{377.54545454545456`, 0.}, {378.4545454545455, 135.30000000000018`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{378.54545454545456`, 0.}, {379.4545454545455, -7.3200000000006185`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{379.54545454545456`, 0.}, {380.4545454545455, -128.75},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{380.54545454545456`, 0.}, {381.4545454545455, -28.05999999999949},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{381.54545454545456`, 0.}, {382.4545454545455, -13.480000000000473`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{382.54545454545456`, 0.}, {383.4545454545455, 62.530000000000655`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{383.54545454545456`, 0.}, {384.4545454545455, 123.71000000000004`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{384.54545454545456`, 0.}, {385.4545454545455, 82.09999999999945},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{385.54545454545456`, 0.}, {386.4545454545455, 43.19999999999982},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{386.54545454545456`, 0.}, {387.4545454545455, 23.520000000000437`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{387.54545454545456`, 0.}, {388.4545454545455, -3.5200000000004366`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{388.54545454545456`, 0.}, {389.4545454545455, -8.25},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{389.54545454545456`, 0.}, {390.4545454545455, 40.25},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{390.54545454545456`, 0.}, {391.4545454545455, -68.71000000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{391.54545454545456`, 0.}, {392.4545454545455, -172.47999999999956`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{392.54545454545456`, 0.}, {393.4545454545455, -56.10999999999967},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{393.54545454545456`, 0.}, {394.4545454545455, 93.72999999999956},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{394.54545454545456`, 0.}, {395.4545454545455, -53.13000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{395.54545454545456`, 0.}, {396.4545454545455, 5.380000000000109},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{396.54545454545456`, 0.}, {397.4545454545455, -112.19999999999982`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{397.54545454545456`, 0.}, {398.4545454545455, 84.75},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{398.54545454545456`, 0.}, {399.4545454545455, 28.6899999999996},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{399.54545454545456`, 0.}, {400.4545454545455, 68.78000000000065},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{400.54545454545456`, 0.}, {401.4545454545455, 36.25},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{401.54545454545456`, 0.}, {402.4545454545455, 18.149999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{402.54545454545456`, 0.}, {403.4545454545455, 4.9099999999998545`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{403.54545454545456`, 0.}, {404.4545454545455, -96.76999999999953},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{404.54545454545456`, 0.}, {405.4545454545455, -62.61999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{405.54545454545456`, 0.}, {406.4545454545455, -31.289999999999964`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{406.54545454545456`, 0.}, {407.4545454545455, -204.79000000000087`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{407.54545454545456`, 0.}, {408.4545454545455, -157.22999999999956`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{408.54545454545456`, 0.}, {409.4545454545455, -156.15999999999985`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{409.54545454545456`, 0.}, {410.4545454545455, -225.82999999999993`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{410.54545454545456`, 0.}, {411.4545454545455, -178.60000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{411.54545454545456`, 0.}, {412.4545454545455, -312.8899999999994},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{412.54545454545456`, 0.}, {413.4545454545455, -6.190000000000509},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{413.54545454545456`, 0.}, {414.4545454545455, -303.65999999999985`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{414.54545454545456`, 0.}, {415.4545454545455, 184.23999999999978`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{415.54545454545456`, 0.}, {416.4545454545455, 200.07999999999993`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{416.54545454545456`, 0.}, {417.4545454545455, 24.5},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{417.54545454545456`, 0.}, {418.4545454545455, -27.340000000000146`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{418.54545454545456`, 0.}, {419.4545454545455, -45.960000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{419.54545454545456`, 0.}, {420.4545454545455, -346.1399999999994},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{420.54545454545456`, 0.}, {421.4545454545455, -122.80000000000018`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{421.54545454545456`, 0.}, {422.4545454545455, -6.220000000000255},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{422.54545454545456`, 0.}, {423.4545454545455, 58.600000000000364`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{423.54545454545456`, 0.}, {424.4545454545455, 148.69999999999982`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{424.54545454545456`, 0.}, {425.4545454545455, -96.9399999999996},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{425.54545454545456`, 0.}, {426.4545454545455, -46.660000000000764`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{426.54545454545456`, 0.}, {427.4545454545455, 132.59000000000015`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{427.54545454545456`, 0.}, {428.4545454545455, -26.149999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{428.54545454545456`, 0.}, {429.4545454545455, 140.9300000000003},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{429.54545454545456`, 0.}, {430.4545454545455, -54.220000000000255`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{430.54545454545456`, 0.}, {431.4545454545455, -192.30000000000018`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{431.54545454545456`, 0.}, {432.4545454545455, -292.1300000000001},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{432.54545454545456`, 0.}, {433.4545454545455, -52.22999999999956},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{433.54545454545456`, 0.}, {434.4545454545455, 211.5599999999995},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{434.54545454545456`, 0.}, {435.4545454545455, 2.930000000000291},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{435.54545454545456`, 0.}, {436.4545454545455, -218.52999999999975`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{436.54545454545456`, 0.}, {437.4545454545455, -117.60000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{437.54545454545456`, 0.}, {438.4545454545455, 94.02999999999975},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{438.54545454545456`, 0.}, {439.4545454545455, 173.82999999999993`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{439.54545454545456`, 0.}, {440.4545454545455, 168.05000000000018`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{440.54545454545456`, 0.}, {441.4545454545455, 65.27000000000044},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{441.54545454545456`, 0.}, {442.4545454545455, -157.60000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{442.54545454545456`, 0.}, {443.4545454545455, 155.77000000000044`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{443.54545454545456`, 0.}, {444.4545454545455, -137.8800000000001},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{444.54545454545456`, 0.}, {445.4545454545455, -269.59000000000015`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{445.54545454545456`, 0.}, {446.4545454545455, 32.350000000000364`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{446.54545454545456`, 0.}, {447.4545454545455, 149.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{447.54545454545456`, 0.}, {448.4545454545455, 282.8799999999992},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{448.54545454545456`, 0.}, {449.4545454545455, -50.01999999999953},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{449.54545454545456`, 0.}, {450.4545454545455, 61.159999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{450.54545454545456`, 0.}, {451.4545454545455, -137.5599999999995},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{451.54545454545456`, 0.}, {452.4545454545455, -125.32000000000062`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{452.54545454545456`, 0.}, {453.4545454545455, -159.98999999999978`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{453.54545454545456`, 0.}, {454.4545454545455, 256.3199999999997},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{454.54545454545456`, 0.}, {455.4545454545455, 172.22000000000025`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{455.54545454545456`, 0.}, {456.4545454545455, 30.449999999999818`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{456.54545454545456`, 0.}, {457.4545454545455, 171.59000000000015`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{457.54545454545456`, 0.}, {458.4545454545455, 17.720000000000255`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{458.54545454545456`, 0.}, {459.4545454545455, 129.46000000000004`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{459.54545454545456`, 0.}, {460.4545454545455, -79.63000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{460.54545454545456`, 0.}, {461.4545454545455, 52.35999999999967},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{461.54545454545456`, 0.}, {462.4545454545455, -107.76999999999953`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{462.54545454545456`, 0.}, {463.4545454545455, 17.979999999999563`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{463.54545454545456`, 0.}, {464.4545454545455, 36.11999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{464.54545454545456`, 0.}, {465.4545454545455, -147.05000000000018`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{465.54545454545456`, 0.}, {466.4545454545455, 204.48000000000047`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{466.54545454545456`, 0.}, {467.4545454545455, 84.3100000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{467.54545454545456`, 0.}, {468.4545454545455, -8.520000000000437},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{468.54545454545456`, 0.}, {469.4545454545455, -30.68000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{469.54545454545456`, 0.}, {470.4545454545455, 321.77000000000044`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{470.54545454545456`, 0.}, {471.4545454545455, 8.349999999999454},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{471.54545454545456`, 0.}, {472.4545454545455, -204.84999999999945`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{472.54545454545456`, 0.}, {473.4545454545455, -306.8299999999999},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{473.54545454545456`, 0.}, {474.4545454545455, 131.1199999999999},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{474.54545454545456`, 0.}, {475.4545454545455, 167.55000000000018`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{475.54545454545456`, 0.}, {476.4545454545455, -167.02000000000044`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{476.54545454545456`, 0.}, {477.4545454545455, -37.47999999999956},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{477.54545454545456`, 0.}, {478.4545454545455, 32.75999999999931},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{478.54545454545456`, 0.}, {479.4545454545455, -131.89999999999964`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{479.54545454545456`, 0.}, {480.4545454545455, 38.27000000000044},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{480.54545454545456`, 0.}, {481.4545454545455, 189.21999999999935`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{481.54545454545456`, 0.}, {482.4545454545455, -72.00999999999931},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{482.54545454545456`, 0.}, {483.4545454545455, -51.88000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{483.54545454545456`, 0.}, {484.4545454545455, -19.780000000000655`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{484.54545454545456`, 0.}, {485.4545454545455, -63.1899999999996},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{485.54545454545456`, 0.}, {486.4545454545455, -49.93000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{486.54545454545456`, 0.}, {487.4545454545455, -194.23999999999978`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{487.54545454545456`, 0.}, {488.4545454545455, -68.60999999999967},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{488.54545454545456`, 0.}, {489.4545454545455, -79.61999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{489.54545454545456`, 0.}, {490.4545454545455, -29.6200000000008},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{490.54545454545456`, 0.}, {491.4545454545455, 64.72000000000025},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{491.54545454545456`, 0.}, {492.4545454545455, 252.46000000000004`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{492.54545454545456`, 0.}, {493.4545454545455, 54.57999999999993},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{493.54545454545456`, 0.}, {494.4545454545455, 288.9300000000003},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{494.54545454545456`, 0.}, {495.4545454545455, -52.960000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{495.54545454545456`, 0.}, {496.4545454545455, 44.80000000000018},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{496.54545454545456`, 0.}, {497.4545454545455, 25.409999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{497.54545454545456`, 0.}, {498.4545454545455, -77.27000000000044},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{498.54545454545456`, 0.}, {499.4545454545455, -34.090000000000146`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{499.54545454545456`, 0.}, {500.4545454545455, -120.28999999999996`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{500.54545454545456`, 0.}, {501.4545454545455, 112.27000000000044`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{501.54545454545456`, 0.}, {502.4545454545455, -201.27999999999975`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{502.54545454545456`, 0.}, {503.4545454545455, -11.170000000000073`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{503.54545454545456`, 0.}, {504.4545454545455, -99.11999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{504.54545454545456`, 0.}, {505.4545454545455, 55.47999999999956},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{505.54545454545456`, 0.}, {506.4545454545455, -28.840000000000146`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{506.54545454545456`, 0.}, {507.4545454545455, -31.06999999999971},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{507.54545454545456`, 0.}, {508.4545454545455, 176.3199999999997},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{508.54545454545456`, 0.}, {509.4545454545455, -55.5},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{509.54545454545456`, 0.}, {510.4545454545455, 60.650000000000546`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{510.54545454545456`, 0.}, {511.4545454545455, 26.75},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{511.54545454545456`, 0.}, {512.4545454545455, 10.829999999999927`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{512.5454545454546, 0.}, {513.4545454545455, -118.48999999999978`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{513.5454545454546, 0.}, {514.4545454545455, 77.50999999999931},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{514.5454545454546, 0.}, {515.4545454545455, 49.57000000000062},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{515.5454545454546, 0.}, {516.4545454545455, 268.21999999999935`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{516.5454545454546, 0.}, {517.4545454545455, -55.01999999999953},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{517.5454545454546, 0.}, {518.4545454545455, -15.5600000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{518.5454545454546, 0.}, {519.4545454545455, -38.06999999999971},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{519.5454545454546, 0.}, {520.4545454545455, -40.69000000000051},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{520.5454545454546, 0.}, {521.4545454545455, 145.75},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{521.5454545454546, 0.}, {522.4545454545455, -10.639999999999418`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{522.5454545454546, 0.}, {523.4545454545455, 26.86999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{523.5454545454546, 0.}, {524.4545454545455, -36.13000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{524.5454545454546, 0.}, {525.4545454545455, 76.93000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{525.5454545454546, 0.}, {526.4545454545455, 112.92000000000007`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{526.5454545454546, 0.}, {527.4545454545455, 21.639999999999418`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{527.5454545454546, 0.}, {528.4545454545455, 61.69000000000051},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{528.5454545454546, 0.}, {529.4545454545455, -11.86999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{529.5454545454546, 0.}, {530.4545454545455, 32.22999999999956},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{530.5454545454546, 0.}, {531.4545454545455, -17.399999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{531.5454545454546, 0.}, {532.4545454545455, 2.630000000000109},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{532.5454545454546, 0.}, {533.4545454545455, 118.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{533.5454545454546, 0.}, {534.4545454545455, -27.8700000000008},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{534.5454545454546, 0.}, {535.4545454545455, -67.52999999999975},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{535.5454545454546, 0.}, {536.4545454545455, 14.460000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{536.5454545454546, 0.}, {537.4545454545455, 157.73000000000047`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{537.5454545454546, 0.}, {538.4545454545455, 38.98999999999978},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{538.5454545454546, 0.}, {539.4545454545455, 111.03999999999996`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{539.5454545454546, 0.}, {540.4545454545455, -1.8400000000001455`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{540.5454545454546, 0.}, {541.4545454545455, -10.63000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{541.5454545454546, 0.}, {542.4545454545455, -5.4399999999996},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{542.5454545454546, 0.}, {543.4545454545455, 40.039999999999964`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{543.5454545454546, 0.}, {544.4545454545455, -95.84000000000015},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{544.5454545454546, 0.}, {545.4545454545455, 45.51000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{545.5454545454546, 0.}, {546.4545454545455, -10.280000000000655`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{546.5454545454546, 0.}, {547.4545454545455, 29.75},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{547.5454545454546, 0.}, {548.4545454545455, -5.979999999999563},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{548.5454545454546, 0.}, {549.4545454545455, 96.06999999999971},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{549.5454545454546, 0.}, {550.4545454545455, 100.27000000000044`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{550.5454545454546, 0.}, {551.4545454545455, -40.11999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{551.5454545454546, 0.}, {552.4545454545455, -64.3100000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{552.5454545454546, 0.}, {553.4545454545455, -34.409999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{553.5454545454546, 0.}, {554.4545454545455, 54.970000000000255`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{554.5454545454546, 0.}, {555.4545454545455, -14.829999999999927`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{555.5454545454546, 0.}, {556.4545454545455, 38.029999999999745`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{556.5454545454546, 0.}, {557.4545454545455, -31.550000000000182`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{557.5454545454546, 0.}, {558.4545454545455, 85.69000000000051},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{558.5454545454546, 0.}, {559.4545454545455, -20.400000000000546`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{559.5454545454546, 0.}, {560.4545454545455, -54.909999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{560.5454545454546, 0.}, {561.4545454545455, -233.35000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{561.5454545454546, 0.}, {562.4545454545455, 38.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{562.5454545454546, 0.}, {563.4545454545455, 163.4300000000003},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{563.5454545454546, 0.}, {564.4545454545455, 45.67000000000007},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{564.5454545454546, 0.}, {565.4545454545455, 21.140000000000327`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{565.5454545454546, 0.}, {566.4545454545455, 94.55999999999949},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{566.5454545454546, 0.}, {567.4545454545455, 83.51000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{567.5454545454546, 0.}, {568.4545454545455, 65.02999999999975},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{568.5454545454546, 0.}, {569.4545454545455, 13.36999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{569.5454545454546, 0.}, {570.4545454545455, -3.5999999999994543`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{570.5454545454546, 0.}, {571.4545454545455, -99.28000000000065},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{571.5454545454546, 0.}, {572.4545454545455, 16.38000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{572.5454545454546, 0.}, {573.4545454545455, -90.05999999999949},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{573.5454545454546, 0.}, {574.4545454545455, 14.359999999999673`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{574.5454545454546, 0.}, {575.4545454545455, 83.60999999999967},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{575.5454545454546, 0.}, {576.4545454545455, -0.32999999999992724`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{576.5454545454546, 0.}, {577.4545454545455, -80.09999999999945},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{577.5454545454546, 0.}, {578.4545454545455, -123.65000000000055`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{578.5454545454546, 0.}, {579.4545454545455, 71.68000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{579.5454545454546, 0.}, {580.4545454545455, 109.81999999999971`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{580.5454545454546, 0.}, {581.4545454545455, -74.36999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{581.5454545454546, 0.}, {582.4545454545455, -198.21999999999935`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{582.5454545454546, 0.}, {583.4545454545455, -8.800000000000182},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{583.5454545454546, 0.}, {584.4545454545455, -168.82999999999993`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{584.5454545454546, 0.}, {585.4545454545455, 68.29999999999927},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{585.5454545454546, 0.}, {586.4545454545455, 68.51000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{586.5454545454546, 0.}, {587.4545454545455, -159.34000000000015`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{587.5454545454546, 0.}, {588.4545454545455, 41.289999999999964`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{588.5454545454546, 0.}, {589.4545454545455, 175.8100000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{589.5454545454546, 0.}, {590.4545454545455, -68.97000000000025},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{590.5454545454546, 0.}, {591.4545454545455, -60.80999999999949},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{591.5454545454546, 0.}, {592.4545454545455, 78.89999999999964},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{592.5454545454546, 0.}, {593.4545454545455, -227.1199999999999},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{593.5454545454546, 0.}, {594.4545454545455, 67.40999999999985},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{594.5454545454546, 0.}, {595.4545454545455, 114.09000000000015`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{595.5454545454546, 0.}, {596.4545454545455, 35.399999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{596.5454545454546, 0.}, {597.4545454545455, 61.42000000000007},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{597.5454545454546, 0.}, {598.4545454545455, -40.13000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{598.5454545454546, 0.}, {599.4545454545455, -50.41999999999916},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{599.5454545454546, 0.}, {600.4545454545455, -16.330000000000837`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{600.5454545454546, 0.}, {601.4545454545455, -132.96999999999935`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{601.5454545454546, 0.}, {602.4545454545455, 8.009999999999309},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{602.5454545454546, 0.}, {603.4545454545455, -124.73999999999978`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{603.5454545454546, 0.}, {604.4545454545455, 30.57000000000062},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{604.5454545454546, 0.}, {605.4545454545455, 42.6899999999996},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{605.5454545454546, 0.}, {606.4545454545455, 61.93000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{606.5454545454546, 0.}, {607.4545454545455, -127.96000000000004`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{607.5454545454546, 0.}, {608.4545454545455, -50.909999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{608.5454545454546, 0.}, {609.4545454545455, -16.800000000000182`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{609.5454545454546, 0.}, {610.4545454545455, -75.30000000000018},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{610.5454545454546, 0.}, {611.4545454545455, -37.73999999999978},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{611.5454545454546, 0.}, {612.4545454545455, 59.81999999999971},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{612.5454545454546, 0.}, {613.4545454545455, 104.5600000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{613.5454545454546, 0.}, {614.4545454545455, -149.85000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{614.5454545454546, 0.}, {615.4545454545455, 30.140000000000327`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{615.5454545454546, 0.}, {616.4545454545455, 24.049999999999272`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{616.5454545454546, 0.}, {617.4545454545455, -16.75},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{617.5454545454546, 0.}, {618.4545454545455, 73.65000000000055},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{618.5454545454546, 0.}, {619.4545454545455, -116.03999999999996`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{619.5454545454546, 0.}, {620.4545454545455, -16.420000000000073`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{620.5454545454546, 0.}, {621.4545454545455, -214.09000000000015`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{621.5454545454546, 0.}, {622.4545454545455, -72.0600000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{622.5454545454546, 0.}, {623.4545454545455, -8.829999999999927},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{623.5454545454546, 0.}, {624.4545454545455, 124.59000000000015`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{624.5454545454546, 0.}, {625.4545454545455, 50.23000000000047},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{625.5454545454546, 0.}, {626.4545454545455, -13.400000000000546`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{626.5454545454546, 0.}, {627.4545454545455, 10.230000000000473`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{627.5454545454546, 0.}, {628.4545454545455, 20.1899999999996},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{628.5454545454546, 0.}, {629.4545454545455, -8.75},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{629.5454545454546, 0.}, {630.4545454545455, -13.88000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{630.5454545454546, 0.}, {631.4545454545455, 90.80000000000018},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{631.5454545454546, 0.}, {632.4545454545455, 18.789999999999964`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{632.5454545454546, 0.}, {633.4545454545455, 115.15999999999985`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{633.5454545454546, 0.}, {634.4545454545455, 28.770000000000437`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{634.5454545454546, 0.}, {635.4545454545455, -49.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{635.5454545454546, 0.}, {636.4545454545455, -79.88000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{636.5454545454546, 0.}, {637.4545454545455, -130.85999999999967`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{637.5454545454546, 0.}, {638.4545454545455, 4.299999999999272},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{638.5454545454546, 0.}, {639.4545454545455, 92.30000000000018},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{639.5454545454546, 0.}, {640.4545454545455, -79.07999999999993},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{640.5454545454546, 0.}, {641.4545454545455, 266.3699999999999},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{641.5454545454546, 0.}, {642.4545454545455, 79.80000000000018},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{642.5454545454546, 0.}, {643.4545454545455, 82.13000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{643.5454545454546, 0.}, {644.4545454545455, -13.409999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{644.5454545454546, 0.}, {645.4545454545455, -29.23999999999978},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{645.5454545454546, 0.}, {646.4545454545455, -125.45000000000073`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{646.5454545454546, 0.}, {647.4545454545455, -22.539999999999964`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{647.5454545454546, 0.}, {648.4545454545455, 50.76000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{648.5454545454546, 0.}, {649.4545454545455, 15.520000000000437`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{649.5454545454546, 0.}, {650.4545454545455, -34.5},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{650.5454545454546, 0.}, {651.4545454545455, 137.75},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{651.5454545454546, 0.}, {652.4545454545455, 8.61999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{652.5454545454546, 0.}, {653.4545454545455, 11.920000000000073`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{653.5454545454546, 0.}, {654.4545454545455, 106.77999999999975`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{654.5454545454546, 0.}, {655.4545454545455, 73.97000000000025},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{655.5454545454546, 0.}, {656.4545454545455, -128.3699999999999},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{656.5454545454546, 0.}, {657.4545454545455, -210.6900000000005},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{657.5454545454546, 0.}, {658.4545454545455, -28.920000000000073`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{658.5454545454546, 0.}, {659.4545454545455, 16.110000000000582`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{659.5454545454546, 0.}, {660.4545454545455, 176.4399999999996},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{660.5454545454546, 0.}, {661.4545454545455, 106.4399999999996},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{661.5454545454546, 0.}, {662.4545454545455, 84.66000000000076},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{662.5454545454546, 0.}, {663.4545454545455, -1.800000000000182},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{663.5454545454546, 0.}, {664.4545454545455, -17.800000000000182`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{664.5454545454546, 0.}, {665.4545454545455, -148.3699999999999},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{665.5454545454546, 0.}, {666.4545454545455, 259.5699999999997},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{666.5454545454546, 0.}, {667.4545454545455, 53.0600000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{667.5454545454546, 0.}, {668.4545454545455, 49.22999999999956},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{668.5454545454546, 0.}, {669.4545454545455, -1.800000000000182},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{669.5454545454546, 0.}, {670.4545454545455, -1.1599999999998545`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{670.5454545454546, 0.}, {671.4545454545455, -20.42999999999938},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{671.5454545454546, 0.}, {672.4545454545455, -34.88000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{672.5454545454546, 0.}, {673.4545454545455, 64.71000000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{673.5454545454546, 0.}, {674.4545454545455, -27.590000000000146`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{674.5454545454546, 0.}, {675.4545454545455, 49.48999999999978},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{675.5454545454546, 0.}, {676.4545454545455, 44.590000000000146`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{676.5454545454546, 0.}, {677.4545454545455, -7.199999999999818},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{677.5454545454546, 0.}, {678.4545454545455, 55.63999999999942},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{678.5454545454546, 0.}, {679.4545454545455, -71.56999999999971},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{679.5454545454546, 0.}, {680.4545454545455, -68.18000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{680.5454545454546, 0.}, {681.4545454545455, 21.5},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{681.5454545454546, 0.}, {682.4545454545455, 76.38000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{682.5454545454546, 0.}, {683.4545454545455, -44.76999999999953},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{683.5454545454546, 0.}, {684.4545454545455, 7.889999999999418},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{684.5454545454546, 0.}, {685.4545454545455, -115.07999999999993`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{685.5454545454546, 0.}, {686.4545454545455, 75.30000000000018},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{686.5454545454546, 0.}, {687.4545454545455, 44.039999999999964`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{687.5454545454546, 0.}, {688.4545454545455, -82.25},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{688.5454545454546, 0.}, {689.4545454545455, 32.10999999999967},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{689.5454545454546, 0.}, {690.4545454545455, 202.64000000000033`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{690.5454545454546, 0.}, {691.4545454545455, 47.17000000000007},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{691.5454545454546, 0.}, {692.4545454545455, -0.8000000000001819},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{692.5454545454546, 0.}, {693.4545454545455, 96.40999999999985},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{693.5454545454546, 0.}, {694.4545454545455, 33.42000000000007},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{694.5454545454546, 0.}, {695.4545454545455, -33.210000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{695.5454545454546, 0.}, {696.4545454545455, 101.8100000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{696.5454545454546, 0.}, {697.4545454545455, -8.44000000000051},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{697.5454545454546, 0.}, {698.4545454545455, -56.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{698.5454545454546, 0.}, {699.4545454545455, 43.07000000000062},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{699.5454545454546, 0.}, {700.4545454545455, -1.2700000000004366`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{700.5454545454546, 0.}, {701.4545454545455, 62.13000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{701.5454545454546, 0.}, {702.4545454545455, -38.460000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{702.5454545454546, 0.}, {703.4545454545455, 11.949999999999818`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{703.5454545454546, 0.}, {704.4545454545455, -148.59999999999945`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{704.5454545454546, 0.}, {705.4545454545455, 13.510000000000218`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{705.5454545454546, 0.}, {706.4545454545455, -73.8700000000008},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{706.5454545454546, 0.}, {707.4545454545455, 110.57999999999993`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{707.5454545454546, 0.}, {708.4545454545455, -20.86999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{708.5454545454546, 0.}, {709.4545454545455, 16.220000000000255`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{709.5454545454546, 0.}, {710.4545454545455, -16.86999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{710.5454545454546, 0.}, {711.4545454545455, 92.65999999999985},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{711.5454545454546, 0.}, {712.4545454545455, -106.65999999999985`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{712.5454545454546, 0.}, {713.4545454545455, -56.68000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{713.5454545454546, 0.}, {714.4545454545455, -29.300000000000182`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{714.5454545454546, 0.}, {715.4545454545455, 76.47000000000025},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{715.5454545454546, 0.}, {716.4545454545455, -49.210000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{716.5454545454546, 0.}, {717.4545454545455, 28.76000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{717.5454545454546, 0.}, {718.4545454545455, 115.02000000000044`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{718.5454545454546, 0.}, {719.4545454545455, 18.279999999999745`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{719.5454545454546, 0.}, {720.4545454545455, 42.67999999999938},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{720.5454545454546, 0.}, {721.4545454545455, -56.589999999999236`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{721.5454545454546, 0.}, {722.4545454545455, -52.590000000000146`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{722.5454545454546, 0.}, {723.4545454545455, -154.36000000000058`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{723.5454545454546, 0.}, {724.4545454545455, 19.160000000000764`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{724.5454545454546, 0.}, {725.4545454545455, 7.3799999999992},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{725.5454545454546, 0.}, {726.4545454545455, 31.6200000000008},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{726.5454545454546, 0.}, {727.4545454545455, -28.69000000000051},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{727.5454545454546, 0.}, {728.4545454545455, 81.23999999999978},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{728.5454545454546, 0.}, {729.4545454545455, -23.769999999999527`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{729.5454545454546, 0.}, {730.4545454545455, 75.03999999999996},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{730.5454545454546, 0.}, {731.4545454545455, 28.18000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{731.5454545454546, 0.}, {732.4545454545455, -37.38000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{732.5454545454546, 0.}, {733.4545454545455, 51.289999999999964`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{733.5454545454546, 0.}, {734.4545454545455, -144.9300000000003},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{734.5454545454546, 0.}, {735.4545454545455, -27.86999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{735.5454545454546, 0.}, {736.4545454545455, -41.460000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{736.5454545454546, 0.}, {737.4545454545455, 5.260000000000218},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{737.5454545454546, 0.}, {738.4545454545455, 0.3599999999996726},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{738.5454545454546, 0.}, {739.4545454545455, -67.19999999999982},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{739.5454545454546, 0.}, {740.4545454545455, -58.5},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{740.5454545454546, 0.}, {741.4545454545455, -92.89000000000033},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{741.5454545454546, 0.}, {742.4545454545455, 173.3100000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{742.5454545454546, 0.}, {743.4545454545455, 49.149999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{743.5454545454546, 0.}, {744.4545454545455, 11.720000000000255`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{744.5454545454546, 0.}, {745.4545454545455, 60.279999999999745`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{745.5454545454546, 0.}, {746.4545454545455, 64.14000000000033},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{746.5454545454546, 0.}, {747.4545454545455, -17.100000000000364`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{747.5454545454546, 0.}, {748.4545454545455, 40.30000000000018},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{748.5454545454546, 0.}, {749.4545454545455, 11.079999999999927`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{749.5454545454546, 0.}, {750.4545454545455, 57.55000000000018},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{750.5454545454546, 0.}, {751.4545454545455, 4.539999999999964},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{751.5454545454546, 0.}, {752.4545454545455, 29.710000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{752.5454545454546, 0.}, {753.4545454545455, -0.09000000000014552},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{753.5454545454546, 0.}, {754.4545454545455, 19.43000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{754.5454545454546, 0.}, {755.4545454545455, 79.98999999999978},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{755.5454545454546, 0.}, {756.4545454545455, -16.73999999999978},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{756.5454545454546, 0.}, {757.4545454545455, 13.11999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{757.5454545454546, 0.}, {758.4545454545455, 58.82999999999993},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{758.5454545454546, 0.}, {759.4545454545455, 25.039999999999964`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{759.5454545454546, 0.}, {760.4545454545455, -32.8100000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{760.5454545454546, 0.}, {761.4545454545455, 14.490000000000691`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{761.5454545454546, 0.}, {762.4545454545455, 8.469999999999345},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{762.5454545454546, 0.}, {763.4545454545455, 48.64000000000033},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{763.5454545454546, 0.}, {764.4545454545455, 14.920000000000073`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{764.5454545454546, 0.}, {765.4545454545455, 3.600000000000364},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{765.5454545454546, 0.}, {766.4545454545455, -35.8700000000008},
       RoundingRadius->0]}, {}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{768.5454545454546, 0.}, {769.4545454545455, 19.650000000000546`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{769.5454545454546, 0.}, {770.4545454545455, -43.48999999999978},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{771.5454545454546, 0.}, {772.4545454545455, 166.38999999999942`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{772.5454545454546, 0.}, {773.4545454545455, -22.340000000000146`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{773.5454545454546, 0.}, {774.4545454545455, 19.93000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{774.5454545454546, 0.}, {775.4545454545455, -43.710000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{775.5454545454546, 0.}, {776.4545454545455, -36.82999999999993},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{776.5454545454546, 0.}, {777.4545454545455, 24.640000000000327`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{777.5454545454546, 0.}, {778.4545454545455, -12.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{778.5454545454546, 0.}, {779.4545454545455, 7.059999999999491},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{779.5454545454546, 0.}, {780.4545454545455, 13.990000000000691`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{780.5454545454546, 0.}, {781.4545454545455, -53.61000000000058},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{781.5454545454546, 0.}, {782.4545454545455, 15.220000000000255`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{782.5454545454546, 0.}, {783.4545454545455, 44.32999999999993},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{783.5454545454546, 0.}, {784.4545454545455, -33.23000000000047},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{784.5454545454546, 0.}, {785.4545454545455, 46.63000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{785.5454545454546, 0.}, {786.4545454545455, -52.649999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{786.5454545454546, 0.}, {787.4545454545455, 11.329999999999927`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{787.5454545454546, 0.}, {788.4545454545455, 40.590000000000146`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{788.5454545454546, 0.}, {789.4545454545455, 109.84000000000015`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{789.5454545454546, 0.}, {790.4545454545455, -24.970000000000255`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{790.5454545454546, 0.}, {791.4545454545455, 15.569999999999709`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{791.5454545454546, 0.}, {792.4545454545455, -37.25999999999931},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{792.5454545454546, 0.}, {793.4545454545455, -35.26000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{793.5454545454546, 0.}, {794.4545454545455, 57.340000000000146`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{794.5454545454546, 0.}, {795.4545454545455, -195.16000000000076`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{795.5454545454546, 0.}, {796.4545454545455, 26.43000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{796.5454545454546, 0.}, {797.4545454545455, -83.47999999999956},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{797.5454545454546, 0.}, {798.4545454545455, 9.670000000000073},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{798.5454545454546, 0.}, {799.4545454545455, 61.289999999999964`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{799.5454545454546, 0.}, {800.4545454545455, -18.400000000000546`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{800.5454545454546, 0.}, {801.4545454545455, 26.449999999999818`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{801.5454545454546, 0.}, {802.4545454545455, 51.70000000000073},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{802.5454545454546, 0.}, {803.4545454545455, -80.70000000000073},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{803.5454545454546, 0.}, {804.4545454545455, -37.67999999999938},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{804.5454545454546, 0.}, {805.4545454545455, 35.219999999999345`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{805.5454545454546, 0.}, {806.4545454545455, 123.72000000000025`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{806.5454545454546, 0.}, {807.4545454545455, -23.550000000000182`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{807.5454545454546, 0.}, {808.4545454545455, -145.32999999999993`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{808.5454545454546, 0.}, {809.4545454545455, 78.34000000000015},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{809.5454545454546, 0.}, {810.4545454545455, 111.27999999999975`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{810.5454545454546, 0.}, {811.4545454545455, -176.07999999999993`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{811.5454545454546, 0.}, {812.4545454545455, 78.72000000000025},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{812.5454545454546, 0.}, {813.4545454545455, 65.86999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{813.5454545454546, 0.}, {814.4545454545455, -33.539999999999964`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{814.5454545454546, 0.}, {815.4545454545455, -16.479999999999563`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{815.5454545454546, 0.}, {816.4545454545455, 178.6300000000001},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{816.5454545454546, 0.}, {817.4545454545455, 49.01999999999953},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{817.5454545454546, 0.}, {818.4545454545455, 20.44000000000051},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{818.5454545454546, 0.}, {819.4545454545455, 46.69999999999982},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{819.5454545454546, 0.}, {820.4545454545455, -2.180000000000291},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{820.5454545454546, 0.}, {821.4545454545455, -18.170000000000073`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{821.5454545454546, 0.}, {822.4545454545455, 4.789999999999964},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{822.5454545454546, 0.}, {823.4545454545455, 87.46000000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{823.5454545454546, 0.}, {824.4545454545455, -15.519999999999527`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{824.5454545454546, 0.}, {825.4545454545455, -32.150000000000546`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{825.5454545454546, 0.}, {826.4545454545455, -62.909999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{826.5454545454546, 0.}, {827.4545454545455, 54.18000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{827.5454545454546, 0.}, {828.4545454545455, -69.46000000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{828.5454545454546, 0.}, {829.4545454545455, -21.159999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{829.5454545454546, 0.}, {830.4545454545455, -40.45000000000073},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{830.5454545454546, 0.}, {831.4545454545455, 8.770000000000437},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{831.5454545454546, 0.}, {832.4545454545455, -90.57999999999993},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{832.5454545454546, 0.}, {833.4545454545455, 6.220000000000255},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{834.5454545454546, 0.}, {835.4545454545455, 148.5599999999995},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{835.5454545454546, 0.}, {836.4545454545455, -69.11999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{836.5454545454546, 0.}, {837.4545454545455, -57.35999999999967},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{837.5454545454546, 0.}, {838.4545454545455, -158.64000000000033`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{838.5454545454546, 0.}, {839.4545454545455, 3.8900000000003274`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{839.5454545454546, 0.}, {840.4545454545455, -25.13000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{840.5454545454546, 0.}, {841.4545454545455, 173.1199999999999},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{841.5454545454546, 0.}, {842.4545454545455, 61.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{842.5454545454546, 0.}, {843.4545454545455, -126.85999999999967`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{843.5454545454546, 0.}, {844.4545454545455, -32.14000000000033},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{844.5454545454546, 0.}, {845.4545454545455, -30.050000000000182`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{845.5454545454546, 0.}, {846.4545454545455, -179.55000000000018`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{846.5454545454546, 0.}, {847.4545454545455, -29.300000000000182`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{847.5454545454546, 0.}, {848.4545454545455, -13.769999999999527`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{848.5454545454546, 0.}, {849.4545454545455, 18.149999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{849.5454545454546, 0.}, {850.4545454545455, 180.10000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{850.5454545454546, 0.}, {851.4545454545455, 100.81999999999971`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{851.5454545454546, 0.}, {852.4545454545455, 73.82999999999993},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{852.5454545454546, 0.}, {853.4545454545455, -18.099999999999454`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{853.5454545454546, 0.}, {854.4545454545455, 58.73999999999978},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{854.5454545454546, 0.}, {855.4545454545455, 40.210000000000036`},
       RoundingRadius->0]}, {}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{856.5454545454546, 0.}, {857.4545454545455, 48.},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{857.5454545454546, 0.}, {858.4545454545455, 160.57999999999993`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{858.5454545454546, 0.}, {859.4545454545455, -10.210000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{859.5454545454546, 0.}, {860.4545454545455, 69.69999999999982},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{860.5454545454546, 0.}, {861.4545454545455, 67.92999999999938},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{861.5454545454546, 0.}, {862.4545454545455, 12.840000000000146`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{862.5454545454546, 0.}, {863.4545454545455, 16.040000000000873`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{863.5454545454546, 0.}, {864.4545454545455, 0.7000000000007276},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{864.5454545454546, 0.}, {865.4545454545455, 59.81999999999971},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{865.5454545454546, 0.}, {866.4545454545455, 23.30999999999949},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{866.5454545454546, 0.}, {867.4545454545455, 7.450000000000728},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{867.5454545454546, 0.}, {868.4545454545455, 28.1299999999992},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{868.5454545454546, 0.}, {869.4545454545455, 57.82999999999993},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{869.5454545454546, 0.}, {870.4545454545455, 16.3700000000008},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{870.5454545454546, 0.}, {871.4545454545455, 58.68999999999869},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{871.5454545454546, 0.}, {872.4545454545455, -178.90999999999985`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{872.5454545454546, 0.}, {873.4545454545455, -46.659999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{873.5454545454546, 0.}, {874.4545454545455, 77.97999999999956},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{874.5454545454546, 0.}, {875.4545454545455, 97.57000000000153},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{875.5454545454546, 0.}, {876.4545454545455, -144.29000000000087`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{876.5454545454546, 0.}, {877.4545454545455, 63.6200000000008},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{877.5454545454546, 0.}, {878.4545454545455, -51.36000000000058},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{878.5454545454546, 0.}, {879.4545454545455, -63.04000000000087},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{879.5454545454546, 0.}, {880.4545454545455, 10.159999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{880.5454545454546, 0.}, {881.4545454545455, -99.77999999999884},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{881.5454545454546, 0.}, {882.4545454545455, -97.36999999999989},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{882.5454545454546, 0.}, {883.4545454545455, 155.8699999999999},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{883.5454545454546, 0.}, {884.4545454545455, 53.01000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{884.5454545454546, 0.}, {885.4545454545455, -85.23000000000138},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{885.5454545454546, 0.}, {886.4545454545455, -79.18999999999869},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{886.5454545454546, 0.}, {887.4545454545455, -47.88000000000011},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{887.5454545454546, 0.}, {888.4545454545455, 32.56999999999971},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{888.5454545454546, 0.}, {889.4545454545455, 87.76999999999953},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{889.5454545454546, 0.}, {890.4545454545455, 13.780000000000655`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{890.5454545454546, 0.}, {891.4545454545455, -32.43000000000029},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{891.5454545454546, 0.}, {892.4545454545455, -268.60000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{892.5454545454546, 0.}, {893.4545454545455, -139.23999999999978`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{893.5454545454546, 0.}, {894.4545454545455, -96.78999999999996},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{894.5454545454546, 0.}, {895.4545454545455, 118.85000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{895.5454545454546, 0.}, {896.4545454545455, 129.6899999999996},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{896.5454545454546, 0.}, {897.4545454545455, 49.76000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{897.5454545454546, 0.}, {898.4545454545455, -31.529999999999745`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{898.5454545454546, 0.}, {899.4545454545455, 24.699999999999818`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{899.5454545454546, 0.}, {900.4545454545455, -73.14999999999964},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{900.5454545454546, 0.}, {901.4545454545455, -81.45000000000073},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{901.5454545454546, 0.}, {902.4545454545455, 164.9900000000007},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{902.5454545454546, 0.}, {903.4545454545455, -188.3100000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{903.5454545454546, 0.}, {904.4545454545455, 162.53999999999996`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{904.5454545454546, 0.}, {905.4545454545455, 89.21000000000004},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{905.5454545454546, 0.}, {906.4545454545455, 8.729999999999563},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{906.5454545454546, 0.}, {907.4545454545455, 92.32000000000062},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{907.5454545454546, 0.}, {908.4545454545455, 53.970000000000255`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{908.5454545454546, 0.}, {909.4545454545455, 22.039999999999054`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{909.5454545454546, 0.}, {910.4545454545455, -33.76000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{910.5454545454546, 0.}, {911.4545454545455, 53.67000000000007},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{911.5454545454546, 0.}, {912.4545454545455, 82.3700000000008},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{912.5454545454546, 0.}, {913.4545454545455, -5.520000000000437},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{913.5454545454546, 0.}, {914.4545454545455, -0.5100000000002183},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{914.5454545454546, 0.}, {915.4545454545455, -16.829999999999927`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{915.5454545454546, 0.}, {916.4545454545455, 64.88000000000102},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{916.5454545454546, 0.}, {917.4545454545455, -80.13000000000102},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{917.5454545454546, 0.}, {918.4545454545455, -54.06999999999971},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{918.5454545454546, 0.}, {919.4545454545455, 14.1200000000008},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{919.5454545454546, 0.}, {920.4545454545455, 11.989999999999782`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{920.5454545454546, 0.}, {921.4545454545455, 4.949999999998909},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{921.5454545454546, 0.}, {922.4545454545455, 134.76000000000022`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{922.5454545454546, 0.}, {923.4545454545455, -3.789999999999054},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{923.5454545454546, 0.}, {924.4545454545455, -8.56000000000131},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{924.5454545454546, 0.}, {925.4545454545455, -98.64999999999964},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{925.5454545454546, 0.}, {926.4545454545455, -39.25},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{926.5454545454546, 0.}, {927.4545454545455, 57.840000000000146`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{927.5454545454546, 0.}, {928.4545454545455, 19.98999999999978},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{928.5454545454546, 0.}, {929.4545454545455, 20.94000000000051},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{929.5454545454546, 0.}, {930.4545454545455, 56.51000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{930.5454545454546, 0.}, {931.4545454545455, 22.360000000000582`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{931.5454545454546, 0.}, {932.4545454545455, -61.82999999999993},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{932.5454545454546, 0.}, {933.4545454545455, 15.649999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{933.5454545454546, 0.}, {934.4545454545455, -25.649999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{934.5454545454546, 0.}, {935.4545454545455, -66.26000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{935.5454545454546, 0.}, {936.4545454545455, -14.6200000000008},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{936.5454545454546, 0.}, {937.4545454545455, 112.47999999999956`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{937.5454545454546, 0.}, {938.4545454545455, 19.100000000000364`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{938.5454545454546, 0.}, {939.4545454545455, 18.159999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{939.5454545454546, 0.}, {940.4545454545455, -192.59000000000015`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{940.5454545454546, 0.}, {941.4545454545455, -84.65999999999985},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{941.5454545454546, 0.}, {942.4545454545455, 36.649999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{942.5454545454546, 0.}, {943.4545454545455, -91.39999999999964},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{943.5454545454546, 0.}, {944.4545454545455, 140.72000000000116`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{944.5454545454546, 0.}, {945.4545454545455, -63.160000000000764`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{945.5454545454546, 0.}, {946.4545454545455, 15.210000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{946.5454545454546, 0.}, {947.4545454545455, 39.05999999999949},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{947.5454545454546, 0.}, {948.4545454545455, 40.69000000000051},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{948.5454545454546, 0.}, {949.4545454545455, 0.6499999999996362},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{949.5454545454546, 0.}, {950.4545454545455, 170.22000000000116`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{950.5454545454546, 0.}, {951.4545454545455, 49.18999999999869},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{951.5454545454546, 0.}, {952.4545454545455, -1.7299999999995634`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{952.5454545454546, 0.}, {953.4545454545455, 15.420000000000073`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{953.5454545454546, 0.}, {954.4545454545455, 103.57999999999993`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{954.5454545454546, 0.}, {955.4545454545455, -16.049999999999272`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{955.5454545454546, 0.}, {956.4545454545455, 39.10999999999876},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{956.5454545454546, 0.}, {957.4545454545455, 58.1200000000008},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{957.5454545454546, 0.}, {958.4545454545455, -18.450000000000728`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{958.5454545454546, 0.}, {959.4545454545455, -40.43999999999869},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{959.5454545454546, 0.}, {960.4545454545455, 29.30999999999949},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{960.5454545454546, 0.}, {961.4545454545455, 1.0299999999988358`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{961.5454545454546, 0.}, {962.4545454545455, -1.5299999999988358`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{962.5454545454546, 0.}, {963.4545454545455, -2.5900000000001455`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{963.5454545454546, 0.}, {964.4545454545455, -67.11000000000058},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{964.5454545454546, 0.}, {965.4545454545455, 94.73999999999978},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{965.5454545454546, 0.}, {966.4545454545455, -59.719999999999345`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{966.5454545454546, 0.}, {967.4545454545455, -31.51000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{967.5454545454546, 0.}, {968.4545454545455, 25.05999999999949},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{968.5454545454546, 0.}, {969.4545454545455, -31.389999999999418`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{969.5454545454546, 0.}, {970.4545454545455, -35.69000000000051},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{970.5454545454546, 0.}, {971.4545454545455, -39.19999999999891},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{971.5454545454546, 0.}, {972.4545454545455, 169.07999999999993`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{972.5454545454546, 0.}, {973.4545454545455, 39.05999999999949},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{973.5454545454546, 0.}, {974.4545454545455, -1.0200000000004366`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{974.5454545454546, 0.}, {975.4545454545455, 80.63000000000102},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{975.5454545454546, 0.}, {976.4545454545455, 41.55999999999949},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{976.5454545454546, 0.}, {977.4545454545455, -34.02000000000044},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{977.5454545454546, 0.}, {978.4545454545455, 53.1200000000008},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{978.5454545454546, 0.}, {979.4545454545455, 2.1199999999989814`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{979.5454545454546, 0.}, {980.4545454545455, 80.23999999999978},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{980.5454545454546, 0.}, {981.4545454545455, -27.599999999998545`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{981.5454545454546, 0.}, {982.4545454545455, 60.76999999999862},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{982.5454545454546, 0.}, {983.4545454545455, 5.110000000000582},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{983.5454545454546, 0.}, {984.4545454545455, -7.0900000000001455`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{984.5454545454546, 0.}, {985.4545454545455, 43.39000000000124},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{985.5454545454546, 0.}, {986.4545454545455, -11.770000000000437`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{986.5454545454546, 0.}, {987.4545454545455, 23.649999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{987.5454545454546, 0.}, {988.4545454545455, -26.090000000000146`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{988.5454545454546, 0.}, {989.4545454545455, 29.399999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{989.5454545454546, 0.}, {990.4545454545455, -28.11999999999898},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{990.5454545454546, 0.}, {991.4545454545455, 31.76000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{991.5454545454546, 0.}, {992.4545454545455, 40.159999999999854`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{992.5454545454546, 0.}, {993.4545454545455, -2.75},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{993.5454545454546, 0.}, {994.4545454545455, 29.579999999999927`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{994.5454545454546, 0.}, {995.4545454545455, -31.38000000000102},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{995.5454545454546, 0.}, {996.4545454545455, -21.649999999999636`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{996.5454545454546, 0.}, {997.4545454545455, 94.82999999999993},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{997.5454545454546, 0.}, {998.4545454545455, 19.030000000000655`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{998.5454545454546, 0.}, {999.4545454545455, 56.73999999999978},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{999.5454545454546, 0.}, {1000.4545454545455`, -32.13999999999942},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1000.5454545454546`, 0.}, {1001.4545454545455`, 8.779999999998836},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1001.5454545454546`, 0.}, {1002.4545454545455`, -5.989999999999782},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1002.5454545454546`, 0.}, {1003.4545454545455`, 22.960000000000946`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1003.5454545454546`, 0.}, {1004.4545454545455`, 80.90999999999985},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1004.5454545454546`, 0.}, {1005.4545454545455`, -9.880000000001019},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1005.5454545454546`, 0.}, {1006.4545454545455`, 61.05999999999949},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1006.5454545454546`, 0.}, {1007.4545454545455`, 36.2400000000016},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1007.5454545454546`, 0.}, {1008.4545454545455`, 17.929999999998472`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1008.5454545454546`, 0.}, {1009.4545454545455`, -3.3400000000001455`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1009.5454545454546`, 0.}, {1010.4545454545455`, -178.5599999999995},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1010.5454545454546`, 0.}, {1011.4545454545455`, -82.77000000000044},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1011.5454545454546`, 0.}, {1012.4545454545455`, -55.67999999999847},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1012.5454545454546`, 0.}, {1013.4545454545455`, 87.45999999999913},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1013.5454545454546`, 0.}, {1014.4545454545455`, 22.76000000000022},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1014.5454545454546`, 0.}, {1015.4545454545455`, -80.72999999999956},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1015.5454545454546`, 0.}, {1016.4545454545455`, -37.32999999999993},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1016.5454545454546`, 0.}, {1017.4545454545455`, -60.11000000000058},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1017.5454545454546`, 0.}, {1018.4545454545455`, -10.540000000000873`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1018.5454545454546`, 0.}, {1019.4545454545455`, 157.10000000000036`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1019.5454545454546`, 0.}, {1020.4545454545455`, -78.43999999999869},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1020.5454545454546`, 0.}, {1021.4545454545455`, 96.6299999999992},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1021.5454545454546`, 0.}, {1022.4545454545455`, 153.98999999999978`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1022.5454545454546`, 0.}, {1023.4545454545455`, 64.44000000000051},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1023.5454545454546`, 0.}, {1024.4545454545455`, 88.63999999999942},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1024.5454545454545`, 0.}, {1025.4545454545455`, 100.56999999999971`},
       RoundingRadius->0]}, 
     {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
      EdgeForm[Opacity[0.7]], RectangleBox[{1025.5454545454545`, 0.}, {1026.4545454545455`, -37.22999999999956},
       RoundingRadius->
        0]}}, {}, {}}, {}, {{{{{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {}, {}, {{}, {}}, {{}, {}}, {}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}}, {}}, {}}, {}}, GraphicsGroupBox[
    {GrayLevel[0], 
     StyleBox[
      LineBox[{{{0.5454545454545454, 0.}, 
         Offset[{0, -4}, {0.5454545454545454, 0.}]}, {{1026.4545454545455`, 
         0.}, Offset[{0, -4}, {1026.4545454545455`, 0.}]}}],
      Antialiasing->False]}]},
  AspectRatio->NCache[
    Rational[1, 3], 0.3333333333333333],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"Tag\"", TraditionalForm], 
    FormBox["\"Dax-Close2Close-Return\"", TraditionalForm]},
  AxesOrigin->{0.4545454545454546, 0},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  ImageSize->600,
  PlotRangePadding->Scaled[0.02],
  Ticks->{None, Automatic}]], "Output",
 CellChangeTimes->{
  3.616667378865383*^9, 3.6166674287854705`*^9, {3.6166675008887973`*^9, 
   3.6166675408404675`*^9}, 3.6166708522646837`*^9, 3.6166721272469234`*^9, 
   3.61667226763157*^9, 3.6166732218404465`*^9, 3.616675743773677*^9, 
   3.6166759669410696`*^9, 3.616676030211981*^9, 3.616676319529889*^9, 
   3.616676380213995*^9}]
}, Open  ]],

Cell["\<\
Hmm, sieht nicht nach nem echten Systemvorteil aus verglichen mit nem \
einfachen Verlauf der Dax-Renditen. Oh weia, da dreht man mir mit Sicherheit \
im Forum nen Strick draus (\[OpenCurlyDoubleQuote]H\[ADoubleDot]ngt den \
Ketzer auf ! Brennen soll er !\[CloseCurlyDoubleQuote]). Zum \
Gl\[UDoubleDot]ck hab ich meinen Account ja l\[ODoubleDot]schen lassen. Da k\
\[ODoubleDot]nnen sie mich aus der Ferne hassen. :D



Kumuliert (also Tag f\[UDoubleDot]r Tag aufgerechnet) ergibt sich dasselbe \
Bild wie bei trash. \
\>", "Text",
 CellChangeTimes->{{3.6166580316341653`*^9, 3.616658070322233*^9}, {
   3.61666364262082*^9, 3.616663667627664*^9}, {3.61666721244429*^9, 
   3.616667250321157*^9}, 3.6166672963880377`*^9, {3.616667564178108*^9, 
   3.6166676529422646`*^9}, {3.616672281312794*^9, 3.6166723049624357`*^9}, 
   3.616675743773677*^9, 3.616676030211981*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"cumulatedGV", "=", 
   RowBox[{"Accumulate", "[", 
    RowBox[{"data", "[", 
     RowBox[{"[", 
      RowBox[{";;", ",", " ", "gVCol"}], "]"}], "]"}], "]"}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.616663821147534*^9, 3.6166638331439548`*^9}, 
   3.616675743773677*^9, 3.616676030211981*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{"cumulatedGV", ",", 
   RowBox[{"ChartStyle", "\[Rule]", " ", "Green"}], ",", " ", 
   RowBox[{"ImageSize", "\[Rule]", " ", "600"}], ",", " ", 
   RowBox[{"AspectRatio", " ", "\[Rule]", " ", 
    RowBox[{"1", "/", "2"}]}], ",", 
   RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Speed\>\""}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Tag\>\"", ",", " ", "\"\<kum. G/V\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.6166586947289295`*^9, 3.6166587317789946`*^9}, {
   3.616658782947085*^9, 3.6166588170799446`*^9}, {3.616663825281541*^9, 
   3.616663829243948*^9}, 3.6166732207952447`*^9, 3.616675743773677*^9, 
   3.616676030211981*^9}],

Cell[BoxData[
 GraphicsBox[{
   {Opacity[0], PointBox[{{0.4545454545454546, 0.}}]}, 
   {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
    EdgeForm[Opacity[0.7]], {}, 
    {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
     EdgeForm[Opacity[0.7]], {}, {}, {}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{3.5454545454545454`, 0.}, {4.454545454545454, 70.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{4.545454545454545, 0.}, {5.454545454545454, 280.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{5.545454545454545, 0.}, {6.454545454545454, 280.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{6.545454545454545, 0.}, {7.454545454545454, 260.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{7.545454545454545, 0.}, {8.454545454545453, 244.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{8.545454545454545, 0.}, {9.454545454545453, 314.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{9.545454545454545, 0.}, {10.454545454545453`, 116.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{10.545454545454545`, 0.}, {11.454545454545453`, 116.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{11.545454545454545`, 0.}, {12.454545454545453`, 116.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{12.545454545454545`, 0.}, {13.454545454545453`, 50.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{13.545454545454545`, 0.}, {14.454545454545453`, -58.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{14.545454545454545`, 0.}, {15.454545454545453`, -120.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{15.545454545454545`, 0.}, {16.454545454545453`, 126.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{16.545454545454543`, 0.}, {17.454545454545453`, 206.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{17.545454545454543`, 0.}, {18.454545454545453`, 258.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{18.545454545454543`, 0.}, {19.454545454545453`, 100.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{19.545454545454543`, 0.}, {20.454545454545453`, 180.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{20.545454545454543`, 0.}, {21.454545454545453`, 17.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{21.545454545454543`, 0.}, {22.454545454545453`, -53.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{22.545454545454543`, 0.}, {23.454545454545453`, -53.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{23.545454545454543`, 0.}, {24.454545454545453`, -195.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{24.545454545454543`, 0.}, {25.454545454545453`, 35.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{25.545454545454543`, 0.}, {26.454545454545453`, 35.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{26.545454545454543`, 0.}, {27.454545454545453`, -73.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{27.545454545454543`, 0.}, {28.454545454545453`, 7.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{28.545454545454543`, 0.}, {29.454545454545453`, 487.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{29.545454545454543`, 0.}, {30.454545454545453`, 647.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{30.545454545454543`, 0.}, {31.454545454545453`, 647.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{31.545454545454543`, 0.}, {32.45454545454545, 707.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{32.54545454545455, 0.}, {33.45454545454545, 699.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{33.54545454545455, 0.}, {34.45454545454545, 689.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{34.54545454545455, 0.}, {35.45454545454545, 689.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{35.54545454545455, 0.}, {36.45454545454545, 689.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{36.54545454545455, 0.}, {37.45454545454545, 457.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{37.54545454545455, 0.}, {38.45454545454545, 597.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{38.54545454545455, 0.}, {39.45454545454545, 859.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{39.54545454545455, 0.}, {40.45454545454545, 929.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{40.54545454545455, 0.}, {41.45454545454545, 929.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{41.54545454545455, 0.}, {42.45454545454545, 929.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{42.54545454545455, 0.}, {43.45454545454545, 939.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{43.54545454545455, 0.}, {44.45454545454545, 939.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{44.54545454545455, 0.}, {45.45454545454545, 869.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{45.54545454545455, 0.}, {46.45454545454545, 869.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{46.54545454545455, 0.}, {47.45454545454545, 929.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{47.54545454545455, 0.}, {48.45454545454545, 943.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{48.54545454545455, 0.}, {49.45454545454545, 943.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{49.54545454545455, 0.}, {50.45454545454545, 943.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{50.54545454545455, 0.}, {51.45454545454545, 1003.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{51.54545454545455, 0.}, {52.45454545454545, 1003.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{52.54545454545455, 0.}, {53.45454545454545, 1003.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{53.54545454545455, 0.}, {54.45454545454545, 1003.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{54.54545454545455, 0.}, {55.45454545454545, 1123.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{55.54545454545455, 0.}, {56.45454545454545, 1183.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{56.54545454545455, 0.}, {57.45454545454545, 1169.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{57.54545454545455, 0.}, {58.45454545454545, 1349.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{58.54545454545455, 0.}, {59.45454545454545, 1205.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{59.54545454545455, 0.}, {60.45454545454545, 1205.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{60.54545454545455, 0.}, {61.45454545454545, 1275.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{61.54545454545455, 0.}, {62.45454545454545, 1415.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{62.54545454545455, 0.}, {63.45454545454545, 1475.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{63.54545454545455, 0.}, {64.45454545454545, 1481.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{64.54545454545455, 0.}, {65.45454545454545, 1481.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{65.54545454545455, 0.}, {66.45454545454545, 1481.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{66.54545454545455, 0.}, {67.45454545454545, 1481.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{67.54545454545455, 0.}, {68.45454545454545, 1523.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{68.54545454545455, 0.}, {69.45454545454545, 1643.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{69.54545454545455, 0.}, {70.45454545454545, 1633.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{70.54545454545455, 0.}, {71.45454545454545, 1693.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{71.54545454545455, 0.}, {72.45454545454545, 1753.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{72.54545454545455, 0.}, {73.45454545454545, 1823.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{73.54545454545455, 0.}, {74.45454545454545, 1883.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{74.54545454545455, 0.}, {75.45454545454545, 1703.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{75.54545454545455, 0.}, {76.45454545454545, 1703.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{76.54545454545455, 0.}, {77.45454545454545, 1573.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{77.54545454545455, 0.}, {78.45454545454545, 1645.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{78.54545454545455, 0.}, {79.45454545454545, 1435.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{79.54545454545455, 0.}, {80.45454545454545, 1580.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{80.54545454545455, 0.}, {81.45454545454545, 1580.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{81.54545454545455, 0.}, {82.45454545454545, 950.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{82.54545454545455, 0.}, {83.45454545454545, 796.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{83.54545454545455, 0.}, {84.45454545454545, 746.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{84.54545454545455, 0.}, {85.45454545454545, 866.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{85.54545454545455, 0.}, {86.45454545454545, 676.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{86.54545454545455, 0.}, {87.45454545454545, 546.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{87.54545454545455, 0.}, {88.45454545454545, 746.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{88.54545454545455, 0.}, {89.45454545454545, -723.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{89.54545454545455, 0.}, {90.45454545454545, -745.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{90.54545454545455, 0.}, {91.45454545454545, -905.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{91.54545454545455, 0.}, {92.45454545454545, -755.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{92.54545454545455, 0.}, {93.45454545454545, -741.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{93.54545454545455, 0.}, {94.45454545454545, -581.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{94.54545454545455, 0.}, {95.45454545454545, -765.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{95.54545454545455, 0.}, {96.45454545454545, -525.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{96.54545454545455, 0.}, {97.45454545454545, -285.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{97.54545454545455, 0.}, {98.45454545454545, -443.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{98.54545454545455, 0.}, {99.45454545454545, -735.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{99.54545454545455, 0.}, {100.45454545454545`, -535.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{100.54545454545455`, 0.}, {101.45454545454545`, -535.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{101.54545454545455`, 0.}, {102.45454545454545`, -535.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{102.54545454545455`, 0.}, {103.45454545454545`, -535.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{103.54545454545455`, 0.}, {104.45454545454545`, -735.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{104.54545454545455`, 0.}, {105.45454545454545`, -655.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{105.54545454545455`, 0.}, {106.45454545454545`, -655.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{106.54545454545455`, 0.}, {107.45454545454545`, -335.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{107.54545454545455`, 0.}, {108.45454545454545`, -455.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{108.54545454545455`, 0.}, {109.45454545454545`, -455.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{109.54545454545455`, 0.}, {110.45454545454545`, -635.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{110.54545454545455`, 0.}, {111.45454545454545`, -475.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{111.54545454545455`, 0.}, {112.45454545454545`, -275.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{112.54545454545455`, 0.}, {113.45454545454545`, 65.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{113.54545454545455`, 0.}, {114.45454545454545`, -291.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{114.54545454545455`, 0.}, {115.45454545454545`, 29.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{115.54545454545455`, 0.}, {116.45454545454545`, 29.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{116.54545454545455`, 0.}, {117.45454545454545`, -155.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{117.54545454545455`, 0.}, {118.45454545454545`, -85.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{118.54545454545455`, 0.}, {119.45454545454545`, -15.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{119.54545454545455`, 0.}, {120.45454545454545`, 55.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{120.54545454545455`, 0.}, {121.45454545454545`, 125.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{121.54545454545455`, 0.}, {122.45454545454545`, 187.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{122.54545454545455`, 0.}, {123.45454545454545`, 327.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{123.54545454545455`, 0.}, {124.45454545454545`, 325.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{124.54545454545455`, 0.}, {125.45454545454545`, 745.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{125.54545454545455`, 0.}, {126.45454545454545`, 735.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{126.54545454545455`, 0.}, {127.45454545454545`, 553.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{127.54545454545455`, 0.}, {128.45454545454547`, 617.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{128.54545454545456`, 0.}, {129.45454545454547`, 777.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{129.54545454545456`, 0.}, {130.45454545454547`, 1041.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{130.54545454545456`, 0.}, {131.45454545454547`, 1041.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{131.54545454545456`, 0.}, {132.45454545454547`, 823.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{132.54545454545456`, 0.}, {133.45454545454547`, 733.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{133.54545454545456`, 0.}, {134.45454545454547`, 733.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{134.54545454545456`, 0.}, {135.45454545454547`, 733.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{135.54545454545456`, 0.}, {136.45454545454547`, 733.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{136.54545454545456`, 0.}, {137.45454545454547`, 531.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{137.54545454545456`, 0.}, {138.45454545454547`, 601.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{138.54545454545456`, 0.}, {139.45454545454547`, 741.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{139.54545454545456`, 0.}, {140.45454545454547`, 455.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{140.54545454545456`, 0.}, {141.45454545454547`, 595.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{141.54545454545456`, 0.}, {142.45454545454547`, 381.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{142.54545454545456`, 0.}, {143.45454545454547`, 577.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{143.54545454545456`, 0.}, {144.45454545454547`, 315.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{144.54545454545456`, 0.}, {145.45454545454547`, 353.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{145.54545454545456`, 0.}, {146.45454545454547`, 423.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{146.54545454545456`, 0.}, {147.45454545454547`, 493.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{147.54545454545456`, 0.}, {148.45454545454547`, 493.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{148.54545454545456`, 0.}, {149.45454545454547`, 671.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{149.54545454545456`, 0.}, {150.45454545454547`, 811.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{150.54545454545456`, 0.}, {151.45454545454547`, 615.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{151.54545454545456`, 0.}, {152.45454545454547`, 615.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{152.54545454545456`, 0.}, {153.45454545454547`, 739.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{153.54545454545456`, 0.}, {154.45454545454547`, 809.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{154.54545454545456`, 0.}, {155.45454545454547`, 805.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{155.54545454545456`, 0.}, {156.45454545454547`, 805.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{156.54545454545456`, 0.}, {157.45454545454547`, 989.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{157.54545454545456`, 0.}, {158.45454545454547`, 847.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{158.54545454545456`, 0.}, {159.45454545454547`, 847.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{159.54545454545456`, 0.}, {160.45454545454547`, 927.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{160.54545454545456`, 0.}, {161.45454545454547`, 1087.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{161.54545454545456`, 0.}, {162.45454545454547`, 1055.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{162.54545454545456`, 0.}, {163.45454545454547`, 1055.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{163.54545454545456`, 0.}, {164.45454545454547`, 857.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{164.54545454545456`, 0.}, {165.45454545454547`, 957.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{165.54545454545456`, 0.}, {166.45454545454547`, 957.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{166.54545454545456`, 0.}, {167.45454545454547`, 731.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{167.54545454545456`, 0.}, {168.45454545454547`, 811.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{168.54545454545456`, 0.}, {169.45454545454547`, 811.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{169.54545454545456`, 0.}, {170.45454545454547`, 751.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{170.54545454545456`, 0.}, {171.45454545454547`, 609.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{171.54545454545456`, 0.}, {172.45454545454547`, 749.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{172.54545454545456`, 0.}, {173.45454545454547`, 487.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{173.54545454545456`, 0.}, {174.45454545454547`, 487.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{174.54545454545456`, 0.}, {175.45454545454547`, 605.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{175.54545454545456`, 0.}, {176.45454545454547`, 605.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{176.54545454545456`, 0.}, {177.45454545454547`, 729.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{177.54545454545456`, 0.}, {178.45454545454547`, 933.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{178.54545454545456`, 0.}, {179.45454545454547`, 797.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{179.54545454545456`, 0.}, {180.45454545454547`, 797.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{180.54545454545456`, 0.}, {181.45454545454547`, 797.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{181.54545454545456`, 0.}, {182.45454545454547`, 797.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{182.54545454545456`, 0.}, {183.45454545454547`, 857.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{183.54545454545456`, 0.}, {184.45454545454547`, 857.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{184.54545454545456`, 0.}, {185.45454545454547`, 983.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{185.54545454545456`, 0.}, {186.45454545454547`, 913.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{186.54545454545456`, 0.}, {187.45454545454547`, 913.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{187.54545454545456`, 0.}, {188.45454545454547`, 1133.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{188.54545454545456`, 0.}, {189.45454545454547`, 943.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{189.54545454545456`, 0.}, {190.45454545454547`, 692.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{190.54545454545456`, 0.}, {191.45454545454547`, 692.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{191.54545454545456`, 0.}, {192.45454545454547`, 1112.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{192.54545454545456`, 0.}, {193.45454545454547`, 1252.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{193.54545454545456`, 0.}, {194.45454545454547`, 1462.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{194.54545454545456`, 0.}, {195.45454545454547`, 1742.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{195.54545454545456`, 0.}, {196.45454545454547`, 1704.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{196.54545454545456`, 0.}, {197.45454545454547`, 1556.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{197.54545454545456`, 0.}, {198.45454545454547`, 1626.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{198.54545454545456`, 0.}, {199.45454545454547`, 1696.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{199.54545454545456`, 0.}, {200.45454545454547`, 1766.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{200.54545454545456`, 0.}, {201.45454545454547`, 1766.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{201.54545454545456`, 0.}, {202.45454545454547`, 1826.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{202.54545454545456`, 0.}, {203.45454545454547`, 1670.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{203.54545454545456`, 0.}, {204.45454545454547`, 1740.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{204.54545454545456`, 0.}, {205.45454545454547`, 1810.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{205.54545454545456`, 0.}, {206.45454545454547`, 1810.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{206.54545454545456`, 0.}, {207.45454545454547`, 1870.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{207.54545454545456`, 0.}, {208.45454545454547`, 1870.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{208.54545454545456`, 0.}, {209.45454545454547`, 1710.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{209.54545454545456`, 0.}, {210.45454545454547`, 1710.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{210.54545454545456`, 0.}, {211.45454545454547`, 1710.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{211.54545454545456`, 0.}, {212.45454545454547`, 1830.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{212.54545454545456`, 0.}, {213.45454545454547`, 1930.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{213.54545454545456`, 0.}, {214.45454545454547`, 2000.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{214.54545454545456`, 0.}, {215.45454545454547`, 2000.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{215.54545454545456`, 0.}, {216.45454545454547`, 2026.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{216.54545454545456`, 0.}, {217.45454545454547`, 1956.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{217.54545454545456`, 0.}, {218.45454545454547`, 2010.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{218.54545454545456`, 0.}, {219.45454545454547`, 1844.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{219.54545454545456`, 0.}, {220.45454545454547`, 1844.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{220.54545454545456`, 0.}, {221.45454545454547`, 1844.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{221.54545454545456`, 0.}, {222.45454545454547`, 1914.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{222.54545454545456`, 0.}, {223.45454545454547`, 2084.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{223.54545454545456`, 0.}, {224.45454545454547`, 2204.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{224.54545454545456`, 0.}, {225.45454545454547`, 2264.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{225.54545454545456`, 0.}, {226.45454545454547`, 2128.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{226.54545454545456`, 0.}, {227.45454545454547`, 1954.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{227.54545454545456`, 0.}, {228.45454545454547`, 1954.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{228.54545454545456`, 0.}, {229.45454545454547`, 1794.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{229.54545454545456`, 0.}, {230.45454545454547`, 1864.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{230.54545454545456`, 0.}, {231.45454545454547`, 1984.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{231.54545454545456`, 0.}, {232.45454545454547`, 1894.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{232.54545454545456`, 0.}, {233.45454545454547`, 1774.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{233.54545454545456`, 0.}, {234.45454545454547`, 1782.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{234.54545454545456`, 0.}, {235.45454545454547`, 1842.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{235.54545454545456`, 0.}, {236.45454545454547`, 1752.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{236.54545454545456`, 0.}, {237.45454545454547`, 1962.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{237.54545454545456`, 0.}, {238.45454545454547`, 1817.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{238.54545454545456`, 0.}, {239.45454545454547`, 1704.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{239.54545454545456`, 0.}, {240.45454545454547`, 1774.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{240.54545454545456`, 0.}, {241.45454545454547`, 1834.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{241.54545454545456`, 0.}, {242.45454545454547`, 1878.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{242.54545454545456`, 0.}, {243.45454545454547`, 1878.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{243.54545454545456`, 0.}, {244.45454545454547`, 1998.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{244.54545454545456`, 0.}, {245.45454545454547`, 1998.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{245.54545454545456`, 0.}, {246.45454545454547`, 1998.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{246.54545454545456`, 0.}, {247.45454545454547`, 1998.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{247.54545454545456`, 0.}, {248.45454545454547`, 2058.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{248.54545454545456`, 0.}, {249.45454545454547`, 2058.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{249.54545454545456`, 0.}, {250.45454545454547`, 2118.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{250.54545454545456`, 0.}, {251.45454545454547`, 2134.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{251.54545454545456`, 0.}, {252.45454545454547`, 2114.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{252.54545454545456`, 0.}, {253.45454545454547`, 2114.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{253.54545454545456`, 0.}, {254.45454545454547`, 2142.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{254.54545454545456`, 0.}, {255.45454545454547`, 2142.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{255.54545454545456`, 0.}, {256.4545454545455, 1878.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{256.54545454545456`, 0.}, {257.4545454545455, 1878.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{257.54545454545456`, 0.}, {258.4545454545455, 1878.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{258.54545454545456`, 0.}, {259.4545454545455, 1878.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{259.54545454545456`, 0.}, {260.4545454545455, 1948.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{260.54545454545456`, 0.}, {261.4545454545455, 2018.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{261.54545454545456`, 0.}, {262.4545454545455, 1892.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{262.54545454545456`, 0.}, {263.4545454545455, 2056.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{263.54545454545456`, 0.}, {264.4545454545455, 2188.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{264.54545454545456`, 0.}, {265.4545454545455, 1954.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{265.54545454545456`, 0.}, {266.4545454545455, 1918.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{266.54545454545456`, 0.}, {267.4545454545455, 1782.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{267.54545454545456`, 0.}, {268.4545454545455, 1828.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{268.54545454545456`, 0.}, {269.4545454545455, 1869.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{269.54545454545456`, 0.}, {270.4545454545455, 1869.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{270.54545454545456`, 0.}, {271.4545454545455, 1799.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{271.54545454545456`, 0.}, {272.4545454545455, 1655.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{272.54545454545456`, 0.}, {273.4545454545455, 1799.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{273.54545454545456`, 0.}, {274.4545454545455, 2009.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{274.54545454545456`, 0.}, {275.4545454545455, 2189.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{275.54545454545456`, 0.}, {276.4545454545455, 2277.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{276.54545454545456`, 0.}, {277.4545454545455, 2261.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{277.54545454545456`, 0.}, {278.4545454545455, 2265.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{278.54545454545456`, 0.}, {279.4545454545455, 2133.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{279.54545454545456`, 0.}, {280.4545454545455, 2193.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{280.54545454545456`, 0.}, {281.4545454545455, 2081.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{281.54545454545456`, 0.}, {282.4545454545455, 2123.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{282.54545454545456`, 0.}, {283.4545454545455, 2123.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{283.54545454545456`, 0.}, {284.4545454545455, 2123.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{284.54545454545456`, 0.}, {285.4545454545455, 2097.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{285.54545454545456`, 0.}, {286.4545454545455, 2061.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{286.54545454545456`, 0.}, {287.4545454545455, 2061.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{287.54545454545456`, 0.}, {288.4545454545455, 2241.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{288.54545454545456`, 0.}, {289.4545454545455, 2285.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{289.54545454545456`, 0.}, {290.4545454545455, 2285.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{290.54545454545456`, 0.}, {291.4545454545455, 2345.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{291.54545454545456`, 0.}, {292.4545454545455, 2345.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{292.54545454545456`, 0.}, {293.4545454545455, 2385.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{293.54545454545456`, 0.}, {294.4545454545455, 2445.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{294.54545454545456`, 0.}, {295.4545454545455, 2235.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{295.54545454545456`, 0.}, {296.4545454545455, 2275.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{296.54545454545456`, 0.}, {297.4545454545455, 2083.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{297.54545454545456`, 0.}, {298.4545454545455, 2485.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{298.54545454545456`, 0.}, {299.4545454545455, 2467.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{299.54545454545456`, 0.}, {300.4545454545455, 2235.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{300.54545454545456`, 0.}, {301.4545454545455, 2085.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{301.54545454545456`, 0.}, {302.4545454545455, 2155.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{302.54545454545456`, 0.}, {303.4545454545455, 2465.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{303.54545454545456`, 0.}, {304.4545454545455, 2351.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{304.54545454545456`, 0.}, {305.4545454545455, 2561.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{305.54545454545456`, 0.}, {306.4545454545455, 2771.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{306.54545454545456`, 0.}, {307.4545454545455, 2911.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{307.54545454545456`, 0.}, {308.4545454545455, 2893.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{308.54545454545456`, 0.}, {309.4545454545455, 2893.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{309.54545454545456`, 0.}, {310.4545454545455, 3213.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{310.54545454545456`, 0.}, {311.4545454545455, 2723.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{311.54545454545456`, 0.}, {312.4545454545455, 2587.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{312.54545454545456`, 0.}, {313.4545454545455, 2595.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{313.54545454545456`, 0.}, {314.4545454545455, 2675.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{314.54545454545456`, 0.}, {315.4545454545455, 2487.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{315.54545454545456`, 0.}, {316.4545454545455, 2561.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{316.54545454545456`, 0.}, {317.4545454545455, 2631.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{317.54545454545456`, 0.}, {318.4545454545455, 2405.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{318.54545454545456`, 0.}, {319.4545454545455, 2465.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{319.54545454545456`, 0.}, {320.4545454545455, 2465.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{320.54545454545456`, 0.}, {321.4545454545455, 2535.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{321.54545454545456`, 0.}, {322.4545454545455, 2489.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{322.54545454545456`, 0.}, {323.4545454545455, 2489.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{323.54545454545456`, 0.}, {324.4545454545455, 2299.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{324.54545454545456`, 0.}, {325.4545454545455, 2299.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{325.54545454545456`, 0.}, {326.4545454545455, 2359.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{326.54545454545456`, 0.}, {327.4545454545455, 2335.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{327.54545454545456`, 0.}, {328.4545454545455, 2395.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{328.54545454545456`, 0.}, {329.4545454545455, 2441.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{329.54545454545456`, 0.}, {330.4545454545455, 2501.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{330.54545454545456`, 0.}, {331.4545454545455, 2517.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{331.54545454545456`, 0.}, {332.4545454545455, 2657.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{332.54545454545456`, 0.}, {333.4545454545455, 2837.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{333.54545454545456`, 0.}, {334.4545454545455, 2837.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{334.54545454545456`, 0.}, {335.4545454545455, 2645.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{335.54545454545456`, 0.}, {336.4545454545455, 2645.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{336.54545454545456`, 0.}, {337.4545454545455, 2383.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{337.54545454545456`, 0.}, {338.4545454545455, 2383.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{338.54545454545456`, 0.}, {339.4545454545455, 2383.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{339.54545454545456`, 0.}, {340.4545454545455, 2383.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{340.54545454545456`, 0.}, {341.4545454545455, 2329.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{341.54545454545456`, 0.}, {342.4545454545455, 2223.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{342.54545454545456`, 0.}, {343.4545454545455, 2223.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{343.54545454545456`, 0.}, {344.4545454545455, 2221.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{344.54545454545456`, 0.}, {345.4545454545455, 2239.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{345.54545454545456`, 0.}, {346.4545454545455, 2311.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{346.54545454545456`, 0.}, {347.4545454545455, 2173.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{347.54545454545456`, 0.}, {348.4545454545455, 2453.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{348.54545454545456`, 0.}, {349.4545454545455, 2143.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{349.54545454545456`, 0.}, {350.4545454545455, 2273.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{350.54545454545456`, 0.}, {351.4545454545455, 2125.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{351.54545454545456`, 0.}, {352.4545454545455, 2211.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{352.54545454545456`, 0.}, {353.4545454545455, 2055.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{353.54545454545456`, 0.}, {354.4545454545455, 1971.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{354.54545454545456`, 0.}, {355.4545454545455, 2041.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{355.54545454545456`, 0.}, {356.4545454545455, 2127.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{356.54545454545456`, 0.}, {357.4545454545455, 2127.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{357.54545454545456`, 0.}, {358.4545454545455, 2323.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{358.54545454545456`, 0.}, {359.4545454545455, 2097.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{359.54545454545456`, 0.}, {360.4545454545455, 1955.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{360.54545454545456`, 0.}, {361.4545454545455, 2165.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{361.54545454545456`, 0.}, {362.4545454545455, 2141.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{362.54545454545456`, 0.}, {363.4545454545455, 1987.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{363.54545454545456`, 0.}, {364.4545454545455, 2127.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{364.54545454545456`, 0.}, {365.4545454545455, 2197.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{365.54545454545456`, 0.}, {366.4545454545455, 2043.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{366.54545454545456`, 0.}, {367.4545454545455, 1911.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{367.54545454545456`, 0.}, {368.4545454545455, 2091.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{368.54545454545456`, 0.}, {369.4545454545455, 2371.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{369.54545454545456`, 0.}, {370.4545454545455, 2325.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{370.54545454545456`, 0.}, {371.4545454545455, 2815.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{371.54545454545456`, 0.}, {372.4545454545455, 2885.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{372.54545454545456`, 0.}, {373.4545454545455, 2749.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{373.54545454545456`, 0.}, {374.4545454545455, 2589.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{374.54545454545456`, 0.}, {375.4545454545455, 2659.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{375.54545454545456`, 0.}, {376.4545454545455, 2511.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{376.54545454545456`, 0.}, {377.4545454545455, 2421.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{377.54545454545456`, 0.}, {378.4545454545455, 2561.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{378.54545454545456`, 0.}, {379.4545454545455, 2239.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{379.54545454545456`, 0.}, {380.4545454545455, 2309.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{380.54545454545456`, 0.}, {381.4545454545455, 2065.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{381.54545454545456`, 0.}, {382.4545454545455, 2065.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{382.54545454545456`, 0.}, {383.4545454545455, 1921.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{383.54545454545456`, 0.}, {384.4545454545455, 1941.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{384.54545454545456`, 0.}, {385.4545454545455, 2035.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{385.54545454545456`, 0.}, {386.4545454545455, 2069.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{386.54545454545456`, 0.}, {387.4545454545455, 1903.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{387.54545454545456`, 0.}, {388.4545454545455, 1897.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{388.54545454545456`, 0.}, {389.4545454545455, 1867.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{389.54545454545456`, 0.}, {390.4545454545455, 1867.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{390.54545454545456`, 0.}, {391.4545454545455, 1867.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{391.54545454545456`, 0.}, {392.4545454545455, 1987.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{392.54545454545456`, 0.}, {393.4545454545455, 2057.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{393.54545454545456`, 0.}, {394.4545454545455, 1901.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{394.54545454545456`, 0.}, {395.4545454545455, 1757.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{395.54545454545456`, 0.}, {396.4545454545455, 1483.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{396.54545454545456`, 0.}, {397.4545454545455, 1277.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{397.54545454545456`, 0.}, {398.4545454545455, 1417.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{398.54545454545456`, 0.}, {399.4545454545455, 1557.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{399.54545454545456`, 0.}, {400.4545454545455, 1659.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{400.54545454545456`, 0.}, {401.4545454545455, 1409.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{401.54545454545456`, 0.}, {402.4545454545455, 1549.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{402.54545454545456`, 0.}, {403.4545454545455, 1689.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{403.54545454545456`, 0.}, {404.4545454545455, 1749.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{404.54545454545456`, 0.}, {405.4545454545455, 1749.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{405.54545454545456`, 0.}, {406.4545454545455, 1869.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{406.54545454545456`, 0.}, {407.4545454545455, 1509.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{407.54545454545456`, 0.}, {408.4545454545455, 1719.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{408.54545454545456`, 0.}, {409.4545454545455, 1789.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{409.54545454545456`, 0.}, {410.4545454545455, 1509.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{410.54545454545456`, 0.}, {411.4545454545455, 1437.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{411.54545454545456`, 0.}, {412.4545454545455, 2077.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{412.54545454545456`, 0.}, {413.4545454545455, 2073.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{413.54545454545456`, 0.}, {414.4545454545455, 2113.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{414.54545454545456`, 0.}, {415.4545454545455, 2147.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{415.54545454545456`, 0.}, {416.4545454545455, 2787.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{416.54545454545456`, 0.}, {417.4545454545455, 2395.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{417.54545454545456`, 0.}, {418.4545454545455, 2795.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{418.54545454545456`, 0.}, {419.4545454545455, 3095.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{419.54545454545456`, 0.}, {420.4545454545455, 3095.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{420.54545454545456`, 0.}, {421.4545454545455, 2905.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{421.54545454545456`, 0.}, {422.4545454545455, 2905.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{422.54545454545456`, 0.}, {423.4545454545455, 2445.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{423.54545454545456`, 0.}, {424.4545454545455, 3215.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{424.54545454545456`, 0.}, {425.4545454545455, 3049.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{425.54545454545456`, 0.}, {426.4545454545455, 3239.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{426.54545454545456`, 0.}, {427.4545454545455, 3239.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{427.54545454545456`, 0.}, {428.4545454545455, 3061.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{428.54545454545456`, 0.}, {429.4545454545455, 3261.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{429.54545454545456`, 0.}, {430.4545454545455, 3261.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{430.54545454545456`, 0.}, {431.4545454545455, 3417.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{431.54545454545456`, 0.}, {432.4545454545455, 3653.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{432.54545454545456`, 0.}, {433.4545454545455, 3993.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{433.54545454545456`, 0.}, {434.4545454545455, 3959.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{434.54545454545456`, 0.}, {435.4545454545455, 3769.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{435.54545454545456`, 0.}, {436.4545454545455, 3969.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{436.54545454545456`, 0.}, {437.4545454545455, 3899.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{437.54545454545456`, 0.}, {438.4545454545455, 4099.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{438.54545454545456`, 0.}, {439.4545454545455, 3831.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{439.54545454545456`, 0.}, {440.4545454545455, 4031.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{440.54545454545456`, 0.}, {441.4545454545455, 4431.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{441.54545454545456`, 0.}, {442.4545454545455, 4393.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{442.54545454545456`, 0.}, {443.4545454545455, 4391.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{443.54545454545456`, 0.}, {444.4545454545455, 4391.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{444.54545454545456`, 0.}, {445.4545454545455, 4591.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{445.54545454545456`, 0.}, {446.4545454545455, 4701.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{446.54545454545456`, 0.}, {447.4545454545455, 4487.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{447.54545454545456`, 0.}, {448.4545454545455, 4797.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{448.54545454545456`, 0.}, {449.4545454545455, 4595.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{449.54545454545456`, 0.}, {450.4545454545455, 4243.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{450.54545454545456`, 0.}, {451.4545454545455, 4077.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{451.54545454545456`, 0.}, {452.4545454545455, 4277.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{452.54545454545456`, 0.}, {453.4545454545455, 4491.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{453.54545454545456`, 0.}, {454.4545454545455, 4313.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{454.54545454545456`, 0.}, {455.4545454545455, 4513.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{455.54545454545456`, 0.}, {456.4545454545455, 4227.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{456.54545454545456`, 0.}, {457.4545454545455, 4219.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{457.54545454545456`, 0.}, {458.4545454545455, 4419.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{458.54545454545456`, 0.}, {459.4545454545455, 4419.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{459.54545454545456`, 0.}, {460.4545454545455, 4351.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{460.54545454545456`, 0.}, {461.4545454545455, 4351.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{461.54545454545456`, 0.}, {462.4545454545455, 4179.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{462.54545454545456`, 0.}, {463.4545454545455, 4179.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{463.54545454545456`, 0.}, {464.4545454545455, 4179.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{464.54545454545456`, 0.}, {465.4545454545455, 4019.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{465.54545454545456`, 0.}, {466.4545454545455, 4028.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{466.54545454545456`, 0.}, {467.4545454545455, 4028.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{467.54545454545456`, 0.}, {468.4545454545455, 4028.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{468.54545454545456`, 0.}, {469.4545454545455, 3868.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{469.54545454545456`, 0.}, {470.4545454545455, 3868.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{470.54545454545456`, 0.}, {471.4545454545455, 4068.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{471.54545454545456`, 0.}, {472.4545454545455, 4268.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{472.54545454545456`, 0.}, {473.4545454545455, 4224.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{473.54545454545456`, 0.}, {474.4545454545455, 4260.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{474.54545454545456`, 0.}, {475.4545454545455, 4088.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{475.54545454545456`, 0.}, {476.4545454545455, 4080.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{476.54545454545456`, 0.}, {477.4545454545455, 4080.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{477.54545454545456`, 0.}, {478.4545454545455, 3976.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{478.54545454545456`, 0.}, {479.4545454545455, 3606.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{479.54545454545456`, 0.}, {480.4545454545455, 4206.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{480.54545454545456`, 0.}, {481.4545454545455, 4206.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{481.54545454545456`, 0.}, {482.4545454545455, 3884.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{482.54545454545456`, 0.}, {483.4545454545455, 3804.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{483.54545454545456`, 0.}, {484.4545454545455, 3736.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{484.54545454545456`, 0.}, {485.4545454545455, 3736.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{485.54545454545456`, 0.}, {486.4545454545455, 3936.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{486.54545454545456`, 0.}, {487.4545454545455, 3936.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{487.54545454545456`, 0.}, {488.4545454545455, 3936.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{488.54545454545456`, 0.}, {489.4545454545455, 4136.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{489.54545454545456`, 0.}, {490.4545454545455, 4286.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{490.54545454545456`, 0.}, {491.4545454545455, 4286.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{491.54545454545456`, 0.}, {492.4545454545455, 4286.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{492.54545454545456`, 0.}, {493.4545454545455, 4286.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{493.54545454545456`, 0.}, {494.4545454545455, 4286.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{494.54545454545456`, 0.}, {495.4545454545455, 4306.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{495.54545454545456`, 0.}, {496.4545454545455, 4306.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{496.54545454545456`, 0.}, {497.4545454545455, 3504.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{497.54545454545456`, 0.}, {498.4545454545455, 3970.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{498.54545454545456`, 0.}, {499.4545454545455, 4210.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{499.54545454545456`, 0.}, {500.4545454545455, 4410.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{500.54545454545456`, 0.}, {501.4545454545455, 4410.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{501.54545454545456`, 0.}, {502.4545454545455, 4432.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{502.54545454545456`, 0.}, {503.4545454545455, 4234.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{503.54545454545456`, 0.}, {504.4545454545455, 4274.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{504.54545454545456`, 0.}, {505.4545454545455, 4072.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{505.54545454545456`, 0.}, {506.4545454545455, 4116.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{506.54545454545456`, 0.}, {507.4545454545455, 4196.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{507.54545454545456`, 0.}, {508.4545454545455, 4448.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{508.54545454545456`, 0.}, {509.4545454545455, 4420.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{509.54545454545456`, 0.}, {510.4545454545455, 4220.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{510.54545454545456`, 0.}, {511.4545454545455, 4014.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{511.54545454545456`, 0.}, {512.4545454545455, 3924.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{512.5454545454546, 0.}, {513.4545454545455, 4054.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{513.5454545454546, 0.}, {514.4545454545455, 4054.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{514.5454545454546, 0.}, {515.4545454545455, 4054.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{515.5454545454546, 0.}, {516.4545454545455, 4054.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{516.5454545454546, 0.}, {517.4545454545455, 4054.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{517.5454545454546, 0.}, {518.4545454545455, 3974.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{518.5454545454546, 0.}, {519.4545454545455, 3974.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{519.5454545454546, 0.}, {520.4545454545455, 3968.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{520.5454545454546, 0.}, {521.4545454545455, 4048.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{521.5454545454546, 0.}, {522.4545454545455, 4128.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{522.5454545454546, 0.}, {523.4545454545455, 4244.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{523.5454545454546, 0.}, {524.4545454545455, 4324.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{524.5454545454546, 0.}, {525.4545454545455, 4324.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{525.5454545454546, 0.}, {526.4545454545455, 4184.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{526.5454545454546, 0.}, {527.4545454545455, 4184.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{527.5454545454546, 0.}, {528.4545454545455, 4424.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{528.5454545454546, 0.}, {529.4545454545455, 4254.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{529.5454545454546, 0.}, {530.4545454545455, 4264.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{530.5454545454546, 0.}, {531.4545454545455, 4308.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{531.5454545454546, 0.}, {532.4545454545455, 4448.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{532.5454545454546, 0.}, {533.4545454545455, 4528.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{533.5454545454546, 0.}, {534.4545454545455, 4738.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{534.5454545454546, 0.}, {535.4545454545455, 5018.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{535.5454545454546, 0.}, {536.4545454545455, 5088.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{536.5454545454546, 0.}, {537.4545454545455, 5088.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{537.5454545454546, 0.}, {538.4545454545455, 4872.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{538.5454545454546, 0.}, {539.4545454545455, 4942.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{539.5454545454546, 0.}, {540.4545454545455, 5190.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{540.5454545454546, 0.}, {541.4545454545455, 5260.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{541.5454545454546, 0.}, {542.4545454545455, 5072.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{542.5454545454546, 0.}, {543.4545454545455, 5142.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{543.5454545454546, 0.}, {544.4545454545455, 5000.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{544.5454545454546, 0.}, {545.4545454545455, 5070.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{545.5454545454546, 0.}, {546.4545454545455, 5140.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{546.5454545454546, 0.}, {547.4545454545455, 5210.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{547.5454545454546, 0.}, {548.4545454545455, 5280.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{548.5454545454546, 0.}, {549.4545454545455, 5138.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{549.5454545454546, 0.}, {550.4545454545455, 5138.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{550.5454545454546, 0.}, {551.4545454545455, 5218.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{551.5454545454546, 0.}, {552.4545454545455, 5218.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{552.5454545454546, 0.}, {553.4545454545455, 5172.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{553.5454545454546, 0.}, {554.4545454545455, 5266.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{554.5454545454546, 0.}, {555.4545454545455, 5406.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{555.5454545454546, 0.}, {556.4545454545455, 5513.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{556.5454545454546, 0.}, {557.4545454545455, 5495.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{557.5454545454546, 0.}, {558.4545454545455, 5705.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{558.5454545454546, 0.}, {559.4545454545455, 5775.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{559.5454545454546, 0.}, {560.4545454545455, 5985.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{560.5454545454546, 0.}, {561.4545454545455, 6055.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{561.5454545454546, 0.}, {562.4545454545455, 6195.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{562.5454545454546, 0.}, {563.4545454545455, 6032.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{563.5454545454546, 0.}, {564.4545454545455, 6121.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{564.5454545454546, 0.}, {565.4545454545455, 6261.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{565.5454545454546, 0.}, {566.4545454545455, 6047.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{566.5454545454546, 0.}, {567.4545454545455, 6047.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{567.5454545454546, 0.}, {568.4545454545455, 5847.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{568.5454545454546, 0.}, {569.4545454545455, 5847.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{569.5454545454546, 0.}, {570.4545454545455, 5847.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{570.5454545454546, 0.}, {571.4545454545455, 5693.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{571.5454545454546, 0.}, {572.4545454545455, 5683.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{572.5454545454546, 0.}, {573.4545454545455, 5669.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{573.5454545454546, 0.}, {574.4545454545455, 5739.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{574.5454545454546, 0.}, {575.4545454545455, 6039.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{575.5454545454546, 0.}, {576.4545454545455, 5901.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{576.5454545454546, 0.}, {577.4545454545455, 5971.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{577.5454545454546, 0.}, {578.4545454545455, 5794.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{578.5454545454546, 0.}, {579.4545454545455, 6074.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{579.5454545454546, 0.}, {580.4545454545455, 6144.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{580.5454545454546, 0.}, {581.4545454545455, 6108.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{581.5454545454546, 0.}, {582.4545454545455, 5928.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{582.5454545454546, 0.}, {583.4545454545455, 5678.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{583.5454545454546, 0.}, {584.4545454545455, 5748.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{584.5454545454546, 0.}, {585.4545454545455, 5740.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{585.5454545454546, 0.}, {586.4545454545455, 5674.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{586.5454545454546, 0.}, {587.4545454545455, 5512.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{587.5454545454546, 0.}, {588.4545454545455, 5362.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{588.5454545454546, 0.}, {589.4545454545455, 5362.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{589.5454545454546, 0.}, {590.4545454545455, 5362.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{590.5454545454546, 0.}, {591.4545454545455, 5186.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{591.5454545454546, 0.}, {592.4545454545455, 4962.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{592.5454545454546, 0.}, {593.4545454545455, 5122.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{593.5454545454546, 0.}, {594.4545454545455, 4992.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{594.5454545454546, 0.}, {595.4545454545455, 5136.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{595.5454545454546, 0.}, {596.4545454545455, 4936.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{596.5454545454546, 0.}, {597.4545454545455, 5154.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{597.5454545454546, 0.}, {598.4545454545455, 5316.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{598.5454545454546, 0.}, {599.4545454545455, 5396.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{599.5454545454546, 0.}, {600.4545454545455, 5244.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{600.5454545454546, 0.}, {601.4545454545455, 5404.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{601.5454545454546, 0.}, {602.4545454545455, 5246.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{602.5454545454546, 0.}, {603.4545454545455, 5368.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{603.5454545454546, 0.}, {604.4545454545455, 5508.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{604.5454545454546, 0.}, {605.4545454545455, 5532.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{605.5454545454546, 0.}, {606.4545454545455, 5532.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{606.5454545454546, 0.}, {607.4545454545455, 5388.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{607.5454545454546, 0.}, {608.4545454545455, 5528.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{608.5454545454546, 0.}, {609.4545454545455, 5468.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{609.5454545454546, 0.}, {610.4545454545455, 5450.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{610.5454545454546, 0.}, {611.4545454545455, 5478.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{611.5454545454546, 0.}, {612.4545454545455, 5548.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{612.5454545454546, 0.}, {613.4545454545455, 5788.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{613.5454545454546, 0.}, {614.4545454545455, 5996.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{614.5454545454546, 0.}, {615.4545454545455, 5911.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{615.5454545454546, 0.}, {616.4545454545455, 6071.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{616.5454545454546, 0.}, {617.4545454545455, 6151.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{617.5454545454546, 0.}, {618.4545454545455, 6037.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{618.5454545454546, 0.}, {619.4545454545455, 6197.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{619.5454545454546, 0.}, {620.4545454545455, 6175.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{620.5454545454546, 0.}, {621.4545454545455, 6255.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{621.5454545454546, 0.}, {622.4545454545455, 6335.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{622.5454545454546, 0.}, {623.4545454545455, 6735.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{623.5454545454546, 0.}, {624.4545454545455, 6586.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{624.5454545454546, 0.}, {625.4545454545455, 6586.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{625.5454545454546, 0.}, {626.4545454545455, 6666.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{626.5454545454546, 0.}, {627.4545454545455, 6736.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{627.5454545454546, 0.}, {628.4545454545455, 6816.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{628.5454545454546, 0.}, {629.4545454545455, 6644.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{629.5454545454546, 0.}, {630.4545454545455, 6644.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{630.5454545454546, 0.}, {631.4545454545455, 6744.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{631.5454545454546, 0.}, {632.4545454545455, 6588.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{632.5454545454546, 0.}, {633.4545454545455, 6828.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{633.5454545454546, 0.}, {634.4545454545455, 6908.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{634.5454545454546, 0.}, {635.4545454545455, 6908.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{635.5454545454546, 0.}, {636.4545454545455, 7094.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{636.5454545454546, 0.}, {637.4545454545455, 7194.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{637.5454545454546, 0.}, {638.4545454545455, 7194.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{638.5454545454546, 0.}, {639.4545454545455, 7142.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{639.5454545454546, 0.}, {640.4545454545455, 7142.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{640.5454545454546, 0.}, {641.4545454545455, 6942.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{641.5454545454546, 0.}, {642.4545454545455, 7026.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{642.5454545454546, 0.}, {643.4545454545455, 7050.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{643.5454545454546, 0.}, {644.4545454545455, 7050.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{644.5454545454546, 0.}, {645.4545454545455, 6898.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{645.5454545454546, 0.}, {646.4545454545455, 6898.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{646.5454545454546, 0.}, {647.4545454545455, 6902.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{647.5454545454546, 0.}, {648.4545454545455, 6737.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{648.5454545454546, 0.}, {649.4545454545455, 6635.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{649.5454545454546, 0.}, {650.4545454545455, 6737.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{650.5454545454546, 0.}, {651.4545454545455, 6713.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{651.5454545454546, 0.}, {652.4545454545455, 6753.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{652.5454545454546, 0.}, {653.4545454545455, 7243.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{653.5454545454546, 0.}, {654.4545454545455, 7041.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{654.5454545454546, 0.}, {655.4545454545455, 7041.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{655.5454545454546, 0.}, {656.4545454545455, 7391.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{656.5454545454546, 0.}, {657.4545454545455, 7643.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{657.5454545454546, 0.}, {658.4545454545455, 7853.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{658.5454545454546, 0.}, {659.4545454545455, 7717.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{659.5454545454546, 0.}, {660.4545454545455, 7787.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{660.5454545454546, 0.}, {661.4545454545455, 7813.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{661.5454545454546, 0.}, {662.4545454545455, 7665.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{662.5454545454546, 0.}, {663.4545454545455, 7637.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{663.5454545454546, 0.}, {664.4545454545455, 7505.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{664.5454545454546, 0.}, {665.4545454545455, 6967.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{665.5454545454546, 0.}, {666.4545454545455, 6823.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{666.5454545454546, 0.}, {667.4545454545455, 6653.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{667.5454545454546, 0.}, {668.4545454545455, 6767.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{668.5454545454546, 0.}, {669.4545454545455, 6461.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{669.5454545454546, 0.}, {670.4545454545455, 6531.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{670.5454545454546, 0.}, {671.4545454545455, 6531.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{671.5454545454546, 0.}, {672.4545454545455, 6531.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{672.5454545454546, 0.}, {673.4545454545455, 6403.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{673.5454545454546, 0.}, {674.4545454545455, 6261.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{674.5454545454546, 0.}, {675.4545454545455, 6389.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{675.5454545454546, 0.}, {676.4545454545455, 6599.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{676.5454545454546, 0.}, {677.4545454545455, 6669.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{677.5454545454546, 0.}, {678.4545454545455, 6809.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{678.5454545454546, 0.}, {679.4545454545455, 6879.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{679.5454545454546, 0.}, {680.4545454545455, 6929.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{680.5454545454546, 0.}, {681.4545454545455, 6929.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{681.5454545454546, 0.}, {682.4545454545455, 6989.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{682.5454545454546, 0.}, {683.4545454545455, 6989.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{683.5454545454546, 0.}, {684.4545454545455, 6989.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{684.5454545454546, 0.}, {685.4545454545455, 7049.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{685.5454545454546, 0.}, {686.4545454545455, 7119.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{686.5454545454546, 0.}, {687.4545454545455, 7239.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{687.5454545454546, 0.}, {688.4545454545455, 7109.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{688.5454545454546, 0.}, {689.4545454545455, 7179.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{689.5454545454546, 0.}, {690.4545454545455, 7417.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{690.5454545454546, 0.}, {691.4545454545455, 7487.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{691.5454545454546, 0.}, {692.4545454545455, 7557.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{692.5454545454546, 0.}, {693.4545454545455, 7487.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{693.5454545454546, 0.}, {694.4545454545455, 7333.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{694.5454545454546, 0.}, {695.4545454545455, 7313.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{695.5454545454546, 0.}, {696.4545454545455, 7373.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{696.5454545454546, 0.}, {697.4545454545455, 7650.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{697.5454545454546, 0.}, {698.4545454545455, 7502.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{698.5454545454546, 0.}, {699.4545454545455, 7584.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{699.5454545454546, 0.}, {700.4545454545455, 7584.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{700.5454545454546, 0.}, {701.4545454545455, 7334.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{701.5454545454546, 0.}, {702.4545454545455, 7474.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{702.5454545454546, 0.}, {703.4545454545455, 7544.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{703.5454545454546, 0.}, {704.4545454545455, 7544.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{704.5454545454546, 0.}, {705.4545454545455, 7544.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{705.5454545454546, 0.}, {706.4545454545455, 7664.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{706.5454545454546, 0.}, {707.4545454545455, 7724.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{707.5454545454546, 0.}, {708.4545454545455, 7724.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{708.5454545454546, 0.}, {709.4545454545455, 7758.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{709.5454545454546, 0.}, {710.4545454545455, 7818.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{710.5454545454546, 0.}, {711.4545454545455, 7740.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{711.5454545454546, 0.}, {712.4545454545455, 7620.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{712.5454545454546, 0.}, {713.4545454545455, 7620.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{713.5454545454546, 0.}, {714.4545454545455, 7382.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{714.5454545454546, 0.}, {715.4545454545455, 7228.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{715.5454545454546, 0.}, {716.4545454545455, 7098.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{716.5454545454546, 0.}, {717.4545454545455, 7158.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{717.5454545454546, 0.}, {718.4545454545455, 7278.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{718.5454545454546, 0.}, {719.4545454545455, 7436.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{719.5454545454546, 0.}, {720.4545454545455, 7616.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{720.5454545454546, 0.}, {721.4545454545455, 7598.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{721.5454545454546, 0.}, {722.4545454545455, 7610.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{722.5454545454546, 0.}, {723.4545454545455, 7468.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{723.5454545454546, 0.}, {724.4545454545455, 7468.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{724.5454545454546, 0.}, {725.4545454545455, 7538.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{725.5454545454546, 0.}, {726.4545454545455, 7420.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{726.5454545454546, 0.}, {727.4545454545455, 7420.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{727.5454545454546, 0.}, {728.4545454545455, 7490.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{728.5454545454546, 0.}, {729.4545454545455, 7418.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{729.5454545454546, 0.}, {730.4545454545455, 7456.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{730.5454545454546, 0.}, {731.4545454545455, 7306.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{731.5454545454546, 0.}, {732.4545454545455, 7376.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{732.5454545454546, 0.}, {733.4545454545455, 7446.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{733.5454545454546, 0.}, {734.4545454545455, 7516.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{734.5454545454546, 0.}, {735.4545454545455, 7576.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{735.5454545454546, 0.}, {736.4545454545455, 7422.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{736.5454545454546, 0.}, {737.4545454545455, 7492.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{737.5454545454546, 0.}, {738.4545454545455, 7374.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{738.5454545454546, 0.}, {739.4545454545455, 7434.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{739.5454545454546, 0.}, {740.4545454545455, 7434.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{740.5454545454546, 0.}, {741.4545454545455, 7476.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{741.5454545454546, 0.}, {742.4545454545455, 7326.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{742.5454545454546, 0.}, {743.4545454545455, 7226.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{743.5454545454546, 0.}, {744.4545454545455, 6806.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{744.5454545454546, 0.}, {745.4545454545455, 6844.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{745.5454545454546, 0.}, {746.4545454545455, 7124.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{746.5454545454546, 0.}, {747.4545454545455, 6950.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{747.5454545454546, 0.}, {748.4545454545455, 6950.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{748.5454545454546, 0.}, {749.4545454545455, 7100.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{749.5454545454546, 0.}, {750.4545454545455, 6928.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{750.5454545454546, 0.}, {751.4545454545455, 6902.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{751.5454545454546, 0.}, {752.4545454545455, 6902.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{752.5454545454546, 0.}, {753.4545454545455, 6892.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{753.5454545454546, 0.}, {754.4545454545455, 6930.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{754.5454545454546, 0.}, {755.4545454545455, 6930.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{755.5454545454546, 0.}, {756.4545454545455, 7000.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{756.5454545454546, 0.}, {757.4545454545455, 7030.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{757.5454545454546, 0.}, {758.4545454545455, 7030.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{758.5454545454546, 0.}, {759.4545454545455, 7072.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{759.5454545454546, 0.}, {760.4545454545455, 7142.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{760.5454545454546, 0.}, {761.4545454545455, 7158.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{761.5454545454546, 0.}, {762.4545454545455, 7158.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{762.5454545454546, 0.}, {763.4545454545455, 7168.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{763.5454545454546, 0.}, {764.4545454545455, 7256.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{764.5454545454546, 0.}, {765.4545454545455, 7436.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{765.5454545454546, 0.}, {766.4545454545455, 7410.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{766.5454545454546, 0.}, {767.4545454545455, 7472.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{767.5454545454546, 0.}, {768.4545454545455, 7564.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{768.5454545454546, 0.}, {769.4545454545455, 7564.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{769.5454545454546, 0.}, {770.4545454545455, 7624.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{770.5454545454546, 0.}, {771.4545454545455, 7624.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{771.5454545454546, 0.}, {772.4545454545455, 7624.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{772.5454545454546, 0.}, {773.4545454545455, 7634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{773.5454545454546, 0.}, {774.4545454545455, 7634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{774.5454545454546, 0.}, {775.4545454545455, 7634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{775.5454545454546, 0.}, {776.4545454545455, 7634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{776.5454545454546, 0.}, {777.4545454545455, 7634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{777.5454545454546, 0.}, {778.4545454545455, 7634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{778.5454545454546, 0.}, {779.4545454545455, 7634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{779.5454545454546, 0.}, {780.4545454545455, 7634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{780.5454545454546, 0.}, {781.4545454545455, 7634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{781.5454545454546, 0.}, {782.4545454545455, 7680.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{782.5454545454546, 0.}, {783.4545454545455, 7680.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{783.5454545454546, 0.}, {784.4545454545455, 7688.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{784.5454545454546, 0.}, {785.4545454545455, 7700.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{785.5454545454546, 0.}, {786.4545454545455, 7730.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{786.5454545454546, 0.}, {787.4545454545455, 7832.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{787.5454545454546, 0.}, {788.4545454545455, 7902.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{788.5454545454546, 0.}, {789.4545454545455, 8022.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{789.5454545454546, 0.}, {790.4545454545455, 8092.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{790.5454545454546, 0.}, {791.4545454545455, 8228.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{791.5454545454546, 0.}, {792.4545454545455, 8228.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{792.5454545454546, 0.}, {793.4545454545455, 8292.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{793.5454545454546, 0.}, {794.4545454545455, 8292.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{794.5454545454546, 0.}, {795.4545454545455, 8292.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{795.5454545454546, 0.}, {796.4545454545455, 8106.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{796.5454545454546, 0.}, {797.4545454545455, 8106.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{797.5454545454546, 0.}, {798.4545454545455, 8166.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{798.5454545454546, 0.}, {799.4545454545455, 8006.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{799.5454545454546, 0.}, {800.4545454545455, 8026.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{800.5454545454546, 0.}, {801.4545454545455, 8086.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{801.5454545454546, 0.}, {802.4545454545455, 8026.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{802.5454545454546, 0.}, {803.4545454545455, 8026.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{803.5454545454546, 0.}, {804.4545454545455, 8080.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{804.5454545454546, 0.}, {805.4545454545455, 7654.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{805.5454545454546, 0.}, {806.4545454545455, 7702.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{806.5454545454546, 0.}, {807.4545454545455, 7438.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{807.5454545454546, 0.}, {808.4545454545455, 7508.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{808.5454545454546, 0.}, {809.4545454545455, 7586.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{809.5454545454546, 0.}, {810.4545454545455, 7594.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{810.5454545454546, 0.}, {811.4545454545455, 7598.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{811.5454545454546, 0.}, {812.4545454545455, 7702.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{812.5454545454546, 0.}, {813.4545454545455, 7528.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{813.5454545454546, 0.}, {814.4545454545455, 7708.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{814.5454545454546, 0.}, {815.4545454545455, 7768.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{815.5454545454546, 0.}, {816.4545454545455, 7638.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{816.5454545454546, 0.}, {817.4545454545455, 7608.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{817.5454545454546, 0.}, {818.4545454545455, 7398.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{818.5454545454546, 0.}, {819.4545454545455, 7286.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{819.5454545454546, 0.}, {820.4545454545455, 6934.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{820.5454545454546, 0.}, {821.4545454545455, 7004.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{821.5454545454546, 0.}, {822.4545454545455, 6932.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{822.5454545454546, 0.}, {823.4545454545455, 6970.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{823.5454545454546, 0.}, {824.4545454545455, 6909.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{824.5454545454546, 0.}, {825.4545454545455, 6909.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{825.5454545454546, 0.}, {826.4545454545455, 6779.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{826.5454545454546, 0.}, {827.4545454545455, 6601.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{827.5454545454546, 0.}, {828.4545454545455, 6601.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{828.5454545454546, 0.}, {829.4545454545455, 6731.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{829.5454545454546, 0.}, {830.4545454545455, 6791.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{830.5454545454546, 0.}, {831.4545454545455, 6895.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{831.5454545454546, 0.}, {832.4545454545455, 7015.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{832.5454545454546, 0.}, {833.4545454545455, 6971.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{833.5454545454546, 0.}, {834.4545454545455, 7031.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{834.5454545454546, 0.}, {835.4545454545455, 7031.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{835.5454545454546, 0.}, {836.4545454545455, 7221.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{836.5454545454546, 0.}, {837.4545454545455, 7251.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{837.5454545454546, 0.}, {838.4545454545455, 7118.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{838.5454545454546, 0.}, {839.4545454545455, 7315.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{839.5454545454546, 0.}, {840.4545454545455, 7177.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{840.5454545454546, 0.}, {841.4545454545455, 7177.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{841.5454545454546, 0.}, {842.4545454545455, 7015.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{842.5454545454546, 0.}, {843.4545454545455, 7015.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{843.5454545454546, 0.}, {844.4545454545455, 7015.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{844.5454545454546, 0.}, {845.4545454545455, 7015.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{845.5454545454546, 0.}, {846.4545454545455, 6723.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{846.5454545454546, 0.}, {847.4545454545455, 6755.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{847.5454545454546, 0.}, {848.4545454545455, 6829.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{848.5454545454546, 0.}, {849.4545454545455, 6529.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{849.5454545454546, 0.}, {850.4545454545455, 6529.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{850.5454545454546, 0.}, {851.4545454545455, 6657.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{851.5454545454546, 0.}, {852.4545454545455, 6449.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{852.5454545454546, 0.}, {853.4545454545455, 6609.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{853.5454545454546, 0.}, {854.4545454545455, 6440.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{854.5454545454546, 0.}, {855.4545454545455, 6283.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{855.5454545454546, 0.}, {856.4545454545455, 6353.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{856.5454545454546, 0.}, {857.4545454545455, 5975.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{857.5454545454546, 0.}, {858.4545454545455, 6183.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{858.5454545454546, 0.}, {859.4545454545455, 6323.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{859.5454545454546, 0.}, {860.4545454545455, 6323.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{860.5454545454546, 0.}, {861.4545454545455, 6133.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{861.5454545454546, 0.}, {862.4545454545455, 5955.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{862.5454545454546, 0.}, {863.4545454545455, 5789.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{863.5454545454546, 0.}, {864.4545454545455, 5849.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{864.5454545454546, 0.}, {865.4545454545455, 5783.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{865.5454545454546, 0.}, {866.4545454545455, 5853.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{866.5454545454546, 0.}, {867.4545454545455, 5853.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{867.5454545454546, 0.}, {868.4545454545455, 6059.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{868.5454545454546, 0.}, {869.4545454545455, 5809.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{869.5454545454546, 0.}, {870.4545454545455, 5809.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{870.5454545454546, 0.}, {871.4545454545455, 5939.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{871.5454545454546, 0.}, {872.4545454545455, 5869.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{872.5454545454546, 0.}, {873.4545454545455, 5869.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{873.5454545454546, 0.}, {874.4545454545455, 6079.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{874.5454545454546, 0.}, {875.4545454545455, 6319.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{875.5454545454546, 0.}, {876.4545454545455, 6343.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{876.5454545454546, 0.}, {877.4545454545455, 6403.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{877.5454545454546, 0.}, {878.4545454545455, 6473.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{878.5454545454546, 0.}, {879.4545454545455, 6199.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{879.5454545454546, 0.}, {880.4545454545455, 6259.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{880.5454545454546, 0.}, {881.4545454545455, 6389.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{881.5454545454546, 0.}, {882.4545454545455, 6739.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{882.5454545454546, 0.}, {883.4545454545455, 6589.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{883.5454545454546, 0.}, {884.4545454545455, 6427.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{884.5454545454546, 0.}, {885.4545454545455, 6481.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{885.5454545454546, 0.}, {886.4545454545455, 6315.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{886.5454545454546, 0.}, {887.4545454545455, 6177.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{887.5454545454546, 0.}, {888.4545454545455, 6307.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{888.5454545454546, 0.}, {889.4545454545455, 6151.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{889.5454545454546, 0.}, {890.4545454545455, 6661.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{890.5454545454546, 0.}, {891.4545454545455, 6665.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{891.5454545454546, 0.}, {892.4545454545455, 6641.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{892.5454545454546, 0.}, {893.4545454545455, 6563.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{893.5454545454546, 0.}, {894.4545454545455, 6517.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{894.5454545454546, 0.}, {895.4545454545455, 6445.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{895.5454545454546, 0.}, {896.4545454545455, 6199.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{896.5454545454546, 0.}, {897.4545454545455, 6289.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{897.5454545454546, 0.}, {898.4545454545455, 6332.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{898.5454545454546, 0.}, {899.4545454545455, 6556.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{899.5454545454546, 0.}, {900.4545454545455, 6390.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{900.5454545454546, 0.}, {901.4545454545455, 6384.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{901.5454545454546, 0.}, {902.4545454545455, 6658.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{902.5454545454546, 0.}, {903.4545454545455, 6640.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{903.5454545454546, 0.}, {904.4545454545455, 6399.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{904.5454545454546, 0.}, {905.4545454545455, 6749.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{905.5454545454546, 0.}, {906.4545454545455, 6566.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{906.5454545454546, 0.}, {907.4545454545455, 6430.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{907.5454545454546, 0.}, {908.4545454545455, 6600.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{908.5454545454546, 0.}, {909.4545454545455, 7020.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{909.5454545454546, 0.}, {910.4545454545455, 7300.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{910.5454545454546, 0.}, {911.4545454545455, 7580.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{911.5454545454546, 0.}, {912.4545454545455, 7210.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{912.5454545454546, 0.}, {913.4545454545455, 6910.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{913.5454545454546, 0.}, {914.4545454545455, 6598.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{914.5454545454546, 0.}, {915.4545454545455, 6416.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{915.5454545454546, 0.}, {916.4545454545455, 6446.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{916.5454545454546, 0.}, {917.4545454545455, 6516.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{917.5454545454546, 0.}, {918.4545454545455, 6516.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{918.5454545454546, 0.}, {919.4545454545455, 6586.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{919.5454545454546, 0.}, {920.4545454545455, 6656.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{920.5454545454546, 0.}, {921.4545454545455, 6640.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{921.5454545454546, 0.}, {922.4545454545455, 6840.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{922.5454545454546, 0.}, {923.4545454545455, 6746.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{923.5454545454546, 0.}, {924.4545454545455, 6746.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{924.5454545454546, 0.}, {925.4545454545455, 6746.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{925.5454545454546, 0.}, {926.4545454545455, 6746.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{926.5454545454546, 0.}, {927.4545454545455, 6592.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{927.5454545454546, 0.}, {928.4545454545455, 6352.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{928.5454545454546, 0.}, {929.4545454545455, 6141.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{929.5454545454546, 0.}, {930.4545454545455, 6211.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{930.5454545454546, 0.}, {931.4545454545455, 6295.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{931.5454545454546, 0.}, {932.4545454545455, 6425.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{932.5454545454546, 0.}, {933.4545454545455, 6417.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{933.5454545454546, 0.}, {934.4545454545455, 6553.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{934.5454545454546, 0.}, {935.4545454545455, 6553.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{935.5454545454546, 0.}, {936.4545454545455, 6301.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{936.5454545454546, 0.}, {937.4545454545455, 6301.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{937.5454545454546, 0.}, {938.4545454545455, 6433.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{938.5454545454546, 0.}, {939.4545454545455, 6563.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{939.5454545454546, 0.}, {940.4545454545455, 6413.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{940.5454545454546, 0.}, {941.4545454545455, 6447.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{941.5454545454546, 0.}, {942.4545454545455, 6567.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{942.5454545454546, 0.}, {943.4545454545455, 6435.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{943.5454545454546, 0.}, {944.4545454545455, 6469.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{944.5454545454546, 0.}, {945.4545454545455, 6505.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{945.5454545454546, 0.}, {946.4545454545455, 6745.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{946.5454545454546, 0.}, {947.4545454545455, 6865.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{947.5454545454546, 0.}, {948.4545454545455, 6693.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{948.5454545454546, 0.}, {949.4545454545455, 6753.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{949.5454545454546, 0.}, {950.4545454545455, 6813.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{950.5454545454546, 0.}, {951.4545454545455, 6621.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{951.5454545454546, 0.}, {952.4545454545455, 6508.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{952.5454545454546, 0.}, {953.4545454545455, 6610.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{953.5454545454546, 0.}, {954.4545454545455, 6634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{954.5454545454546, 0.}, {955.4545454545455, 6648.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{955.5454545454546, 0.}, {956.4545454545455, 6600.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{956.5454545454546, 0.}, {957.4545454545455, 6730.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{957.5454545454546, 0.}, {958.4545454545455, 6860.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{958.5454545454546, 0.}, {959.4545454545455, 7018.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{959.5454545454546, 0.}, {960.4545454545455, 7096.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{960.5454545454546, 0.}, {961.4545454545455, 6972.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{961.5454545454546, 0.}, {962.4545454545455, 6972.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{962.5454545454546, 0.}, {963.4545454545455, 7050.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{963.5454545454546, 0.}, {964.4545454545455, 7120.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{964.5454545454546, 0.}, {965.4545454545455, 7120.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{965.5454545454546, 0.}, {966.4545454545455, 7120.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{966.5454545454546, 0.}, {967.4545454545455, 6870.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{967.5454545454546, 0.}, {968.4545454545455, 6734.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{968.5454545454546, 0.}, {969.4545454545455, 6734.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{969.5454545454546, 0.}, {970.4545454545455, 6834.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{970.5454545454546, 0.}, {971.4545454545455, 6878.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{971.5454545454546, 0.}, {972.4545454545455, 6998.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{972.5454545454546, 0.}, {973.4545454545455, 6998.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{973.5454545454546, 0.}, {974.4545454545455, 7058.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{974.5454545454546, 0.}, {975.4545454545455, 7238.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{975.5454545454546, 0.}, {976.4545454545455, 7184.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{976.5454545454546, 0.}, {977.4545454545455, 7016.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{977.5454545454546, 0.}, {978.4545454545455, 7096.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{978.5454545454546, 0.}, {979.4545454545455, 7050.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{979.5454545454546, 0.}, {980.4545454545455, 6912.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{980.5454545454546, 0.}, {981.4545454545455, 6866.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{981.5454545454546, 0.}, {982.4545454545455, 7003.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{982.5454545454546, 0.}, {983.4545454545455, 6795.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{983.5454545454546, 0.}, {984.4545454545455, 6855.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{984.5454545454546, 0.}, {985.4545454545455, 6855.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{985.5454545454546, 0.}, {986.4545454545455, 7005.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{986.5454545454546, 0.}, {987.4545454545455, 6975.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{987.5454545454546, 0.}, {988.4545454545455, 7155.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{988.5454545454546, 0.}, {989.4545454545455, 7155.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{989.5454545454546, 0.}, {990.4545454545455, 7155.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{990.5454545454546, 0.}, {991.4545454545455, 6947.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{991.5454545454546, 0.}, {992.4545454545455, 6947.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{992.5454545454546, 0.}, {993.4545454545455, 7017.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{993.5454545454546, 0.}, {994.4545454545455, 7087.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{994.5454545454546, 0.}, {995.4545454545455, 7147.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{995.5454545454546, 0.}, {996.4545454545455, 7129.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{996.5454545454546, 0.}, {997.4545454545455, 7177.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{997.5454545454546, 0.}, {998.4545454545455, 7255.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{998.5454545454546, 0.}, {999.4545454545455, 7315.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{999.5454545454546, 0.}, {1000.4545454545455`, 7315.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1000.5454545454546`, 0.}, {1001.4545454545455`, 7189.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1001.5454545454546`, 0.}, {1002.4545454545455`, 7189.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1002.5454545454546`, 0.}, {1003.4545454545455`, 6849.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1003.5454545454546`, 0.}, {1004.4545454545455`, 6779.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1004.5454545454546`, 0.}, {1005.4545454545455`, 6779.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1005.5454545454546`, 0.}, {1006.4545454545455`, 6755.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1006.5454545454546`, 0.}, {1007.4545454545455`, 6935.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1007.5454545454546`, 0.}, {1008.4545454545455`, 6953.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1008.5454545454546`, 0.}, {1009.4545454545455`, 7023.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1009.5454545454546`, 0.}, {1010.4545454545455`, 7223.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1010.5454545454546`, 0.}, {1011.4545454545455`, 7245.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1011.5454545454546`, 0.}, {1012.4545454545455`, 7315.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1012.5454545454546`, 0.}, {1013.4545454545455`, 7343.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1013.5454545454546`, 0.}, {1014.4545454545455`, 7403.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1014.5454545454546`, 0.}, {1015.4545454545455`, 7441.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1015.5454545454546`, 0.}, {1016.4545454545455`, 7441.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1016.5454545454546`, 0.}, {1017.4545454545455`, 7429.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1017.5454545454546`, 0.}, {1018.4545454545455`, 7435.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1018.5454545454546`, 0.}, {1019.4545454545455`, 7459.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1019.5454545454546`, 0.}, {1020.4545454545455`, 7459.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1020.5454545454546`, 0.}, {1021.4545454545455`, 7291.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1021.5454545454546`, 0.}, {1022.4545454545455`, 6955.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1022.5454545454546`, 0.}, {1023.4545454545455`, 7009.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1023.5454545454546`, 0.}, {1024.4545454545455`, 6841.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1024.5454545454545`, 0.}, {1025.4545454545455`, 6901.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1025.5454545454545`, 0.}, {1026.4545454545455`, 6785.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1026.5454545454545`, 0.}, {1027.4545454545455`, 6747.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1027.5454545454545`, 0.}, {1028.4545454545455`, 6867.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1028.5454545454545`, 0.}, {1029.4545454545455`, 6867.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1029.5454545454545`, 0.}, {1030.4545454545455`, 6704.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1030.5454545454545`, 0.}, {1031.4545454545455`, 6746.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1031.5454545454545`, 0.}, {1032.4545454545455`, 6706.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1032.5454545454545`, 0.}, {1033.4545454545455`, 6894.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1033.5454545454545`, 0.}, {1034.4545454545455`, 6976.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1034.5454545454545`, 0.}, {1035.4545454545455`, 6934.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1035.5454545454545`, 0.}, {1036.4545454545455`, 6934.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1036.5454545454545`, 0.}, {1037.4545454545455`, 6934.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1037.5454545454545`, 0.}, {1038.4545454545455`, 6934.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1038.5454545454545`, 0.}, {1039.4545454545455`, 6934.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1039.5454545454545`, 0.}, {1040.4545454545455`, 6934.},
       RoundingRadius->
        0]}}, {}, {}}, {}, {{{{{}, {}, {}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}}, {}}, {}}, {}}, 
   GraphicsGroupBox[
    {GrayLevel[0], 
     StyleBox[
      LineBox[{{{0.5454545454545454, 0.}, 
         Offset[{0, -4}, {0.5454545454545454, 0.}]}, {{1040.4545454545455`, 
         0.}, Offset[{0, -4}, {1040.4545454545455`, 0.}]}}],
      Antialiasing->False]}]},
  AspectRatio->NCache[
    Rational[1, 2], 0.5],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"Tag\"", TraditionalForm], 
    FormBox["\"kum. G/V\"", TraditionalForm]},
  AxesOrigin->{0.4545454545454546, 0},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  ImageSize->600,
  PlotRangePadding->Scaled[0.02],
  Ticks->{None, Automatic}]], "Output",
 CellChangeTimes->{{3.6166587098453565`*^9, 3.616658738767807*^9}, 
   3.6166588249891586`*^9, 3.6166708572566924`*^9, 3.6166721347193365`*^9, 
   3.6166722734503803`*^9, 3.616675744085677*^9, 3.616675971215477*^9, 
   3.6166760302319803`*^9, 3.616676385986006*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Bei der Darstellung gehe ich von 0 Startkapital aus. ", "Text",
 CellChangeTimes->{{3.6166637531470146`*^9, 3.616663772366248*^9}, 
   3.616675744085677*^9, 3.6166760302319803`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", "cumulatedGV", "]"}]], "Input",
 CellChangeTimes->{{3.6166637149737473`*^9, 3.6166637252697654`*^9}, 
   3.6166638156875243`*^9, 3.616675744085677*^9, 3.6166760302319803`*^9}],

Cell[BoxData["8292"], "Output",
 CellChangeTimes->{3.6166637257533665`*^9, 3.616663837184362*^9, 
  3.616670857334693*^9, 3.616672134890937*^9, 3.616672273637581*^9, 
  3.6166757441012774`*^9, 3.616675971340277*^9, 3.6166760302319803`*^9, 
  3.6166763861888056`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Min", "[", "cumulatedGV", "]"}]], "Input",
 CellChangeTimes->{{3.6166637314629765`*^9, 3.6166637398245907`*^9}, {
   3.616663797841093*^9, 3.6166638084803114`*^9}, 3.6166757441012774`*^9, 
   3.6166760302319803`*^9}],

Cell[BoxData[
 RowBox[{"-", "905"}]], "Output",
 CellChangeTimes->{3.616663740464192*^9, 3.616663839477566*^9, 
  3.6166708573814926`*^9, 3.616672134953337*^9, 3.616672273715581*^9, 
  3.6166757441012774`*^9, 3.616675971371477*^9, 3.6166760302319803`*^9, 
  3.6166763862668056`*^9}]
}, Open  ]],

Cell["Endwert:", "Text",
 CellChangeTimes->{{3.616667847615006*^9, 3.6166678498770103`*^9}, 
   3.6166757441012774`*^9, 3.6166760302319803`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"cumulatedGV", "[", 
  RowBox[{"[", 
   RowBox[{"-", "1"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.6166678394717917`*^9, 3.6166678423421965`*^9}, 
   3.6166757441012774`*^9, 3.6166760302319803`*^9}],

Cell[BoxData["6934"], "Output",
 CellChangeTimes->{3.6166678427009974`*^9, 3.616670857412693*^9, 
  3.6166721350313373`*^9, 3.616672273793581*^9, 3.6166757441012774`*^9, 
  3.616675971433877*^9, 3.6166760302319803`*^9, 3.616676386360406*^9}]
}, Open  ]],

Cell["\<\


Wenn ich jetzt Georgs Startwert von 2000 Euro ansetze: \
\>", "Text",
 CellChangeTimes->{{3.61666108039432*^9, 3.616661080815521*^9}, {
   3.616663775579854*^9, 3.616663791382682*^9}, 3.616663844781575*^9, 
   3.6166757441012774`*^9, 3.6166760302319803`*^9}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"startAccount", "=", " ", "2000"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Min", "[", 
  RowBox[{"cumulatedGV", "+", "startAccount"}], "]"}]}], "Input",
 CellChangeTimes->{{3.6166638500543847`*^9, 3.6166638711300216`*^9}, 
   3.6166757441012774`*^9, 3.6166760302319803`*^9}],

Cell[BoxData["1095"], "Output",
 CellChangeTimes->{3.6166638715980225`*^9, 3.616670857475093*^9, 
  3.6166721350937376`*^9, 3.616672273871581*^9, 3.6166757441012774`*^9, 
  3.616675971480677*^9, 3.6166760302319803`*^9, 3.6166763864384065`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Max", "[", 
  RowBox[{"cumulatedGV", "+", "startAccount"}], "]"}]], "Input",
 CellChangeTimes->{{3.616663879476036*^9, 3.6166638818628407`*^9}, 
   3.6166757441012774`*^9, 3.6166760302319803`*^9}],

Cell[BoxData["10292"], "Output",
 CellChangeTimes->{3.616663882315241*^9, 3.616670857521893*^9, 
  3.6166721351561375`*^9, 3.616672273949581*^9, 3.6166757441012774`*^9, 
  3.6166759715274773`*^9, 3.6166760302319803`*^9, 3.616676386516406*^9}]
}, Open  ]],

Cell["Endwert:", "Text",
 CellChangeTimes->{{3.6166678586286254`*^9, 3.6166678600794277`*^9}, 
   3.6166757441168776`*^9, 3.6166760302319803`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"cumulatedGV", "[", 
   RowBox[{"[", 
    RowBox[{"-", "1"}], "]"}], "]"}], "+", "startAccount"}]], "Input",
 CellChangeTimes->{{3.6166678649778366`*^9, 3.6166678717326484`*^9}, 
   3.6166757441168776`*^9, 3.6166760302319803`*^9}],

Cell[BoxData["8934"], "Output",
 CellChangeTimes->{3.616667872185049*^9, 3.616670857568693*^9, 
  3.6166721352185373`*^9, 3.616672274027581*^9, 3.6166757441168776`*^9, 
  3.616675971574278*^9, 3.6166760302319803`*^9, 3.6166763866100063`*^9}]
}, Open  ]],

Cell["\<\

Und noch der Plot dazu:\
\>", "Text",
 CellChangeTimes->{{3.616667890811482*^9, 3.6166679058967085`*^9}, 
   3.6166757441168776`*^9, 3.6166760302319803`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"BarChart", "[", 
  RowBox[{
   RowBox[{"cumulatedGV", "+", "startAccount"}], ",", 
   RowBox[{"ChartStyle", "\[Rule]", " ", "Green"}], ",", " ", 
   RowBox[{"ImageSize", "\[Rule]", " ", "600"}], ",", " ", 
   RowBox[{"AspectRatio", " ", "\[Rule]", " ", 
    RowBox[{"1", "/", "2"}]}], ",", 
   RowBox[{"PerformanceGoal", "\[Rule]", "\"\<Speed\>\""}], ",", " ", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Tag\>\"", ",", " ", "\"\<kum. G/V\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.616663893516061*^9, 3.616663907103685*^9}, 
   3.6166757441168776`*^9, 3.616675852714469*^9, 3.6166760302319803`*^9}],

Cell[BoxData[
 GraphicsBox[{
   {Opacity[0], PointBox[{{0.4545454545454546, 0.}}]}, 
   {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
    EdgeForm[Opacity[0.7]], {}, 
    {RGBColor[0.798413061722744, 0.824719615472648, 0.968322270542458], 
     EdgeForm[Opacity[0.7]], 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{0.5454545454545454, 0.}, {1.4545454545454546`, 2000.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1.5454545454545454`, 0.}, {2.4545454545454546`, 2000.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{2.5454545454545454`, 0.}, {3.4545454545454546`, 2000.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{3.5454545454545454`, 0.}, {4.454545454545454, 2070.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{4.545454545454545, 0.}, {5.454545454545454, 2280.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{5.545454545454545, 0.}, {6.454545454545454, 2280.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{6.545454545454545, 0.}, {7.454545454545454, 2260.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{7.545454545454545, 0.}, {8.454545454545453, 2244.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{8.545454545454545, 0.}, {9.454545454545453, 2314.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{9.545454545454545, 0.}, {10.454545454545453`, 2116.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{10.545454545454545`, 0.}, {11.454545454545453`, 2116.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{11.545454545454545`, 0.}, {12.454545454545453`, 2116.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{12.545454545454545`, 0.}, {13.454545454545453`, 2050.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{13.545454545454545`, 0.}, {14.454545454545453`, 1942.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{14.545454545454545`, 0.}, {15.454545454545453`, 1880.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{15.545454545454545`, 0.}, {16.454545454545453`, 2126.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{16.545454545454543`, 0.}, {17.454545454545453`, 2206.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{17.545454545454543`, 0.}, {18.454545454545453`, 2258.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{18.545454545454543`, 0.}, {19.454545454545453`, 2100.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{19.545454545454543`, 0.}, {20.454545454545453`, 2180.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{20.545454545454543`, 0.}, {21.454545454545453`, 2017.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{21.545454545454543`, 0.}, {22.454545454545453`, 1947.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{22.545454545454543`, 0.}, {23.454545454545453`, 1947.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{23.545454545454543`, 0.}, {24.454545454545453`, 1805.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{24.545454545454543`, 0.}, {25.454545454545453`, 2035.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{25.545454545454543`, 0.}, {26.454545454545453`, 2035.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{26.545454545454543`, 0.}, {27.454545454545453`, 1927.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{27.545454545454543`, 0.}, {28.454545454545453`, 2007.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{28.545454545454543`, 0.}, {29.454545454545453`, 2487.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{29.545454545454543`, 0.}, {30.454545454545453`, 2647.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{30.545454545454543`, 0.}, {31.454545454545453`, 2647.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{31.545454545454543`, 0.}, {32.45454545454545, 2707.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{32.54545454545455, 0.}, {33.45454545454545, 2699.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{33.54545454545455, 0.}, {34.45454545454545, 2689.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{34.54545454545455, 0.}, {35.45454545454545, 2689.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{35.54545454545455, 0.}, {36.45454545454545, 2689.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{36.54545454545455, 0.}, {37.45454545454545, 2457.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{37.54545454545455, 0.}, {38.45454545454545, 2597.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{38.54545454545455, 0.}, {39.45454545454545, 2859.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{39.54545454545455, 0.}, {40.45454545454545, 2929.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{40.54545454545455, 0.}, {41.45454545454545, 2929.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{41.54545454545455, 0.}, {42.45454545454545, 2929.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{42.54545454545455, 0.}, {43.45454545454545, 2939.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{43.54545454545455, 0.}, {44.45454545454545, 2939.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{44.54545454545455, 0.}, {45.45454545454545, 2869.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{45.54545454545455, 0.}, {46.45454545454545, 2869.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{46.54545454545455, 0.}, {47.45454545454545, 2929.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{47.54545454545455, 0.}, {48.45454545454545, 2943.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{48.54545454545455, 0.}, {49.45454545454545, 2943.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{49.54545454545455, 0.}, {50.45454545454545, 2943.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{50.54545454545455, 0.}, {51.45454545454545, 3003.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{51.54545454545455, 0.}, {52.45454545454545, 3003.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{52.54545454545455, 0.}, {53.45454545454545, 3003.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{53.54545454545455, 0.}, {54.45454545454545, 3003.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{54.54545454545455, 0.}, {55.45454545454545, 3123.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{55.54545454545455, 0.}, {56.45454545454545, 3183.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{56.54545454545455, 0.}, {57.45454545454545, 3169.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{57.54545454545455, 0.}, {58.45454545454545, 3349.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{58.54545454545455, 0.}, {59.45454545454545, 3205.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{59.54545454545455, 0.}, {60.45454545454545, 3205.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{60.54545454545455, 0.}, {61.45454545454545, 3275.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{61.54545454545455, 0.}, {62.45454545454545, 3415.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{62.54545454545455, 0.}, {63.45454545454545, 3475.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{63.54545454545455, 0.}, {64.45454545454545, 3481.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{64.54545454545455, 0.}, {65.45454545454545, 3481.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{65.54545454545455, 0.}, {66.45454545454545, 3481.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{66.54545454545455, 0.}, {67.45454545454545, 3481.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{67.54545454545455, 0.}, {68.45454545454545, 3523.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{68.54545454545455, 0.}, {69.45454545454545, 3643.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{69.54545454545455, 0.}, {70.45454545454545, 3633.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{70.54545454545455, 0.}, {71.45454545454545, 3693.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{71.54545454545455, 0.}, {72.45454545454545, 3753.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{72.54545454545455, 0.}, {73.45454545454545, 3823.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{73.54545454545455, 0.}, {74.45454545454545, 3883.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{74.54545454545455, 0.}, {75.45454545454545, 3703.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{75.54545454545455, 0.}, {76.45454545454545, 3703.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{76.54545454545455, 0.}, {77.45454545454545, 3573.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{77.54545454545455, 0.}, {78.45454545454545, 3645.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{78.54545454545455, 0.}, {79.45454545454545, 3435.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{79.54545454545455, 0.}, {80.45454545454545, 3580.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{80.54545454545455, 0.}, {81.45454545454545, 3580.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{81.54545454545455, 0.}, {82.45454545454545, 2950.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{82.54545454545455, 0.}, {83.45454545454545, 2796.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{83.54545454545455, 0.}, {84.45454545454545, 2746.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{84.54545454545455, 0.}, {85.45454545454545, 2866.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{85.54545454545455, 0.}, {86.45454545454545, 2676.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{86.54545454545455, 0.}, {87.45454545454545, 2546.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{87.54545454545455, 0.}, {88.45454545454545, 2746.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{88.54545454545455, 0.}, {89.45454545454545, 1277.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{89.54545454545455, 0.}, {90.45454545454545, 1255.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{90.54545454545455, 0.}, {91.45454545454545, 1095.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{91.54545454545455, 0.}, {92.45454545454545, 1245.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{92.54545454545455, 0.}, {93.45454545454545, 1259.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{93.54545454545455, 0.}, {94.45454545454545, 1419.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{94.54545454545455, 0.}, {95.45454545454545, 1235.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{95.54545454545455, 0.}, {96.45454545454545, 1475.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{96.54545454545455, 0.}, {97.45454545454545, 1715.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{97.54545454545455, 0.}, {98.45454545454545, 1557.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{98.54545454545455, 0.}, {99.45454545454545, 1265.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{99.54545454545455, 0.}, {100.45454545454545`, 1465.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{100.54545454545455`, 0.}, {101.45454545454545`, 1465.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{101.54545454545455`, 0.}, {102.45454545454545`, 1465.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{102.54545454545455`, 0.}, {103.45454545454545`, 1465.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{103.54545454545455`, 0.}, {104.45454545454545`, 1265.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{104.54545454545455`, 0.}, {105.45454545454545`, 1345.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{105.54545454545455`, 0.}, {106.45454545454545`, 1345.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{106.54545454545455`, 0.}, {107.45454545454545`, 1665.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{107.54545454545455`, 0.}, {108.45454545454545`, 1545.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{108.54545454545455`, 0.}, {109.45454545454545`, 1545.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{109.54545454545455`, 0.}, {110.45454545454545`, 1365.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{110.54545454545455`, 0.}, {111.45454545454545`, 1525.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{111.54545454545455`, 0.}, {112.45454545454545`, 1725.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{112.54545454545455`, 0.}, {113.45454545454545`, 2065.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{113.54545454545455`, 0.}, {114.45454545454545`, 1709.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{114.54545454545455`, 0.}, {115.45454545454545`, 2029.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{115.54545454545455`, 0.}, {116.45454545454545`, 2029.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{116.54545454545455`, 0.}, {117.45454545454545`, 1845.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{117.54545454545455`, 0.}, {118.45454545454545`, 1915.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{118.54545454545455`, 0.}, {119.45454545454545`, 1985.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{119.54545454545455`, 0.}, {120.45454545454545`, 2055.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{120.54545454545455`, 0.}, {121.45454545454545`, 2125.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{121.54545454545455`, 0.}, {122.45454545454545`, 2187.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{122.54545454545455`, 0.}, {123.45454545454545`, 2327.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{123.54545454545455`, 0.}, {124.45454545454545`, 2325.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{124.54545454545455`, 0.}, {125.45454545454545`, 2745.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{125.54545454545455`, 0.}, {126.45454545454545`, 2735.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{126.54545454545455`, 0.}, {127.45454545454545`, 2553.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{127.54545454545455`, 0.}, {128.45454545454547`, 2617.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{128.54545454545456`, 0.}, {129.45454545454547`, 2777.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{129.54545454545456`, 0.}, {130.45454545454547`, 3041.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{130.54545454545456`, 0.}, {131.45454545454547`, 3041.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{131.54545454545456`, 0.}, {132.45454545454547`, 2823.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{132.54545454545456`, 0.}, {133.45454545454547`, 2733.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{133.54545454545456`, 0.}, {134.45454545454547`, 2733.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{134.54545454545456`, 0.}, {135.45454545454547`, 2733.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{135.54545454545456`, 0.}, {136.45454545454547`, 2733.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{136.54545454545456`, 0.}, {137.45454545454547`, 2531.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{137.54545454545456`, 0.}, {138.45454545454547`, 2601.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{138.54545454545456`, 0.}, {139.45454545454547`, 2741.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{139.54545454545456`, 0.}, {140.45454545454547`, 2455.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{140.54545454545456`, 0.}, {141.45454545454547`, 2595.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{141.54545454545456`, 0.}, {142.45454545454547`, 2381.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{142.54545454545456`, 0.}, {143.45454545454547`, 2577.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{143.54545454545456`, 0.}, {144.45454545454547`, 2315.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{144.54545454545456`, 0.}, {145.45454545454547`, 2353.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{145.54545454545456`, 0.}, {146.45454545454547`, 2423.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{146.54545454545456`, 0.}, {147.45454545454547`, 2493.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{147.54545454545456`, 0.}, {148.45454545454547`, 2493.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{148.54545454545456`, 0.}, {149.45454545454547`, 2671.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{149.54545454545456`, 0.}, {150.45454545454547`, 2811.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{150.54545454545456`, 0.}, {151.45454545454547`, 2615.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{151.54545454545456`, 0.}, {152.45454545454547`, 2615.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{152.54545454545456`, 0.}, {153.45454545454547`, 2739.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{153.54545454545456`, 0.}, {154.45454545454547`, 2809.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{154.54545454545456`, 0.}, {155.45454545454547`, 2805.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{155.54545454545456`, 0.}, {156.45454545454547`, 2805.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{156.54545454545456`, 0.}, {157.45454545454547`, 2989.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{157.54545454545456`, 0.}, {158.45454545454547`, 2847.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{158.54545454545456`, 0.}, {159.45454545454547`, 2847.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{159.54545454545456`, 0.}, {160.45454545454547`, 2927.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{160.54545454545456`, 0.}, {161.45454545454547`, 3087.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{161.54545454545456`, 0.}, {162.45454545454547`, 3055.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{162.54545454545456`, 0.}, {163.45454545454547`, 3055.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{163.54545454545456`, 0.}, {164.45454545454547`, 2857.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{164.54545454545456`, 0.}, {165.45454545454547`, 2957.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{165.54545454545456`, 0.}, {166.45454545454547`, 2957.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{166.54545454545456`, 0.}, {167.45454545454547`, 2731.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{167.54545454545456`, 0.}, {168.45454545454547`, 2811.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{168.54545454545456`, 0.}, {169.45454545454547`, 2811.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{169.54545454545456`, 0.}, {170.45454545454547`, 2751.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{170.54545454545456`, 0.}, {171.45454545454547`, 2609.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{171.54545454545456`, 0.}, {172.45454545454547`, 2749.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{172.54545454545456`, 0.}, {173.45454545454547`, 2487.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{173.54545454545456`, 0.}, {174.45454545454547`, 2487.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{174.54545454545456`, 0.}, {175.45454545454547`, 2605.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{175.54545454545456`, 0.}, {176.45454545454547`, 2605.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{176.54545454545456`, 0.}, {177.45454545454547`, 2729.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{177.54545454545456`, 0.}, {178.45454545454547`, 2933.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{178.54545454545456`, 0.}, {179.45454545454547`, 2797.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{179.54545454545456`, 0.}, {180.45454545454547`, 2797.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{180.54545454545456`, 0.}, {181.45454545454547`, 2797.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{181.54545454545456`, 0.}, {182.45454545454547`, 2797.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{182.54545454545456`, 0.}, {183.45454545454547`, 2857.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{183.54545454545456`, 0.}, {184.45454545454547`, 2857.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{184.54545454545456`, 0.}, {185.45454545454547`, 2983.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{185.54545454545456`, 0.}, {186.45454545454547`, 2913.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{186.54545454545456`, 0.}, {187.45454545454547`, 2913.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{187.54545454545456`, 0.}, {188.45454545454547`, 3133.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{188.54545454545456`, 0.}, {189.45454545454547`, 2943.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{189.54545454545456`, 0.}, {190.45454545454547`, 2692.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{190.54545454545456`, 0.}, {191.45454545454547`, 2692.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{191.54545454545456`, 0.}, {192.45454545454547`, 3112.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{192.54545454545456`, 0.}, {193.45454545454547`, 3252.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{193.54545454545456`, 0.}, {194.45454545454547`, 3462.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{194.54545454545456`, 0.}, {195.45454545454547`, 3742.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{195.54545454545456`, 0.}, {196.45454545454547`, 3704.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{196.54545454545456`, 0.}, {197.45454545454547`, 3556.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{197.54545454545456`, 0.}, {198.45454545454547`, 3626.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{198.54545454545456`, 0.}, {199.45454545454547`, 3696.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{199.54545454545456`, 0.}, {200.45454545454547`, 3766.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{200.54545454545456`, 0.}, {201.45454545454547`, 3766.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{201.54545454545456`, 0.}, {202.45454545454547`, 3826.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{202.54545454545456`, 0.}, {203.45454545454547`, 3670.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{203.54545454545456`, 0.}, {204.45454545454547`, 3740.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{204.54545454545456`, 0.}, {205.45454545454547`, 3810.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{205.54545454545456`, 0.}, {206.45454545454547`, 3810.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{206.54545454545456`, 0.}, {207.45454545454547`, 3870.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{207.54545454545456`, 0.}, {208.45454545454547`, 3870.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{208.54545454545456`, 0.}, {209.45454545454547`, 3710.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{209.54545454545456`, 0.}, {210.45454545454547`, 3710.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{210.54545454545456`, 0.}, {211.45454545454547`, 3710.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{211.54545454545456`, 0.}, {212.45454545454547`, 3830.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{212.54545454545456`, 0.}, {213.45454545454547`, 3930.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{213.54545454545456`, 0.}, {214.45454545454547`, 4000.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{214.54545454545456`, 0.}, {215.45454545454547`, 4000.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{215.54545454545456`, 0.}, {216.45454545454547`, 4026.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{216.54545454545456`, 0.}, {217.45454545454547`, 3956.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{217.54545454545456`, 0.}, {218.45454545454547`, 4010.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{218.54545454545456`, 0.}, {219.45454545454547`, 3844.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{219.54545454545456`, 0.}, {220.45454545454547`, 3844.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{220.54545454545456`, 0.}, {221.45454545454547`, 3844.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{221.54545454545456`, 0.}, {222.45454545454547`, 3914.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{222.54545454545456`, 0.}, {223.45454545454547`, 4084.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{223.54545454545456`, 0.}, {224.45454545454547`, 4204.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{224.54545454545456`, 0.}, {225.45454545454547`, 4264.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{225.54545454545456`, 0.}, {226.45454545454547`, 4128.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{226.54545454545456`, 0.}, {227.45454545454547`, 3954.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{227.54545454545456`, 0.}, {228.45454545454547`, 3954.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{228.54545454545456`, 0.}, {229.45454545454547`, 3794.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{229.54545454545456`, 0.}, {230.45454545454547`, 3864.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{230.54545454545456`, 0.}, {231.45454545454547`, 3984.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{231.54545454545456`, 0.}, {232.45454545454547`, 3894.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{232.54545454545456`, 0.}, {233.45454545454547`, 3774.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{233.54545454545456`, 0.}, {234.45454545454547`, 3782.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{234.54545454545456`, 0.}, {235.45454545454547`, 3842.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{235.54545454545456`, 0.}, {236.45454545454547`, 3752.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{236.54545454545456`, 0.}, {237.45454545454547`, 3962.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{237.54545454545456`, 0.}, {238.45454545454547`, 3817.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{238.54545454545456`, 0.}, {239.45454545454547`, 3704.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{239.54545454545456`, 0.}, {240.45454545454547`, 3774.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{240.54545454545456`, 0.}, {241.45454545454547`, 3834.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{241.54545454545456`, 0.}, {242.45454545454547`, 3878.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{242.54545454545456`, 0.}, {243.45454545454547`, 3878.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{243.54545454545456`, 0.}, {244.45454545454547`, 3998.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{244.54545454545456`, 0.}, {245.45454545454547`, 3998.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{245.54545454545456`, 0.}, {246.45454545454547`, 3998.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{246.54545454545456`, 0.}, {247.45454545454547`, 3998.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{247.54545454545456`, 0.}, {248.45454545454547`, 4058.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{248.54545454545456`, 0.}, {249.45454545454547`, 4058.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{249.54545454545456`, 0.}, {250.45454545454547`, 4118.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{250.54545454545456`, 0.}, {251.45454545454547`, 4134.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{251.54545454545456`, 0.}, {252.45454545454547`, 4114.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{252.54545454545456`, 0.}, {253.45454545454547`, 4114.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{253.54545454545456`, 0.}, {254.45454545454547`, 4142.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{254.54545454545456`, 0.}, {255.45454545454547`, 4142.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{255.54545454545456`, 0.}, {256.4545454545455, 3878.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{256.54545454545456`, 0.}, {257.4545454545455, 3878.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{257.54545454545456`, 0.}, {258.4545454545455, 3878.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{258.54545454545456`, 0.}, {259.4545454545455, 3878.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{259.54545454545456`, 0.}, {260.4545454545455, 3948.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{260.54545454545456`, 0.}, {261.4545454545455, 4018.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{261.54545454545456`, 0.}, {262.4545454545455, 3892.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{262.54545454545456`, 0.}, {263.4545454545455, 4056.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{263.54545454545456`, 0.}, {264.4545454545455, 4188.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{264.54545454545456`, 0.}, {265.4545454545455, 3954.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{265.54545454545456`, 0.}, {266.4545454545455, 3918.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{266.54545454545456`, 0.}, {267.4545454545455, 3782.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{267.54545454545456`, 0.}, {268.4545454545455, 3828.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{268.54545454545456`, 0.}, {269.4545454545455, 3869.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{269.54545454545456`, 0.}, {270.4545454545455, 3869.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{270.54545454545456`, 0.}, {271.4545454545455, 3799.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{271.54545454545456`, 0.}, {272.4545454545455, 3655.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{272.54545454545456`, 0.}, {273.4545454545455, 3799.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{273.54545454545456`, 0.}, {274.4545454545455, 4009.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{274.54545454545456`, 0.}, {275.4545454545455, 4189.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{275.54545454545456`, 0.}, {276.4545454545455, 4277.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{276.54545454545456`, 0.}, {277.4545454545455, 4261.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{277.54545454545456`, 0.}, {278.4545454545455, 4265.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{278.54545454545456`, 0.}, {279.4545454545455, 4133.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{279.54545454545456`, 0.}, {280.4545454545455, 4193.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{280.54545454545456`, 0.}, {281.4545454545455, 4081.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{281.54545454545456`, 0.}, {282.4545454545455, 4123.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{282.54545454545456`, 0.}, {283.4545454545455, 4123.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{283.54545454545456`, 0.}, {284.4545454545455, 4123.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{284.54545454545456`, 0.}, {285.4545454545455, 4097.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{285.54545454545456`, 0.}, {286.4545454545455, 4061.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{286.54545454545456`, 0.}, {287.4545454545455, 4061.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{287.54545454545456`, 0.}, {288.4545454545455, 4241.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{288.54545454545456`, 0.}, {289.4545454545455, 4285.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{289.54545454545456`, 0.}, {290.4545454545455, 4285.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{290.54545454545456`, 0.}, {291.4545454545455, 4345.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{291.54545454545456`, 0.}, {292.4545454545455, 4345.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{292.54545454545456`, 0.}, {293.4545454545455, 4385.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{293.54545454545456`, 0.}, {294.4545454545455, 4445.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{294.54545454545456`, 0.}, {295.4545454545455, 4235.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{295.54545454545456`, 0.}, {296.4545454545455, 4275.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{296.54545454545456`, 0.}, {297.4545454545455, 4083.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{297.54545454545456`, 0.}, {298.4545454545455, 4485.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{298.54545454545456`, 0.}, {299.4545454545455, 4467.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{299.54545454545456`, 0.}, {300.4545454545455, 4235.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{300.54545454545456`, 0.}, {301.4545454545455, 4085.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{301.54545454545456`, 0.}, {302.4545454545455, 4155.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{302.54545454545456`, 0.}, {303.4545454545455, 4465.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{303.54545454545456`, 0.}, {304.4545454545455, 4351.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{304.54545454545456`, 0.}, {305.4545454545455, 4561.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{305.54545454545456`, 0.}, {306.4545454545455, 4771.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{306.54545454545456`, 0.}, {307.4545454545455, 4911.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{307.54545454545456`, 0.}, {308.4545454545455, 4893.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{308.54545454545456`, 0.}, {309.4545454545455, 4893.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{309.54545454545456`, 0.}, {310.4545454545455, 5213.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{310.54545454545456`, 0.}, {311.4545454545455, 4723.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{311.54545454545456`, 0.}, {312.4545454545455, 4587.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{312.54545454545456`, 0.}, {313.4545454545455, 4595.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{313.54545454545456`, 0.}, {314.4545454545455, 4675.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{314.54545454545456`, 0.}, {315.4545454545455, 4487.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{315.54545454545456`, 0.}, {316.4545454545455, 4561.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{316.54545454545456`, 0.}, {317.4545454545455, 4631.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{317.54545454545456`, 0.}, {318.4545454545455, 4405.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{318.54545454545456`, 0.}, {319.4545454545455, 4465.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{319.54545454545456`, 0.}, {320.4545454545455, 4465.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{320.54545454545456`, 0.}, {321.4545454545455, 4535.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{321.54545454545456`, 0.}, {322.4545454545455, 4489.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{322.54545454545456`, 0.}, {323.4545454545455, 4489.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{323.54545454545456`, 0.}, {324.4545454545455, 4299.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{324.54545454545456`, 0.}, {325.4545454545455, 4299.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{325.54545454545456`, 0.}, {326.4545454545455, 4359.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{326.54545454545456`, 0.}, {327.4545454545455, 4335.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{327.54545454545456`, 0.}, {328.4545454545455, 4395.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{328.54545454545456`, 0.}, {329.4545454545455, 4441.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{329.54545454545456`, 0.}, {330.4545454545455, 4501.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{330.54545454545456`, 0.}, {331.4545454545455, 4517.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{331.54545454545456`, 0.}, {332.4545454545455, 4657.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{332.54545454545456`, 0.}, {333.4545454545455, 4837.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{333.54545454545456`, 0.}, {334.4545454545455, 4837.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{334.54545454545456`, 0.}, {335.4545454545455, 4645.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{335.54545454545456`, 0.}, {336.4545454545455, 4645.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{336.54545454545456`, 0.}, {337.4545454545455, 4383.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{337.54545454545456`, 0.}, {338.4545454545455, 4383.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{338.54545454545456`, 0.}, {339.4545454545455, 4383.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{339.54545454545456`, 0.}, {340.4545454545455, 4383.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{340.54545454545456`, 0.}, {341.4545454545455, 4329.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{341.54545454545456`, 0.}, {342.4545454545455, 4223.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{342.54545454545456`, 0.}, {343.4545454545455, 4223.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{343.54545454545456`, 0.}, {344.4545454545455, 4221.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{344.54545454545456`, 0.}, {345.4545454545455, 4239.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{345.54545454545456`, 0.}, {346.4545454545455, 4311.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{346.54545454545456`, 0.}, {347.4545454545455, 4173.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{347.54545454545456`, 0.}, {348.4545454545455, 4453.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{348.54545454545456`, 0.}, {349.4545454545455, 4143.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{349.54545454545456`, 0.}, {350.4545454545455, 4273.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{350.54545454545456`, 0.}, {351.4545454545455, 4125.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{351.54545454545456`, 0.}, {352.4545454545455, 4211.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{352.54545454545456`, 0.}, {353.4545454545455, 4055.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{353.54545454545456`, 0.}, {354.4545454545455, 3971.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{354.54545454545456`, 0.}, {355.4545454545455, 4041.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{355.54545454545456`, 0.}, {356.4545454545455, 4127.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{356.54545454545456`, 0.}, {357.4545454545455, 4127.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{357.54545454545456`, 0.}, {358.4545454545455, 4323.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{358.54545454545456`, 0.}, {359.4545454545455, 4097.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{359.54545454545456`, 0.}, {360.4545454545455, 3955.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{360.54545454545456`, 0.}, {361.4545454545455, 4165.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{361.54545454545456`, 0.}, {362.4545454545455, 4141.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{362.54545454545456`, 0.}, {363.4545454545455, 3987.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{363.54545454545456`, 0.}, {364.4545454545455, 4127.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{364.54545454545456`, 0.}, {365.4545454545455, 4197.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{365.54545454545456`, 0.}, {366.4545454545455, 4043.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{366.54545454545456`, 0.}, {367.4545454545455, 3911.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{367.54545454545456`, 0.}, {368.4545454545455, 4091.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{368.54545454545456`, 0.}, {369.4545454545455, 4371.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{369.54545454545456`, 0.}, {370.4545454545455, 4325.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{370.54545454545456`, 0.}, {371.4545454545455, 4815.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{371.54545454545456`, 0.}, {372.4545454545455, 4885.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{372.54545454545456`, 0.}, {373.4545454545455, 4749.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{373.54545454545456`, 0.}, {374.4545454545455, 4589.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{374.54545454545456`, 0.}, {375.4545454545455, 4659.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{375.54545454545456`, 0.}, {376.4545454545455, 4511.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{376.54545454545456`, 0.}, {377.4545454545455, 4421.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{377.54545454545456`, 0.}, {378.4545454545455, 4561.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{378.54545454545456`, 0.}, {379.4545454545455, 4239.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{379.54545454545456`, 0.}, {380.4545454545455, 4309.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{380.54545454545456`, 0.}, {381.4545454545455, 4065.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{381.54545454545456`, 0.}, {382.4545454545455, 4065.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{382.54545454545456`, 0.}, {383.4545454545455, 3921.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{383.54545454545456`, 0.}, {384.4545454545455, 3941.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{384.54545454545456`, 0.}, {385.4545454545455, 4035.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{385.54545454545456`, 0.}, {386.4545454545455, 4069.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{386.54545454545456`, 0.}, {387.4545454545455, 3903.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{387.54545454545456`, 0.}, {388.4545454545455, 3897.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{388.54545454545456`, 0.}, {389.4545454545455, 3867.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{389.54545454545456`, 0.}, {390.4545454545455, 3867.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{390.54545454545456`, 0.}, {391.4545454545455, 3867.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{391.54545454545456`, 0.}, {392.4545454545455, 3987.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{392.54545454545456`, 0.}, {393.4545454545455, 4057.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{393.54545454545456`, 0.}, {394.4545454545455, 3901.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{394.54545454545456`, 0.}, {395.4545454545455, 3757.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{395.54545454545456`, 0.}, {396.4545454545455, 3483.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{396.54545454545456`, 0.}, {397.4545454545455, 3277.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{397.54545454545456`, 0.}, {398.4545454545455, 3417.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{398.54545454545456`, 0.}, {399.4545454545455, 3557.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{399.54545454545456`, 0.}, {400.4545454545455, 3659.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{400.54545454545456`, 0.}, {401.4545454545455, 3409.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{401.54545454545456`, 0.}, {402.4545454545455, 3549.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{402.54545454545456`, 0.}, {403.4545454545455, 3689.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{403.54545454545456`, 0.}, {404.4545454545455, 3749.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{404.54545454545456`, 0.}, {405.4545454545455, 3749.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{405.54545454545456`, 0.}, {406.4545454545455, 3869.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{406.54545454545456`, 0.}, {407.4545454545455, 3509.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{407.54545454545456`, 0.}, {408.4545454545455, 3719.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{408.54545454545456`, 0.}, {409.4545454545455, 3789.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{409.54545454545456`, 0.}, {410.4545454545455, 3509.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{410.54545454545456`, 0.}, {411.4545454545455, 3437.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{411.54545454545456`, 0.}, {412.4545454545455, 4077.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{412.54545454545456`, 0.}, {413.4545454545455, 4073.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{413.54545454545456`, 0.}, {414.4545454545455, 4113.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{414.54545454545456`, 0.}, {415.4545454545455, 4147.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{415.54545454545456`, 0.}, {416.4545454545455, 4787.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{416.54545454545456`, 0.}, {417.4545454545455, 4395.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{417.54545454545456`, 0.}, {418.4545454545455, 4795.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{418.54545454545456`, 0.}, {419.4545454545455, 5095.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{419.54545454545456`, 0.}, {420.4545454545455, 5095.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{420.54545454545456`, 0.}, {421.4545454545455, 4905.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{421.54545454545456`, 0.}, {422.4545454545455, 4905.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{422.54545454545456`, 0.}, {423.4545454545455, 4445.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{423.54545454545456`, 0.}, {424.4545454545455, 5215.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{424.54545454545456`, 0.}, {425.4545454545455, 5049.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{425.54545454545456`, 0.}, {426.4545454545455, 5239.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{426.54545454545456`, 0.}, {427.4545454545455, 5239.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{427.54545454545456`, 0.}, {428.4545454545455, 5061.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{428.54545454545456`, 0.}, {429.4545454545455, 5261.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{429.54545454545456`, 0.}, {430.4545454545455, 5261.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{430.54545454545456`, 0.}, {431.4545454545455, 5417.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{431.54545454545456`, 0.}, {432.4545454545455, 5653.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{432.54545454545456`, 0.}, {433.4545454545455, 5993.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{433.54545454545456`, 0.}, {434.4545454545455, 5959.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{434.54545454545456`, 0.}, {435.4545454545455, 5769.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{435.54545454545456`, 0.}, {436.4545454545455, 5969.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{436.54545454545456`, 0.}, {437.4545454545455, 5899.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{437.54545454545456`, 0.}, {438.4545454545455, 6099.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{438.54545454545456`, 0.}, {439.4545454545455, 5831.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{439.54545454545456`, 0.}, {440.4545454545455, 6031.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{440.54545454545456`, 0.}, {441.4545454545455, 6431.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{441.54545454545456`, 0.}, {442.4545454545455, 6393.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{442.54545454545456`, 0.}, {443.4545454545455, 6391.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{443.54545454545456`, 0.}, {444.4545454545455, 6391.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{444.54545454545456`, 0.}, {445.4545454545455, 6591.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{445.54545454545456`, 0.}, {446.4545454545455, 6701.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{446.54545454545456`, 0.}, {447.4545454545455, 6487.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{447.54545454545456`, 0.}, {448.4545454545455, 6797.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{448.54545454545456`, 0.}, {449.4545454545455, 6595.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{449.54545454545456`, 0.}, {450.4545454545455, 6243.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{450.54545454545456`, 0.}, {451.4545454545455, 6077.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{451.54545454545456`, 0.}, {452.4545454545455, 6277.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{452.54545454545456`, 0.}, {453.4545454545455, 6491.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{453.54545454545456`, 0.}, {454.4545454545455, 6313.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{454.54545454545456`, 0.}, {455.4545454545455, 6513.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{455.54545454545456`, 0.}, {456.4545454545455, 6227.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{456.54545454545456`, 0.}, {457.4545454545455, 6219.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{457.54545454545456`, 0.}, {458.4545454545455, 6419.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{458.54545454545456`, 0.}, {459.4545454545455, 6419.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{459.54545454545456`, 0.}, {460.4545454545455, 6351.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{460.54545454545456`, 0.}, {461.4545454545455, 6351.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{461.54545454545456`, 0.}, {462.4545454545455, 6179.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{462.54545454545456`, 0.}, {463.4545454545455, 6179.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{463.54545454545456`, 0.}, {464.4545454545455, 6179.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{464.54545454545456`, 0.}, {465.4545454545455, 6019.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{465.54545454545456`, 0.}, {466.4545454545455, 6028.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{466.54545454545456`, 0.}, {467.4545454545455, 6028.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{467.54545454545456`, 0.}, {468.4545454545455, 6028.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{468.54545454545456`, 0.}, {469.4545454545455, 5868.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{469.54545454545456`, 0.}, {470.4545454545455, 5868.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{470.54545454545456`, 0.}, {471.4545454545455, 6068.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{471.54545454545456`, 0.}, {472.4545454545455, 6268.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{472.54545454545456`, 0.}, {473.4545454545455, 6224.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{473.54545454545456`, 0.}, {474.4545454545455, 6260.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{474.54545454545456`, 0.}, {475.4545454545455, 6088.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{475.54545454545456`, 0.}, {476.4545454545455, 6080.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{476.54545454545456`, 0.}, {477.4545454545455, 6080.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{477.54545454545456`, 0.}, {478.4545454545455, 5976.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{478.54545454545456`, 0.}, {479.4545454545455, 5606.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{479.54545454545456`, 0.}, {480.4545454545455, 6206.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{480.54545454545456`, 0.}, {481.4545454545455, 6206.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{481.54545454545456`, 0.}, {482.4545454545455, 5884.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{482.54545454545456`, 0.}, {483.4545454545455, 5804.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{483.54545454545456`, 0.}, {484.4545454545455, 5736.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{484.54545454545456`, 0.}, {485.4545454545455, 5736.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{485.54545454545456`, 0.}, {486.4545454545455, 5936.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{486.54545454545456`, 0.}, {487.4545454545455, 5936.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{487.54545454545456`, 0.}, {488.4545454545455, 5936.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{488.54545454545456`, 0.}, {489.4545454545455, 6136.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{489.54545454545456`, 0.}, {490.4545454545455, 6286.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{490.54545454545456`, 0.}, {491.4545454545455, 6286.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{491.54545454545456`, 0.}, {492.4545454545455, 6286.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{492.54545454545456`, 0.}, {493.4545454545455, 6286.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{493.54545454545456`, 0.}, {494.4545454545455, 6286.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{494.54545454545456`, 0.}, {495.4545454545455, 6306.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{495.54545454545456`, 0.}, {496.4545454545455, 6306.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{496.54545454545456`, 0.}, {497.4545454545455, 5504.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{497.54545454545456`, 0.}, {498.4545454545455, 5970.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{498.54545454545456`, 0.}, {499.4545454545455, 6210.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{499.54545454545456`, 0.}, {500.4545454545455, 6410.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{500.54545454545456`, 0.}, {501.4545454545455, 6410.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{501.54545454545456`, 0.}, {502.4545454545455, 6432.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{502.54545454545456`, 0.}, {503.4545454545455, 6234.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{503.54545454545456`, 0.}, {504.4545454545455, 6274.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{504.54545454545456`, 0.}, {505.4545454545455, 6072.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{505.54545454545456`, 0.}, {506.4545454545455, 6116.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{506.54545454545456`, 0.}, {507.4545454545455, 6196.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{507.54545454545456`, 0.}, {508.4545454545455, 6448.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{508.54545454545456`, 0.}, {509.4545454545455, 6420.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{509.54545454545456`, 0.}, {510.4545454545455, 6220.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{510.54545454545456`, 0.}, {511.4545454545455, 6014.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{511.54545454545456`, 0.}, {512.4545454545455, 5924.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{512.5454545454546, 0.}, {513.4545454545455, 6054.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{513.5454545454546, 0.}, {514.4545454545455, 6054.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{514.5454545454546, 0.}, {515.4545454545455, 6054.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{515.5454545454546, 0.}, {516.4545454545455, 6054.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{516.5454545454546, 0.}, {517.4545454545455, 6054.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{517.5454545454546, 0.}, {518.4545454545455, 5974.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{518.5454545454546, 0.}, {519.4545454545455, 5974.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{519.5454545454546, 0.}, {520.4545454545455, 5968.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{520.5454545454546, 0.}, {521.4545454545455, 6048.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{521.5454545454546, 0.}, {522.4545454545455, 6128.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{522.5454545454546, 0.}, {523.4545454545455, 6244.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{523.5454545454546, 0.}, {524.4545454545455, 6324.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{524.5454545454546, 0.}, {525.4545454545455, 6324.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{525.5454545454546, 0.}, {526.4545454545455, 6184.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{526.5454545454546, 0.}, {527.4545454545455, 6184.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{527.5454545454546, 0.}, {528.4545454545455, 6424.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{528.5454545454546, 0.}, {529.4545454545455, 6254.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{529.5454545454546, 0.}, {530.4545454545455, 6264.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{530.5454545454546, 0.}, {531.4545454545455, 6308.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{531.5454545454546, 0.}, {532.4545454545455, 6448.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{532.5454545454546, 0.}, {533.4545454545455, 6528.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{533.5454545454546, 0.}, {534.4545454545455, 6738.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{534.5454545454546, 0.}, {535.4545454545455, 7018.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{535.5454545454546, 0.}, {536.4545454545455, 7088.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{536.5454545454546, 0.}, {537.4545454545455, 7088.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{537.5454545454546, 0.}, {538.4545454545455, 6872.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{538.5454545454546, 0.}, {539.4545454545455, 6942.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{539.5454545454546, 0.}, {540.4545454545455, 7190.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{540.5454545454546, 0.}, {541.4545454545455, 7260.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{541.5454545454546, 0.}, {542.4545454545455, 7072.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{542.5454545454546, 0.}, {543.4545454545455, 7142.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{543.5454545454546, 0.}, {544.4545454545455, 7000.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{544.5454545454546, 0.}, {545.4545454545455, 7070.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{545.5454545454546, 0.}, {546.4545454545455, 7140.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{546.5454545454546, 0.}, {547.4545454545455, 7210.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{547.5454545454546, 0.}, {548.4545454545455, 7280.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{548.5454545454546, 0.}, {549.4545454545455, 7138.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{549.5454545454546, 0.}, {550.4545454545455, 7138.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{550.5454545454546, 0.}, {551.4545454545455, 7218.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{551.5454545454546, 0.}, {552.4545454545455, 7218.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{552.5454545454546, 0.}, {553.4545454545455, 7172.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{553.5454545454546, 0.}, {554.4545454545455, 7266.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{554.5454545454546, 0.}, {555.4545454545455, 7406.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{555.5454545454546, 0.}, {556.4545454545455, 7513.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{556.5454545454546, 0.}, {557.4545454545455, 7495.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{557.5454545454546, 0.}, {558.4545454545455, 7705.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{558.5454545454546, 0.}, {559.4545454545455, 7775.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{559.5454545454546, 0.}, {560.4545454545455, 7985.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{560.5454545454546, 0.}, {561.4545454545455, 8055.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{561.5454545454546, 0.}, {562.4545454545455, 8195.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{562.5454545454546, 0.}, {563.4545454545455, 8032.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{563.5454545454546, 0.}, {564.4545454545455, 8121.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{564.5454545454546, 0.}, {565.4545454545455, 8261.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{565.5454545454546, 0.}, {566.4545454545455, 8047.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{566.5454545454546, 0.}, {567.4545454545455, 8047.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{567.5454545454546, 0.}, {568.4545454545455, 7847.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{568.5454545454546, 0.}, {569.4545454545455, 7847.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{569.5454545454546, 0.}, {570.4545454545455, 7847.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{570.5454545454546, 0.}, {571.4545454545455, 7693.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{571.5454545454546, 0.}, {572.4545454545455, 7683.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{572.5454545454546, 0.}, {573.4545454545455, 7669.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{573.5454545454546, 0.}, {574.4545454545455, 7739.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{574.5454545454546, 0.}, {575.4545454545455, 8039.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{575.5454545454546, 0.}, {576.4545454545455, 7901.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{576.5454545454546, 0.}, {577.4545454545455, 7971.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{577.5454545454546, 0.}, {578.4545454545455, 7794.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{578.5454545454546, 0.}, {579.4545454545455, 8074.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{579.5454545454546, 0.}, {580.4545454545455, 8144.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{580.5454545454546, 0.}, {581.4545454545455, 8108.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{581.5454545454546, 0.}, {582.4545454545455, 7928.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{582.5454545454546, 0.}, {583.4545454545455, 7678.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{583.5454545454546, 0.}, {584.4545454545455, 7748.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{584.5454545454546, 0.}, {585.4545454545455, 7740.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{585.5454545454546, 0.}, {586.4545454545455, 7674.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{586.5454545454546, 0.}, {587.4545454545455, 7512.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{587.5454545454546, 0.}, {588.4545454545455, 7362.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{588.5454545454546, 0.}, {589.4545454545455, 7362.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{589.5454545454546, 0.}, {590.4545454545455, 7362.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{590.5454545454546, 0.}, {591.4545454545455, 7186.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{591.5454545454546, 0.}, {592.4545454545455, 6962.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{592.5454545454546, 0.}, {593.4545454545455, 7122.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{593.5454545454546, 0.}, {594.4545454545455, 6992.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{594.5454545454546, 0.}, {595.4545454545455, 7136.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{595.5454545454546, 0.}, {596.4545454545455, 6936.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{596.5454545454546, 0.}, {597.4545454545455, 7154.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{597.5454545454546, 0.}, {598.4545454545455, 7316.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{598.5454545454546, 0.}, {599.4545454545455, 7396.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{599.5454545454546, 0.}, {600.4545454545455, 7244.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{600.5454545454546, 0.}, {601.4545454545455, 7404.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{601.5454545454546, 0.}, {602.4545454545455, 7246.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{602.5454545454546, 0.}, {603.4545454545455, 7368.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{603.5454545454546, 0.}, {604.4545454545455, 7508.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{604.5454545454546, 0.}, {605.4545454545455, 7532.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{605.5454545454546, 0.}, {606.4545454545455, 7532.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{606.5454545454546, 0.}, {607.4545454545455, 7388.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{607.5454545454546, 0.}, {608.4545454545455, 7528.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{608.5454545454546, 0.}, {609.4545454545455, 7468.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{609.5454545454546, 0.}, {610.4545454545455, 7450.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{610.5454545454546, 0.}, {611.4545454545455, 7478.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{611.5454545454546, 0.}, {612.4545454545455, 7548.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{612.5454545454546, 0.}, {613.4545454545455, 7788.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{613.5454545454546, 0.}, {614.4545454545455, 7996.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{614.5454545454546, 0.}, {615.4545454545455, 7911.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{615.5454545454546, 0.}, {616.4545454545455, 8071.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{616.5454545454546, 0.}, {617.4545454545455, 8151.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{617.5454545454546, 0.}, {618.4545454545455, 8037.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{618.5454545454546, 0.}, {619.4545454545455, 8197.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{619.5454545454546, 0.}, {620.4545454545455, 8175.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{620.5454545454546, 0.}, {621.4545454545455, 8255.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{621.5454545454546, 0.}, {622.4545454545455, 8335.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{622.5454545454546, 0.}, {623.4545454545455, 8735.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{623.5454545454546, 0.}, {624.4545454545455, 8586.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{624.5454545454546, 0.}, {625.4545454545455, 8586.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{625.5454545454546, 0.}, {626.4545454545455, 8666.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{626.5454545454546, 0.}, {627.4545454545455, 8736.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{627.5454545454546, 0.}, {628.4545454545455, 8816.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{628.5454545454546, 0.}, {629.4545454545455, 8644.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{629.5454545454546, 0.}, {630.4545454545455, 8644.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{630.5454545454546, 0.}, {631.4545454545455, 8744.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{631.5454545454546, 0.}, {632.4545454545455, 8588.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{632.5454545454546, 0.}, {633.4545454545455, 8828.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{633.5454545454546, 0.}, {634.4545454545455, 8908.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{634.5454545454546, 0.}, {635.4545454545455, 8908.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{635.5454545454546, 0.}, {636.4545454545455, 9094.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{636.5454545454546, 0.}, {637.4545454545455, 9194.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{637.5454545454546, 0.}, {638.4545454545455, 9194.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{638.5454545454546, 0.}, {639.4545454545455, 9142.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{639.5454545454546, 0.}, {640.4545454545455, 9142.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{640.5454545454546, 0.}, {641.4545454545455, 8942.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{641.5454545454546, 0.}, {642.4545454545455, 9026.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{642.5454545454546, 0.}, {643.4545454545455, 9050.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{643.5454545454546, 0.}, {644.4545454545455, 9050.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{644.5454545454546, 0.}, {645.4545454545455, 8898.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{645.5454545454546, 0.}, {646.4545454545455, 8898.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{646.5454545454546, 0.}, {647.4545454545455, 8902.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{647.5454545454546, 0.}, {648.4545454545455, 8737.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{648.5454545454546, 0.}, {649.4545454545455, 8635.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{649.5454545454546, 0.}, {650.4545454545455, 8737.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{650.5454545454546, 0.}, {651.4545454545455, 8713.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{651.5454545454546, 0.}, {652.4545454545455, 8753.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{652.5454545454546, 0.}, {653.4545454545455, 9243.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{653.5454545454546, 0.}, {654.4545454545455, 9041.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{654.5454545454546, 0.}, {655.4545454545455, 9041.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{655.5454545454546, 0.}, {656.4545454545455, 9391.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{656.5454545454546, 0.}, {657.4545454545455, 9643.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{657.5454545454546, 0.}, {658.4545454545455, 9853.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{658.5454545454546, 0.}, {659.4545454545455, 9717.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{659.5454545454546, 0.}, {660.4545454545455, 9787.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{660.5454545454546, 0.}, {661.4545454545455, 9813.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{661.5454545454546, 0.}, {662.4545454545455, 9665.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{662.5454545454546, 0.}, {663.4545454545455, 9637.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{663.5454545454546, 0.}, {664.4545454545455, 9505.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{664.5454545454546, 0.}, {665.4545454545455, 8967.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{665.5454545454546, 0.}, {666.4545454545455, 8823.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{666.5454545454546, 0.}, {667.4545454545455, 8653.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{667.5454545454546, 0.}, {668.4545454545455, 8767.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{668.5454545454546, 0.}, {669.4545454545455, 8461.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{669.5454545454546, 0.}, {670.4545454545455, 8531.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{670.5454545454546, 0.}, {671.4545454545455, 8531.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{671.5454545454546, 0.}, {672.4545454545455, 8531.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{672.5454545454546, 0.}, {673.4545454545455, 8403.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{673.5454545454546, 0.}, {674.4545454545455, 8261.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{674.5454545454546, 0.}, {675.4545454545455, 8389.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{675.5454545454546, 0.}, {676.4545454545455, 8599.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{676.5454545454546, 0.}, {677.4545454545455, 8669.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{677.5454545454546, 0.}, {678.4545454545455, 8809.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{678.5454545454546, 0.}, {679.4545454545455, 8879.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{679.5454545454546, 0.}, {680.4545454545455, 8929.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{680.5454545454546, 0.}, {681.4545454545455, 8929.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{681.5454545454546, 0.}, {682.4545454545455, 8989.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{682.5454545454546, 0.}, {683.4545454545455, 8989.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{683.5454545454546, 0.}, {684.4545454545455, 8989.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{684.5454545454546, 0.}, {685.4545454545455, 9049.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{685.5454545454546, 0.}, {686.4545454545455, 9119.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{686.5454545454546, 0.}, {687.4545454545455, 9239.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{687.5454545454546, 0.}, {688.4545454545455, 9109.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{688.5454545454546, 0.}, {689.4545454545455, 9179.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{689.5454545454546, 0.}, {690.4545454545455, 9417.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{690.5454545454546, 0.}, {691.4545454545455, 9487.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{691.5454545454546, 0.}, {692.4545454545455, 9557.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{692.5454545454546, 0.}, {693.4545454545455, 9487.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{693.5454545454546, 0.}, {694.4545454545455, 9333.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{694.5454545454546, 0.}, {695.4545454545455, 9313.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{695.5454545454546, 0.}, {696.4545454545455, 9373.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{696.5454545454546, 0.}, {697.4545454545455, 9650.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{697.5454545454546, 0.}, {698.4545454545455, 9502.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{698.5454545454546, 0.}, {699.4545454545455, 9584.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{699.5454545454546, 0.}, {700.4545454545455, 9584.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{700.5454545454546, 0.}, {701.4545454545455, 9334.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{701.5454545454546, 0.}, {702.4545454545455, 9474.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{702.5454545454546, 0.}, {703.4545454545455, 9544.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{703.5454545454546, 0.}, {704.4545454545455, 9544.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{704.5454545454546, 0.}, {705.4545454545455, 9544.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{705.5454545454546, 0.}, {706.4545454545455, 9664.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{706.5454545454546, 0.}, {707.4545454545455, 9724.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{707.5454545454546, 0.}, {708.4545454545455, 9724.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{708.5454545454546, 0.}, {709.4545454545455, 9758.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{709.5454545454546, 0.}, {710.4545454545455, 9818.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{710.5454545454546, 0.}, {711.4545454545455, 9740.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{711.5454545454546, 0.}, {712.4545454545455, 9620.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{712.5454545454546, 0.}, {713.4545454545455, 9620.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{713.5454545454546, 0.}, {714.4545454545455, 9382.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{714.5454545454546, 0.}, {715.4545454545455, 9228.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{715.5454545454546, 0.}, {716.4545454545455, 9098.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{716.5454545454546, 0.}, {717.4545454545455, 9158.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{717.5454545454546, 0.}, {718.4545454545455, 9278.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{718.5454545454546, 0.}, {719.4545454545455, 9436.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{719.5454545454546, 0.}, {720.4545454545455, 9616.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{720.5454545454546, 0.}, {721.4545454545455, 9598.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{721.5454545454546, 0.}, {722.4545454545455, 9610.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{722.5454545454546, 0.}, {723.4545454545455, 9468.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{723.5454545454546, 0.}, {724.4545454545455, 9468.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{724.5454545454546, 0.}, {725.4545454545455, 9538.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{725.5454545454546, 0.}, {726.4545454545455, 9420.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{726.5454545454546, 0.}, {727.4545454545455, 9420.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{727.5454545454546, 0.}, {728.4545454545455, 9490.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{728.5454545454546, 0.}, {729.4545454545455, 9418.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{729.5454545454546, 0.}, {730.4545454545455, 9456.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{730.5454545454546, 0.}, {731.4545454545455, 9306.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{731.5454545454546, 0.}, {732.4545454545455, 9376.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{732.5454545454546, 0.}, {733.4545454545455, 9446.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{733.5454545454546, 0.}, {734.4545454545455, 9516.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{734.5454545454546, 0.}, {735.4545454545455, 9576.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{735.5454545454546, 0.}, {736.4545454545455, 9422.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{736.5454545454546, 0.}, {737.4545454545455, 9492.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{737.5454545454546, 0.}, {738.4545454545455, 9374.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{738.5454545454546, 0.}, {739.4545454545455, 9434.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{739.5454545454546, 0.}, {740.4545454545455, 9434.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{740.5454545454546, 0.}, {741.4545454545455, 9476.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{741.5454545454546, 0.}, {742.4545454545455, 9326.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{742.5454545454546, 0.}, {743.4545454545455, 9226.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{743.5454545454546, 0.}, {744.4545454545455, 8806.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{744.5454545454546, 0.}, {745.4545454545455, 8844.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{745.5454545454546, 0.}, {746.4545454545455, 9124.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{746.5454545454546, 0.}, {747.4545454545455, 8950.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{747.5454545454546, 0.}, {748.4545454545455, 8950.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{748.5454545454546, 0.}, {749.4545454545455, 9100.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{749.5454545454546, 0.}, {750.4545454545455, 8928.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{750.5454545454546, 0.}, {751.4545454545455, 8902.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{751.5454545454546, 0.}, {752.4545454545455, 8902.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{752.5454545454546, 0.}, {753.4545454545455, 8892.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{753.5454545454546, 0.}, {754.4545454545455, 8930.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{754.5454545454546, 0.}, {755.4545454545455, 8930.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{755.5454545454546, 0.}, {756.4545454545455, 9000.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{756.5454545454546, 0.}, {757.4545454545455, 9030.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{757.5454545454546, 0.}, {758.4545454545455, 9030.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{758.5454545454546, 0.}, {759.4545454545455, 9072.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{759.5454545454546, 0.}, {760.4545454545455, 9142.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{760.5454545454546, 0.}, {761.4545454545455, 9158.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{761.5454545454546, 0.}, {762.4545454545455, 9158.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{762.5454545454546, 0.}, {763.4545454545455, 9168.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{763.5454545454546, 0.}, {764.4545454545455, 9256.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{764.5454545454546, 0.}, {765.4545454545455, 9436.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{765.5454545454546, 0.}, {766.4545454545455, 9410.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{766.5454545454546, 0.}, {767.4545454545455, 9472.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{767.5454545454546, 0.}, {768.4545454545455, 9564.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{768.5454545454546, 0.}, {769.4545454545455, 9564.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{769.5454545454546, 0.}, {770.4545454545455, 9624.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{770.5454545454546, 0.}, {771.4545454545455, 9624.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{771.5454545454546, 0.}, {772.4545454545455, 9624.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{772.5454545454546, 0.}, {773.4545454545455, 9634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{773.5454545454546, 0.}, {774.4545454545455, 9634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{774.5454545454546, 0.}, {775.4545454545455, 9634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{775.5454545454546, 0.}, {776.4545454545455, 9634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{776.5454545454546, 0.}, {777.4545454545455, 9634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{777.5454545454546, 0.}, {778.4545454545455, 9634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{778.5454545454546, 0.}, {779.4545454545455, 9634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{779.5454545454546, 0.}, {780.4545454545455, 9634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{780.5454545454546, 0.}, {781.4545454545455, 9634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{781.5454545454546, 0.}, {782.4545454545455, 9680.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{782.5454545454546, 0.}, {783.4545454545455, 9680.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{783.5454545454546, 0.}, {784.4545454545455, 9688.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{784.5454545454546, 0.}, {785.4545454545455, 9700.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{785.5454545454546, 0.}, {786.4545454545455, 9730.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{786.5454545454546, 0.}, {787.4545454545455, 9832.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{787.5454545454546, 0.}, {788.4545454545455, 9902.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{788.5454545454546, 0.}, {789.4545454545455, 10022.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{789.5454545454546, 0.}, {790.4545454545455, 10092.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{790.5454545454546, 0.}, {791.4545454545455, 10228.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{791.5454545454546, 0.}, {792.4545454545455, 10228.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{792.5454545454546, 0.}, {793.4545454545455, 10292.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{793.5454545454546, 0.}, {794.4545454545455, 10292.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{794.5454545454546, 0.}, {795.4545454545455, 10292.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{795.5454545454546, 0.}, {796.4545454545455, 10106.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{796.5454545454546, 0.}, {797.4545454545455, 10106.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{797.5454545454546, 0.}, {798.4545454545455, 10166.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{798.5454545454546, 0.}, {799.4545454545455, 10006.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{799.5454545454546, 0.}, {800.4545454545455, 10026.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{800.5454545454546, 0.}, {801.4545454545455, 10086.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{801.5454545454546, 0.}, {802.4545454545455, 10026.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{802.5454545454546, 0.}, {803.4545454545455, 10026.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{803.5454545454546, 0.}, {804.4545454545455, 10080.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{804.5454545454546, 0.}, {805.4545454545455, 9654.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{805.5454545454546, 0.}, {806.4545454545455, 9702.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{806.5454545454546, 0.}, {807.4545454545455, 9438.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{807.5454545454546, 0.}, {808.4545454545455, 9508.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{808.5454545454546, 0.}, {809.4545454545455, 9586.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{809.5454545454546, 0.}, {810.4545454545455, 9594.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{810.5454545454546, 0.}, {811.4545454545455, 9598.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{811.5454545454546, 0.}, {812.4545454545455, 9702.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{812.5454545454546, 0.}, {813.4545454545455, 9528.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{813.5454545454546, 0.}, {814.4545454545455, 9708.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{814.5454545454546, 0.}, {815.4545454545455, 9768.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{815.5454545454546, 0.}, {816.4545454545455, 9638.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{816.5454545454546, 0.}, {817.4545454545455, 9608.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{817.5454545454546, 0.}, {818.4545454545455, 9398.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{818.5454545454546, 0.}, {819.4545454545455, 9286.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{819.5454545454546, 0.}, {820.4545454545455, 8934.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{820.5454545454546, 0.}, {821.4545454545455, 9004.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{821.5454545454546, 0.}, {822.4545454545455, 8932.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{822.5454545454546, 0.}, {823.4545454545455, 8970.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{823.5454545454546, 0.}, {824.4545454545455, 8909.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{824.5454545454546, 0.}, {825.4545454545455, 8909.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{825.5454545454546, 0.}, {826.4545454545455, 8779.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{826.5454545454546, 0.}, {827.4545454545455, 8601.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{827.5454545454546, 0.}, {828.4545454545455, 8601.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{828.5454545454546, 0.}, {829.4545454545455, 8731.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{829.5454545454546, 0.}, {830.4545454545455, 8791.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{830.5454545454546, 0.}, {831.4545454545455, 8895.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{831.5454545454546, 0.}, {832.4545454545455, 9015.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{832.5454545454546, 0.}, {833.4545454545455, 8971.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{833.5454545454546, 0.}, {834.4545454545455, 9031.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{834.5454545454546, 0.}, {835.4545454545455, 9031.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{835.5454545454546, 0.}, {836.4545454545455, 9221.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{836.5454545454546, 0.}, {837.4545454545455, 9251.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{837.5454545454546, 0.}, {838.4545454545455, 9118.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{838.5454545454546, 0.}, {839.4545454545455, 9315.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{839.5454545454546, 0.}, {840.4545454545455, 9177.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{840.5454545454546, 0.}, {841.4545454545455, 9177.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{841.5454545454546, 0.}, {842.4545454545455, 9015.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{842.5454545454546, 0.}, {843.4545454545455, 9015.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{843.5454545454546, 0.}, {844.4545454545455, 9015.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{844.5454545454546, 0.}, {845.4545454545455, 9015.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{845.5454545454546, 0.}, {846.4545454545455, 8723.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{846.5454545454546, 0.}, {847.4545454545455, 8755.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{847.5454545454546, 0.}, {848.4545454545455, 8829.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{848.5454545454546, 0.}, {849.4545454545455, 8529.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{849.5454545454546, 0.}, {850.4545454545455, 8529.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{850.5454545454546, 0.}, {851.4545454545455, 8657.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{851.5454545454546, 0.}, {852.4545454545455, 8449.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{852.5454545454546, 0.}, {853.4545454545455, 8609.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{853.5454545454546, 0.}, {854.4545454545455, 8440.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{854.5454545454546, 0.}, {855.4545454545455, 8283.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{855.5454545454546, 0.}, {856.4545454545455, 8353.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{856.5454545454546, 0.}, {857.4545454545455, 7975.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{857.5454545454546, 0.}, {858.4545454545455, 8183.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{858.5454545454546, 0.}, {859.4545454545455, 8323.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{859.5454545454546, 0.}, {860.4545454545455, 8323.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{860.5454545454546, 0.}, {861.4545454545455, 8133.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{861.5454545454546, 0.}, {862.4545454545455, 7955.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{862.5454545454546, 0.}, {863.4545454545455, 7789.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{863.5454545454546, 0.}, {864.4545454545455, 7849.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{864.5454545454546, 0.}, {865.4545454545455, 7783.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{865.5454545454546, 0.}, {866.4545454545455, 7853.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{866.5454545454546, 0.}, {867.4545454545455, 7853.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{867.5454545454546, 0.}, {868.4545454545455, 8059.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{868.5454545454546, 0.}, {869.4545454545455, 7809.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{869.5454545454546, 0.}, {870.4545454545455, 7809.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{870.5454545454546, 0.}, {871.4545454545455, 7939.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{871.5454545454546, 0.}, {872.4545454545455, 7869.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{872.5454545454546, 0.}, {873.4545454545455, 7869.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{873.5454545454546, 0.}, {874.4545454545455, 8079.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{874.5454545454546, 0.}, {875.4545454545455, 8319.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{875.5454545454546, 0.}, {876.4545454545455, 8343.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{876.5454545454546, 0.}, {877.4545454545455, 8403.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{877.5454545454546, 0.}, {878.4545454545455, 8473.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{878.5454545454546, 0.}, {879.4545454545455, 8199.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{879.5454545454546, 0.}, {880.4545454545455, 8259.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{880.5454545454546, 0.}, {881.4545454545455, 8389.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{881.5454545454546, 0.}, {882.4545454545455, 8739.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{882.5454545454546, 0.}, {883.4545454545455, 8589.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{883.5454545454546, 0.}, {884.4545454545455, 8427.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{884.5454545454546, 0.}, {885.4545454545455, 8481.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{885.5454545454546, 0.}, {886.4545454545455, 8315.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{886.5454545454546, 0.}, {887.4545454545455, 8177.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{887.5454545454546, 0.}, {888.4545454545455, 8307.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{888.5454545454546, 0.}, {889.4545454545455, 8151.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{889.5454545454546, 0.}, {890.4545454545455, 8661.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{890.5454545454546, 0.}, {891.4545454545455, 8665.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{891.5454545454546, 0.}, {892.4545454545455, 8641.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{892.5454545454546, 0.}, {893.4545454545455, 8563.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{893.5454545454546, 0.}, {894.4545454545455, 8517.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{894.5454545454546, 0.}, {895.4545454545455, 8445.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{895.5454545454546, 0.}, {896.4545454545455, 8199.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{896.5454545454546, 0.}, {897.4545454545455, 8289.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{897.5454545454546, 0.}, {898.4545454545455, 8332.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{898.5454545454546, 0.}, {899.4545454545455, 8556.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{899.5454545454546, 0.}, {900.4545454545455, 8390.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{900.5454545454546, 0.}, {901.4545454545455, 8384.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{901.5454545454546, 0.}, {902.4545454545455, 8658.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{902.5454545454546, 0.}, {903.4545454545455, 8640.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{903.5454545454546, 0.}, {904.4545454545455, 8399.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{904.5454545454546, 0.}, {905.4545454545455, 8749.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{905.5454545454546, 0.}, {906.4545454545455, 8566.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{906.5454545454546, 0.}, {907.4545454545455, 8430.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{907.5454545454546, 0.}, {908.4545454545455, 8600.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{908.5454545454546, 0.}, {909.4545454545455, 9020.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{909.5454545454546, 0.}, {910.4545454545455, 9300.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{910.5454545454546, 0.}, {911.4545454545455, 9580.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{911.5454545454546, 0.}, {912.4545454545455, 9210.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{912.5454545454546, 0.}, {913.4545454545455, 8910.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{913.5454545454546, 0.}, {914.4545454545455, 8598.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{914.5454545454546, 0.}, {915.4545454545455, 8416.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{915.5454545454546, 0.}, {916.4545454545455, 8446.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{916.5454545454546, 0.}, {917.4545454545455, 8516.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{917.5454545454546, 0.}, {918.4545454545455, 8516.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{918.5454545454546, 0.}, {919.4545454545455, 8586.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{919.5454545454546, 0.}, {920.4545454545455, 8656.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{920.5454545454546, 0.}, {921.4545454545455, 8640.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{921.5454545454546, 0.}, {922.4545454545455, 8840.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{922.5454545454546, 0.}, {923.4545454545455, 8746.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{923.5454545454546, 0.}, {924.4545454545455, 8746.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{924.5454545454546, 0.}, {925.4545454545455, 8746.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{925.5454545454546, 0.}, {926.4545454545455, 8746.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{926.5454545454546, 0.}, {927.4545454545455, 8592.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{927.5454545454546, 0.}, {928.4545454545455, 8352.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{928.5454545454546, 0.}, {929.4545454545455, 8141.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{929.5454545454546, 0.}, {930.4545454545455, 8211.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{930.5454545454546, 0.}, {931.4545454545455, 8295.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{931.5454545454546, 0.}, {932.4545454545455, 8425.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{932.5454545454546, 0.}, {933.4545454545455, 8417.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{933.5454545454546, 0.}, {934.4545454545455, 8553.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{934.5454545454546, 0.}, {935.4545454545455, 8553.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{935.5454545454546, 0.}, {936.4545454545455, 8301.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{936.5454545454546, 0.}, {937.4545454545455, 8301.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{937.5454545454546, 0.}, {938.4545454545455, 8433.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{938.5454545454546, 0.}, {939.4545454545455, 8563.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{939.5454545454546, 0.}, {940.4545454545455, 8413.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{940.5454545454546, 0.}, {941.4545454545455, 8447.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{941.5454545454546, 0.}, {942.4545454545455, 8567.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{942.5454545454546, 0.}, {943.4545454545455, 8435.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{943.5454545454546, 0.}, {944.4545454545455, 8469.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{944.5454545454546, 0.}, {945.4545454545455, 8505.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{945.5454545454546, 0.}, {946.4545454545455, 8745.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{946.5454545454546, 0.}, {947.4545454545455, 8865.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{947.5454545454546, 0.}, {948.4545454545455, 8693.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{948.5454545454546, 0.}, {949.4545454545455, 8753.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{949.5454545454546, 0.}, {950.4545454545455, 8813.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{950.5454545454546, 0.}, {951.4545454545455, 8621.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{951.5454545454546, 0.}, {952.4545454545455, 8508.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{952.5454545454546, 0.}, {953.4545454545455, 8610.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{953.5454545454546, 0.}, {954.4545454545455, 8634.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{954.5454545454546, 0.}, {955.4545454545455, 8648.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{955.5454545454546, 0.}, {956.4545454545455, 8600.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{956.5454545454546, 0.}, {957.4545454545455, 8730.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{957.5454545454546, 0.}, {958.4545454545455, 8860.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{958.5454545454546, 0.}, {959.4545454545455, 9018.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{959.5454545454546, 0.}, {960.4545454545455, 9096.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{960.5454545454546, 0.}, {961.4545454545455, 8972.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{961.5454545454546, 0.}, {962.4545454545455, 8972.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{962.5454545454546, 0.}, {963.4545454545455, 9050.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{963.5454545454546, 0.}, {964.4545454545455, 9120.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{964.5454545454546, 0.}, {965.4545454545455, 9120.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{965.5454545454546, 0.}, {966.4545454545455, 9120.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{966.5454545454546, 0.}, {967.4545454545455, 8870.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{967.5454545454546, 0.}, {968.4545454545455, 8734.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{968.5454545454546, 0.}, {969.4545454545455, 8734.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{969.5454545454546, 0.}, {970.4545454545455, 8834.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{970.5454545454546, 0.}, {971.4545454545455, 8878.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{971.5454545454546, 0.}, {972.4545454545455, 8998.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{972.5454545454546, 0.}, {973.4545454545455, 8998.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{973.5454545454546, 0.}, {974.4545454545455, 9058.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{974.5454545454546, 0.}, {975.4545454545455, 9238.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{975.5454545454546, 0.}, {976.4545454545455, 9184.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{976.5454545454546, 0.}, {977.4545454545455, 9016.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{977.5454545454546, 0.}, {978.4545454545455, 9096.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{978.5454545454546, 0.}, {979.4545454545455, 9050.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{979.5454545454546, 0.}, {980.4545454545455, 8912.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{980.5454545454546, 0.}, {981.4545454545455, 8866.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{981.5454545454546, 0.}, {982.4545454545455, 9003.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{982.5454545454546, 0.}, {983.4545454545455, 8795.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{983.5454545454546, 0.}, {984.4545454545455, 8855.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{984.5454545454546, 0.}, {985.4545454545455, 8855.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{985.5454545454546, 0.}, {986.4545454545455, 9005.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{986.5454545454546, 0.}, {987.4545454545455, 8975.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{987.5454545454546, 0.}, {988.4545454545455, 9155.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{988.5454545454546, 0.}, {989.4545454545455, 9155.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{989.5454545454546, 0.}, {990.4545454545455, 9155.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{990.5454545454546, 0.}, {991.4545454545455, 8947.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{991.5454545454546, 0.}, {992.4545454545455, 8947.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{992.5454545454546, 0.}, {993.4545454545455, 9017.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{993.5454545454546, 0.}, {994.4545454545455, 9087.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{994.5454545454546, 0.}, {995.4545454545455, 9147.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{995.5454545454546, 0.}, {996.4545454545455, 9129.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{996.5454545454546, 0.}, {997.4545454545455, 9177.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{997.5454545454546, 0.}, {998.4545454545455, 9255.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{998.5454545454546, 0.}, {999.4545454545455, 9315.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{999.5454545454546, 0.}, {1000.4545454545455`, 9315.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1000.5454545454546`, 0.}, {1001.4545454545455`, 9189.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1001.5454545454546`, 0.}, {1002.4545454545455`, 9189.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1002.5454545454546`, 0.}, {1003.4545454545455`, 8849.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1003.5454545454546`, 0.}, {1004.4545454545455`, 8779.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1004.5454545454546`, 0.}, {1005.4545454545455`, 8779.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1005.5454545454546`, 0.}, {1006.4545454545455`, 8755.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1006.5454545454546`, 0.}, {1007.4545454545455`, 8935.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1007.5454545454546`, 0.}, {1008.4545454545455`, 8953.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1008.5454545454546`, 0.}, {1009.4545454545455`, 9023.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1009.5454545454546`, 0.}, {1010.4545454545455`, 9223.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1010.5454545454546`, 0.}, {1011.4545454545455`, 9245.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1011.5454545454546`, 0.}, {1012.4545454545455`, 9315.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1012.5454545454546`, 0.}, {1013.4545454545455`, 9343.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1013.5454545454546`, 0.}, {1014.4545454545455`, 9403.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1014.5454545454546`, 0.}, {1015.4545454545455`, 9441.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1015.5454545454546`, 0.}, {1016.4545454545455`, 9441.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1016.5454545454546`, 0.}, {1017.4545454545455`, 9429.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1017.5454545454546`, 0.}, {1018.4545454545455`, 9435.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1018.5454545454546`, 0.}, {1019.4545454545455`, 9459.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1019.5454545454546`, 0.}, {1020.4545454545455`, 9459.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1020.5454545454546`, 0.}, {1021.4545454545455`, 9291.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1021.5454545454546`, 0.}, {1022.4545454545455`, 8955.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1022.5454545454546`, 0.}, {1023.4545454545455`, 9009.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1023.5454545454546`, 0.}, {1024.4545454545455`, 8841.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1024.5454545454545`, 0.}, {1025.4545454545455`, 8901.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1025.5454545454545`, 0.}, {1026.4545454545455`, 8785.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1026.5454545454545`, 0.}, {1027.4545454545455`, 8747.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1027.5454545454545`, 0.}, {1028.4545454545455`, 8867.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1028.5454545454545`, 0.}, {1029.4545454545455`, 8867.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1029.5454545454545`, 0.}, {1030.4545454545455`, 8704.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1030.5454545454545`, 0.}, {1031.4545454545455`, 8746.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1031.5454545454545`, 0.}, {1032.4545454545455`, 8706.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1032.5454545454545`, 0.}, {1033.4545454545455`, 8894.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1033.5454545454545`, 0.}, {1034.4545454545455`, 8976.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1034.5454545454545`, 0.}, {1035.4545454545455`, 8934.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1035.5454545454545`, 0.}, {1036.4545454545455`, 8934.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1036.5454545454545`, 0.}, {1037.4545454545455`, 8934.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1037.5454545454545`, 0.}, {1038.4545454545455`, 8934.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1038.5454545454545`, 0.}, {1039.4545454545455`, 8934.},
       RoundingRadius->0]}, 
     {RGBColor[0, 1, 0], EdgeForm[Opacity[0.7]], 
      RectangleBox[{1039.5454545454545`, 0.}, {1040.4545454545455`, 8934.},
       RoundingRadius->
        0]}}, {}, {}}, {}, {{{{{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, \
{{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, {}}, {{}, \
{}}}, {}}, {}}, {}}, GraphicsGroupBox[
    {GrayLevel[0], 
     StyleBox[
      LineBox[{{{0.5454545454545454, 0.}, 
         Offset[{0, -4}, {0.5454545454545454, 0.}]}, {{1040.4545454545455`, 
         0.}, Offset[{0, -4}, {1040.4545454545455`, 0.}]}}],
      Antialiasing->False]}]},
  AspectRatio->NCache[
    Rational[1, 2], 0.5],
  Axes->{True, True},
  AxesLabel->{
    FormBox["\"Tag\"", TraditionalForm], 
    FormBox["\"kum. G/V\"", TraditionalForm]},
  AxesOrigin->{0.4545454545454546, 0},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  ImageSize->600,
  PlotRangePadding->Scaled[0.02],
  Ticks->{None, Automatic}]], "Output",
 CellChangeTimes->{{3.6166639052784815`*^9, 3.6166639133436956`*^9}, 
   3.6166708626543016`*^9, 3.6166721418173494`*^9, 3.616672279627991*^9, 
   3.616675744428878*^9, 3.6166759755054846`*^9, 3.6166760302575808`*^9, 
   3.616676392678417*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\

Na ja, durch die Konstante verschiebt sich die gesamte Kurve in der H\
\[ODoubleDot]he, mehr passiert da allerdings nicht.



Abschlie\[SZ]end mal wieder ein Plausibilit\[ADoubleDot]ts/Korrektheuitscheck:\
\>", "Text",
 CellChangeTimes->{{3.616663917930104*^9, 3.6166639439197493`*^9}, {
   3.616667913103921*^9, 3.616667951199188*^9}, {3.616672355802925*^9, 
   3.6166723559589252`*^9}, 3.616675744428878*^9, 3.6166760302575808`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"ListLinePlot", "[", 
    RowBox[{
     RowBox[{"cumulatedGV", "+", "startAccount"}], ",", " ", 
     RowBox[{"PlotStyle", "\[Rule]", "Red"}], ",", " ", 
     RowBox[{"ImageSize", "\[Rule]", "600"}], ",", " ", 
     RowBox[{"AspectRatio", " ", "\[Rule]", " ", 
      RowBox[{"1", "/", "2"}]}], ",", " ", 
     RowBox[{"AxesLabel", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{"\"\<Handelstag\>\"", ",", "\"\<Kum. G/V\>\""}], "}"}]}]}], 
    "]"}], ",", "\[IndentingNewLine]", 
   RowBox[{"ListPlot", "[", 
    RowBox[{"data", "[", 
     RowBox[{"[", 
      RowBox[{";;", ",", 
       RowBox[{"-", "1"}]}], "]"}], "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6166639608457794`*^9, 3.6166641405268946`*^9}, 
   3.616675744428878*^9, 3.6166758561932745`*^9, 3.6166760302575808`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {}, 
    {RGBColor[1, 0, 0], LineBox[CompressedData["
1:eJxd2H+UVGUdx/ErUE2lNibSZBrXX7QR2AhokxBef7IJ0XUlWFH0ivwYCXH4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      "]]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], PointBox[CompressedData["
1:eJxd2H+UVGUdx/ErZ6tJiUZBXEvlRkgrog6INgnSLUM2/MG4EqwIckXAERGG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      "]]}, {}}},
  AspectRatio->NCache[
    Rational[1, 2], 0.5],
  Axes->True,
  AxesLabel->{
    FormBox["\"Handelstag\"", TraditionalForm], 
    FormBox["\"Kum. G/V\"", TraditionalForm]},
  AxesOrigin->{0, 0},
  ImageSize->600,
  PlotRange->{{0., 1040.}, {0., 10292.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.616664039345117*^9, 3.61666410372643*^9}, 
   3.616664146969706*^9, 3.6166708628103023`*^9, 3.6166721419577494`*^9, 
   3.6166722797215915`*^9, 3.616675744444478*^9, 3.6166759756614847`*^9, 
   3.6166760302575808`*^9, 3.616676392881218*^9}]
}, Open  ]],

Cell["\<\
In der Abbildung ist die rote Linie die von mir berechnete kumulierte \
G/V-Kurve, und die blauen Punkte sind die aus der von PT gehosteten Tabelle. \
Passt also. 
Man kann aber noch nen Extratest machen, um wirklich sicher zu sein. Bei \
Differenzbildung beider Kurven muss jeder Wert 0 sein. 


Das sieht nach kumulierten Rundungsfehlern aus ? \
\>", "Text",
 CellChangeTimes->{{3.6166641518837147`*^9, 3.616664273423528*^9}, {
   3.6166643270096226`*^9, 3.616664344544053*^9}, 3.616675744444478*^9, 
   3.6166760302575808`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"differences", "=", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"cumulatedGV", "+", "startAccount"}], ")"}], "  ", "-", 
   RowBox[{"data", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", 
      RowBox[{"-", "1"}]}], "]"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.6166642381986666`*^9, 3.616664245561879*^9}, {
   3.616664281675943*^9, 3.616664289195156*^9}, {3.6166643502848635`*^9, 
   3.6166643531708684`*^9}, 3.616675744460078*^9, 3.6166760302575808`*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", 
   ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", 
   "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "0", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", 
   "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", 
   ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "1", ",", "2", ",", 
   "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", 
   ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
   "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", 
   ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
   "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", 
   ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
   "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", 
   ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
   "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", 
   ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
   "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", 
   ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
   "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", 
   ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
   "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", 
   ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
   "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", 
   ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
   "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", 
   ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
   "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", 
   ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", 
   "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", 
   ",", "2", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", "3", ",", 
   "3", ",", "3", ",", "3", ",", "3", ",", "3"}], "}"}]], "Output",
 CellChangeTimes->{3.616664289834757*^9, 3.616664353576469*^9, 
  3.6166708629351025`*^9, 3.6166721420357494`*^9, 3.616672279783992*^9, 
  3.6166757444756775`*^9, 3.616675975739485*^9, 3.616676030273181*^9, 
  3.6166763929748178`*^9}]
}, Open  ]],

Cell["\<\
Wo geht die 1 los und was f\[UDoubleDot]r Werte stehen da in beiden Listen:\
\>", "Text",
 CellChangeTimes->{{3.6166644374266167`*^9, 3.616664464009063*^9}, 
   3.6166757444756775`*^9, 3.616676030273181*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"indexOne", "=", " ", 
   RowBox[{"Flatten", "[", 
    RowBox[{"Position", "[", 
     RowBox[{"differences", ",", "1"}], "]"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6166643714385004`*^9, 3.616664446022231*^9}, 
   3.6166757444756775`*^9, 3.616676030273181*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TableForm", "[", 
  RowBox[{"data", "[", 
   RowBox[{"[", 
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{"indexOne", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "-", "1"}], ";;", " ", 
      RowBox[{
       RowBox[{"indexOne", "[", 
        RowBox[{"[", "1", "]"}], "]"}], "+", "1"}]}], ",", ";;"}], "]"}], 
   "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.6166646748746333`*^9, 3.616664716698307*^9}, 
   3.6166757444756775`*^9, 3.616676030273181*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"2012-02-29\"\>", "23", "140", "6195", "8195"},
    {"\<\"2012-03-01\"\>", "23", 
     RowBox[{"-", "163"}], "6031", "8031"},
    {"\<\"2012-03-02\"\>", "23", "89", "6120", "8120"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.6166646852174516`*^9, 3.6166647172443075`*^9}, 
   3.6166708630287027`*^9, 3.6166721421293497`*^9, 3.6166722799243917`*^9, 
   3.6166757444756775`*^9, 3.616675975833085*^9, 3.616676030273181*^9, 
   3.616676393068418*^9}]
}, Open  ]],

Cell["\<\
In der Textdatei findet man an der Stelle:
2012-02-28\t23\t70\t6,055\t8,055
2012-02-29\t23\t140\t6,195\t8,195
2012-03-01\t23\t-163\t6,031\t8,031
2012-03-02\t23\t89\t6,120\t8,120
2012-03-05\t23\t140\t6,260\t8,260
\
\>", "Text",
 CellChangeTimes->{{3.6166643634512863`*^9, 3.616664366633692*^9}, {
   3.6166648231684937`*^9, 3.6166648332149115`*^9}, 3.6166757444756775`*^9, 
   3.616676030273181*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"cumulatedGV", "+", "startAccount"}], ")"}], " ", "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{
     RowBox[{"indexOne", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "1"}], ";;", " ", 
    RowBox[{
     RowBox[{"indexOne", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "+", "1"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.616665268986077*^9, 3.616665321682969*^9}, 
   3.6166757444756775`*^9, 3.616676030273181*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8195", ",", "8032", ",", "8121"}], "}"}]], "Output",
 CellChangeTimes->{3.616665322509771*^9, 3.6166708630911026`*^9, 
  3.61667214219175*^9, 3.616672280017992*^9, 3.6166757444756775`*^9, 
  3.616675975911085*^9, 3.616676030273181*^9, 3.616676393130818*^9}]
}, Open  ]],

Cell["\<\


Ok, das ist vermutlich so ein echt mieser subtiler Fehler in den \
Datenformaten, die hat man zum Gl\[UDoubleDot]ck recht selten. Mal pr\
\[UDoubleDot]fen:\
\>", "Text",
 CellChangeTimes->{{3.6166653414638042`*^9, 3.6166653928034945`*^9}, {
   3.6166658306338634`*^9, 3.616665836749074*^9}, 3.6166757444756775`*^9, 
   3.616676030273181*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"gvData", "=", 
   RowBox[{
    RowBox[{"data", "[", 
     RowBox[{"[", 
      RowBox[{";;", ",", " ", "gVCol"}], "]"}], "]"}], " ", "//", "N"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"cleanCumulatedGV", "=", 
   RowBox[{"Accumulate", "[", "gvData", "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.6166654121631284`*^9, 3.616665443378783*^9}, 
   3.6166757444912777`*^9, 3.616676030273181*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"cleanCumulatedGV", "+", "startAccount"}], ")"}], " ", "[", 
  RowBox[{"[", 
   RowBox[{
    RowBox[{
     RowBox[{"indexOne", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "-", "1"}], ";;", " ", 
    RowBox[{
     RowBox[{"indexOne", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "+", "1"}]}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.616665451178797*^9, 3.6166654567168064`*^9}, 
   3.6166757444912777`*^9, 3.616676030273181*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"8195.`", ",", "8032.`", ",", "8121.`"}], "}"}]], "Output",
 CellChangeTimes->{3.6166654586824102`*^9, 3.616670863184703*^9, 
  3.61667214228535*^9, 3.6166722802363925`*^9, 3.6166757444912777`*^9, 
  3.616675975989085*^9, 3.616676030273181*^9, 3.616676393255618*^9}]
}, Open  ]],

Cell[TextData[{
 "Hmm, das geht auch nicht (Umwandeln in einfache Zahlen statt Symbols), die \
Unterschiede bleiben. \n\n\nAlso nochmal in die Originaldaten schauen und Old \
School vergleichen.  Im Google-Spreadsheet stand: \n\n",
 Cell[BoxData[
  GraphicsBox[{
    TagBox[RasterBox[CompressedData["
1:eJztvfGrZdl133mZ+R/qx6Zr9IN/0egX/2QIDZpu078IBg+kQTQKJhQocg89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      "], {{0, 557}, {648, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False], 
    {Thickness[0.0005754399373371566], StrokeForm[RGBColor[1, 1, 0]], 
     EdgeForm[{RGBColor[1, 1, 0], Opacity[1.], Thickness[
     0.0005754399373371566]}], FaceForm[RGBColor[
     0.798413061722744, 0.824719615472648, 0.968322270542458]], 
     ArrowBox[{{563., 256.}, {567., 223.}}]}},
   BaseStyle->"ImageGraphics",
   ImagePadding->{{0., 0.}, {0., 0.}},
   ImageSize->Automatic,
   ImageSizeRaw->{648, 557},
   PlotRange->{{0., 648.}, {0., 557.}},
   PlotRangePadding->Automatic]], "Input"]
}], "Text",
 CellChangeTimes->{{3.6166655432189584`*^9, 3.6166655971014533`*^9}, {
   3.616665741027306*^9, 3.616665741183306*^9}, 3.616665775768567*^9, {
   3.616665843035885*^9, 3.6166658671223273`*^9}, {3.616665964192498*^9, 
   3.6166659688101063`*^9}, {3.6166757445380783`*^9, 
   3.6166757445380783`*^9}, {3.616676030273181*^9, 3.616676030273181*^9}}],

Cell["", "Text",
 CellChangeTimes->{{3.61666108039432*^9, 3.616661080815521*^9}, {
   3.616663775579854*^9, 3.616663791382682*^9}, 3.616663844781575*^9, {
   3.6166656186138906`*^9, 3.616665636273122*^9}, 3.6166757445380783`*^9, 
   3.616676030273181*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"8195", "-", "163"}]], "Input",
 CellChangeTimes->{{3.6166656372559233`*^9, 3.616665638129525*^9}, 
   3.6166757445380783`*^9, 3.616676030273181*^9}],

Cell[BoxData["8032"], "Output",
 CellChangeTimes->{3.616665638519526*^9, 3.616670863278303*^9, 
  3.61667214234775*^9, 3.6166722803299923`*^9, 3.6166757445380783`*^9, 
  3.616675976051485*^9, 3.616676030273181*^9, 3.6166763933180184`*^9}]
}, Open  ]],

Cell["\<\
N\[ODoubleDot]\[ODoubleDot], dann ist es kein Rundungsfehler, sondern in der \
Tabelle steht tats\[ADoubleDot]chlich ein falscher Wert. Sowas kommt \
vermutlich noch 2 mal vor, damit kumuliert sich das auf die maximal 3 Punkte \
Unterschied aus der obigen Liste. Kann auch vom Google erzeugt worden sein, \
ich wei\[SZ] ja  nicht, wer die reinkodiert hat. 

Solange die Fehler kein gr\[ODoubleDot]\[SZ]eres Ausma\[SZ] annehmen, ist es \
ja harmlos. Da hab ich schon Datentabellen mit erheblich mehr Fehlern \
bearbeitet. \
\>", "Text",
 CellChangeTimes->{{3.616665650422347*^9, 3.6166657184540663`*^9}, {
   3.6166657990126076`*^9, 3.6166658136922336`*^9}, {3.6166659905097446`*^9, 
   3.616666132204793*^9}, {3.616667993990063*^9, 3.6166680022580776`*^9}, {
   3.616672442773078*^9, 3.6166724481394873`*^9}, 3.616675744553678*^9, 
   3.616676030273181*^9}],

Cell["\<\


\
\>", "Text",
 CellChangeTimes->{{3.61666108039432*^9, 3.616661080815521*^9}, {
   3.616663775579854*^9, 3.616663791382682*^9}, 3.616663844781575*^9, {
   3.6166656186138906`*^9, 3.6166656309535127`*^9}, {3.6166661370720015`*^9, 
   3.6166661372124023`*^9}, 3.616675744553678*^9, 3.616676030273181*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Erg\[ADoubleDot]nzende Betrachtung durch Hinzunahme der Dax-Kursdaten\
\>", "Subtitle",
 CellChangeTimes->{{3.616661063920691*^9, 3.616661098225151*^9}, 
   3.616675744553678*^9, 3.616676030273181*^9}],

Cell[TextData[{
 "\n Ich nehm\[CloseCurlyQuote] erstmal den \[OpenCurlyDoubleQuote]normalen\
\[CloseCurlyDoubleQuote] Daxperformance-Index aus der ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 "-Datenbank. Das ist nat\[UDoubleDot]rlich nicht der korrekte Datensatz, \
aber als erster Anhaltspunkt sollte es schon mal Ideen liefern, hoffe ich. \n\
\n\nIch ben\[ODoubleDot]tige dazu Start- und Enddatum, damit ich nur diese \
Daten gezielt aus der Datenbank abrufen kann. Format: date,O,H,L,C,V, "
}], "Text",
 CellChangeTimes->{{3.616658857031615*^9, 3.616658925546935*^9}, {
   3.616659026213912*^9, 3.6166590636539774`*^9}, {3.616661102561959*^9, 
   3.6166611490812407`*^9}, {3.6166611793608937`*^9, 3.616661209172546*^9}, {
   3.6166661395524063`*^9, 3.6166661433900127`*^9}, 3.616675744553678*^9, 
   3.616676030273181*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"startDate", "=", " ", 
  RowBox[{"data", "[", 
   RowBox[{"[", 
    RowBox[{"1", ",", "dateCol"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.6166589679634094`*^9, 3.616658993547455*^9}, 
   3.616675744553678*^9, 3.616676030273181*^9}],

Cell[BoxData["\<\"2010-01-04\"\>"], "Output",
 CellChangeTimes->{{3.616658983095436*^9, 3.6166589955130577`*^9}, 
   3.616670863356303*^9, 3.6166721424101505`*^9, 3.6166722804235926`*^9, 
   3.616675744553678*^9, 3.616675976113886*^9, 3.616676030273181*^9, 
   3.6166763933960185`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"endDate", "=", " ", 
  RowBox[{
   RowBox[{"data", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", "dateCol"}], "]"}], "]"}], "[", 
   RowBox[{"[", 
    RowBox[{"-", "1"}], "]"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.616658989007847*^9, 3.6166590201611013`*^9}, 
   3.616675744553678*^9, 3.616676030273181*^9}],

Cell[BoxData["\<\"2013-12-30\"\>"], "Output",
 CellChangeTimes->{{3.6166590063394775`*^9, 3.6166590208787026`*^9}, 
   3.6166708634343033`*^9, 3.6166721424725504`*^9, 3.616672280517193*^9, 
   3.616675744553678*^9, 3.6166759761762857`*^9, 3.616676030273181*^9, 
   3.6166763934740186`*^9}]
}, Open  ]],

Cell["\<\
Man muss auch das Format des Datums nicht anpassen, das ist ja schon mal sch\
\[ODoubleDot]n. \
\>", "Text",
 CellChangeTimes->{{3.6166591120764627`*^9, 3.616659129345693*^9}, 
   3.6166612162549586`*^9, 3.616666156072835*^9, 3.616675744553678*^9, 
   3.616676030273181*^9}],

Cell["\<\
Mal sehen, was beim Dax in dem Zeitraum f\[UDoubleDot]r Daten drin sind: \
\>", "Text",
 CellChangeTimes->{{3.6166591394545107`*^9, 3.616659139594911*^9}, {
   3.616659652664212*^9, 3.6166596671098375`*^9}, {3.616666158225639*^9, 
   3.61666615894324*^9}, 3.616675744553678*^9, 3.616676030273181*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"TradingChart", "[", 
  RowBox[{
   RowBox[{"FinancialData", "[", 
    RowBox[{"\"\<^GDaxi\>\"", ",", "\"\<OHLCV\>\"", ",", 
     RowBox[{"{", 
      RowBox[{"startDate", ",", "endDate"}], "}"}]}], "]"}], ",", " ", 
   RowBox[{"ImageSize", "\[Rule]", "600"}], ",", " ", 
   RowBox[{"AspectRatio", "\[Rule]", " ", 
    RowBox[{"1", "/", "2"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.6166593190732265`*^9, 3.6166593577612944`*^9}, {
   3.616659408398983*^9, 3.616659408695384*^9}, {3.616659449239855*^9, 
   3.6166594694106903`*^9}, {3.616659528550394*^9, 3.6166595608580513`*^9}, {
   3.6166596048813286`*^9, 3.6166596125721416`*^9}, 3.616675744553678*^9, 
   3.6166758974709473`*^9, 3.616676030273181*^9}],

Cell[BoxData[
 GraphicsBox[
  DynamicModuleBox[{System`TradingChartDump`$timestampdepth$5891 = "Full", 
   System`TradingChartDump`$highlightposition$5891 = Automatic, 
   System`TradingChartDump`$timestampstyle$5891 = Directive[
    GrayLevel[0.75], 
    Opacity[0.25]], System`TradingChartDump`$dates$5891 = CompressedData["
1:eJxd2VmOHNcVRVEqo7nR901GRmYJmpKH4AHY83UzF6sgPniBHwTX791xStBj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   "], System`TradingChartDump`$visdates$5891 = {
   "Mon. Jan 04, 2010", "Tue. Jan 05, 2010", "Wed. Jan 06, 2010", 
    "Thu. Jan 07, 2010", "Fri. Jan 08, 2010", "Mon. Jan 11, 2010", 
    "Tue. Jan 12, 2010", "Wed. Jan 13, 2010", "Thu. Jan 14, 2010", 
    "Fri. Jan 15, 2010", "Mon. Jan 18, 2010", "Tue. Jan 19, 2010", 
    "Wed. Jan 20, 2010", "Thu. Jan 21, 2010", "Fri. Jan 22, 2010", 
    "Mon. Jan 25, 2010", "Tue. Jan 26, 2010", "Wed. Jan 27, 2010", 
    "Thu. Jan 28, 2010", "Fri. Jan 29, 2010", "Mon. Feb 01, 2010", 
    "Tue. Feb 02, 2010", "Wed. Feb 03, 2010", "Thu. Feb 04, 2010", 
    "Fri. Feb 05, 2010", "Mon. Feb 08, 2010", "Tue. Feb 09, 2010", 
    "Wed. Feb 10, 2010", "Thu. Feb 11, 2010", "Fri. Feb 12, 2010", 
    "Mon. Feb 15, 2010", "Tue. Feb 16, 2010", "Wed. Feb 17, 2010", 
    "Thu. Feb 18, 2010", "Fri. Feb 19, 2010", "Mon. Feb 22, 2010", 
    "Tue. Feb 23, 2010", "Wed. Feb 24, 2010", "Thu. Feb 25, 2010", 
    "Fri. Feb 26, 2010", "Mon. Mar 01, 2010", "Tue. Mar 02, 2010", 
    "Wed. Mar 03, 2010", "Thu. Mar 04, 2010", "Fri. Mar 05, 2010", 
    "Mon. Mar 08, 2010", "Tue. Mar 09, 2010", "Wed. Mar 10, 2010", 
    "Thu. Mar 11, 2010", "Fri. Mar 12, 2010", "Mon. Mar 15, 2010", 
    "Tue. Mar 16, 2010", "Wed. Mar 17, 2010", "Thu. Mar 18, 2010", 
    "Fri. Mar 19, 2010", "Mon. Mar 22, 2010", "Tue. Mar 23, 2010", 
    "Wed. Mar 24, 2010", "Thu. Mar 25, 2010", "Fri. Mar 26, 2010", 
    "Mon. Mar 29, 2010", "Tue. Mar 30, 2010", "Wed. Mar 31, 2010", 
    "Thu. Apr 01, 2010", "Mon. Apr 05, 2010", "Tue. Apr 06, 2010", 
    "Wed. Apr 07, 2010", "Thu. Apr 08, 2010", "Fri. Apr 09, 2010", 
    "Mon. Apr 12, 2010", "Tue. Apr 13, 2010", "Wed. Apr 14, 2010", 
    "Thu. Apr 15, 2010", "Fri. Apr 16, 2010", "Mon. Apr 19, 2010", 
    "Tue. Apr 20, 2010", "Wed. Apr 21, 2010", "Thu. Apr 22, 2010", 
    "Fri. Apr 23, 2010", "Mon. Apr 26, 2010", "Tue. Apr 27, 2010", 
    "Wed. Apr 28, 2010", "Thu. Apr 29, 2010", "Fri. Apr 30, 2010", 
    "Mon. May 03, 2010", "Tue. May 04, 2010", "Wed. May 05, 2010", 
    "Thu. May 06, 2010", "Fri. May 07, 2010", "Mon. May 10, 2010", 
    "Tue. May 11, 2010", "Wed. May 12, 2010", "Thu. May 13, 2010", 
    "Fri. May 14, 2010", "Mon. May 17, 2010", "Tue. May 18, 2010", 
    "Wed. May 19, 2010", "Thu. May 20, 2010", "Fri. May 21, 2010", 
    "Mon. May 24, 2010", "Tue. May 25, 2010", "Wed. May 26, 2010", 
    "Thu. May 27, 2010", "Fri. May 28, 2010", "Mon. May 31, 2010", 
    "Tue. Jun 01, 2010", "Wed. Jun 02, 2010", "Thu. Jun 03, 2010", 
    "Fri. Jun 04, 2010", "Mon. Jun 07, 2010", "Tue. Jun 08, 2010", 
    "Wed. Jun 09, 2010", "Thu. Jun 10, 2010", "Fri. Jun 11, 2010", 
    "Mon. Jun 14, 2010", "Tue. Jun 15, 2010", "Wed. Jun 16, 2010", 
    "Thu. Jun 17, 2010", "Fri. Jun 18, 2010", "Mon. Jun 21, 2010", 
    "Tue. Jun 22, 2010", "Wed. Jun 23, 2010", "Thu. Jun 24, 2010", 
    "Fri. Jun 25, 2010", "Mon. Jun 28, 2010", "Tue. Jun 29, 2010", 
    "Wed. Jun 30, 2010", "Thu. Jul 01, 2010", "Fri. Jul 02, 2010", 
    "Mon. Jul 05, 2010", "Tue. Jul 06, 2010", "Wed. Jul 07, 2010", 
    "Thu. Jul 08, 2010", "Fri. Jul 09, 2010", "Mon. Jul 12, 2010", 
    "Tue. Jul 13, 2010", "Wed. Jul 14, 2010", "Thu. Jul 15, 2010", 
    "Fri. Jul 16, 2010", "Mon. Jul 19, 2010", "Tue. Jul 20, 2010", 
    "Wed. Jul 21, 2010", "Thu. Jul 22, 2010", "Fri. Jul 23, 2010", 
    "Mon. Jul 26, 2010", "Tue. Jul 27, 2010", "Wed. Jul 28, 2010", 
    "Thu. Jul 29, 2010", "Fri. Jul 30, 2010", "Mon. Aug 02, 2010", 
    "Tue. Aug 03, 2010", "Wed. Aug 04, 2010", "Thu. Aug 05, 2010", 
    "Fri. Aug 06, 2010", "Mon. Aug 09, 2010", "Tue. Aug 10, 2010", 
    "Wed. Aug 11, 2010", "Thu. Aug 12, 2010", "Fri. Aug 13, 2010", 
    "Mon. Aug 16, 2010", "Tue. Aug 17, 2010", "Wed. Aug 18, 2010", 
    "Thu. Aug 19, 2010", "Fri. Aug 20, 2010", "Mon. Aug 23, 2010", 
    "Tue. Aug 24, 2010", "Wed. Aug 25, 2010", "Thu. Aug 26, 2010", 
    "Fri. Aug 27, 2010", "Mon. Aug 30, 2010", "Tue. Aug 31, 2010", 
    "Wed. Sep 01, 2010", "Thu. Sep 02, 2010", "Fri. Sep 03, 2010", 
    "Mon. Sep 06, 2010", "Tue. Sep 07, 2010", "Wed. Sep 08, 2010", 
    "Thu. Sep 09, 2010", "Fri. Sep 10, 2010", "Mon. Sep 13, 2010", 
    "Tue. Sep 14, 2010", "Wed. Sep 15, 2010", "Thu. Sep 16, 2010", 
    "Fri. Sep 17, 2010", "Mon. Sep 20, 2010", "Tue. Sep 21, 2010", 
    "Wed. Sep 22, 2010", "Thu. Sep 23, 2010", "Fri. Sep 24, 2010", 
    "Mon. Sep 27, 2010", "Tue. Sep 28, 2010", "Wed. Sep 29, 2010", 
    "Thu. Sep 30, 2010", "Fri. Oct 01, 2010", "Mon. Oct 04, 2010", 
    "Tue. Oct 05, 2010", "Wed. Oct 06, 2010", "Thu. Oct 07, 2010", 
    "Fri. Oct 08, 2010", "Mon. Oct 11, 2010", "Tue. Oct 12, 2010", 
    "Wed. Oct 13, 2010", "Thu. Oct 14, 2010", "Fri. Oct 15, 2010", 
    "Mon. Oct 18, 2010", "Tue. Oct 19, 2010", "Wed. Oct 20, 2010", 
    "Thu. Oct 21, 2010", "Fri. Oct 22, 2010", "Mon. Oct 25, 2010", 
    "Tue. Oct 26, 2010", "Wed. Oct 27, 2010", "Thu. Oct 28, 2010", 
    "Fri. Oct 29, 2010", "Mon. Nov 01, 2010", "Tue. Nov 02, 2010", 
    "Wed. Nov 03, 2010", "Thu. Nov 04, 2010", "Fri. Nov 05, 2010", 
    "Mon. Nov 08, 2010", "Tue. Nov 09, 2010", "Wed. Nov 10, 2010", 
    "Thu. Nov 11, 2010", "Fri. Nov 12, 2010", "Mon. Nov 15, 2010", 
    "Tue. Nov 16, 2010", "Wed. Nov 17, 2010", "Thu. Nov 18, 2010", 
    "Fri. Nov 19, 2010", "Mon. Nov 22, 2010", "Tue. Nov 23, 2010", 
    "Wed. Nov 24, 2010", "Thu. Nov 25, 2010", "Fri. Nov 26, 2010", 
    "Mon. Nov 29, 2010", "Tue. Nov 30, 2010", "Wed. Dec 01, 2010", 
    "Thu. Dec 02, 2010", "Fri. Dec 03, 2010", "Mon. Dec 06, 2010", 
    "Tue. Dec 07, 2010", "Wed. Dec 08, 2010", "Thu. Dec 09, 2010", 
    "Fri. Dec 10, 2010", "Mon. Dec 13, 2010", "Tue. Dec 14, 2010", 
    "Wed. Dec 15, 2010", "Thu. Dec 16, 2010", "Fri. Dec 17, 2010", 
    "Mon. Dec 20, 2010", "Tue. Dec 21, 2010", "Wed. Dec 22, 2010", 
    "Thu. Dec 23, 2010", "Mon. Dec 27, 2010", "Tue. Dec 28, 2010", 
    "Wed. Dec 29, 2010", "Thu. Dec 30, 2010", "Fri. Dec 31, 2010", 
    "Mon. Jan 03, 2011", "Tue. Jan 04, 2011", "Wed. Jan 05, 2011", 
    "Thu. Jan 06, 2011", "Fri. Jan 07, 2011", "Mon. Jan 10, 2011", 
    "Tue. Jan 11, 2011", "Wed. Jan 12, 2011", "Thu. Jan 13, 2011", 
    "Fri. Jan 14, 2011", "Mon. Jan 17, 2011", "Tue. Jan 18, 2011", 
    "Wed. Jan 19, 2011", "Thu. Jan 20, 2011", "Fri. Jan 21, 2011", 
    "Mon. Jan 24, 2011", "Tue. Jan 25, 2011", "Wed. Jan 26, 2011", 
    "Thu. Jan 27, 2011", "Fri. Jan 28, 2011", "Mon. Jan 31, 2011", 
    "Tue. Feb 01, 2011", "Wed. Feb 02, 2011", "Thu. Feb 03, 2011", 
    "Fri. Feb 04, 2011", "Mon. Feb 07, 2011", "Tue. Feb 08, 2011", 
    "Wed. Feb 09, 2011", "Thu. Feb 10, 2011", "Fri. Feb 11, 2011", 
    "Mon. Feb 14, 2011", "Tue. Feb 15, 2011", "Wed. Feb 16, 2011", 
    "Thu. Feb 17, 2011", "Fri. Feb 18, 2011", "Mon. Feb 21, 2011", 
    "Tue. Feb 22, 2011", "Wed. Feb 23, 2011", "Thu. Feb 24, 2011", 
    "Fri. Feb 25, 2011", "Mon. Feb 28, 2011", "Tue. Mar 01, 2011", 
    "Wed. Mar 02, 2011", "Thu. Mar 03, 2011", "Fri. Mar 04, 2011", 
    "Mon. Mar 07, 2011", "Tue. Mar 08, 2011", "Wed. Mar 09, 2011", 
    "Thu. Mar 10, 2011", "Fri. Mar 11, 2011", "Mon. Mar 14, 2011", 
    "Tue. Mar 15, 2011", "Wed. Mar 16, 2011", "Thu. Mar 17, 2011", 
    "Fri. Mar 18, 2011", "Mon. Mar 21, 2011", "Tue. Mar 22, 2011", 
    "Wed. Mar 23, 2011", "Thu. Mar 24, 2011", "Fri. Mar 25, 2011", 
    "Mon. Mar 28, 2011", "Tue. Mar 29, 2011", "Wed. Mar 30, 2011", 
    "Thu. Mar 31, 2011", "Fri. Apr 01, 2011", "Mon. Apr 04, 2011", 
    "Tue. Apr 05, 2011", "Wed. Apr 06, 2011", "Thu. Apr 07, 2011", 
    "Fri. Apr 08, 2011", "Mon. Apr 11, 2011", "Tue. Apr 12, 2011", 
    "Wed. Apr 13, 2011", "Thu. Apr 14, 2011", "Fri. Apr 15, 2011", 
    "Mon. Apr 18, 2011", "Tue. Apr 19, 2011", "Wed. Apr 20, 2011", 
    "Thu. Apr 21, 2011", "Mon. Apr 25, 2011", "Tue. Apr 26, 2011", 
    "Wed. Apr 27, 2011", "Thu. Apr 28, 2011", "Fri. Apr 29, 2011", 
    "Mon. May 02, 2011", "Tue. May 03, 2011", "Wed. May 04, 2011", 
    "Thu. May 05, 2011", "Fri. May 06, 2011", "Mon. May 09, 2011", 
    "Tue. May 10, 2011", "Wed. May 11, 2011", "Thu. May 12, 2011", 
    "Fri. May 13, 2011", "Mon. May 16, 2011", "Tue. May 17, 2011", 
    "Wed. May 18, 2011", "Thu. May 19, 2011", "Fri. May 20, 2011", 
    "Mon. May 23, 2011", "Tue. May 24, 2011", "Wed. May 25, 2011", 
    "Thu. May 26, 2011", "Fri. May 27, 2011", "Mon. May 30, 2011", 
    "Tue. May 31, 2011", "Wed. Jun 01, 2011", "Thu. Jun 02, 2011", 
    "Fri. Jun 03, 2011", "Mon. Jun 06, 2011", "Tue. Jun 07, 2011", 
    "Wed. Jun 08, 2011", "Thu. Jun 09, 2011", "Fri. Jun 10, 2011", 
    "Mon. Jun 13, 2011", "Tue. Jun 14, 2011", "Wed. Jun 15, 2011", 
    "Thu. Jun 16, 2011", "Fri. Jun 17, 2011", "Mon. Jun 20, 2011", 
    "Tue. Jun 21, 2011", "Wed. Jun 22, 2011", "Thu. Jun 23, 2011", 
    "Fri. Jun 24, 2011", "Mon. Jun 27, 2011", "Tue. Jun 28, 2011", 
    "Wed. Jun 29, 2011", "Thu. Jun 30, 2011", "Fri. Jul 01, 2011", 
    "Mon. Jul 04, 2011", "Tue. Jul 05, 2011", "Wed. Jul 06, 2011", 
    "Thu. Jul 07, 2011", "Fri. Jul 08, 2011", "Mon. Jul 11, 2011", 
    "Tue. Jul 12, 2011", "Wed. Jul 13, 2011", "Thu. Jul 14, 2011", 
    "Fri. Jul 15, 2011", "Mon. Jul 18, 2011", "Tue. Jul 19, 2011", 
    "Wed. Jul 20, 2011", "Thu. Jul 21, 2011", "Fri. Jul 22, 2011", 
    "Mon. Jul 25, 2011", "Tue. Jul 26, 2011", "Wed. Jul 27, 2011", 
    "Thu. Jul 28, 2011", "Fri. Jul 29, 2011", "Mon. Aug 01, 2011", 
    "Tue. Aug 02, 2011", "Wed. Aug 03, 2011", "Thu. Aug 04, 2011", 
    "Fri. Aug 05, 2011", "Mon. Aug 08, 2011", "Tue. Aug 09, 2011", 
    "Wed. Aug 10, 2011", "Thu. Aug 11, 2011", "Fri. Aug 12, 2011", 
    "Mon. Aug 15, 2011", "Tue. Aug 16, 2011", "Wed. Aug 17, 2011", 
    "Thu. Aug 18, 2011", "Fri. Aug 19, 2011", "Mon. Aug 22, 2011", 
    "Tue. Aug 23, 2011", "Wed. Aug 24, 2011", "Thu. Aug 25, 2011", 
    "Fri. Aug 26, 2011", "Mon. Aug 29, 2011", "Tue. Aug 30, 2011", 
    "Wed. Aug 31, 2011", "Thu. Sep 01, 2011", "Fri. Sep 02, 2011", 
    "Mon. Sep 05, 2011", "Tue. Sep 06, 2011", "Wed. Sep 07, 2011", 
    "Thu. Sep 08, 2011", "Fri. Sep 09, 2011", "Mon. Sep 12, 2011", 
    "Tue. Sep 13, 2011", "Wed. Sep 14, 2011", "Thu. Sep 15, 2011", 
    "Fri. Sep 16, 2011", "Mon. Sep 19, 2011", "Tue. Sep 20, 2011", 
    "Wed. Sep 21, 2011", "Thu. Sep 22, 2011", "Fri. Sep 23, 2011", 
    "Mon. Sep 26, 2011", "Tue. Sep 27, 2011", "Wed. Sep 28, 2011", 
    "Thu. Sep 29, 2011", "Fri. Sep 30, 2011", "Mon. Oct 03, 2011", 
    "Tue. Oct 04, 2011", "Wed. Oct 05, 2011", "Thu. Oct 06, 2011", 
    "Fri. Oct 07, 2011", "Mon. Oct 10, 2011", "Tue. Oct 11, 2011", 
    "Wed. Oct 12, 2011", "Thu. Oct 13, 2011", "Fri. Oct 14, 2011", 
    "Mon. Oct 17, 2011", "Tue. Oct 18, 2011", "Wed. Oct 19, 2011", 
    "Thu. Oct 20, 2011", "Fri. Oct 21, 2011", "Mon. Oct 24, 2011", 
    "Tue. Oct 25, 2011", "Wed. Oct 26, 2011", "Thu. Oct 27, 2011", 
    "Fri. Oct 28, 2011", "Mon. Oct 31, 2011", "Tue. Nov 01, 2011", 
    "Wed. Nov 02, 2011", "Thu. Nov 03, 2011", "Fri. Nov 04, 2011", 
    "Mon. Nov 07, 2011", "Tue. Nov 08, 2011", "Wed. Nov 09, 2011", 
    "Thu. Nov 10, 2011", "Fri. Nov 11, 2011", "Mon. Nov 14, 2011", 
    "Tue. Nov 15, 2011", "Wed. Nov 16, 2011", "Thu. Nov 17, 2011", 
    "Fri. Nov 18, 2011", "Mon. Nov 21, 2011", "Tue. Nov 22, 2011", 
    "Wed. Nov 23, 2011", "Thu. Nov 24, 2011", "Fri. Nov 25, 2011", 
    "Mon. Nov 28, 2011", "Tue. Nov 29, 2011", "Wed. Nov 30, 2011", 
    "Thu. Dec 01, 2011", "Fri. Dec 02, 2011", "Mon. Dec 05, 2011", 
    "Tue. Dec 06, 2011", "Wed. Dec 07, 2011", "Thu. Dec 08, 2011", 
    "Fri. Dec 09, 2011", "Mon. Dec 12, 2011", "Tue. Dec 13, 2011", 
    "Wed. Dec 14, 2011", "Thu. Dec 15, 2011", "Fri. Dec 16, 2011", 
    "Mon. Dec 19, 2011", "Tue. Dec 20, 2011", "Wed. Dec 21, 2011", 
    "Thu. Dec 22, 2011", "Fri. Dec 23, 2011", "Tue. Dec 27, 2011", 
    "Wed. Dec 28, 2011", "Thu. Dec 29, 2011", "Fri. Dec 30, 2011", 
    "Tue. Jan 03, 2012", "Wed. Jan 04, 2012", "Thu. Jan 05, 2012", 
    "Fri. Jan 06, 2012", "Mon. Jan 09, 2012", "Tue. Jan 10, 2012", 
    "Wed. Jan 11, 2012", "Thu. Jan 12, 2012", "Fri. Jan 13, 2012", 
    "Mon. Jan 16, 2012", "Tue. Jan 17, 2012", "Wed. Jan 18, 2012", 
    "Thu. Jan 19, 2012", "Fri. Jan 20, 2012", "Mon. Jan 23, 2012", 
    "Tue. Jan 24, 2012", "Wed. Jan 25, 2012", "Thu. Jan 26, 2012", 
    "Fri. Jan 27, 2012", "Mon. Jan 30, 2012", "Tue. Jan 31, 2012", 
    "Wed. Feb 01, 2012", "Thu. Feb 02, 2012", "Fri. Feb 03, 2012", 
    "Mon. Feb 06, 2012", "Tue. Feb 07, 2012", "Wed. Feb 08, 2012", 
    "Thu. Feb 09, 2012", "Fri. Feb 10, 2012", "Mon. Feb 13, 2012", 
    "Tue. Feb 14, 2012", "Wed. Feb 15, 2012", "Thu. Feb 16, 2012", 
    "Fri. Feb 17, 2012", "Mon. Feb 20, 2012", "Tue. Feb 21, 2012", 
    "Wed. Feb 22, 2012", "Thu. Feb 23, 2012", "Fri. Feb 24, 2012", 
    "Mon. Feb 27, 2012", "Tue. Feb 28, 2012", "Wed. Feb 29, 2012", 
    "Thu. Mar 01, 2012", "Fri. Mar 02, 2012", "Mon. Mar 05, 2012", 
    "Tue. Mar 06, 2012", "Wed. Mar 07, 2012", "Thu. Mar 08, 2012", 
    "Fri. Mar 09, 2012", "Mon. Mar 12, 2012", "Tue. Mar 13, 2012", 
    "Wed. Mar 14, 2012", "Thu. Mar 15, 2012", "Fri. Mar 16, 2012", 
    "Mon. Mar 19, 2012", "Tue. Mar 20, 2012", "Wed. Mar 21, 2012", 
    "Thu. Mar 22, 2012", "Fri. Mar 23, 2012", "Mon. Mar 26, 2012", 
    "Tue. Mar 27, 2012", "Wed. Mar 28, 2012", "Thu. Mar 29, 2012", 
    "Fri. Mar 30, 2012", "Mon. Apr 02, 2012", "Tue. Apr 03, 2012", 
    "Wed. Apr 04, 2012", "Thu. Apr 05, 2012", "Tue. Apr 10, 2012", 
    "Wed. Apr 11, 2012", "Thu. Apr 12, 2012", "Fri. Apr 13, 2012", 
    "Mon. Apr 16, 2012", "Tue. Apr 17, 2012", "Wed. Apr 18, 2012", 
    "Thu. Apr 19, 2012", "Fri. Apr 20, 2012", "Mon. Apr 23, 2012", 
    "Tue. Apr 24, 2012", "Wed. Apr 25, 2012", "Thu. Apr 26, 2012", 
    "Fri. Apr 27, 2012", "Mon. Apr 30, 2012", "Wed. May 02, 2012", 
    "Thu. May 03, 2012", "Fri. May 04, 2012", "Mon. May 07, 2012", 
    "Tue. May 08, 2012", "Wed. May 09, 2012", "Thu. May 10, 2012", 
    "Fri. May 11, 2012", "Mon. May 14, 2012", "Tue. May 15, 2012", 
    "Wed. May 16, 2012", "Thu. May 17, 2012", "Fri. May 18, 2012", 
    "Mon. May 21, 2012", "Tue. May 22, 2012", "Wed. May 23, 2012", 
    "Thu. May 24, 2012", "Fri. May 25, 2012", "Mon. May 28, 2012", 
    "Tue. May 29, 2012", "Wed. May 30, 2012", "Thu. May 31, 2012", 
    "Fri. Jun 01, 2012", "Mon. Jun 04, 2012", "Tue. Jun 05, 2012", 
    "Wed. Jun 06, 2012", "Thu. Jun 07, 2012", "Fri. Jun 08, 2012", 
    "Mon. Jun 11, 2012", "Tue. Jun 12, 2012", "Wed. Jun 13, 2012", 
    "Thu. Jun 14, 2012", "Fri. Jun 15, 2012", "Mon. Jun 18, 2012", 
    "Tue. Jun 19, 2012", "Wed. Jun 20, 2012", "Thu. Jun 21, 2012", 
    "Fri. Jun 22, 2012", "Mon. Jun 25, 2012", "Tue. Jun 26, 2012", 
    "Wed. Jun 27, 2012", "Thu. Jun 28, 2012", "Fri. Jun 29, 2012", 
    "Mon. Jul 02, 2012", "Tue. Jul 03, 2012", "Wed. Jul 04, 2012", 
    "Thu. Jul 05, 2012", "Fri. Jul 06, 2012", "Mon. Jul 09, 2012", 
    "Tue. Jul 10, 2012", "Wed. Jul 11, 2012", "Thu. Jul 12, 2012", 
    "Fri. Jul 13, 2012", "Mon. Jul 16, 2012", "Tue. Jul 17, 2012", 
    "Wed. Jul 18, 2012", "Thu. Jul 19, 2012", "Fri. Jul 20, 2012", 
    "Mon. Jul 23, 2012", "Tue. Jul 24, 2012", "Wed. Jul 25, 2012", 
    "Thu. Jul 26, 2012", "Fri. Jul 27, 2012", "Mon. Jul 30, 2012", 
    "Tue. Jul 31, 2012", "Wed. Aug 01, 2012", "Thu. Aug 02, 2012", 
    "Fri. Aug 03, 2012", "Mon. Aug 06, 2012", "Tue. Aug 07, 2012", 
    "Wed. Aug 08, 2012", "Thu. Aug 09, 2012", "Fri. Aug 10, 2012", 
    "Mon. Aug 13, 2012", "Tue. Aug 14, 2012", "Wed. Aug 15, 2012", 
    "Thu. Aug 16, 2012", "Fri. Aug 17, 2012", "Mon. Aug 20, 2012", 
    "Tue. Aug 21, 2012", "Wed. Aug 22, 2012", "Thu. Aug 23, 2012", 
    "Fri. Aug 24, 2012", "Mon. Aug 27, 2012", "Tue. Aug 28, 2012", 
    "Wed. Aug 29, 2012", "Thu. Aug 30, 2012", "Fri. Aug 31, 2012", 
    "Mon. Sep 03, 2012", "Tue. Sep 04, 2012", "Wed. Sep 05, 2012", 
    "Thu. Sep 06, 2012", "Fri. Sep 07, 2012", "Mon. Sep 10, 2012", 
    "Tue. Sep 11, 2012", "Wed. Sep 12, 2012", "Thu. Sep 13, 2012", 
    "Fri. Sep 14, 2012", "Mon. Sep 17, 2012", "Tue. Sep 18, 2012", 
    "Wed. Sep 19, 2012", "Thu. Sep 20, 2012", "Fri. Sep 21, 2012", 
    "Mon. Sep 24, 2012", "Tue. Sep 25, 2012", "Wed. Sep 26, 2012", 
    "Thu. Sep 27, 2012", "Fri. Sep 28, 2012", "Mon. Oct 01, 2012", 
    "Tue. Oct 02, 2012", "Wed. Oct 03, 2012", "Thu. Oct 04, 2012", 
    "Fri. Oct 05, 2012", "Mon. Oct 08, 2012", "Tue. Oct 09, 2012", 
    "Wed. Oct 10, 2012", "Thu. Oct 11, 2012", "Fri. Oct 12, 2012", 
    "Mon. Oct 15, 2012", "Tue. Oct 16, 2012", "Wed. Oct 17, 2012", 
    "Thu. Oct 18, 2012", "Fri. Oct 19, 2012", "Mon. Oct 22, 2012", 
    "Tue. Oct 23, 2012", "Wed. Oct 24, 2012", "Thu. Oct 25, 2012", 
    "Fri. Oct 26, 2012", "Mon. Oct 29, 2012", "Tue. Oct 30, 2012", 
    "Wed. Oct 31, 2012", "Thu. Nov 01, 2012", "Fri. Nov 02, 2012", 
    "Mon. Nov 05, 2012", "Tue. Nov 06, 2012", "Wed. Nov 07, 2012", 
    "Thu. Nov 08, 2012", "Fri. Nov 09, 2012", "Mon. Nov 12, 2012", 
    "Tue. Nov 13, 2012", "Wed. Nov 14, 2012", "Thu. Nov 15, 2012", 
    "Fri. Nov 16, 2012", "Mon. Nov 19, 2012", "Tue. Nov 20, 2012", 
    "Wed. Nov 21, 2012", "Thu. Nov 22, 2012", "Fri. Nov 23, 2012", 
    "Mon. Nov 26, 2012", "Tue. Nov 27, 2012", "Wed. Nov 28, 2012", 
    "Thu. Nov 29, 2012", "Fri. Nov 30, 2012", "Mon. Dec 03, 2012", 
    "Tue. Dec 04, 2012", "Wed. Dec 05, 2012", "Thu. Dec 06, 2012", 
    "Fri. Dec 07, 2012", "Mon. Dec 10, 2012", "Tue. Dec 11, 2012", 
    "Wed. Dec 12, 2012", "Thu. Dec 13, 2012", "Fri. Dec 14, 2012", 
    "Mon. Dec 17, 2012", "Tue. Dec 18, 2012", "Wed. Dec 19, 2012", 
    "Thu. Dec 20, 2012", "Fri. Dec 21, 2012", "Mon. Dec 24, 2012", 
    "Wed. Dec 26, 2012", "Thu. Dec 27, 2012", "Fri. Dec 28, 2012", 
    "Mon. Dec 31, 2012", "Wed. Jan 02, 2013", "Thu. Jan 03, 2013", 
    "Fri. Jan 04, 2013", "Mon. Jan 07, 2013", "Tue. Jan 08, 2013", 
    "Wed. Jan 09, 2013", "Thu. Jan 10, 2013", "Fri. Jan 11, 2013", 
    "Mon. Jan 14, 2013", "Tue. Jan 15, 2013", "Wed. Jan 16, 2013", 
    "Thu. Jan 17, 2013", "Fri. Jan 18, 2013", "Mon. Jan 21, 2013", 
    "Tue. Jan 22, 2013", "Wed. Jan 23, 2013", "Thu. Jan 24, 2013", 
    "Fri. Jan 25, 2013", "Mon. Jan 28, 2013", "Tue. Jan 29, 2013", 
    "Wed. Jan 30, 2013", "Thu. Jan 31, 2013", "Fri. Feb 01, 2013", 
    "Mon. Feb 04, 2013", "Tue. Feb 05, 2013", "Wed. Feb 06, 2013", 
    "Thu. Feb 07, 2013", "Fri. Feb 08, 2013", "Mon. Feb 11, 2013", 
    "Tue. Feb 12, 2013", "Wed. Feb 13, 2013", "Thu. Feb 14, 2013", 
    "Fri. Feb 15, 2013", "Mon. Feb 18, 2013", "Tue. Feb 19, 2013", 
    "Wed. Feb 20, 2013", "Thu. Feb 21, 2013", "Fri. Feb 22, 2013", 
    "Mon. Feb 25, 2013", "Tue. Feb 26, 2013", "Wed. Feb 27, 2013", 
    "Thu. Feb 28, 2013", "Fri. Mar 01, 2013", "Mon. Mar 04, 2013", 
    "Tue. Mar 05, 2013", "Wed. Mar 06, 2013", "Thu. Mar 07, 2013", 
    "Fri. Mar 08, 2013", "Mon. Mar 11, 2013", "Tue. Mar 12, 2013", 
    "Wed. Mar 13, 2013", "Thu. Mar 14, 2013", "Fri. Mar 15, 2013", 
    "Mon. Mar 18, 2013", "Tue. Mar 19, 2013", "Wed. Mar 20, 2013", 
    "Thu. Mar 21, 2013", "Fri. Mar 22, 2013", "Mon. Mar 25, 2013", 
    "Tue. Mar 26, 2013", "Wed. Mar 27, 2013", "Thu. Mar 28, 2013", 
    "Mon. Apr 01, 2013", "Tue. Apr 02, 2013", "Wed. Apr 03, 2013", 
    "Thu. Apr 04, 2013", "Fri. Apr 05, 2013", "Mon. Apr 08, 2013", 
    "Tue. Apr 09, 2013", "Wed. Apr 10, 2013", "Thu. Apr 11, 2013", 
    "Fri. Apr 12, 2013", "Mon. Apr 15, 2013", "Tue. Apr 16, 2013", 
    "Wed. Apr 17, 2013", "Thu. Apr 18, 2013", "Fri. Apr 19, 2013", 
    "Mon. Apr 22, 2013", "Tue. Apr 23, 2013", "Wed. Apr 24, 2013", 
    "Thu. Apr 25, 2013", "Fri. Apr 26, 2013", "Mon. Apr 29, 2013", 
    "Tue. Apr 30, 2013", "Wed. May 01, 2013", "Thu. May 02, 2013", 
    "Fri. May 03, 2013", "Mon. May 06, 2013", "Tue. May 07, 2013", 
    "Wed. May 08, 2013", "Thu. May 09, 2013", "Fri. May 10, 2013", 
    "Mon. May 13, 2013", "Tue. May 14, 2013", "Wed. May 15, 2013", 
    "Thu. May 16, 2013", "Fri. May 17, 2013", "Mon. May 20, 2013", 
    "Tue. May 21, 2013", "Wed. May 22, 2013", "Thu. May 23, 2013", 
    "Fri. May 24, 2013", "Mon. May 27, 2013", "Tue. May 28, 2013", 
    "Wed. May 29, 2013", "Thu. May 30, 2013", "Fri. May 31, 2013", 
    "Mon. Jun 03, 2013", "Tue. Jun 04, 2013", "Wed. Jun 05, 2013", 
    "Thu. Jun 06, 2013", "Fri. Jun 07, 2013", "Mon. Jun 10, 2013", 
    "Tue. Jun 11, 2013", "Wed. Jun 12, 2013", "Thu. Jun 13, 2013", 
    "Fri. Jun 14, 2013", "Mon. Jun 17, 2013", "Tue. Jun 18, 2013", 
    "Wed. Jun 19, 2013", "Thu. Jun 20, 2013", "Fri. Jun 21, 2013", 
    "Mon. Jun 24, 2013", "Tue. Jun 25, 2013", "Wed. Jun 26, 2013", 
    "Thu. Jun 27, 2013", "Fri. Jun 28, 2013", "Mon. Jul 01, 2013", 
    "Tue. Jul 02, 2013", "Wed. Jul 03, 2013", "Thu. Jul 04, 2013", 
    "Fri. Jul 05, 2013", "Mon. Jul 08, 2013", "Tue. Jul 09, 2013", 
    "Wed. Jul 10, 2013", "Thu. Jul 11, 2013", "Fri. Jul 12, 2013", 
    "Mon. Jul 15, 2013", "Tue. Jul 16, 2013", "Wed. Jul 17, 2013", 
    "Thu. Jul 18, 2013", "Fri. Jul 19, 2013", "Mon. Jul 22, 2013", 
    "Tue. Jul 23, 2013", "Wed. Jul 24, 2013", "Thu. Jul 25, 2013", 
    "Fri. Jul 26, 2013", "Mon. Jul 29, 2013", "Tue. Jul 30, 2013", 
    "Wed. Jul 31, 2013", "Thu. Aug 01, 2013", "Fri. Aug 02, 2013", 
    "Mon. Aug 05, 2013", "Tue. Aug 06, 2013", "Wed. Aug 07, 2013", 
    "Thu. Aug 08, 2013", "Fri. Aug 09, 2013", "Mon. Aug 12, 2013", 
    "Tue. Aug 13, 2013", "Wed. Aug 14, 2013", "Thu. Aug 15, 2013", 
    "Fri. Aug 16, 2013", "Mon. Aug 19, 2013", "Tue. Aug 20, 2013", 
    "Wed. Aug 21, 2013", "Thu. Aug 22, 2013", "Fri. Aug 23, 2013", 
    "Mon. Aug 26, 2013", "Tue. Aug 27, 2013", "Wed. Aug 28, 2013", 
    "Thu. Aug 29, 2013", "Fri. Aug 30, 2013", "Mon. Sep 02, 2013", 
    "Tue. Sep 03, 2013", "Wed. Sep 04, 2013", "Thu. Sep 05, 2013", 
    "Fri. Sep 06, 2013", "Mon. Sep 09, 2013", "Tue. Sep 10, 2013", 
    "Wed. Sep 11, 2013", "Thu. Sep 12, 2013", "Fri. Sep 13, 2013", 
    "Mon. Sep 16, 2013", "Tue. Sep 17, 2013", "Wed. Sep 18, 2013", 
    "Thu. Sep 19, 2013", "Fri. Sep 20, 2013", "Mon. Sep 23, 2013", 
    "Tue. Sep 24, 2013", "Wed. Sep 25, 2013", "Thu. Sep 26, 2013", 
    "Fri. Sep 27, 2013", "Mon. Sep 30, 2013", "Tue. Oct 01, 2013", 
    "Wed. Oct 02, 2013", "Thu. Oct 03, 2013", "Fri. Oct 04, 2013", 
    "Mon. Oct 07, 2013", "Tue. Oct 08, 2013", "Wed. Oct 09, 2013", 
    "Thu. Oct 10, 2013", "Fri. Oct 11, 2013", "Mon. Oct 14, 2013", 
    "Tue. Oct 15, 2013", "Wed. Oct 16, 2013", "Thu. Oct 17, 2013", 
    "Fri. Oct 18, 2013", "Mon. Oct 21, 2013", "Tue. Oct 22, 2013", 
    "Wed. Oct 23, 2013", "Thu. Oct 24, 2013", "Fri. Oct 25, 2013", 
    "Mon. Oct 28, 2013", "Tue. Oct 29, 2013", "Wed. Oct 30, 2013", 
    "Thu. Oct 31, 2013", "Fri. Nov 01, 2013", "Mon. Nov 04, 2013", 
    "Tue. Nov 05, 2013", "Wed. Nov 06, 2013", "Thu. Nov 07, 2013", 
    "Fri. Nov 08, 2013", "Mon. Nov 11, 2013", "Tue. Nov 12, 2013", 
    "Wed. Nov 13, 2013", "Thu. Nov 14, 2013", "Fri. Nov 15, 2013", 
    "Mon. Nov 18, 2013", "Tue. Nov 19, 2013", "Wed. Nov 20, 2013", 
    "Thu. Nov 21, 2013", "Fri. Nov 22, 2013", "Mon. Nov 25, 2013", 
    "Tue. Nov 26, 2013", "Wed. Nov 27, 2013", "Thu. Nov 28, 2013", 
    "Fri. Nov 29, 2013", "Mon. Dec 02, 2013", "Tue. Dec 03, 2013", 
    "Wed. Dec 04, 2013", "Thu. Dec 05, 2013", "Fri. Dec 06, 2013", 
    "Mon. Dec 09, 2013", "Tue. Dec 10, 2013", "Wed. Dec 11, 2013", 
    "Thu. Dec 12, 2013", "Fri. Dec 13, 2013", "Mon. Dec 16, 2013", 
    "Tue. Dec 17, 2013", "Wed. Dec 18, 2013", "Thu. Dec 19, 2013", 
    "Fri. Dec 20, 2013", "Mon. Dec 23, 2013", "Fri. Dec 27, 2013", 
    "Mon. Dec 30, 2013"}, System`TradingChartDump`$subplotrect$5891, 
   System`TradingChartDump`$subplotpoint$5891, 
   System`TradingChartDump`$ndigits$5891 = 6, 
   System`TradingChartDump`$highlightstyle$5891 = Directive[
    PointSize[0.01], 
    GrayLevel[0]], System`TradingChartDump`$bouncingballstyle$5891 = Directive[
    PointSize[0.01], 
    GrayLevel[0]], System`TradingChartDump`$bouncingballQ$5891 = True, 
   System`TradingChartDump`$timestampQ$5891 = True, 
   System`TradingChartDump`$data$5891 = {{{2010, 1, 4}, {
     5975.52, 6048.3, 5974.43, 6048.3, 24260800}}, {{2010, 1, 5}, {
     6043.94, 6058.02, 6015.67, 6031.86, 27329600}}, {{2010, 1, 6}, {
     6032.39, 6047.57, 5997.09, 6034.33, 24605300}}, {{2010, 1, 7}, {
     6016.8, 6037.57, 5961.25, 6019.36, 30059600}}, {{2010, 1, 8}, {
     6028.62, 6053.04, 5972.24, 6037.61, 31735200}}, {{2010, 1, 11}, {
     6057.93, 6094.26, 6031.14, 6040.5, 27162500}}, {{2010, 1, 12}, {
     6039.39, 6055.56, 5924.72, 5943., 35242500}}, {{2010, 1, 13}, {
     5937.17, 5974.44, 5925.24, 5963.14, 30161300}}, {{2010, 1, 14}, {
     5999.08, 6009.91, 5951.69, 5988.88, 33479000}}, {{2010, 1, 15}, {
     5996.56, 6025.36, 5866.84, 5875.97, 46886700}}, {{2010, 1, 18}, {
     5897.63, 5922.93, 5877.65, 5918.55, 20918000}}, {{2010, 1, 19}, {
     5905.33, 5988.8, 5849.67, 5976.48, 29504500}}, {{2010, 1, 20}, {
     5963.71, 5972.77, 5832.09, 5851.53, 32339400}}, {{2010, 1, 21}, {
     5878.239999999999, 5908.849999999999, 5742.449999999999, 5746.97, 
      39063300}}, {{2010, 1, 22}, {
     5735.68, 5740.87, 5639.49, 5695.32, 47739600}}, {{2010, 1, 25}, {
     5662.85, 5693.86, 5624.58, 5631.37, 33562000}}, {{2010, 1, 26}, {
     5593.94, 5675.96, 5574.46, 5668.93, 42243000}}, {{2010, 1, 27}, {
     5643.52, 5673.73, 5589.01, 5643.2, 38209400}}, {{2010, 1, 28}, {
     5687.1, 5718.81, 5540.33, 5540.33, 44525700}}, {{2010, 1, 29}, {
     5566.03, 5657.87, 5556.19, 5608.79, 41892900}}, {{2010, 2, 1}, {
     5587.5, 5674.21, 5567.72, 5654.48, 30622000}}, {{2010, 2, 2}, {
     5664.25, 5723.2, 5624.61, 5709.66, 31530300}}, {{2010, 2, 3}, {
     5715.16, 5733.71, 5656.9, 5672.09, 35285100}}, {{2010, 2, 4}, {
     5671.17, 5696.94, 5522.57, 5533.24, 43787300}}, {{2010, 2, 5}, {
     5515.69, 5527., 5433.02, 5434.34, 56173500}}, {{2010, 2, 8}, {
     5476.47, 5505.06, 5434.4, 5484.85, 34475500}}, {{2010, 2, 9}, {
     5485.31, 5537.97, 5461.51, 5498.26, 34406000}}, {{2010, 2, 10}, {
     5533.709999999999, 5592.2699999999995`, 5505.369999999999, 5536.37, 
      33831200}}, {{2010, 2, 11}, {
     5562.83, 5580.77, 5454.07, 5503.93, 32636900}}, {{2010, 2, 12}, {
     5550.45, 5565.43, 5460.05, 5500.39, 30096300}}, {{2010, 2, 15}, {
     5525.739999999999, 5547.139999999999, 5502.489999999999, 5511.1, 
      14732800}}, {{2010, 2, 16}, {
     5573.069999999999, 5592.119999999999, 5498.069999999999, 5592.12, 
      27671800}}, {{2010, 2, 17}, {
     5640.17, 5682.36, 5634.98, 5648.34, 32105200}}, {{2010, 2, 18}, {
     5645.629999999999, 5691.599999999999, 5626.079999999999, 5680.41, 
      34666100}}, {{2010, 2, 19}, {
     5627.26, 5729.58, 5626.57, 5722.05, 37978900}}, {{2010, 2, 22}, {
     5741., 5743.89, 5683.61, 5688.44, 23709800}}, {{2010, 2, 23}, {
     5715.63, 5732.14, 5584.47, 5604.07, 33399600}}, {{2010, 2, 24}, {
     5622.31, 5639.71, 5572.25, 5615.51, 30482300}}, {{2010, 2, 25}, {
     5562.7, 5655.75, 5518.27, 5532.33, 38160100}}, {{2010, 2, 26}, {
     5588.99, 5605.1, 5530.19, 5598.46, 32942100}}, {{2010, 3, 1}, {
     5652.85, 5717.72, 5641.18, 5713.51, 28803000}}, {{2010, 3, 2}, {
     5728.28, 5780.14, 5709.74, 5776.56, 28856200}}, {{2010, 3, 3}, {
     5759.219999999999, 5828.799999999999, 5750.299999999999, 5817.88, 
      29965900}}, {{2010, 3, 4}, {
     5773.86, 5823.11, 5767.65, 5795.32, 27443200}}, {{2010, 3, 5}, {
     5816.19, 5880.25, 5808.36, 5877.36, 31100200}}, {{2010, 3, 8}, {
     5891.74, 5894.19, 5865.44, 5875.91, 25009000}}, {{2010, 3, 9}, {
     5872.57, 5900.16, 5838.17, 5885.89, 24946200}}, {{2010, 3, 10}, {
     5882.76, 5951.93, 5874.75, 5936.72, 27233400}}, {{2010, 3, 11}, {
     5913.17, 5954.55, 5906.84, 5928.63, 26188100}}, {{2010, 3, 12}, {
     5944.569999999999, 5989.879999999999, 5934.149999999999, 5945.11, 
      32115200}}, {{2010, 3, 15}, {
     5933.63, 5953.19, 5898.22, 5903.56, 22773300}}, {{2010, 3, 16}, {
     5935.189999999999, 5991.109999999999, 5930.339999999999, 5970.99, 
      26636800}}, {{2010, 3, 17}, {
     5999.31, 6035.95, 5991.21, 6024.28, 33973300}}, {{2010, 3, 18}, {
     6005.29, 6039.39, 5995.68, 6012.31, 29637800}}, {{2010, 3, 19}, {
     6031.73, 6041.95, 5956.65, 5982.43, 90135600}}, {{2010, 3, 22}, {
     5960.85, 5987.5, 5910.85, 5987.5, 28205900}}, {{2010, 3, 23}, {
     5987.09, 6030.94, 5981.35, 6017.27, 29921800}}, {{2010, 3, 24}, {
     6038., 6044.64, 5964.76, 6039., 33523800}}, {{2010, 3, 25}, {
     6043.84, 6139.5, 6038.05, 6132.95, 36091500}}, {{2010, 3, 26}, {
     6125.869999999999, 6135.949999999999, 6105.669999999999, 6120.05, 
      34200900}}, {{2010, 3, 29}, {
     6150.17, 6172.85, 6128.21, 6156.85, 25749600}}, {{2010, 3, 30}, {
     6187.64, 6203.5, 6135.51, 6142.45, 31262900}}, {{2010, 3, 31}, {
     6139.4, 6162.18, 6108.23, 6153.55, 34364600}}, {{2010, 4, 1}, {
     6189.38, 6238.57, 6186.59, 6235.56, 29546500}}, {{2010, 4, 5}, {
     6235.56, 6235.56, 6235.56, 6235.56, 0}}, {{2010, 4, 6}, {
     6250.01, 6265.32, 6214.18, 6252.21, 29445700}}, {{2010, 4, 7}, {
     6248.369999999999, 6256.399999999999, 6208.5199999999995`, 6222.41, 
      28689600}}, {{2010, 4, 8}, {
     6199.94, 6207.14, 6138.02, 6171.83, 30684300}}, {{2010, 4, 9}, {
     6226.26, 6254.49, 6216.6, 6249.7, 30543800}}, {{2010, 4, 12}, {
     6283.81, 6285.03, 6223.78, 6250.69, 24311600}}, {{2010, 4, 13}, {
     6236.28, 6251.46, 6199.71, 6230.83, 28970000}}, {{2010, 4, 14}, {
     6269.48, 6305.15, 6249.92, 6278.4, 33812600}}, {{2010, 4, 15}, {
     6286.63, 6310.76, 6249.74, 6291.45, 31402600}}, {{2010, 4, 16}, {
     6264.65, 6305.4, 6162.84, 6180.9, 80519400}}, {{2010, 4, 19}, {
     6158.6, 6190.86, 6140.38, 6162.44, 38311800}}, {{2010, 4, 20}, {
     6193.499999999999, 6267.539999999999, 6172.569999999999, 6264.23, 
      42345100}}, {{2010, 4, 21}, {
     6280.54, 6281.38, 6229.18, 6230.38, 46312400}}, {{2010, 4, 22}, {
     6229.23, 6286.36, 6141.07, 6168.72, 61398300}}, {{2010, 4, 23}, {
     6192.62, 6287.54, 6170.39, 6259.53, 42665300}}, {{2010, 4, 26}, {
     6317.13, 6341.52, 6299.58, 6332.1, 35338000}}, {{2010, 4, 27}, {
     6332.4, 6333., 6159.51, 6159.51, 56206000}}, {{2010, 4, 28}, {
     6141.01, 6159.02, 6024.01, 6084.34, 77665900}}, {{2010, 4, 29}, {
     6110.5599999999995`, 6159.409999999999, 6073.369999999999, 6144.91, 
      64846600}}, {{2010, 4, 30}, {
     6155.57, 6205.72, 6085.62, 6135.7, 68821500}}, {{2010, 5, 3}, {
     6122.76, 6190.07, 6089.93, 6166.92, 30275500}}, {{2010, 5, 4}, {
     6176.24, 6197., 5995.43, 6006.86, 62448200}}, {{2010, 5, 5}, {
     6021.06, 6031.09, 5929.35, 5958.45, 73549600}}, {{2010, 5, 6}, {
     5919.94, 6009.48, 5884.39, 5908.26, 79638100}}, {{2010, 5, 7}, {
     5790.67, 5905.35, 5655.18, 5715.09, 89479600}}, {{2010, 5, 10}, {
     5814.41, 6017.91, 5805.98, 6017.91, 81524900}}, {{2010, 5, 11}, {
     5922.03, 6042.11, 5918.14, 6037.71, 46839700}}, {{2010, 5, 12}, {
     6026.06, 6217.24, 6006.31, 6183.49, 53109300}}, {{2010, 5, 13}, {
     6240.67, 6276.8, 6196.89, 6251.97, 34774900}}, {{2010, 5, 14}, {
     6226.49, 6233.71, 6014.78, 6056.71, 50055800}}, {{2010, 5, 17}, {
     6029.91, 6151.54, 6026.32, 6066.92, 40514200}}, {{2010, 5, 18}, {
     6144.08, 6181.26, 6113.87, 6155.93, 34243400}}, {{2010, 5, 19}, {
     6091.85, 6124.81, 5972.17, 5988.67, 51424000}}, {{2010, 5, 20}, {
     6023.11, 6043.84, 5780.73, 5867.88, 57232900}}, {{2010, 5, 21}, {
     5835.22, 5872.65, 5689.18, 5829.25, 122848200}}, {{2010, 5, 24}, {
     5858.449999999999, 5872.069999999999, 5733.569999999999, 5805.68, 
      24457800}}, {{2010, 5, 25}, {
     5659.59, 5690.25, 5607.68, 5670.04, 48243900}}, {{2010, 5, 26}, {
     5735.46, 5828.37, 5721.02, 5758.02, 46121000}}, {{2010, 5, 27}, {
     5802.64, 5952.21, 5802.36, 5937.14, 56115700}}, {{2010, 5, 28}, {
     5962.84, 5980.78, 5927.31, 5946.18, 30768600}}, {{2010, 5, 31}, {
     5933.58, 5993.94, 5931.2, 5964.33, 12898800}}, {{2010, 6, 1}, {
     5943.94, 6012.04, 5833.61, 5981.27, 32624200}}, {{2010, 6, 2}, {
     5923.48, 5992.21, 5869.35, 5981.2, 27324700}}, {{2010, 6, 3}, {
     6075.68, 6101.83, 6046.38, 6054.63, 27857500}}, {{2010, 6, 4}, {
     6081.47, 6114.58, 5912.9, 5938.88, 36808500}}, {{2010, 6, 7}, {
     5876.48, 5954.47, 5851.93, 5904.95, 32367400}}, {{2010, 6, 8}, {
     5916.86, 5922.95, 5798.76, 5868.55, 47791900}}, {{2010, 6, 9}, {
     5895.94, 5993.93, 5832.97, 5984.75, 33300400}}, {{2010, 6, 10}, {
     5959.11, 6089.43, 5925.06, 6056.59, 36840800}}, {{2010, 6, 11}, {
     6082.9, 6084.7, 5983.27, 6047.83, 35919300}}, {{2010, 6, 14}, {
     6113.46, 6137.25, 6093.38, 6125., 28207400}}, {{2010, 6, 15}, {
     6089.32, 6194.25, 6089.32, 6175.05, 29784300}}, {{2010, 6, 16}, {
     6203.009999999999, 6207.299999999999, 6143.179999999999, 6190.91, 
      32408100}}, {{2010, 6, 17}, {
     6181.77, 6241.36, 6164.99, 6223.54, 31423100}}, {{2010, 6, 18}, {
     6223.88, 6256.55, 6189.71, 6216.98, 106356600}}, {{2010, 6, 21}, {
     6320.41, 6330.81, 6263.41, 6292.97, 26997700}}, {{2010, 6, 22}, {
     6254.86, 6295.58, 6216.39, 6269.04, 25040800}}, {{2010, 6, 23}, {
     6219.2, 6271.85, 6178.84, 6204.52, 26377700}}, {{2010, 6, 24}, {
     6232.38, 6235.48, 6097.01, 6115.48, 30445200}}, {{2010, 6, 25}, {
     6116.23, 6149.87, 6039.56, 6070.6, 28816200}}, {{2010, 6, 28}, {
     6097.37, 6168.99, 6059.83, 6157.22, 22344600}}, {{2010, 6, 29}, {
     6061.68, 6068.82, 5935.35, 5952.03, 33993600}}, {{2010, 6, 30}, {
     5972.26, 6001.03, 5938.2, 5965.52, 29491100}}, {{2010, 7, 1}, {
     5885.61, 5953.84, 5827.25, 5857.43, 37447100}}, {{2010, 7, 2}, {
     5885.219999999999, 5941.219999999999, 5833.119999999999, 5834.15, 
      27871200}}, {{2010, 7, 5}, {
     5853.75, 5861.05, 5809.37, 5816.2, 15694000}}, {{2010, 7, 6}, {
     5847.47, 5995.64, 5842.07, 5940.98, 28958800}}, {{2010, 7, 7}, {
     5896.18, 5997.82, 5848.66, 5992.86, 31101600}}, {{2010, 7, 8}, {
     6025.86, 6057.52, 6006.68, 6035.66, 30229900}}, {{2010, 7, 9}, {
     6070.47, 6078.56, 6039.31, 6065.24, 21628200}}, {{2010, 7, 12}, {
     6079.95, 6119.7, 6061.84, 6077.19, 18200900}}, {{2010, 7, 13}, {
     6078.34, 6200.82, 6076.14, 6191.13, 31375300}}, {{2010, 7, 14}, {
     6215.23, 6226.54, 6161.13, 6209.76, 26012000}}, {{2010, 7, 15}, {
     6187.78, 6248.07, 6127.36, 6149.36, 29997400}}, {{2010, 7, 16}, {
     6165.51, 6205.44, 6018.64, 6040.27, 45476800}}, {{2010, 7, 19}, {
     6034.87, 6083.12, 5993.55, 6009.11, 22770200}}, {{2010, 7, 20}, {
     6039.16, 6052.51, 5906.04, 5967.49, 25462800}}, {{2010, 7, 21}, {
     6011.719999999999, 6060.489999999999, 5976.919999999999, 5990.38, 
      22813700}}, {{2010, 7, 22}, {
     5971.09, 6148.13, 5961.86, 6142.15, 30219900}}, {{2010, 7, 23}, {
     6125.26, 6190.24, 6112.5, 6166.34, 25071000}}, {{2010, 7, 26}, {
     6201.02, 6201.14, 6131.91, 6194.21, 19436700}}, {{2010, 7, 27}, {
     6211.1, 6253.64, 6189.96, 6207.31, 40151400}}, {{2010, 7, 28}, {
     6238.71, 6249.16, 6147.57, 6178.94, 28763900}}, {{2010, 7, 29}, {
     6202.78, 6243.42, 6124.45, 6134.7, 32422600}}, {{2010, 7, 30}, {
     6123.41, 6184.54, 6059.19, 6147.97, 30874800}}, {{2010, 8, 2}, {
     6187.64, 6304.26, 6182.68, 6292.13, 30825200}}, {{2010, 8, 3}, {
     6279.949999999999, 6310.319999999999, 6265.609999999999, 6307.91, 
      28444300}}, {{2010, 8, 4}, {
     6287.65, 6361.67, 6264.28, 6331.33, 29295200}}, {{2010, 8, 5}, {
     6332.82, 6382.56, 6321.38, 6333.58, 33586300}}, {{2010, 8, 6}, {
     6361.09, 6386.97, 6244.69, 6259.63, 36121700}}, {{2010, 8, 9}, {
     6326.619999999999, 6356.409999999999, 6318.119999999999, 6351.6, 
      21595500}}, {{2010, 8, 10}, {
     6315.87, 6333.25, 6247.62, 6286.25, 24146100}}, {{2010, 8, 11}, {
     6234.599999999999, 6236.569999999999, 6143.579999999999, 6154.07, 
      30207000}}, {{2010, 8, 12}, {
     6141.9, 6173.42, 6097.72, 6135.17, 30582400}}, {{2010, 8, 13}, {
     6163.11, 6168.71, 6068.82, 6110.41, 27177100}}, {{2010, 8, 16}, {
     6132.78, 6156.57, 6062.29, 6110.57, 20988900}}, {{2010, 8, 17}, {
     6125.32, 6215.35, 6123.79, 6206.4, 26084800}}, {{2010, 8, 18}, {
     6183.12, 6216.55, 6155.51, 6186.31, 22856200}}, {{2010, 8, 19}, {
     6216.33, 6229.46, 6070.83, 6075.13, 30652900}}, {{2010, 8, 20}, {
     6079.91, 6097.35, 5999.63, 6005.16, 33860400}}, {{2010, 8, 23}, {
     6017.19, 6055.23, 5995.37, 6010.91, 19657100}}, {{2010, 8, 24}, {
     5962.869999999999, 5975.829999999999, 5869.299999999999, 5935.44, 
      26305300}}, {{2010, 8, 25}, {
     5925.48, 5954.96, 5837.9, 5899.5, 29686600}}, {{2010, 8, 26}, {
     5937.27, 5948.91, 5896.52, 5912.58, 23078700}}, {{2010, 8, 27}, {
     5899.99, 5957.32, 5845.49, 5951.17, 26027900}}, {{2010, 8, 30}, {
     5973.48, 5978.19, 5889.84, 5912.41, 13770700}}, {{2010, 8, 31}, {
     5846.03, 5925.81, 5833.51, 5925.22, 28331400}}, {{2010, 9, 1}, {
     5936.94, 6087.94, 5876.43, 6083.9, 34019300}}, {{2010, 9, 2}, {
     6071.56, 6104.09, 6052.55, 6083.85, 27498300}}, {{2010, 9, 3}, {
     6091.66, 6178.01, 6088.26, 6134.62, 28219900}}, {{2010, 9, 6}, {
     6156.29, 6164.93, 6140.98, 6155.04, 17930500}}, {{2010, 9, 7}, {
     6136.92, 6138.93, 6083.2, 6117.89, 20940300}}, {{2010, 9, 8}, {
     6099.33, 6180.38, 6062.65, 6164.44, 27335100}}, {{2010, 9, 9}, {
     6141.84, 6233.07, 6133.99, 6221.52, 28191500}}, {{2010, 9, 10}, {
     6186.22, 6224.65, 6182.56, 6214.77, 29874500}}, {{2010, 9, 13}, {
     6258.51, 6290.87, 6231.52, 6261.68, 28716900}}, {{2010, 9, 14}, {
     6261.78, 6287.78, 6231.38, 6275.41, 31979400}}, {{2010, 9, 15}, {
     6282.52, 6288.2, 6227.2, 6261.87, 27933900}}, {{2010, 9, 16}, {
     6255.14, 6281.1, 6233.97, 6249.65, 29403500}}, {{2010, 9, 17}, {
     6297.93, 6321.2, 6185.74, 6209.76, 83782200}}, {{2010, 9, 20}, {
     6231.28, 6301.63, 6219.85, 6294.58, 28489200}}, {{2010, 9, 21}, {
     6281.07, 6339.97, 6275.98, 6275.98, 36518100}}, {{2010, 9, 22}, {
     6286.33, 6297.4, 6192.43, 6208.33, 38750300}}, {{2010, 9, 23}, {
     6252.3099999999995`, 6263.739999999999, 6129.439999999999, 6184.71, 
      32363100}}, {{2010, 9, 24}, {
     6173.889999999999, 6310.279999999999, 6146.419999999999, 6298.3, 
      36674600}}, {{2010, 9, 27}, {
     6307.87, 6324.09, 6272.17, 6278.89, 28926800}}, {{2010, 9, 28}, {
     6258.2, 6311.92, 6197.96, 6276.09, 34090000}}, {{2010, 9, 29}, {
     6296.28, 6326.34, 6223.14, 6246.92, 34768700}}, {{2010, 9, 30}, {
     6214.02, 6339.36, 6204.69, 6229.02, 38524700}}, {{2010, 10, 1}, {
     6244.0599999999995`, 6293.089999999999, 6187.219999999999, 6211.34, 
      40205100}}, {{2010, 10, 4}, {
     6205., 6210.25, 6128.54, 6134.21, 28583000}}, {{2010, 10, 5}, {
     6132.12, 6233.45, 6115.87, 6215.83, 33121300}}, {{2010, 10, 6}, {
     6248.81, 6289.56, 6242.52, 6270.73, 35882100}}, {{2010, 10, 7}, {
     6278.61, 6321.79, 6233.14, 6276.25, 30503800}}, {{2010, 10, 8}, {
     6269.48, 6295.09, 6239.43, 6291.67, 30996700}}, {{2010, 10, 11}, {
     6308.43, 6325.31, 6289.36, 6309.51, 20361900}}, {{2010, 10, 12}, {
     6257.03, 6316.77, 6228.39, 6304.57, 29308300}}, {{2010, 10, 13}, {
     6339.76, 6456.27, 6335.22, 6434.52, 39405000}}, {{2010, 10, 14}, {
     6446.32, 6485.71, 6445.32, 6455.27, 31846200}}, {{2010, 10, 15}, {
     6478., 6512.78, 6438.78, 6492.3, 48250000}}, {{2010, 10, 18}, {
     6465.83, 6533.83, 6462.59, 6516.63, 25772600}}, {{2010, 10, 19}, {
     6508.36, 6544.79, 6472.18, 6490.69, 29970200}}, {{2010, 10, 20}, {
     6470.3, 6527.85, 6461.48, 6524.55, 26325000}}, {{2010, 10, 21}, {
     6514.99, 6621.84, 6504.66, 6611.01, 30509500}}, {{2010, 10, 22}, {
     6594.9, 6623.94, 6586.4, 6605.84, 24196400}}, {{2010, 10, 25}, {
     6645.45, 6668.54, 6625.83, 6639.21, 23578000}}, {{2010, 10, 26}, {
     6634.24, 6645.7, 6580.28, 6613.8, 31144200}}, {{2010, 10, 27}, {
     6591.24, 6629.13, 6553.25, 6568., 37387200}}, {{2010, 10, 28}, {
     6600.28, 6644.61, 6576.02, 6595.28, 34311700}}, {{2010, 10, 29}, {
     6585.969999999999, 6630.979999999999, 6569.249999999999, 6601.37, 
      33007700}}, {{2010, 11, 1}, {
     6637.09, 6670.9, 6586.01, 6604.86, 25403100}}, {{2010, 11, 2}, {
     6600.41, 6668.93, 6597.46, 6654.31, 24046400}}, {{2010, 11, 3}, {
     6666.069999999999, 6682.909999999999, 6604.749999999999, 6617.8, 
      27328100}}, {{2010, 11, 4}, {
     6677.78, 6757.29, 6676.42, 6734.69, 39901300}}, {{2010, 11, 5}, {
     6743.56, 6775.17, 6712.47, 6754.2, 35627200}}, {{2010, 11, 8}, {
     6746.44, 6759.41, 6728.35, 6750.5, 25373400}}, {{2010, 11, 9}, {
     6742.05, 6810.86, 6736.63, 6787.81, 32465800}}, {{2010, 11, 10}, {
     6759.59, 6783.69, 6684.22, 6719.84, 41237200}}, {{2010, 11, 11}, {
     6747.8, 6750.39, 6700.47, 6723.41, 34122100}}, {{2010, 11, 12}, {
     6650.92, 6758.59, 6617.97, 6734.61, 37468500}}, {{2010, 11, 15}, {
     6705.13, 6812.96, 6679.69, 6790.17, 34458600}}, {{2010, 11, 16}, {
     6751.13, 6772.01, 6663.15, 6663.24, 33355900}}, {{2010, 11, 17}, {
     6658.99, 6705.19, 6653.57, 6700.07, 24864000}}, {{2010, 11, 18}, {
     6765.699999999999, 6835.539999999999, 6754.399999999999, 6832.11, 
      29329200}}, {{2010, 11, 19}, {
     6841.37, 6854.09, 6794.43, 6843.55, 42738800}}, {{2010, 11, 22}, {
     6892.0199999999995`, 6901.929999999999, 6805.969999999999, 6822.05, 
      29098500}}, {{2010, 11, 23}, {
     6791.75, 6827.83, 6705., 6705., 35161100}}, {{2010, 11, 24}, {
     6740.609999999999, 6833.699999999999, 6701.979999999999, 6823.8, 
      37293500}}, {{2010, 11, 25}, {
     6834.68, 6885.81, 6823.19, 6879.66, 26295500}}, {{2010, 11, 26}, {
     6842.39, 6871.71, 6778.6, 6848.98, 31534500}}, {{2010, 11, 29}, {
     6867.77, 6907.61, 6697.97, 6697.97, 38812100}}, {{2010, 11, 30}, {
     6732.59, 6763.52, 6655.94, 6688.49, 40637400}}, {{2010, 12, 1}, {
     6748.36, 6868.81, 6736.69, 6866.63, 39402600}}, {{2010, 12, 2}, {
     6895.77, 6958.69, 6840.65, 6957.61, 42149200}}, {{2010, 12, 3}, {
     6947.3099999999995`, 6977.909999999999, 6914.499999999999, 6947.72, 
      33961600}}, {{2010, 12, 6}, {
     6970.24, 6971.95, 6926.57, 6954.38, 26083600}}, {{2010, 12, 7}, {
     6987.88, 7042.67, 6962.1, 7001.91, 33585700}}, {{2010, 12, 8}, {
     6976.189999999999, 7013.529999999999, 6956.669999999999, 6975.87, 
      31056900}}, {{2010, 12, 9}, {
     7017.99, 7021.31, 6947.9, 6964.16, 45373100}}, {{2010, 12, 10}, {
     6987.689999999999, 7018.109999999999, 6973.319999999999, 7006.17, 
      29143200}}, {{2010, 12, 13}, {
     7027.58, 7044.87, 7017.6, 7029.39, 23170800}}, {{2010, 12, 14}, {
     7024.79, 7032.65, 7011.14, 7027.4, 23583600}}, {{2010, 12, 15}, {
     7007.49, 7029.74, 6964.13, 7016.37, 31593300}}, {{2010, 12, 16}, {
     7012.99, 7033.03, 6991.69, 7024.4, 25254100}}, {{2010, 12, 17}, {
     7042.83, 7043.15, 6980.18, 6982.45, 76014900}}, {{2010, 12, 20}, {
     7000.38, 7068.56, 6992.67, 7018.6, 25113400}}, {{2010, 12, 21}, {
     7045.249999999999, 7087.839999999999, 7042.979999999999, 7077.99, 
      22804500}}, {{2010, 12, 22}, {
     7079.219999999999, 7084.099999999999, 7067.709999999999, 7067.92, 
      18508800}}, {{2010, 12, 23}, {
     7083.079999999999, 7083.079999999999, 7042.579999999999, 7057.69, 
      14089000}}, {{2010, 12, 27}, {
     7055.32, 7056.34, 6943.05, 6970.73, 15536800}}, {{2010, 12, 28}, {
     6984.849999999999, 6990.8099999999995`, 6957.649999999999, 6972.1, 
      11623400}}, {{2010, 12, 29}, {
     6989.54, 7008.31, 6981.79, 6995.47, 12671600}}, {{2010, 12, 30}, {
     6996.56, 7008.12, 6897.22, 6914.19, 14052700}}, {{2010, 12, 31}, {
     6914.19, 6914.19, 6914.19, 6914.19, 0}}, {{2011, 1, 3}, {
     6973.39, 7026.62, 6969.83, 6989.74, 20366700}}, {{2011, 1, 4}, {
     6979.68, 7025.86, 6952.02, 6975.35, 28821900}}, {{2011, 1, 5}, {
     6966.08, 6967.24, 6842.9, 6939.82, 42598700}}, {{2011, 1, 6}, {
     6949.48, 7047.59, 6949.07, 6981.39, 30272800}}, {{2011, 1, 7}, {
     6991.55, 7010.89, 6939.88, 6947.84, 29836200}}, {{2011, 1, 10}, {
     6920.36, 6941.39, 6835.74, 6857.06, 28413200}}, {{2011, 1, 11}, {
     6879.39, 6951.19, 6860.52, 6941.57, 36660200}}, {{2011, 1, 12}, {
     6958.84, 7070.4, 6958.5, 7068.78, 38486700}}, {{2011, 1, 13}, {
     7075.54, 7084.07, 7036.09, 7075.11, 44048700}}, {{2011, 1, 14}, {
     7055.42, 7083.02, 7015.35, 7075.7, 42432900}}, {{2011, 1, 17}, {
     7072.75, 7087.43, 7055.83, 7078.06, 24861600}}, {{2011, 1, 18}, {
     7100.48, 7156.25, 7099.12, 7143.45, 37225200}}, {{2011, 1, 19}, {
     7163.37, 7165., 7077.23, 7082.76, 36740100}}, {{2011, 1, 20}, {
     7074.89, 7084.24, 7008.62, 7024.27, 48538600}}, {{2011, 1, 21}, {
     7047.699999999999, 7122.889999999999, 7023.689999999999, 7062.42, 
      64352000}}, {{2011, 1, 24}, {
     7080.78, 7089.62, 7000.41, 7067.77, 49538600}}, {{2011, 1, 25}, {
     7096.84, 7102.08, 7043.64, 7059.01, 51252800}}, {{2011, 1, 26}, {
     7092.889999999999, 7160.859999999999, 7087.249999999999, 7127.35, 
      38158300}}, {{2011, 1, 27}, {
     7120.64, 7180.15, 7114.35, 7155.58, 38526300}}, {{2011, 1, 28}, {
     7155.469999999999, 7177.229999999999, 7102.799999999999, 7102.8, 
      34172300}}, {{2011, 1, 31}, {
     7094.56, 7107.37, 7033.09, 7077.48, 31186300}}, {{2011, 2, 1}, {
     7133.34, 7190.75, 7105.31, 7184.27, 38952900}}, {{2011, 2, 2}, {
     7202.62, 7222.13, 7160.36, 7183.67, 40675400}}, {{2011, 2, 3}, {
     7175.75, 7198.98, 7144.08, 7193.68, 34878500}}, {{2011, 2, 4}, {
     7216.659999999999, 7226.639999999999, 7186.239999999999, 7216.21, 
      31836400}}, {{2011, 2, 7}, {
     7222.05, 7287.66, 7214.05, 7283.62, 31565200}}, {{2011, 2, 8}, {
     7274.17, 7325.03, 7272.8, 7323.24, 35605000}}, {{2011, 2, 9}, {
     7319.119999999999, 7350.779999999999, 7310.439999999999, 7320.9, 
      28514000}}, {{2011, 2, 10}, {
     7322.62, 7340.87, 7269.53, 7340.28, 36583200}}, {{2011, 2, 11}, {
     7320.07, 7390.48, 7283.87, 7371.2, 34588400}}, {{2011, 2, 14}, {
     7403.829999999999, 7424.359999999999, 7378.409999999999, 7396.63, 
      26660000}}, {{2011, 2, 15}, {
     7397.68, 7420.69, 7376.24, 7400.04, 36099500}}, {{2011, 2, 16}, {
     7414.23, 7438.42, 7399.82, 7414.3, 45810600}}, {{2011, 2, 17}, {
     7429., 7434.93, 7364.04, 7405.51, 37389200}}, {{2011, 2, 18}, {
     7422.11, 7427.3, 7379.94, 7426.81, 49458200}}, {{2011, 2, 21}, {
     7412.06, 7441.82, 7310.69, 7321.81, 32484400}}, {{2011, 2, 22}, {
     7293.109999999999, 7350.949999999999, 7259.669999999999, 7318.35, 
      39212800}}, {{2011, 2, 23}, {
     7295.119999999999, 7310.729999999999, 7183.299999999999, 7194.6, 
      36741300}}, {{2011, 2, 24}, {
     7134.7, 7156.05, 7093.91, 7130.5, 47085000}}, {{2011, 2, 25}, {
     7139.88, 7194.02, 7130.15, 7185.17, 34238300}}, {{2011, 2, 28}, {
     7173.59, 7305.49, 7148.94, 7272.32, 35941200}}, {{2011, 3, 1}, {
     7309.8, 7356.33, 7193.78, 7223.3, 36894600}}, {{2011, 3, 2}, {
     7169.04, 7202.58, 7122.69, 7181.12, 36461600}}, {{2011, 3, 3}, {
     7225.23, 7294.04, 7191.14, 7225.96, 31783400}}, {{2011, 3, 4}, {
     7262.54, 7311.25, 7157.12, 7178.9, 33634300}}, {{2011, 3, 7}, {
     7137.81, 7270.81, 7127.31, 7161.93, 28893000}}, {{2011, 3, 8}, {
     7211.0599999999995`, 7222.159999999999, 7072.469999999999, 7164.75, 
      35838600}}, {{2011, 3, 9}, {
     7177.55, 7217.54, 7109.26, 7131.8, 35117700}}, {{2011, 3, 10}, {
     7078.69, 7109.71, 7021.95, 7063.09, 39693500}}, {{2011, 3, 11}, {
     7002.259999999999, 7014.0199999999995`, 6963.3099999999995`, 6981.49, 
      46873100}}, {{2011, 3, 14}, {
     6896.31, 6946.44, 6847.94, 6866.63, 54185000}}, {{2011, 3, 15}, {
     6668.99, 6714.83, 6483.39, 6647.66, 89815800}}, {{2011, 3, 16}, {
     6696.31, 6733.03, 6501.85, 6513.84, 60220200}}, {{2011, 3, 17}, {
     6557.85, 6692.83, 6517.18, 6656.88, 48466700}}, {{2011, 3, 18}, {
     6715.17, 6761.31, 6655.69, 6664.4, 103186200}}, {{2011, 3, 21}, {
     6782.299999999999, 6829.749999999999, 6781.299999999999, 6816.12, 
      49218800}}, {{2011, 3, 22}, {
     6823.079999999999, 6826.029999999999, 6765.0599999999995`, 6780.97, 
      32898100}}, {{2011, 3, 23}, {
     6749.18, 6807.38, 6720.02, 6804.45, 30670600}}, {{2011, 3, 24}, {
     6798.08, 6941.72, 6787.04, 6933.58, 33874800}}, {{2011, 3, 25}, {
     6971.77, 6985.25, 6920.57, 6946.36, 27188200}}, {{2011, 3, 28}, {
     6931.86, 6981.19, 6915.58, 6938.63, 23172600}}, {{2011, 3, 29}, {
     6952.51, 6960.16, 6867.42, 6934.44, 27010700}}, {{2011, 3, 30}, {
     7010.77, 7065.27, 7002.77, 7057.15, 33168800}}, {{2011, 3, 31}, {
     7068.289999999999, 7079.759999999999, 7041.3099999999995`, 7041.31, 
      31320500}}, {{2011, 4, 1}, {
     7086.56, 7192.38, 7086.56, 7179.81, 36017900}}, {{2011, 4, 4}, {
     7178.59, 7200.26, 7168.24, 7175.33, 24799500}}, {{2011, 4, 5}, {
     7174.689999999999, 7186.349999999999, 7129.409999999999, 7175.31, 
      33963400}}, {{2011, 4, 6}, {
     7197.37, 7242.69, 7157.68, 7215.11, 35036600}}, {{2011, 4, 7}, {
     7212.46, 7241.09, 7175.35, 7178.78, 33798000}}, {{2011, 4, 8}, {
     7226.79, 7232.87, 7195.44, 7217.02, 31782400}}, {{2011, 4, 11}, {
     7215.34, 7224.74, 7157.33, 7204.86, 31582800}}, {{2011, 4, 12}, {
     7131.44, 7177.74, 7089.17, 7102.91, 45427200}}, {{2011, 4, 13}, {
     7135.21, 7201.12, 7122.51, 7177.97, 46087100}}, {{2011, 4, 14}, {
     7160.989999999999, 7184.929999999999, 7099.659999999999, 7146.56, 
      31142900}}, {{2011, 4, 15}, {
     7166.98, 7193.38, 7144.96, 7178.29, 59044100}}, {{2011, 4, 18}, {
     7165.99, 7174.75, 6994.56, 7026.85, 40413800}}, {{2011, 4, 19}, {
     7050.85, 7078.79, 7027.04, 7039.31, 38697300}}, {{2011, 4, 20}, {
     7137.1, 7261.26, 7136.74, 7249.19, 47939500}}, {{2011, 4, 21}, {
     7294.58, 7316.53, 7280.1, 7295.49, 32311400}}, {{2011, 4, 25}, {
     7295.49, 7295.49, 7295.49, 7295.49, 0}}, {{2011, 4, 26}, {
     7288.77, 7359.97, 7278.52, 7356.51, 24123700}}, {{2011, 4, 27}, {
     7374.109999999999, 7428.719999999999, 7361.239999999999, 7404.95, 
      33012900}}, {{2011, 4, 28}, {
     7450.57, 7480.33, 7426.62, 7475.22, 53112200}}, {{2011, 4, 29}, {
     7475., 7514.69, 7461.53, 7514.46, 35600000}}, {{2011, 5, 2}, {
     7570.86, 7600.41, 7527.64, 7527.64, 27700000}}, {{2011, 5, 3}, {
     7518.6, 7523.68, 7446.83, 7500.7, 53527000}}, {{2011, 5, 4}, {
     7475.18, 7534.26, 7355.4, 7373.93, 66109600}}, {{2011, 5, 5}, {
     7416.38, 7423.96, 7291.39, 7376.96, 66841700}}, {{2011, 5, 6}, {
     7391.039999999999, 7501.629999999999, 7362.549999999999, 7492.25, 
      62720800}}, {{2011, 5, 9}, {
     7461.35, 7489.09, 7379.97, 7410.52, 41079200}}, {{2011, 5, 10}, {
     7446.44, 7533.86, 7423.33, 7501.52, 33452900}}, {{2011, 5, 11}, {
     7526.56, 7566.41, 7469.63, 7495.05, 40487200}}, {{2011, 5, 12}, {
     7438.02, 7443.95, 7356.76, 7443.95, 51671100}}, {{2011, 5, 13}, {
     7486.2, 7511.09, 7391.14, 7403.31, 34958000}}, {{2011, 5, 16}, {
     7348.12, 7402.52, 7284.96, 7387.54, 36801300}}, {{2011, 5, 17}, {
     7346.81, 7368.98, 7253.89, 7256.65, 33967300}}, {{2011, 5, 18}, {
     7325.85, 7340.54, 7261.29, 7303.53, 27277100}}, {{2011, 5, 19}, {
     7360.47, 7415.65, 7316.74, 7358.23, 33279100}}, {{2011, 5, 20}, {
     7372.179999999999, 7410.3099999999995`, 7228.129999999999, 7266.82, 
      81539300}}, {{2011, 5, 23}, {
     7158.08, 7166.15, 7105.2, 7121.52, 37996000}}, {{2011, 5, 24}, {
     7129.939999999999, 7202.209999999999, 7128.039999999999, 7150.66, 
      33377800}}, {{2011, 5, 25}, {
     7079.25, 7183.8, 7071.42, 7170.94, 47196600}}, {{2011, 5, 26}, {
     7202.719999999999, 7217.239999999999, 7087.319999999999, 7114.09, 
      46009500}}, {{2011, 5, 27}, {
     7205.13, 7208.48, 7115.48, 7163.47, 30986900}}, {{2011, 5, 30}, {
     7165., 7204.16, 7146.98, 7160.3, 0}}, {{2011, 5, 31}, {
     7240.12, 7319.69, 7238.77, 7293.69, 44550500}}, {{2011, 6, 1}, {
     7310.5599999999995`, 7314.659999999999, 7193.889999999999, 7217.43, 
      33434200}}, {{2011, 6, 2}, {
     7155.86, 7157.59, 7074.12, 7074.12, 24048200}}, {{2011, 6, 3}, {
     7101.48, 7120.12, 7021.36, 7109.03, 32161500}}, {{2011, 6, 6}, {
     7095.4, 7124.31, 7062.73, 7084.57, 25762500}}, {{2011, 6, 7}, {
     7094.14, 7147.63, 7086.9, 7103.25, 27143900}}, {{2011, 6, 8}, {
     7076.31, 7089.15, 6991.62, 7060.23, 32893900}}, {{2011, 6, 9}, {
     7061.87, 7183.78, 7035.86, 7159.66, 33056200}}, {{2011, 6, 10}, {
     7152.55, 7182.83, 7050.84, 7069.9, 33949100}}, {{2011, 6, 13}, {
     7075.91, 7123.88, 7040.42, 7085.14, 15918000}}, {{2011, 6, 14}, {
     7165.14, 7231.49, 7161.21, 7204.79, 30373600}}, {{2011, 6, 15}, {
     7178.05, 7202.17, 7093.23, 7115.08, 33491000}}, {{2011, 6, 16}, {
     7062.18, 7111.64, 7017.98, 7110.2, 39600000}}, {{2011, 6, 17}, {
     7084.27, 7224.11, 7037.24, 7164.05, 80652900}}, {{2011, 6, 20}, {
     7078.59, 7158.24, 7063.86, 7150.21, 26636300}}, {{2011, 6, 21}, {
     7202.88, 7285.51, 7176.74, 7285.51, 32716900}}, {{2011, 6, 22}, {
     7285.93, 7310.1, 7262.37, 7278.19, 30854200}}, {{2011, 6, 23}, {
     7225.2, 7237.2, 7118.52, 7149.44, 36758600}}, {{2011, 6, 24}, {
     7231.73, 7273.32, 7099.22, 7121.38, 40547100}}, {{2011, 6, 27}, {
     7101.15, 7144.44, 7079.11, 7107.9, 28088600}}, {{2011, 6, 28}, {
     7138.5, 7187.08, 7075.19, 7170.43, 37509000}}, {{2011, 6, 29}, {
     7230.95, 7320.3, 7230.95, 7294.14, 38853400}}, {{2011, 6, 30}, {
     7310.339999999999, 7378.349999999999, 7285.439999999999, 7376.24, 
      32845500}}, {{2011, 7, 1}, {
     7374.49, 7443.2, 7357.03, 7419.44, 32625500}}, {{2011, 7, 4}, {
     7427.139999999999, 7450.379999999999, 7416.729999999999, 7442.96, 
      19069400}}, {{2011, 7, 5}, {
     7433.13, 7474.93, 7424.73, 7439.44, 26160900}}, {{2011, 7, 6}, {
     7443.93, 7450.71, 7396.74, 7431.19, 31339000}}, {{2011, 7, 7}, {
     7467.82, 7516.15, 7442.98, 7471.44, 34618500}}, {{2011, 7, 8}, {
     7502.83, 7523.53, 7389.8, 7402.73, 36224100}}, {{2011, 7, 11}, {
     7352.73, 7358.5, 7188.96, 7230.25, 41724900}}, {{2011, 7, 12}, {
     7112.19, 7190.47, 6996.26, 7174.14, 52912600}}, {{2011, 7, 13}, {
     7171.47, 7280.16, 7163.09, 7267.87, 35735100}}, {{2011, 7, 14}, {
     7204.939999999999, 7267.279999999999, 7197.489999999999, 7214.74, 0}}, {{
     2011, 7, 15}, {
     7188.699999999999, 7254.099999999999, 7139.679999999999, 7220.12, 
      43506900}}, {{2011, 7, 18}, {
     7162.82, 7171.55, 7089.09, 7107.92, 35099200}}, {{2011, 7, 19}, {
     7148.479999999999, 7236.439999999999, 7139.759999999999, 7192.67, 0}}, {{
     2011, 7, 20}, {7250.18, 7263.18, 7166.37, 7221.36, 33754900}}, {{2011, 7,
      21}, {7264.98, 7326.61, 7142.43, 7290.14, 0}}, {{2011, 7, 22}, {
     7308.48, 7357.25, 7266.79, 7326.39, 31435600}}, {{2011, 7, 25}, {
     7273.6, 7366.78, 7258.52, 7344.54, 25257100}}, {{2011, 7, 26}, {
     7369.89, 7382.8, 7302.5, 7349.45, 30274400}}, {{2011, 7, 27}, {
     7315.75, 7344.17, 7216.58, 7252.68, 36552400}}, {{2011, 7, 28}, {
     7163.95, 7203.01, 7110.13, 7190.06, 44256400}}, {{2011, 7, 29}, {
     7108.27, 7190.91, 7063.82, 7158.77, 38125300}}, {{2011, 8, 1}, {
     7254.499999999999, 7282.009999999999, 6953.979999999999, 6953.98, 
      42809200}}, {{2011, 8, 2}, {
     6909.43, 6938.34, 6772.38, 6796.75, 46228700}}, {{2011, 8, 3}, {
     6717.84, 6783.07, 6543.6, 6640.59, 60276900}}, {{2011, 8, 4}, {
     6714.79, 6730.43, 6391.54, 6414.76, 64343200}}, {{2011, 8, 5}, {
     6338.7699999999995`, 6436.659999999999, 6152.619999999999, 6236.16, 
      81668200}}, {{2011, 8, 8}, {
     6170.69, 6272.94, 5911.09, 5923.27, 71999800}}, {{2011, 8, 9}, {
     5896.139999999999, 6026.2699999999995`, 5502.629999999999, 5917.08, 
      95099500}}, {{2011, 8, 10}, {
     6040.679999999999, 6089.079999999999, 5549.0199999999995`, 5613.42, 
      87252800}}, {{2011, 8, 11}, {
     5771.21, 5825.08, 5487.82, 5797.66, 72182900}}, {{2011, 8, 12}, {
     5775.96, 6023.75, 5678.62, 5997.74, 52384600}}, {{2011, 8, 15}, {
     6075.589999999999, 6106.109999999999, 6008.009999999999, 6022.24, 
      30978100}}, {{2011, 8, 16}, {
     5957.94, 5998.31, 5849.52, 5994.9, 34177600}}, {{2011, 8, 17}, {
     5910.5, 6018.37, 5870.17, 5948.94, 30907200}}, {{2011, 8, 18}, {
     5854.36, 5892.57, 5535.61, 5602.8, 53714100}}, {{2011, 8, 19}, {
     5581.509999999999, 5595.149999999999, 5345.359999999999, 5480., 
      63842800}}, {{2011, 8, 22}, {
     5412.75, 5591.35, 5408.71, 5473.78, 33877900}}, {{2011, 8, 23}, {
     5529.26, 5636.06, 5452.15, 5532.38, 35757400}}, {{2011, 8, 24}, {
     5579.8, 5743.1, 5514.15, 5681.08, 36724000}}, {{2011, 8, 25}, {
     5739.859999999999, 5777.039999999999, 5451.5199999999995`, 5584.14, 
      46227600}}, {{2011, 8, 26}, {
     5582.5, 5588.69, 5403.58, 5537.48, 36127500}}, {{2011, 8, 29}, {
     5634.0599999999995`, 5714.719999999999, 5587.779999999999, 5670.07, 
      19843600}}, {{2011, 8, 30}, {
     5713.53, 5730.36, 5572.65, 5643.92, 26854200}}, {{2011, 8, 31}, {
     5686.26, 5869.65, 5648.97, 5784.85, 49542100}}, {{2011, 9, 1}, {
     5793.1, 5794.5, 5639.03, 5730.63, 37537700}}, {{2011, 9, 2}, {
     5623.7, 5635.5, 5493.31, 5538.33, 35729600}}, {{2011, 9, 5}, {
     5409.9, 5421.1, 5208.4, 5246.2, 0}}, {{2011, 9, 6}, {
     5248.31, 5332.11, 5150.05, 5193.97, 44398800}}, {{2011, 9, 7}, {
     5332.52, 5406.23, 5276.88, 5405.53, 36320800}}, {{2011, 9, 8}, {
     5410.08, 5473.68, 5313.78, 5408.46, 32435100}}, {{2011, 9, 9}, {
     5383.63, 5400.79, 5174.24, 5189.93, 38534000}}, {{2011, 9, 12}, {
     5063.59, 5126.52, 4965.8, 5072.33, 43750200}}, {{2011, 9, 13}, {
     5153.95, 5222.81, 4969.84, 5166.36, 43188900}}, {{2011, 9, 14}, {
     5108.1, 5347.82, 5105.82, 5340.19, 43360500}}, {{2011, 9, 15}, {
     5386.86, 5566.58, 5374.57, 5508.24, 44832400}}, {{2011, 9, 16}, {
     5607.51, 5655.95, 5524.22, 5573.51, 83673300}}, {{2011, 9, 19}, {
     5447.32, 5496.94, 5362.01, 5415.91, 31196400}}, {{2011, 9, 20}, {
     5373.529999999999, 5577.599999999999, 5369.069999999999, 5571.68, 
      30618100}}, {{2011, 9, 21}, {
     5557.07, 5557.92, 5417.85, 5433.8, 29222200}}, {{2011, 9, 22}, {
     5258.42, 5289.77, 5135.85, 5164.21, 42986900}}, {{2011, 9, 23}, {
     5227.089999999999, 5229.599999999999, 4973.919999999999, 5196.56, 
      40802700}}, {{2011, 9, 26}, {
     5128.56, 5415.56, 5118.19, 5345.56, 41842700}}, {{2011, 9, 27}, {
     5502.889999999999, 5638.039999999999, 5483.229999999999, 5628.44, 
      47598100}}, {{2011, 9, 28}, {
     5560.6, 5700.08, 5520.59, 5578.42, 33258200}}, {{2011, 9, 29}, {
     5555.07, 5704.41, 5533.33, 5639.58, 32227500}}, {{2011, 9, 30}, {
     5602.55, 5606.56, 5438.55, 5502.02, 36597800}}, {{2011, 10, 3}, {
     5311.93, 5437.74, 5289.04, 5376.7, 26285300}}, {{2011, 10, 4}, {
     5284.11, 5288.78, 5125.44, 5216.71, 38128100}}, {{2011, 10, 5}, {
     5341.43, 5486.03, 5266.14, 5473.03, 36853500}}, {{2011, 10, 6}, {
     5511.56, 5645.25, 5465.55, 5645.25, 43781800}}, {{2011, 10, 7}, {
     5647.66, 5749.13, 5606.32, 5675.7, 33773200}}, {{2011, 10, 10}, {
     5705.4, 5872.15, 5652.99, 5847.29, 30469800}}, {{2011, 10, 11}, {
     5825.91, 5883.38, 5773.88, 5865.01, 29914000}}, {{2011, 10, 12}, {
     5851.1, 6022.05, 5798.16, 5994.47, 37347200}}, {{2011, 10, 13}, {
     5969.91, 6036.02, 5878.29, 5914.84, 36374900}}, {{2011, 10, 14}, {
     5934.78, 6037.29, 5885.39, 5967.2, 34489800}}, {{2011, 10, 17}, {
     6021.29, 6081.41, 5819.97, 5859.43, 31908700}}, {{2011, 10, 18}, {
     5781.77, 5907.46, 5747.65, 5877.41, 28418800}}, {{2011, 10, 19}, {
     5909.58, 5977.75, 5874.85, 5913.53, 27125000}}, {{2011, 10, 20}, {
     5834.42, 5914.87, 5752.83, 5766.48, 36015000}}, {{2011, 10, 21}, {
     5800.06, 5980.46, 5769.19, 5970.96, 37582400}}, {{2011, 10, 24}, {
     6014.36, 6067.16, 5937.58, 6055.27, 27538400}}, {{2011, 10, 25}, {
     6026.449999999999, 6157.929999999999, 5964.279999999999, 6046.75, 
      32778700}}, {{2011, 10, 26}, {
     6041.16, 6143.56, 5951.82, 6016.07, 31283600}}, {{2011, 10, 27}, {
     6222.75, 6347.6, 6196.6, 6337.84, 62548700}}, {{2011