//+------------------------------------------------------------------+
//|                                               AGSwingTrading.mq5 |
//|                                                     Chaosfreak   |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Chaosfreak"
#property link      "http://www.mql5.com"
#property version   "1.10"

#include <trade/trade.mqh>

input int Risk = 30;

int magicNumber = 143534;
MqlDateTime lastNewOrderCheck;
MqlDateTime lastExpirationCheck;

double High[], Low[];

double iLow(string symbol, ENUM_TIMEFRAMES timeframe, int index)
{
  double low = 0;
 
  ArraySetAsSeries(Low, true);
  int copied = CopyLow(symbol, timeframe, 0, Bars(symbol, timeframe), Low);
  
  if(copied > 0 && index < copied) 
  {
    low = Low[index];
  }
  
  return(low);
}

double iHigh(string symbol, ENUM_TIMEFRAMES timeframe, int index)
{
  double high = 0;
 
  ArraySetAsSeries(High, true);
  int copied = CopyHigh(symbol, timeframe, 0, Bars(symbol, timeframe), High);
  
  if(copied > 0 && index < copied) 
  {
    high = High[index];
  }
  
  return(high);
}
 
int OnInit()
{
  return(INIT_SUCCEEDED);
}

void OnDeinit(const int reason)
{
}

void OnTick()
{
  CheckNewOrders();
  CheckExpiration();
}

bool IsOrderPlaced(uint retCode)
{
  return(retCode == TRADE_RETCODE_DONE || retCode == TRADE_RETCODE_PLACED);
}

void CheckNewOrders()
{
  string varName, id, symbol, direction;
  int atrHandle;
  double atrBuffer[];
  datetime barDates[];
  ENUM_ORDER_TYPE orderType;
  double atr, spread, entry, slValue, sl, tpValue, tp, volume, point, price, volumeAdjust;  
  MqlDateTime currentDate, barDate;
  CTrade trade;
  
  trade.SetExpertMagicNumber(magicNumber);
  trade.SetTypeFilling(ORDER_FILLING_FOK);
  
  TimeCurrent(currentDate);

  if(currentDate.hour >= 9 && currentDate.hour <= 17 && lastNewOrderCheck.sec + 5 < currentDate.sec)
  {  
     for(int i = GlobalVariablesTotal() - 1; i >= 0; i--)
     {
       varName = GlobalVariableName(i);
       id = StringSubstr(varName, 0, 3);
       
       if(id != "ST_")
       {
         continue;
       }
       
       direction = StringSubstr(varName, 3, 1);
       symbol = StringSubstr(varName, 4);
       
       CopyTime(symbol, PERIOD_D1, 0, 1, barDates);
       TimeToStruct(barDates[0], barDate);
         
       if(barDate.day != currentDate.day)
       {
         continue;
       }
       
       atrHandle = iATR(symbol, PERIOD_D1, 10);
       CopyBuffer(atrHandle, 0, 0, 1, atrBuffer);
       atr = atrBuffer[0];
       point = SymbolInfoDouble(symbol, SYMBOL_POINT);
       price = SymbolInfoDouble(symbol, SYMBOL_ASK);
       
       if(price < 10)
         spread = 0.005;
       else if(price >= 10 && price < 20)
         spread = 0.01;
       else if(price >= 20 && price < 50)
         spread = 0.015;
       else if(price >= 50 && price < 100)
         spread = 0.02;
       else if(price >= 100 && price < 150)
         spread = 0.05;
       else
         spread = 0.1;
       
       slValue = (atr * 0.6) + spread;
       tpValue = atr * 1.8;
       volume = MathRound(Risk / slValue);
       volumeAdjust = GlobalVariableGet(varName);
       
       if(volumeAdjust > 0)
       {
         volume = MathRound(volume * volumeAdjust);
       }       
       
       if(direction == "L")
       {
         orderType = ORDER_TYPE_BUY_STOP;
         entry = iHigh(symbol, PERIOD_D1, 1) + spread; 
         sl = entry - slValue;
         tp = entry + tpValue;            
       }
       else
       {
         orderType = ORDER_TYPE_SELL_STOP;
         entry = iLow(symbol, PERIOD_D1, 1) - spread; 
         sl = entry + slValue;
         tp = entry - tpValue;            
       }
       
       trade.OrderOpen(symbol, orderType, volume, entry, entry, sl, tp, ORDER_TIME_DAY);
       
       if(!IsOrderPlaced(trade.ResultRetcode()))
       {
         if(trade.ResultRetcode() == TRADE_RETCODE_INVALID_PRICE)
         {
           if(direction == "L")
           {
             entry = SymbolInfoDouble(symbol, SYMBOL_ASK);
             sl = entry - slValue;
             tp = entry + tpValue; 
             trade.Buy(volume, symbol, 0, sl, tp);
           }
           else
           {
             entry = SymbolInfoDouble(symbol, SYMBOL_BID);
             sl = entry + slValue;
             tp = entry - tpValue; 
             trade.Sell(volume, symbol, 0, sl, tp);
           }
         }
         
         if(trade.ResultRetcode() == TRADE_RETCODE_MARKET_CLOSED || trade.ResultRetcode() == TRADE_RETCODE_PRICE_OFF)
         {
           continue;
         }
       }
       
       if(IsOrderPlaced(trade.ResultRetcode()))
       {
         GlobalVariableDel(varName);
       }      
     }
  }
  
  TimeCurrent(lastNewOrderCheck);
}

void CheckExpiration()
{
  MqlDateTime currentTime;
  MqlDateTime positionTime; 
  int timeLimit;
  CTrade trade;
  
  TimeCurrent(currentTime);
  
  if(currentTime.hour < 17 || currentTime.min < 20 || lastExpirationCheck.day == currentTime.day)  
    return;     
    
  for(int i = PositionsTotal() - 1; i >= 0; i--)
  {
    PositionSelect(PositionGetSymbol(i));
    
    if(PositionGetInteger(POSITION_MAGIC) != magicNumber)
      continue;
      
    timeLimit = 259200;
    
    TimeToStruct(PositionGetInteger(POSITION_TIME), positionTime);
      
    if(positionTime.day_of_week > 2)
    {
      timeLimit = timeLimit + 172800;
    }
      
    if(PositionGetInteger(POSITION_TIME) + timeLimit < TimeCurrent())
    {
      trade.PositionClose(PositionGetSymbol(i));
    }
  }
  
  for(int i = OrdersTotal() - 1; i >= 0; i--)
  {
    trade.OrderDelete(OrderGetTicket(i));
  }
    
  TimeCurrent(lastExpirationCheck);
}