//+------------------------------------------------------------------+
//|                                                    SpreadATR.mq4 |
//|                                                Christoph |
//|                                              http://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright " Christoph"
#property link      "http://www.mql5.com"
#property version   "1.00"
#property strict
#property indicator_separate_window
#property indicator_buffers 1
#property indicator_plots   1
//--- plot ATRSpread
#property indicator_label1  "ATRSpread"
#property indicator_type1   DRAW_LINE
#property indicator_color1  clrRed
#property indicator_style1  STYLE_SOLID
#property indicator_width1  1
//--- input parameters
input int      ATRPeriode=10;
//--- indicator buffers
double         ATRSpreadBuffer[];
int            i,CurrentTime;
double SpreadGes,Nummer,Mittelwert;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int OnInit()
  {
//--- indicator buffers mapping
   SetIndexBuffer(0,ATRSpreadBuffer);
   
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
 double Spread=MarketInfo(NULL,MODE_SPREAD);
  
 if(CurrentTime != Time[0])
    {
      Nummer=0;
      SpreadGes=0;      
     CurrentTime= Time[0];
    }

      SpreadGes=Spread +  SpreadGes;
      Nummer=Nummer+1;
      Mittelwert=SpreadGes/Nummer/100000;  
      
      
      ATRSpreadBuffer[i]=iATR(NULL,0,ATRPeriode,0)/Mittelwert;
      
      
   return(rates_total);
  }
//+------------------------------------------------------------------+
