//+------------------------------------------------------------------+
//|                                        Market_at_Open_Stocks.mq4 |
//|                                                  Mutzl Christoph |
//|                                                                  |
//+------------------------------------------------------------------+
#property copyright "Mutzl Christoph"
#property link      ""
#property version   "1.00"
#property strict
//--- input parameters
input int      StartMinute=0;
input int      MagicNumber=1;
input int      Volumen_Stk=12;
input string   Direction="Long";
input double   StopLoss=30.5;
input double   Target=35.5;
input double   Stop_Buy_Sell=32.5;

bool Zeit, First, ZeitClose;
int TicketLong, TicketShort;
int TradeDay;
bool ausgefuehrt, busted;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
   
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {


   //
   // CHECKEN OB EINE ORDER OFFEN IST
      int offeneorders=0;
      int orders=OrdersTotal();
   
      for(int i=0;i<orders;i++)
      {    
         if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES))
         {
            if(Symbol()==OrderSymbol() && OrderMagicNumber()==MagicNumber) 
            {
               offeneorders++;
            }
         }   
      }
   
   
 
   
   
   
   /*//
   //Zeit
   if(TimeHour(TimeCurrent())==8 && TimeMinute(TimeCurrent())<=StartMinute) Zeit=FALSE; // Zeiten bernehmbar 1:1 von Amibroker !!!
      else Zeit=TRUE;
      */      
      
   
      
       //
       // Order AB einstellen, geleich zu Marktbeginn (nur wenn wir mit einem Gap erffnen und so ber/unter dem Stop Kurs sind)
        busted=(Direction=="Long" && Ask>Stop_Buy_Sell) || (Direction=="Short" && Bid < Stop_Buy_Sell);
        
        if(TradeDay!= TimeDay(TimeCurrent()) && busted) 
       {
         TradeDay=0;
       
         if(offeneorders ==0 && TradeDay==0 )
         {    
            if(Direction=="Long")
            {
               TicketLong=OrderSend(NULL,OP_BUY,Volumen_Stk,Ask,200,StopLoss,Target,NULL,MagicNumber,0,Green);
               TradeDay=TimeDay(TimeCurrent());
            }
            
            else if(Direction=="Short")
            {
               TicketShort=OrderSend(NULL,OP_SELL,Volumen_Stk,Bid,200,StopLoss,Target,NULL,MagicNumber,0,Red);
               TradeDay=TimeDay(TimeCurrent());
            }                 
                                  
         }
       }
        
        
        
        
        
        
        
        
        
       //Kommt nur zur Ausfhrung wenn der Kurs keinen Sprung ber/unter den Stop Kurs gemacht hat
       // Stop - Short Order & Stop -Long Order
     
       if(TradeDay!= TimeDay(TimeCurrent())&& busted == False) 
       {
         TradeDay=0;
       
         if(offeneorders ==0 && TradeDay==0 )
         {    
            if(Direction=="Long")
            {
               TicketLong=OrderSend(NULL,OP_BUYSTOP,Volumen_Stk,Stop_Buy_Sell,200,StopLoss,Target,NULL,MagicNumber,0,Green);
               TradeDay=TimeDay(TimeCurrent());
            }
            
            else if(Direction=="Short")
            {
               TicketShort=OrderSend(NULL,OP_SELLSTOP,Volumen_Stk,Stop_Buy_Sell,200,StopLoss,Target,NULL,MagicNumber,0,Red);
               TradeDay=TimeDay(TimeCurrent());
            }                 
                                  
         }
       }
  
      
      
      
   //
   // Order bei Marktschluss schlieen wenn sie nicht ausgefhrt wurde !!!
       
      //
      //Zeit
         if(TimeHour(TimeCurrent())==17 && TimeMinute(TimeCurrent())>=20) ZeitClose=True; // Zeiten bernehmbar 1:1 von Amibroker !!!
         else ZeitClose=False;
      
      //
      // Scahuen ob Order ausgefhrt wurde
          for(int i=0;i<orders;i++)
         {    
            if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES))
            {
               if(Symbol()==OrderSymbol() && OrderMagicNumber()==MagicNumber) 
               {
                  if(OrderType()== OP_BUY || OrderType()== OP_SELL)
                     {
                        ausgefuehrt=True;
                     }
                  else ausgefuehrt=False;
               }
            }   
         }
      
       //Short Order & Long Order
     
        for(int i=0;i<orders;i++)
        { 
       
         if(offeneorders >0 && ZeitClose && ausgefuehrt==False)
         {    
            if(OrderSelect(i,SELECT_BY_POS,MODE_TRADES))
            {
               if(Symbol()==OrderSymbol() && OrderMagicNumber()==MagicNumber) 
               {
                  OrderDelete(OrderTicket(),0);
               }
            }      
                                  
         }
       }
      
   
  }
//+------------------------------------------------------------------+
