//+------------------------------------------------------------------+
//|                                      Stock_OCO_Order_at_Open.mq5 |
//|                        Copyright 2015, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2015, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"
#property version   "1.00"
//--- input parameters
input double   MaximalerVerlust = 50;
input string   Direction = "Long";
input int      RisikoPercent = 2;
input int      MagicNumber = 1234;
input bool     AllDayOrder = false;  //wenn true, dann StartHour und StartMinute ohne Funktion
input int      StartHour = 9;
input int      StartMinute = 10;
input int      Nachkommastellen = 2;
input int      DeleteCloseHour = 17;
input int      DeleteCloseMinute = 20;
input int      ZeitStoppTage= 4;
input double   ATRTakeProfit =1.8;
input double   ATRStopLoss =0.6;

int HATR;
int i, Tag, j, Anzahl;
int offeneOrders, PendingOrders;
bool HeuteKeineOrderMehr, Time, GleicheMagic, Once;
int Spread;
double AvgTR[], h[], l[];
double StopBuySell, TakeProfit, StopLoss, StopLossValue;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
      HATR = iATR(NULL,0,10);
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
   
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
   
   MqlTradeRequest request;
   MqlTradeResult result;
   MqlDateTime dt;
   ZeroMemory(request);
   
   ulong ticket, tickethistory;
   
  
   
   //Arrays definieren
   CopyBuffer(HATR,0,0,2,AvgTR);
   
   CopyHigh(Symbol(),0,0,2,h); //der 2er steht dafr dass ich nur einen Tag in die Vergangenheit gehen muss
   CopyLow(Symbol(),0,0,2,l);
   
   ArraySetAsSeries(AvgTR,true);
   ArraySetAsSeries(h,true);
   ArraySetAsSeries(l,true);
   
   
   //StopBuy, TakeProfit, StopLoss
   if(Direction == "Long")
   {
   StopBuySell =NormalizeDouble(h[1] + h[1]*0.0005,Nachkommastellen);
   TakeProfit = NormalizeDouble(StopBuySell + StopBuySell*0.003 + AvgTR[1]*ATRTakeProfit,Nachkommastellen);
   StopLoss = NormalizeDouble(StopBuySell - StopBuySell*0.003 - AvgTR[1]*ATRStopLoss,Nachkommastellen);
   StopLossValue= StopBuySell - StopLoss;
   Anzahl = MathFloor((AccountInfoDouble(ACCOUNT_BALANCE)*RisikoPercent/100) / StopLossValue);  
   }
   else 
   {
   StopBuySell = NormalizeDouble(l[1] -l[1]*0.0005,Nachkommastellen);
   TakeProfit = NormalizeDouble(StopBuySell - StopBuySell*0.003 - AvgTR[1]*ATRTakeProfit,Nachkommastellen);
   StopLoss = NormalizeDouble(StopBuySell + StopBuySell*0.003 + AvgTR[1]*ATRStopLoss,Nachkommastellen);
   StopLossValue= StopLoss -StopBuySell ;
   Anzahl = MathFloor((AccountInfoDouble(ACCOUNT_BALANCE)*RisikoPercent/100) / StopLossValue);  
   }
  
  

   //Positionsgre festlegen
   request.volume       =Anzahl;
 
 
    //nur eine Order ffnen!!
   //zhlt eine Pending Order
   offeneOrders=0;
   PendingOrders=0;
   for(i=0;i<OrdersTotal();i++)
     {
        ticket=OrderGetTicket(i);
        if(OrderGetString(ORDER_SYMBOL)==Symbol())
        {            
          PendingOrders++; 
          offeneOrders++;       
        }
     }
    
   // Zhlt eine offene Order 
   for(i=0;i<PositionsTotal();i++)
     {
      if(Symbol()==PositionGetSymbol(i)&& PositionGetInteger(POSITION_MAGIC)==MagicNumber)
      {
      offeneOrders++;     
      }
     }
 
 
 
   //Allgemeine request Bezeichnungen zuordenen
   request.symbol       =Symbol();
   request.tp           =TakeProfit;
   request.sl           =StopLoss;
   request.deviation    =100;
   request.magic        =MagicNumber;
   request.type_filling =ORDER_FILLING_FOK;
   
   
   
   //Spezielle request Bezeichnungen zuordnen
   if(Direction=="Long" )
   {
   request.type         =ORDER_TYPE_BUY_STOP;
   }
   else
   {
   request.type         =ORDER_TYPE_SELL_STOP;
   }
      

   TimeCurrent(dt);
   Spread=SymbolInfoInteger(Symbol(),SYMBOL_SPREAD);
   
 
     
   //Order wird nur erffnet wenn der Ask unterhalb von (Target+StopBuySell)/2 ist. [das soll ein zu groes Risiko verhindern]
   //Eine Marketorder wird ausgefhrt wenn der Preis ber dem StopbuySell liegt (Gap)
   //ansonsten wird eine PendingOrder ausgefhrt
   //Order zu einer bestimmten Zeit ffnen 
   //Order wird nur erstellt, wenn heute noch keine Order auf diesem Wert offen war
   //und Order wird nur erffnet wenn diese MAgic noch nie auf diesem Symbol verwendet wurde
   HeuteKeineOrderMehr=0;
   GleicheMagic = 0;
   HistorySelect(0,TimeCurrent());
   
   for(i=0;i<HistoryDealsTotal();i++)
   {
      tickethistory=HistoryDealGetTicket(i);
      
      if(Symbol()==HistoryDealGetString(tickethistory,DEAL_SYMBOL) && TimeToString(TimeCurrent(dt),TIME_DATE)== TimeToString(HistoryDealGetInteger(tickethistory,DEAL_TIME),TIME_DATE))
      {
         HeuteKeineOrderMehr=1;     
      }
      
      if(Symbol()==HistoryDealGetString(tickethistory,DEAL_SYMBOL) && HistoryDealGetInteger(tickethistory,DEAL_MAGIC) == MagicNumber )
      {
         GleicheMagic=1;     
      }

   }
  

   //Zeitfilter ein oder ausschalten!
   if(AllDayOrder == true)
   {
      Time = 0;
   }
   else Time = dt.hour == StartHour && dt.min <= StartMinute;
   
   
   //Order prfen und aufgeben
 if( Time == 0 && offeneOrders==0 && HeuteKeineOrderMehr==0)// && GleicheMagic==0)
 { 
   if(Direction=="Long" && SymbolInfoDouble(Symbol(),SYMBOL_ASK)>=StopBuySell && ((TakeProfit+StopBuySell)/2)>SymbolInfoDouble(Symbol(),SYMBOL_ASK))
   {                     
   request.action       =TRADE_ACTION_DEAL;
   request.price        =SymbolInfoDouble(Symbol(),SYMBOL_ASK);
   request.type         =ORDER_TYPE_BUY;
   request.comment      ="RSI Long Market mit " +Spread+"Spread (in Punkten)";
   OrderSend(request,result);
   Tag=dt.day; j=1;
   }
   else if (Direction=="Short" && SymbolInfoDouble(Symbol(),SYMBOL_BID)<=StopBuySell && SymbolInfoDouble(Symbol(),SYMBOL_BID)>((StopBuySell+TakeProfit)/2))
   {
   request.action       =TRADE_ACTION_DEAL;
   request.price        =SymbolInfoDouble(Symbol(),SYMBOL_BID);
   request.type         =ORDER_TYPE_SELL;
   request.comment      ="RSI Short Market mit "+Spread+"Spread (in Punkten)";
   OrderSend(request,result);
   Tag=dt.day; j=1;
   }
   else if(Direction=="Long" && SymbolInfoDouble(Symbol(),SYMBOL_ASK)<StopBuySell )
   {
   request.action       =TRADE_ACTION_PENDING;
   request.price        =StopBuySell;
   request.type         =ORDER_TYPE_BUY_STOP;
    request.comment      ="RSI Long Stop mit "+Spread+"Spread (in Punkten)";
   OrderSend(request,result);
   Tag=dt.day; j=1;
   }
   else if (Direction=="Short" && SymbolInfoDouble(Symbol(),SYMBOL_BID)>StopBuySell)
   {
   request.action       =TRADE_ACTION_PENDING;
   request.price        =StopBuySell;
   request.type         =ORDER_TYPE_SELL_STOP;
   request.comment      ="RSI Short Stop mit "+Spread+"Spread (in Punkten)";
   OrderSend(request,result);
   Tag=dt.day; j=1;
   }
 }
        
    
  
   
   //Pendingorder zu einer bestimmten Zeit wiederum lschen 
   if(PendingOrders>0 && dt.hour==DeleteCloseHour && dt.min>=DeleteCloseMinute)
   {
       request.action=TRADE_ACTION_REMOVE;
       request.order=ticket;
       OrderSend(request,result); 
   }




   //Wenn ich mit dieser Position um einen gewissen Geldbetrag im Minus bin, dann sofort Order schlieen
      for(i=0;i<PositionsTotal();i++)
     {            
      if(Symbol()==PositionGetSymbol(i)&& PositionGetInteger(POSITION_MAGIC)==MagicNumber && (PositionGetDouble(POSITION_PROFIT)<(MaximalerVerlust*-1)))
      { 
         if(PositionGetInteger(POSITION_TYPE)==POSITION_TYPE_BUY)
         {  
            request.sl           =0; 
            request.tp           =0;   
            request.volume       =PositionGetDouble(POSITION_VOLUME);
            request.action       =TRADE_ACTION_DEAL;
            request.price        =SymbolInfoDouble(Symbol(),SYMBOL_BID);
            request.type         =ORDER_TYPE_SELL;
            request.comment      ="Maximalverlust erreicht mit "+Spread + "Spread (in Punkten)"; 
            OrderSend(request,result);          
         }
         
         else if (PositionGetInteger(POSITION_TYPE)==POSITION_TYPE_SELL)
         {  
            request.sl           =0; 
            request.tp           =0;         
            request.volume       =PositionGetDouble(POSITION_VOLUME);
            request.action       =TRADE_ACTION_DEAL;
            request.price        =SymbolInfoDouble(Symbol(),SYMBOL_ASK);
            request.type         =ORDER_TYPE_BUY;
            request.comment      ="Maximalverlust erreicht mit "+Spread + "Spread (in Punkten)"; 
            OrderSend(request,result);          
         }
      }
     }
   
     
   //nach x Tagen automatisch am ende des Tages schlieen!!
      if(Tag != dt.day)
      {
        Tag= dt.day;
        j++;
      }
   
   
      for(i=0;i<PositionsTotal();i++)
     {
      if(Symbol()==PositionGetSymbol(i)&& PositionGetInteger(POSITION_MAGIC)==MagicNumber && j >= ZeitStoppTage && dt.hour==DeleteCloseHour && dt.min>=DeleteCloseMinute )
      { 

         if(PositionGetInteger(POSITION_TYPE)==POSITION_TYPE_BUY)
         {  
            request.sl           =0; 
            request.tp           =0;   
            request.volume       =PositionGetDouble(POSITION_VOLUME);
            request.action       =TRADE_ACTION_DEAL;
            request.price        =SymbolInfoDouble(Symbol(),SYMBOL_BID);
            request.type         =ORDER_TYPE_SELL;
            request.comment      ="Zeitstopp erreicht mit "+Spread + "Spread (in Punkten)"; 
            OrderSend(request,result);          
         }
         
         else if (PositionGetInteger(POSITION_TYPE)==POSITION_TYPE_SELL)
         {  
            request.sl           =0; 
            request.tp           =0;         
            request.volume       =PositionGetDouble(POSITION_VOLUME);
            request.action       =TRADE_ACTION_DEAL;
            request.price        =SymbolInfoDouble(Symbol(),SYMBOL_ASK);
            request.type         =ORDER_TYPE_BUY;
            request.comment      ="Zeitstopp erreicht mit "+Spread + "Spread (in Punkten)"; 
            OrderSend(request,result);          
         }
      }
     }


   

   //Wenn der Trade mit einerm Gap eingestoppt wird, dann muss der SL nachgezogen werden, sodass das gleiche Risiko wie am Anfang besteht!
   for(i=0;i<PositionsTotal();i++)
     {            
      if(Symbol()==PositionGetSymbol(i)&& PositionGetInteger(POSITION_MAGIC)==MagicNumber  )
      { 
         if(PositionGetInteger(POSITION_TYPE)==POSITION_TYPE_BUY && PositionGetDouble(POSITION_PRICE_OPEN) >  StopBuySell && Once==0)
         {  
            request.sl           =NormalizeDouble((PositionGetDouble(POSITION_PRICE_OPEN) -  StopBuySell) + StopLoss,Nachkommastellen); 
            request.action       =TRADE_ACTION_SLTP; 
            OrderSend(request,result); 
            Once=1;         
         }
         
         else if (PositionGetInteger(POSITION_TYPE)==POSITION_TYPE_SELL && PositionGetDouble(POSITION_PRICE_OPEN) <  StopBuySell && Once==0 )
         {  
            request.sl           =NormalizeDouble(StopLoss - (StopBuySell - PositionGetDouble(POSITION_PRICE_OPEN)),Nachkommastellen) ; 
            request.action       =TRADE_ACTION_SLTP; 
            OrderSend(request,result);  
            Once=1;        
         }
      }
     }

   
  }
//+------------------------------------------------------------------+
