//+------------------------------------------------------------------+
//|                                          Stock_FS_MethodeMT4.mq4 |
//|                        Copyright 2015, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2015, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"
#property version   "1.00"
#property strict

#include <stderror.mqh> 
#include <stdlib.mqh> 

//--- input parameters
input double   MaximalerVerlust = 50;
input string   Direction = "Long";
input int      RisikoPercent = 2;
input int      MagicNumber = 1234;
input bool     AllDayOrder = false;  //wenn true, dann StartHour und StartMinute ohne Funktion
input int      StartHour = 9;
input int      StartMinute = 10;
input int      Nachkommastellen = 2;
input int      DeleteCloseHour = 17;
input int      DeleteCloseMinute = 20;
input int      ZeitStoppTage= 4;
input double   ATRTakeProfit =1.8;
input double   ATRStopLoss =0.6;

int Anzahl;
bool HeuteKeineOrderMehr, GleicheMagic, Once;
double h[], l[];
double StopBuySell, TakeProfit, StopLoss, StopLossValue;

//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
   CopyHigh(Symbol(), PERIOD_D1, 0, 2, h); //der 2er steht dafr dass ich nur einen Tag in die Vergangenheit gehen muss
   CopyLow(Symbol(), PERIOD_D1, 0, 2, l);
   
   ArraySetAsSeries(h,true);
   ArraySetAsSeries(l,true);
   
   double atrYesterday = iATR(Symbol(), PERIOD_D1, 10, 1);
   
   //StopBuy, TakeProfit, StopLoss
   if(Direction == "Long")
   {
   StopBuySell =NormalizeDouble(h[1] + h[1]*0.0005,Nachkommastellen);
   TakeProfit = NormalizeDouble(StopBuySell + StopBuySell*0.003 + atrYesterday*ATRTakeProfit,Nachkommastellen);
   StopLoss = NormalizeDouble(StopBuySell - StopBuySell*0.003 - atrYesterday*ATRStopLoss,Nachkommastellen);
   StopLossValue= StopBuySell - StopLoss;
   Anzahl = (int)MathFloor((AccountInfoDouble(ACCOUNT_BALANCE)*RisikoPercent/100) / StopLossValue);  
   }
   else 
   {
   StopBuySell = NormalizeDouble(l[1] -l[1]*0.0005,Nachkommastellen);
   TakeProfit = NormalizeDouble(StopBuySell - StopBuySell*0.003 - atrYesterday*ATRTakeProfit,Nachkommastellen);
   StopLoss = NormalizeDouble(StopBuySell + StopBuySell*0.003 + atrYesterday*ATRStopLoss,Nachkommastellen);
   StopLossValue= StopLoss -StopBuySell ;
   Anzahl = (int)MathFloor((AccountInfoDouble(ACCOUNT_BALANCE)*RisikoPercent/100) / StopLossValue);  
   }

   //auf maximalen Verlust begrenzen
   double maxLoss = Anzahl * MathAbs(StopBuySell - StopLoss);
   if(maxLoss > MaximalerVerlust)
     Anzahl = (int)(MaximalerVerlust / MathAbs(StopBuySell - StopLoss));
  
   bool openOrPendingOrders = false;
   for(int i=0; i<OrdersTotal(); i++)
   {    
      if(OrderSelect(i, SELECT_BY_POS, MODE_TRADES))
      {
         if(Symbol() == OrderSymbol() && OrderMagicNumber() == MagicNumber) 
         {
            openOrPendingOrders = true;
            break;
         }
      }   
   }
     
   //Order wird nur erffnet wenn der Ask unterhalb von (Target+StopBuySell)/2 ist. [das soll ein zu groes Risiko verhindern]
   //Eine Marketorder wird ausgefhrt wenn der Preis ber dem StopbuySell liegt (Gap)
   //ansonsten wird eine PendingOrder ausgefhrt
   //Order zu einer bestimmten Zeit ffnen 
   //Order wird nur erstellt, wenn heute noch keine Order auf diesem Wert offen war
   //und Order wird nur erffnet wenn diese MAgic noch nie auf diesem Symbol verwendet wurde

   HeuteKeineOrderMehr=0;
   GleicheMagic = 1;
   for(int i=0; i<OrdersTotal(); i++)
   {    
      if(OrderSelect(i, SELECT_BY_POS, MODE_HISTORY))
      {
         if(Symbol() == OrderSymbol() && OrderMagicNumber() == MagicNumber) 
         {
            if(Year() == TimeYear(OrderCloseTime()) && DayOfYear() == TimeDayOfYear(OrderCloseTime()))
               HeuteKeineOrderMehr=1;     
         }
      }   
   }
   
   bool placeOrder = true;
   if(AllDayOrder == false) //Zeitfilter ein oder ausschalten! 
     placeOrder = !(Hour() == StartHour && Minute() <= StartMinute);
   
   MqlDateTime dt;
   TimeCurrent(dt);
   dt.hour = DeleteCloseHour;
   dt.min = DeleteCloseMinute;
   datetime expiration = StructToTime(dt);
   
   //Order prfen und aufgeben
   if( placeOrder && !openOrPendingOrders && HeuteKeineOrderMehr==0)// && GleicheMagic==0)
   { 
      if(Direction=="Long" && SymbolInfoDouble(Symbol(),SYMBOL_ASK)>=StopBuySell && ((TakeProfit+StopBuySell)/2)>SymbolInfoDouble(Symbol(),SYMBOL_ASK))
      { //gap up                    
         double ask = SymbolInfoDouble(Symbol(), SYMBOL_ASK);
         StopLoss = NormalizeDouble((ask -  StopBuySell) + StopLoss,Nachkommastellen); //SL nachziehen, sodass das gleiche Risiko wie am Anfang besteht!
         maxLoss = Anzahl * (ask - StopLoss);
         if(maxLoss > MaximalerVerlust)
           Anzahl = (int)(MaximalerVerlust / (ask - StopLoss));
      
         if(OrderSend(Symbol(), OP_BUY, Anzahl, SymbolInfoDouble(Symbol(), SYMBOL_ASK), 100, StopLoss, TakeProfit, NULL, MagicNumber, expiration) == -1)
            Print("OrderSend Error: ", ErrorDescription(GetLastError())); 
      }
      else if (Direction=="Short" && SymbolInfoDouble(Symbol(),SYMBOL_BID)<=StopBuySell && SymbolInfoDouble(Symbol(),SYMBOL_BID)>((StopBuySell+TakeProfit)/2))
      { //gap down
         double bid = SymbolInfoDouble(Symbol(), SYMBOL_BID);
         StopLoss = NormalizeDouble(StopLoss - (StopBuySell - bid),Nachkommastellen); //SL nachziehen, sodass das gleiche Risiko wie am Anfang besteht!
         maxLoss = Anzahl * (StopLoss - bid);
         if(maxLoss > MaximalerVerlust)
           Anzahl = (int)(MaximalerVerlust / (StopLoss - bid));
      
         if(OrderSend(Symbol(), OP_SELL, Anzahl, SymbolInfoDouble(Symbol(), SYMBOL_BID), 100, StopLoss, TakeProfit, NULL, MagicNumber, expiration) == -1)
            Print("OrderSend Error: ", ErrorDescription(GetLastError())); 
      }
      else if(Direction=="Long" && SymbolInfoDouble(Symbol(),SYMBOL_ASK)<StopBuySell )
      {
         if(OrderSend(Symbol(), OP_BUYSTOP, Anzahl, StopBuySell, 100, StopLoss, TakeProfit, NULL, MagicNumber, expiration) == -1)
            Print("OrderSend Error: ", ErrorDescription(GetLastError())); 
      }
      else if (Direction=="Short" && SymbolInfoDouble(Symbol(),SYMBOL_BID)>StopBuySell)
      {
         if(OrderSend(Symbol(), OP_SELLSTOP, Anzahl, StopBuySell, 100, StopLoss, TakeProfit, NULL, MagicNumber, expiration) == -1)
            Print("OrderSend Error: ", ErrorDescription(GetLastError())); 
      }
   }

   //nach x Tagen automatisch am Ende des Tages schlieen!!
   for(int i=0; i<OrdersTotal(); i++)
   {    
      if(OrderSelect(i, SELECT_BY_POS, MODE_TRADES))
      {
         if(Symbol() == OrderSymbol() && OrderMagicNumber() == MagicNumber) 
         {
            datetime openTime = OrderOpenTime();
            if(openTime > 0 && (TimeCurrent() - openTime) > (ZeitStoppTage-1) * 86400)
            {
               if(Hour()==DeleteCloseHour && Minute()>=DeleteCloseMinute) 
               {
                  if(OrderType() == OP_BUY || OrderType() == OP_BUYSTOP) 
                  {
                     if(!OrderClose(OrderTicket(), OrderLots(), Bid, 100))
                        Print("OrderSend Error: ", ErrorDescription(GetLastError())); 
                  }
                  else
                  {
                     if(!OrderClose(OrderTicket(), OrderLots(), Ask, 100))
                        Print("OrderSend Error: ", ErrorDescription(GetLastError())); 
                  }
               }
            }
         }
      }   
   }
 
  }
//+------------------------------------------------------------------+
