//+------------------------------------------------------------------+
//|                                                          CVI.mq4 |
//|                                 Copyright 2013, Gehtsoft USA LLC |
//|                                       http://www.fxcodebase.com/ |
//+------------------------------------------------------------------+
#property copyright "Copyright 2013, Gehtsoft USA LLC"
#property link      "http://www.fxcodebase.com/"
#property indicator_buffers 1
#property indicator_separate_window
#property indicator_color1 Red
//--- input parameters
extern int       CVI_Period=14;
extern int       MA_Method=0;
extern int       Price_Method=4;
extern bool Modified_Algorithm = true;  

extern double    Overbought=0.5;
extern double    Oversold= -0.5;
extern color Overbought_Oversold_Color = Gray;


double CVI[];
 


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators

  IndicatorShortName("CVI");
  IndicatorDigits(Digits);  
   IndicatorBuffers(1);
   
   
    SetIndexBuffer(0,CVI);
   SetIndexStyle(0,DRAW_LINE); 
  
   
  
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   ObjectsDeleteAll();
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
  
  
    int ExtCountedBars=IndicatorCounted();
	 if (ExtCountedBars<0) return(0);
	 
   int    limit=Bars;
   
   
//----
 if (limit<CVI_Period) return(0);	
 
 int i;
 
 
          for( i=limit-CVI_Period+1; i>=0; i--)
		   {
		   
		     double MA=iMA(NULL,0,CVI_Period,0,MA_Method,Price_Method,i);
			double ATR= iATR(	NULL,0, CVI_Period, i);

			
					if (Modified_Algorithm) 
					 {        
					 if (ATR!=0) CVI[i]=(Close[i]-MA)/( ATR* MathSqrt(CVI_Period));
					}else
					{			
					 if (ATR!=0)  CVI[i]=(Close[i]-MA)/ ATR;
					}	
			
			
           }			
   

   
 
   
//------------------------------------------------------------------------
      int windowIndex=WindowFind("CVI");
   // finding the window number of our indicator
   
   if(windowIndex<0)
   {
      // if the number is -1, there is an error
      Print("Can\'t find window");
      return(0);
   }  
 
   ObjectCreate("OB",OBJ_HLINE,windowIndex,0,Overbought);
   ObjectCreate("OS",OBJ_HLINE,windowIndex,0,Oversold);
   
   ObjectSet("OB",OBJPROP_COLOR,Overbought_Oversold_Color);
   ObjectSet("OB",OBJPROP_WIDTH,3);
   
    ObjectSet("OS",OBJPROP_COLOR,Overbought_Oversold_Color);
   ObjectSet("OS",OBJPROP_WIDTH,3);
 
   WindowRedraw();        
//----
   return(0);
  }
//+------------------------------------------------------------------+