//+------------------------------------------------------------------+
//|                                                   i-ABCDathe.mq4 |
//|                Copyright 2014, tom-next.com, Alexander Piechotta |
//|                                          http://www.tom-next.com |
//+------------------------------------------------------------------+
// MQL4 Code //
///////////////
#property copyright "2014, tom-next.com, Alexander Piechotta"
#property link      "http://www.tom-next.com"
#property version   "1.00"
#property description "tom-next.community project"
#property description "Ein Indikator zur Untersttzung fr den Handel nach der Friedrich Dathe Methode."
/*
Dem neuen Programmierer ist erlaubt, aber nicht verpflichtet, den obigen Copyright wie folgt zu ndern:
Copyright (c) 2014, 2016 www.tom-next.com,  Alexander Piechotta, Thomas Mustermann,...

Bei Modifikationen dieses Source Codes sollte der Programmierer dass dem Aenderungsprotokoll zufgen, 
mit Versionsnummer, Datum, Name und welche Aenderungen. 

Ein Beispiel:

/*=====Change Log=====
*
* v1.0, 24. Dezember, 1994, Sabine Musterfrau
*   -Diese Datei wurde ab dieser Version hinzugefgt
*
* v1.5, 4. April, 1997, Thomas Mustermann
*   -Int newFunc() {...}
*
*/


/*=====Change Log=====
*
* v1.0, 24. August, 2014, Alexander Piechotta
*   -Diese Datei wurde ab dieser Version hinzugefgt
*
*/
#property indicator_chart_window
#property indicator_buffers 8
#property indicator_plots   8

#property indicator_type1   DRAW_NONE
#property indicator_type2   DRAW_NONE
#property indicator_type3   DRAW_NONE
#property indicator_type4   DRAW_NONE
#property indicator_type5   DRAW_NONE
#property indicator_type6   DRAW_NONE
#property indicator_type7   DRAW_NONE
#property indicator_type8   DRAW_NONE

#property indicator_label1  "a Upper"
#property indicator_label2  "a Lower"
#property indicator_label3  "b Upper"
#property indicator_label4  "b Lower"
#property indicator_label5  "c Upper"
#property indicator_label6  "c Lower"
#property indicator_label7  "d Upper"
#property indicator_label8  "d Lower"

//--- zeige nur bestimme ABCD Formation
enum ABCD_Show 
  {
   S=0,     // Upper & Lower
   M=1,     // nur Upper
   T=2,     // nur Lower
  };
//--- input parameters
input ABCD_Show ShowOnly=S; //Zeige ABCD Formation:
//--- input parameters 
sinput bool ABCD_successively=false; //ABCD Formation einzeln, nacheinander
sinput int A_Min_Bars_Left=1; // hchste/tiefste A der letzten X Kerzen
                              
//---- indicator buffers
double a_upper[];
double a_lower[];
double b_upper[];
double b_lower[];
double c_upper[];
double c_lower[];
double d_upper[];
double d_lower[];

string  tx="";

color Color=clrGold; //Farbe fr Upper A/B/C/D
double  dy;

//--- class with the LetterABCD indicator calculation methods 
#include "ABCDOnBuffer.mqh" 
//--- class with the LetterABCD indicator text fuer Chart
#include	"ABCDOnChart.mqh"

CLetterABCDOnBuffer  letter;
CLetterABCDOnChart   upper;
CLetterABCDOnChart   lower;
//+------------------------------------------------------------------+ 
//| Custom indicator initialization function                         | 
//+------------------------------------------------------------------+ 
int OnInit()
  {
//--- initialize the ABCD indicator class instance: 
   if(!letter.Init(A_Min_Bars_Left,ABCD_successively)) return(INIT_FAILED);
   if(!upper.Init("up",Color)) return(INIT_FAILED);
   if(!lower.Init("lo",Color)) return(INIT_FAILED);
//--- indicator setting 
   IndicatorSetInteger(INDICATOR_DIGITS,_Digits);

//--- indicator buffers mapping 
   SetIndexBuffer(0,a_upper,INDICATOR_DATA);
   SetIndexBuffer(1,a_lower,INDICATOR_DATA);
   SetIndexBuffer(2,b_upper,INDICATOR_DATA);
   SetIndexBuffer(3,b_lower,INDICATOR_DATA);
   SetIndexBuffer(4,c_upper,INDICATOR_DATA);
   SetIndexBuffer(5,c_lower,INDICATOR_DATA);
   SetIndexBuffer(6,d_upper,INDICATOR_DATA);
   SetIndexBuffer(7,d_lower,INDICATOR_DATA);
//--- 
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+ 
//| Custom indicator iteration function                              | 
//+------------------------------------------------------------------+ 
int OnCalculate(const int rates_total,
                const int prev_calculated,
                const datetime &time[],
                const double &open[],
                const double &high[],
                const double &low[],
                const double &close[],
                const long &tick_volume[],
                const long &volume[],
                const int &spread[])
  {
   //--- save as_series flags: 
    ArraySetAsSeries(a_upper, false); 
    ArraySetAsSeries(a_lower, false); 
    ArraySetAsSeries(b_upper, false); 
    ArraySetAsSeries(b_lower, false); 
    ArraySetAsSeries(c_upper, false); 
    ArraySetAsSeries(c_lower, false); 
    ArraySetAsSeries(d_upper, false); 
    ArraySetAsSeries(d_lower, false); 
    ArraySetAsSeries(time, false); 
    ArraySetAsSeries(high, false); 
    ArraySetAsSeries(low, false); 
  
//--- indicator calculation, based on the timeseries 
   letter.MainOnArray(rates_total,prev_calculated,high,low);

//--- Text Abstand vom high/low
   dy=0; for(int a=1; a<=letter.Size(); a++) dy+=0.1*(high[a]-low[a])/letter.Size();

//--- first calculation: 
   int start=0;
   if(prev_calculated==0)
     {
      start=rates_total-letter.Size();
      ArrayInitialize(a_upper,EMPTY_VALUE);
      ArrayInitialize(a_lower,EMPTY_VALUE);
      ArrayInitialize(b_upper,EMPTY_VALUE);
      ArrayInitialize(b_lower,EMPTY_VALUE);
      ArrayInitialize(c_upper,EMPTY_VALUE);
      ArrayInitialize(c_lower,EMPTY_VALUE);
      ArrayInitialize(d_upper,EMPTY_VALUE);
      ArrayInitialize(d_lower,EMPTY_VALUE);
     }
//--- number of bars was changed(jeder Tick): 
   else start=prev_calculated-letter.Size();
   
//--- use the data from the ABCD buffer, 
//    for example, copy data to the indicator buffer: 
   for(int i=start;i<rates_total && !IsStopped();i++)
     {
      //--- Flle den Indikator Buffer     
      a_upper[i]= letter.upper[rates_total-1-i].a;
      a_lower[i]= letter.lower[rates_total-1-i].a;
      b_upper[i]= letter.upper[rates_total-1-i].b;
      b_lower[i]= letter.lower[rates_total-1-i].b;
      c_upper[i]= letter.upper[rates_total-1-i].c;
      c_lower[i]= letter.lower[rates_total-1-i].c;
      d_upper[i]= letter.upper[rates_total-1-i].d;
      d_lower[i]= letter.lower[rates_total-1-i].d;

      //--- Fill chart with Text ABCD upper
      tx="";
      tx += (a_upper[i]==EMPTY_VALUE)?"":"a";
      tx += (b_upper[i]==EMPTY_VALUE)?"":"b";
      tx += (c_upper[i]==EMPTY_VALUE)?"":"c";
      tx += (d_upper[i]==EMPTY_VALUE)?"":"d";
      if(tx!="") upper.AddText(i,time[i],high[i]+1*dy,tx);

      //--- Fill chart with Text ABCD lower
      tx="";
      tx += (a_lower[i]==EMPTY_VALUE)?"":"a";
      tx += (b_lower[i]==EMPTY_VALUE)?"":"b";
      tx += (c_lower[i]==EMPTY_VALUE)?"":"c";
      tx += (d_lower[i]==EMPTY_VALUE)?"":"d";
      if(tx!="") lower.AddText(i,time[i],low[i]-1*dy,tx);
     }

//--- return value of prev_calculated for next call: 
   return(rates_total);
  }
//+------------------------------------------------------------------+
