//+------------------------------------------------------------------+
//|                                      Stock_OCO_Order_at_Open.mq5 |
//|                        Copyright 2015, MetaQuotes Software Corp. |
//|                                             https://www.mql5.com |
//+------------------------------------------------------------------+
#property copyright "Copyright 2015, MetaQuotes Software Corp."
#property link      "https://www.mql5.com"
#property version   "1.00"



enum ENUM_DIRECTION{
   TRADE_LONG=1, //Long
   TRADE_SHORT=-1 //Short
};
string Direction;

//--- input parameters
//input double   MaximalerVerlust=50;
input double   minCRV=2; //Minimum CRV, if Opening Gap
input double   TakeProfit=0;
input double   StopLoss=0;
input double   StopBuySell=0;
input ENUM_DIRECTION   Dir=1;
input int      Anzahl=10;
input int      MagicNumber=1234;

int i;
int offeneOrders, PendingOrders;
bool HeuteKeineOrderMehr;
int Spread;
//+------------------------------------------------------------------+
//| Expert initialization function                                   |
//+------------------------------------------------------------------+
int OnInit()
  {
//---
   string message="";
   if(Dir==TRADE_LONG)
      Direction="Long";
   if(Dir==TRADE_SHORT)
      Direction="Short";
   if ((TakeProfit-StopBuySell)*Dir<=0)
      message="Entry and TP do not match direction of trade.";
   if ((StopBuySell-StopLoss)*Dir<=0)
      message="Entry and SL do not match direction of trade."; 
   if (message!="")
   {
      MessageBox(message,"Operation failed", MB_ICONERROR);
      ExpertRemove(); //entfernt EA
      Comment("Check Parameters!"); //zeigt Hinweis in Ecke des Charts   
   } else
      Comment(" "); //lscht Hinweis in Ecke des Charts 
//---
   return(INIT_SUCCEEDED);
  }
//+------------------------------------------------------------------+
//| Expert deinitialization function                                 |
//+------------------------------------------------------------------+
void OnDeinit(const int reason)
  {
//---
   
  }
//+------------------------------------------------------------------+
//| Expert tick function                                             |
//+------------------------------------------------------------------+
void OnTick()
  {
   
   MqlTradeRequest request;
   MqlTradeResult result;
   MqlDateTime dt;
   ZeroMemory(request);
   
   ulong ticket, tickethistory;
   
   //Allgemeine request Bezeichnungen zuordenen
   request.symbol       =Symbol();
   request.volume       =Anzahl;
   request.tp           =TakeProfit;
   request.sl           =StopLoss;
   request.deviation    =100;
   request.magic        =MagicNumber;
   request.type_filling =ORDER_FILLING_FOK;
   
   
   //Spezielle request Bezeichnungen zuordnen
   if(Direction=="Long")
   {
   request.type         =ORDER_TYPE_BUY_STOP;
   }
   else
   {
   request.type         =ORDER_TYPE_SELL_STOP;
   }
      

   TimeCurrent(dt);
   Spread=SymbolInfoInteger(Symbol(),SYMBOL_SPREAD);
   
 
   
   //nur eine Order ffnen!!
   //zhlt eine Pending Order
   offeneOrders=0;
   PendingOrders=0;
   for(i=0;i<OrdersTotal();i++)
     {
        ticket=OrderGetTicket(i);
        if(OrderGetString(ORDER_SYMBOL)==Symbol())
        {            
          offeneOrders++;
          PendingOrders++;       
        }
     }
    
   // Zhlt eine offene Order 
   for(i=0;i<PositionsTotal();i++)
     {
      if(Symbol()==PositionGetSymbol(i)&& PositionGetInteger(POSITION_MAGIC)==MagicNumber)
      {
      offeneOrders++;     
      }
     }
     
   //Order wird nur erffnet wenn der Ask unterhalb von (Target+StopBuySell)/2 ist. [das soll ein zu groes Risiko verhindern]
   //Eine Marketorder wird ausgefhrt wenn der Preis ber dem StopbuySell liegt (Gap)
   //ansonsten wird eine PendingOrder ausgefhrt
   //Order zu einer bestimmten Zeit ffnen (zur Markterffnung in den ersten 10 Minuten
   
   //Order wird nur erstellt, wenn heute noch keine Order auf diesem Wert offen war
   HeuteKeineOrderMehr=0;
   HistorySelect(0,TimeCurrent());
   
   for(i=0;i<HistoryDealsTotal();i++)
   {
      tickethistory=HistoryDealGetTicket(i);
      
      if(Symbol()==HistoryDealGetString(tickethistory,DEAL_SYMBOL) && TimeToString(TimeCurrent(dt),TIME_DATE)== TimeToString(HistoryDealGetInteger(tickethistory,DEAL_TIME),TIME_DATE))
      {
         HeuteKeineOrderMehr=1;     
      }

   }

   
 if(dt.hour==9 && dt.min<=10 && offeneOrders==0 && HeuteKeineOrderMehr==0)
 {
   if(Direction=="Long" && SymbolInfoDouble(Symbol(),SYMBOL_ASK)>=StopBuySell && ((TakeProfit+StopLoss*minCRV)/(1+minCRV))>SymbolInfoDouble(Symbol(),SYMBOL_ASK))
   {                     
   request.action       =TRADE_ACTION_DEAL;
   request.price        =SymbolInfoDouble(Symbol(),SYMBOL_ASK);
   request.type         =ORDER_TYPE_BUY;
   request.comment      ="RSI Long Mrket " +Spread;
   OrderSend(request,result);
   }
   else if (Direction=="Short" && SymbolInfoDouble(Symbol(),SYMBOL_BID)<=StopBuySell && SymbolInfoDouble(Symbol(),SYMBOL_BID)>((TakeProfit+StopLoss*minCRV)/(1+minCRV)))
   {
   request.action       =TRADE_ACTION_DEAL;
   request.price        =SymbolInfoDouble(Symbol(),SYMBOL_BID);
   request.type         =ORDER_TYPE_SELL;
   request.comment      ="RSI Short Market "+Spread;
   OrderSend(request,result);
   }
   else if(Direction=="Long" && SymbolInfoDouble(Symbol(),SYMBOL_ASK)<StopBuySell )
   {
   request.action       =TRADE_ACTION_PENDING;
   request.price        =StopBuySell;
   request.type         =ORDER_TYPE_BUY_STOP;
    request.comment      ="RSI Long Stop "+Spread;
   OrderSend(request,result);
   }
   else if (Direction=="Short" && SymbolInfoDouble(Symbol(),SYMBOL_BID)>StopBuySell)
   {
   request.action       =TRADE_ACTION_PENDING;
   request.price        =StopBuySell;
   request.type         =ORDER_TYPE_SELL_STOP;
   request.comment      ="RSI Short Stop "+Spread;
   OrderSend(request,result);
   }
 }
        
    
  
   
   //Pendingorder zu einer bestimmten Zeit wiederum lschen (zu Marktschluss ab den letzen 10 Minuten)
   if(PendingOrders>0 && dt.hour==17 && dt.min>=20)
   {
       request.action=TRADE_ACTION_REMOVE;
       request.order=ticket;
       OrderSend(request,result); 
   }




/*
Maximaler Verlust:
   Wenn maximaler Verlust und Stoploss nahezu gleich liegen und gleichzeitig triggern,
   wird statt die Position zu schlieen, diese gleich wieder neu erffnet,
   und zwar in die Gegenrichtung und ohne StopLoss!
   Ohne zustzliche Prfung sollte diese Funktion nicht verwendet werden.

   //Wenn ich mit dieser Position um einen gewissen Geldbetrag im Minus bin, dann sofort Order schlieen
      for(i=0;i<PositionsTotal();i++)
     {
      if(Symbol()==PositionGetSymbol(i)&& PositionGetInteger(POSITION_MAGIC)==MagicNumber && (PositionGetDouble(POSITION_PROFIT)<(MaximalerVerlust*-1)))
      { 

         if(PositionGetInteger(POSITION_TYPE)==POSITION_TYPE_BUY)
         {  
            request.sl           =0; 
            request.tp           =0;   
            request.volume       =PositionGetDouble(POSITION_VOLUME);
            request.action       =TRADE_ACTION_DEAL;
            request.price        =SymbolInfoDouble(Symbol(),SYMBOL_BID);
            request.type         =ORDER_TYPE_SELL;
            request.comment      ="Maximalverlust erreicht "+Spread; 
            OrderSend(request,result);          
         }
         
         else if (PositionGetInteger(POSITION_TYPE)==POSITION_TYPE_SELL)
         {  
            request.sl           =0; 
            request.tp           =0;         
            request.volume       =PositionGetDouble(POSITION_VOLUME);
            request.action       =TRADE_ACTION_DEAL;
            request.price        =SymbolInfoDouble(Symbol(),SYMBOL_ASK);
            request.type         =ORDER_TYPE_BUY;
            request.comment      ="Maximalverlust erreicht "+Spread; 
            OrderSend(request,result);          
         }
      }
     }

*/




   
  }
//+------------------------------------------------------------------+
