//+------------------------------------------------------------------+
//|                                            BG-BunnygirlCross.mq4 |
//|                                Copyright  2005, David W. Thomas |
//|                                           mailto:davidwt@usa.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, David W. Thomas"
#property link      "mailto:davidwt@usa.net"

#property indicator_chart_window
#property indicator_buffers 8
#property indicator_color1 DimGray
#property indicator_color2 DarkViolet
#property indicator_color3 MediumVioletRed
#property indicator_color4 MediumVioletRed
#property indicator_color5 MediumVioletRed
#property indicator_color6 SteelBlue
#property indicator_color7 LightSeaGreen
#property indicator_color8 SeaGreen

#define CROSSTYPE_LONG 1
#define CROSSTYPE_SHORT -1


//---- input parameters
extern int PipsForBounce= 3;
extern int TimeZoneOfData= 2;
extern bool FilterTradingTime= true;
extern bool ShowDailyOpenLevel= false;


//---- hidden inputs
int MA_Method= MODE_LWMA;


//---- buffers
double TodayOpenBuffer[];
double CrossBounceBuffer[];
double EntryFilterBuffer[];
double EntryFilterBuffer2[];
double BuySymbolBuffer[];
double WMA5Buffer[];
double WMA20Buffer[];
double WMA100Buffer[];

//---- variables

string TypeStrMA = "";

double EntryFilterPips = 0;
		

int TimeFilterStart = 0;
int TimeFilterEnd = 24;


//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   //---- indicators
	SetIndexStyle(0, DRAW_LINE, STYLE_DASH, 2);
	SetIndexBuffer(0, TodayOpenBuffer);
	SetIndexLabel(0, "Daily Open");
	SetIndexEmptyValue(0, 0.0);
	
	SetIndexStyle(1, DRAW_LINE);
	SetIndexBuffer(1, CrossBounceBuffer);
	SetIndexLabel(1, "Cross/Bounce");
	SetIndexEmptyValue(1, 0.0);
	
	SetIndexStyle(2, DRAW_LINE, STYLE_DOT);
	SetIndexBuffer(2, EntryFilterBuffer);
	SetIndexLabel(2, "Buy EntryFilterPips");
	SetIndexEmptyValue(2, 0.0);
	
	SetIndexStyle(3, DRAW_LINE, STYLE_DOT);
	SetIndexBuffer(3, EntryFilterBuffer2);
	SetIndexLabel(3, "Sell EntryFilterPips");
	SetIndexEmptyValue(3, 0.0);

	SetIndexStyle(4, DRAW_ARROW);
	SetIndexArrow(4, 162);
	SetIndexBuffer(4, BuySymbolBuffer);
	SetIndexLabel(4, "Cross Up Symbol");
	SetIndexEmptyValue(3, 0.0);
	
	SetIndexStyle(5, DRAW_LINE, STYLE_SOLID, 1);
	SetIndexBuffer(5, WMA5Buffer);
	SetIndexLabel(5, "30min. WMA5");
	SetIndexEmptyValue(6, 0.0);	  

	SetIndexStyle(6, DRAW_LINE, STYLE_DOT, 1);
	SetIndexBuffer(6, WMA20Buffer);
	SetIndexLabel(6, "30min. WMA20");
   SetIndexEmptyValue(6, 0.0);	  
	
	SetIndexStyle(7, DRAW_LINE, STYLE_DOT, 1);
	SetIndexBuffer(7, WMA100Buffer);
	SetIndexLabel(7, "30min. WMA100");
   SetIndexEmptyValue(7, 0.0);	 

		
		
	if (Symbol() == "EURUSD")
		EntryFilterPips = 25 * Point;
	else
		EntryFilterPips = 30 * Point;
		
	if (MA_Method == MODE_EMA)
		TypeStrMA = "EMA";
	else
		TypeStrMA = "WMA";
		
	Print(" Cross of ", TypeStrMA, " with a EntryFilterPips of ", EntryFilterPips/Point, " pips.");
	if (FilterTradingTime) {
		TimeFilterStart = 6 + TimeZoneOfData;
		TimeFilterEnd = 17 + TimeZoneOfData;
      Print(" Only shows buy/sell EntryFilterPipss from ", TimeFilterStart, " to ", TimeFilterEnd, " hours (chart time).");
	}
	else {
		TimeFilterStart = 0;
		TimeFilterEnd = 24;
		Print(" Show buy/sell EntryFilterPipss at all times.");
	}

	return(0);
}


//+------------------------------------------------------------------+
//| Custor indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
{

	return(0);
}


//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
{
   int counted_bars= IndicatorCounted(),
         lastbar;

   if (counted_bars>0)
      counted_bars--;
      
   lastbar= Bars- counted_bars;	

   Bunnygirl(0, lastbar);
   
   return (0);
}
	   


//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int Bunnygirl(int offset, int lastbar)
{
   static datetime timelastcross = 0;
   static int crosstype= CROSSTYPE_LONG;   // LONG
   static double crosslevel= 0;

	string crossdirstr = "";

   int idxcross= 0, 
         tzdiffsec= TimeZoneOfData * 3600,
         shift, idxline;
   
	double ma20p, ma20p1, ma20p2,
	       ma5p, ma5p1, ma5p2,
	       ma100p,
			 diff0, diff1, diff2,
          tz, exactcross,
          barsper30= 1.0*PERIOD_M30/Period(),
          barsperday= PERIOD_D1/Period(),
          deltatime= 2.0; // computed beween bar shift and shift+2	
          
   // lastbar+= barsperday+2;  // make sure we catch the daily open		 

   lastbar= MathMin(Bars-20*barsper30-1, lastbar);

	for (shift= lastbar; shift>=offset; shift--) {
	
		TodayOpenBuffer[shift]= 0;
		CrossBounceBuffer[shift]= 0;
		EntryFilterBuffer[shift]= 0;
		BuySymbolBuffer[shift]= 0;
		

      if (ShowDailyOpenLevel) {

         if (TimeDayOfWeek(Time[shift]-tzdiffsec) != TimeDayOfWeek(Time[shift+1]-tzdiffsec)) { // day change
            TodayOpenBuffer[shift]= Open[shift];         
            TodayOpenBuffer[shift+1]= 0;  // avoid stairs in the line
         }
         else {
            TodayOpenBuffer[shift]= TodayOpenBuffer[shift+1];
         }
		}
		
		if (0 && Symbol()=="GBPUSD") Print("x");
		
      ma5p= iMA(NULL,0,   5*barsper30, 0, MA_Method, PRICE_CLOSE,  shift);
      ma5p1= iMA(NULL,0,  5*barsper30, 0, MA_Method, PRICE_CLOSE,  shift+1);
      ma5p2= iMA(NULL,0,  5*barsper30, 0, MA_Method, PRICE_CLOSE,  shift+2);
      
      ma20p= iMA(NULL,0,   20*barsper30, 0, MA_Method, PRICE_CLOSE,  shift);
      ma20p1= iMA(NULL,0,  20*barsper30, 0, MA_Method, PRICE_CLOSE,  shift+1);
      ma20p2= iMA(NULL,0,  20*barsper30, 0, MA_Method, PRICE_CLOSE,  shift+2);
      
      ma100p= iMA(NULL,0,   100*barsper30, 0, MA_Method, PRICE_CLOSE,  shift);
      
      diff0= ma5p - ma20p;
      diff1= ma5p1 - ma20p1;
      diff2= ma5p2 - ma20p2;
      
      if (0 && Symbol()=="GBPUSD") {
         Print("x", shift, ":",  ma5p, ", ", ma5p2);
      }
      
      WMA5Buffer[shift]= ma5p;
      WMA20Buffer[shift]= ma20p;
      WMA100Buffer[shift]= ma100p;

      idxcross= 0;
      deltatime= 2.0; // computed beween bar shift and shift+2
      
      // equate ma5p2 + tz * deltaprice5 = ma20p2 + tz * deltaprice20
      tz= (ma20p2 - ma5p2) * deltatime / ((ma5p - ma5p2) - (ma20p - ma20p2));
      exactcross= ma5p2 + tz * (ma5p - ma5p2) / deltatime;
      
      if (0 && Symbol()=="GBPUSD") Print("y");

      if (tz>=0.0 && tz<=deltatime) {   // cross within the time segment of the two samples
         idxcross= shift+2-MathRound(tz);
         if (diff0 > 0) 
            crosstype= CROSSTYPE_LONG;
         else
            crosstype= CROSSTYPE_SHORT;
            
         crosslevel= exactcross;
      }
      else {   // check bounce
		   // bull bounce signals:
		   if (diff0>0 && diff1>0 && diff2>diff1 && diff0>=diff1 && diff1<=PipsForBounce*Point) {
		      idxcross= shift+1;
			   crosstype= CROSSTYPE_LONG;
			   crosslevel = ma20p1;
		   }

		   // bear bounce signals:
		   if (diff0<0 && diff1<0 && diff2<diff1 && diff0<=diff1 && MathAbs(diff1)<=PipsForBounce*Point) {
            idxcross= shift+1;
			   crosstype= CROSSTYPE_SHORT;
			   crosslevel = ma20p1;
		   }
      }
      
		
		CrossBounceBuffer[shift] = crosslevel;
		
		if (idxcross!=0) {
		   timelastcross= Time[idxcross];
		   CrossBounceBuffer[idxcross]= crosslevel;  
		   if (CrossBounceBuffer[idxcross+1]!=crosslevel)
		      CrossBounceBuffer[idxcross+1]= 0;   
		}
		else {
         idxline= shift;   		     
		}


		if (TimeHour(Time[shift])>=TimeFilterStart && TimeHour(Time[shift])<=TimeFilterEnd) {
		

         if (crosstype==CROSSTYPE_LONG) {

            EntryFilterBuffer[shift]= crosslevel + crosstype*EntryFilterPips /* + Ask - Bid */;

            if (Open[shift]<EntryFilterBuffer[shift] && Close[shift]>EntryFilterBuffer[shift]) {
              BuySymbolBuffer[shift]= EntryFilterBuffer[shift];
            }
         }
         else 
         if (crosstype==CROSSTYPE_SHORT) {
            EntryFilterBuffer[shift]= crosslevel + crosstype*EntryFilterPips;

            if (Open[shift]>EntryFilterBuffer[shift] && Close[shift]<EntryFilterBuffer[shift]) {
              BuySymbolBuffer[shift] = EntryFilterBuffer[shift];
            }
         }
		}
	}

	if (crosstype==CROSSTYPE_LONG)
		crossdirstr= "bull";
	else
   if (crosstype==CROSSTYPE_SHORT) 
		crossdirstr= "bear";

	if (timelastcross!=0)  // use of Digits suggested by aircom@strategybuilderfx.com.
		Comment("Last ", TypeStrMA, " cross/bounce: ", TimeToStr(timelastcross), ", ", crossdirstr, " at ", DoubleToStr(crosslevel,Digits));
	else
		Comment("Last ", TypeStrMA, " cross/bounce: ", crossdirstr, " at ", DoubleToStr(crosslevel,Digits));
	
	return(0);
}



