//+------------------------------------------------------------------+
//| OsMaPips                                                         |
//| Shimodax                                                         |
//|                                                                  |
//+------------------------------------------------------------------+
#property  copyright "Shimodax"
#property  link      "http://www.strategybuilderfx.com"


/* Introduction:

   Slope of OMA curve
   
   Enjoy
   
   Markus
*/


//---- indicator settings
#property  indicator_separate_window
#property  indicator_buffers 3
#property  indicator_color1  Gray
#property  indicator_color2  DodgerBlue
#property  indicator_color3  FireBrick

//---- indicator parameters
extern int Length= 14;


//---- indicator buffers
double OsMAUpBuffer[];
double OsMADownBuffer[];
double OsMABuffer[];




//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
{
   //---- drawing settings
   SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,2);
   SetIndexBuffer(0,OsMABuffer);
   SetIndexDrawBegin(0,Length);
   
   SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID,2);
   SetIndexBuffer(1,OsMAUpBuffer);
   SetIndexDrawBegin(1,Length);

   SetIndexStyle(2,DRAW_HISTOGRAM,STYLE_SOLID,2);
   SetIndexBuffer(2,OsMADownBuffer);
   SetIndexDrawBegin(2,Length);
   
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS)+2);
   
   IndicatorShortName("OMASlope("+Length+")");
   
   return(0);
}

int deinit()
{
   return (0);
}


//+------------------------------------------------------------------+
//| Custom indicator start function (on each tick)                   |
//+------------------------------------------------------------------+
int start()
{
  int counted_bars= IndicatorCounted(),
         lastbar;

   if (counted_bars>0)
      counted_bars--;
      
   lastbar= Bars- counted_bars;	
   
   OMASlope(0, lastbar, Length);

   return (0);
}
   

int OMASlope(int offset, int lastbar, int length)
{    
   int i, 
       swing_in= 3;
   double prevsignal= 0;

   lastbar= MathMin(Bars-Length-swing_in-1, lastbar);
   

   for (i= lastbar+swing_in; i>=offset; i--){

      double cur= iCustom(NULL, 0, "OMA", Length, 0, i);
      double prev= iCustom(NULL, 0, "OMA", Length, 0, i+1);
      
      double signal= (cur-prev)/Point;
   
      OsMABuffer[i]= signal;
      OsMAUpBuffer[i]= 0;
      OsMADownBuffer[i]= 0;
      
      if(signal>0){
         OsMAUpBuffer[i]= OsMABuffer[i];
      }
      else 
      if(signal<0){
         OsMADownBuffer[i]= OsMABuffer[i];
      }
      else 
      if (prevsignal!=0) {
         OsMABuffer[i]= prevsignal;
      }

      prevsignal= signal;
   }
 
   return (0);  
}
 
 