//+------------------------------------------------------------------+
//|                                                                  |
//|                                                                  |
//|                                                                  |
//+------------------------------------------------------------------+

#property indicator_chart_window
#property indicator_buffers 1
#property indicator_color1 DodgerBlue

//---- input parameters
extern int Length= 14;

/* Theory: 

   Gleitende Durchschnitte als sogenannte Trendindikatoren spielen eine 
   groe Rolle in der technischen Analyse von Finanzmarktdaten. Der 
   einfache gleitende Durchschnitt (SMA) ist nur fr eine visuelle Analyse 
   geeignet, da er in trendschwachen Phasen durch hufige Richtungsnderungen 
   falsche Signale erzeugt. Der einfache exponentielle Durchschnitt (EMA) 
   hat eine von der Gre des gewhlten Glttungsmaes abhngige Filterwirkung 
   mit den entscheidenden Nachteilen, dass a) das Glttungsma nicht adaptiv 
   ist und b) eine Trendumkehr angezeigt wird, sobald der aktuelle Wert der 
   Zeitreihe seinen gleitenden Durchschnitt kreuzt, was wiederum zu einer 
   Flle von Fehlsignalen fhrt. Der EMA ist wie der SMA nur fr visuelle 
   Analysen geeignet. Dieses gilt dann auch fr alle Indikatoren, die auf 
   einer einfachen Mittelwertbildung oder auf einer konstanten Glttung 
   nach den Prinzip des EMA basieren.

   Die Strke des optimalen gleitenden Durchschnitts (OMA) besteht darin, 
   dass der aktuelle Wert der Zeitreihe einen von der momentanen Volatilitt 
   abhngigen Schwellenwert berschreiten muss, damit der Filter steigt bzw. 
   fllt, wodurch Fehlsignale in trendschwachen Phasen vermieden werden. 
*/   


//---- buffers
double ExtMapBuffer1[];



//+------------------------------------------------------------------+
//| Custom indicator initialization function                         
//+------------------------------------------------------------------+
int init()
{
   SetIndexStyle(0,DRAW_LINE);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexDrawBegin(0, Length);
   
   IndicatorShortName("OMA("+Length+")");
   
   return(0);
}


//+------------------------------------------------------------------+
//| Custom indicator start function (on each tick)                   |
//+------------------------------------------------------------------+
int start()
{
   int counted_bars= IndicatorCounted(),
         lastbar;

   if (counted_bars>0)
      counted_bars--;
      
   lastbar= Bars- counted_bars;	
   
   OMA(0, lastbar, Length);

   return (0);
}


//+------------------------------------------------------------------+
//| Correcte moving avaerage/optimized moving average                |
//+------------------------------------------------------------------+
int OMA(int offset, int lastbar, int length)
{
   int shift,
       n= length,
       swing_in= length;  // swing in loop to assure we have ca_prev
   double sa, k, v1, v2, 
          ca= 0, caprev= 0;
    
   // ---
   // variable definitions
   lastbar= MathMin(Bars-length-swing_in-1, lastbar);
   

   // ---
   for (shift= lastbar+swing_in; shift>=offset; shift--) {
      
      if (caprev==0) {
         caprev= Close[shift+1];
      }
      
      sa= iMA(NULL, 0, n, 0, MODE_SMA, PRICE_CLOSE, shift);
      v1= iStdDev(NULL, 0, n, MODE_SMA, 0, PRICE_CLOSE, shift);
      v1= v1*v1;
      
      v2= caprev-sa;
      v2= v2*v2;
      
      if (v2>=v1) {
         k= 1-v1/v2;
         ca= caprev+k*(sa-caprev);
      }
      
	   if (shift<=lastbar)
	     ExtMapBuffer1[shift]= ca;

      caprev= ca;
   }

   //----
   return(0);
}


/*
   Converted from Metastock:
   
   {Corrected Average (CA), A.Uhl, Oct. 25, 2005}
   vars:
   CA(0),SA(0),n(0), v1(0),v2(0),K(0);

   inputs:
   Price(Close),length(35);

   if CurrentBar=1 then
   CA=Price
   else
   begin

   if CurrentBar<length then
   n=CurrentBar
   else
   n=length;

   SA=Average(Price,n);
   v1=Square(StdDev(Price,n));
   v2=Square(CA[1]-SA);

   if v2<v1 then
   K=0
   else
   K=1-v1/v2;
   CA=CA[1]+K*(SA-CA[1]);
   end;

   Plot1(CA,"Corrected Average",Red,White,3);
   Plot2(SA,"Simple Average",Blue,White,1);
*/

