//+------------------------------------------------------------------+
//|                                     Dinapoli_Trend_Direktion.mq4 |
//|                      Copyright  2005, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"



#property indicator_separate_window
#property indicator_minimum 0
#property indicator_maximum 1
#property indicator_buffers 4


//---- input parameters
extern int       Minutes=0;
//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
double ExtMapBuffer3[];
double ExtMapBuffer4[];
double Ma;
double hhigh, llow;

string TimeFrameStr;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
  SetIndexStyle(0,DRAW_HISTOGRAM,STYLE_SOLID,3,Red);
  SetIndexBuffer(0,ExtMapBuffer1);
  SetIndexStyle(1,DRAW_HISTOGRAM,STYLE_SOLID,3, LimeGreen);
  SetIndexBuffer(1,ExtMapBuffer2);
  SetIndexStyle(2,DRAW_HISTOGRAM,STYLE_SOLID,1, Salmon);
  SetIndexBuffer(2,ExtMapBuffer3);
   SetIndexStyle(3,DRAW_HISTOGRAM,STYLE_SOLID,1, LightGreen);
  SetIndexBuffer(3,ExtMapBuffer4);


switch(Minutes)
   {
      case 1 : TimeFrameStr="Period_M1"; break;
      case 5 : TimeFrameStr="Period_M5"; break;
      case 15 : TimeFrameStr="Period_M15"; break;
      case 30 : TimeFrameStr="Period_M30"; break;
      case 60 : TimeFrameStr="Period_H1"; break;
      case 240 : TimeFrameStr="Period_H4"; break;
      case 1440 : TimeFrameStr="Period_D1"; break;
      case 10080 : TimeFrameStr="Period_W1"; break;
      case 43200 : TimeFrameStr="Period_MN1"; break;
      default : TimeFrameStr="Current Timeframe"; Minutes=0;
   }
   IndicatorShortName("Dinapoli_Trend_Direktion ("+TimeFrameStr+")");  

 
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();
//----

for (int i = 0; i < 500; i++){
   ExtMapBuffer1[i]=0;
   ExtMapBuffer2[i]=0;
   ExtMapBuffer3[i]=0;
   ExtMapBuffer4[i]=0;
   
        double Trigger60=iStochastic(NULL,Minutes,8,3,3,MODE_SMA,1,MODE_MAIN,i);
        double Trigger61=iStochastic(NULL,Minutes,8,3,3,MODE_SMA,1,MODE_SIGNAL,i);
        double MACDMAIN60 = iMACD(NULL,Minutes,8.3896,17.5185,9.0503,PRICE_CLOSE,MODE_MAIN,i);
        double MACDSIGNAL60 = iMACD(NULL,Minutes,8.3896,17.5185,9.0503,PRICE_CLOSE,MODE_SIGNAL,i);
        
   
   if (Trigger60 > Trigger61 && MACDMAIN60>MACDSIGNAL60   ){    
      ExtMapBuffer2[i] = 1;
      }
   
   if (Trigger60 < Trigger61 && MACDMAIN60>MACDSIGNAL60   ){    
      ExtMapBuffer4[i] = 1;
      }   
   
   if (Trigger60 <Trigger61 && MACDMAIN60<MACDSIGNAL60 ){ 
      ExtMapBuffer1[i] = 1;
         }
   
   if (Trigger60 >Trigger61 && MACDMAIN60<MACDSIGNAL60 ){ 
      ExtMapBuffer3[i] = 1;
         }
         
   if (ExtMapBuffer1[i] == 0 && ExtMapBuffer2[i] == 0){
      //ExtMapBuffer3[i] = 1;
      }
  
}
 
 
 
   
//----
   return(0);
  }
//+------------------------------------------------------------------+