//+----------------------------------------------------------------------+
//|ZigZag                                                |
//|----------------------------------------------------------------------+                                                                  |
//|ExtHidden - 0 -   .  ZigZag.                     |
//|            1 -     ,        |
//|                  >0.21  <5.                    |
//|            2 -     ,   -    |  
//|                    ( 0.866  -    |
//|                  Gartley)                               |
//|            3 -  ,    2            |
//|                                                 |
//|            4 -        |
//|                                                                      |
//|                                                                      |
//|ExtFractal -   (, ),            |
//|                                    |
//|                                                                      |
//|ExtFractalEnd -  ,                |
//|                            |
//|                 ExtFractalEnd=0           |
//|                  .                        |
//|                  ExtFractalEnd=5                  |
//|                                                                      |
//|ExtDeltaType -    0 -    " "    |
//|                  1 -   (%- )<ExtDelta     |
//|                  2 - ((%- )/ )<ExtDelta  |
//|                                                                      |
//|                                                                      |
//|ExtDelta - ()   .               |
//|             .                            |
//|                    0<ExtDelta<1                            |
//|                                                                      |
//|ExtFibo  - true -                             |
//|           false -     (        |
//|                     ZigZag-a)                    |
//|                                                                      |
//+----------------------------------------------------------------------+
#property copyright "nen"
#property link      "http://onix-trade.net/forum/index.php?act=post&do=reply_post&f=9&t=118"

#property indicator_chart_window
#property indicator_buffers 1
#property indicator_color1 Red
//---- indicator parameters
extern int ExtDepth=12;
extern int ExtHidden=2;
extern int ExtFractal=15;
extern int ExtFractalEnd=15;
extern double ExtDelta=0.04;
extern int ExtDeltaType=1;
extern bool ExtFibo=true;
extern color ExtLine=White; //DarkBlue;
extern color ExtPesavento=White;
extern color ExtGartley866=White;
extern color ExtNotFibo=White;
extern int ExtDeviation=5;
extern int ExtBackstep=3;
//---- indicator buffers
//    ZigZag
double zz[];
//   
double ExtMapBuffer[];
//   
double ExtMapBuffer2[];

//    (   )
double fi[]={0.382, 0.5, 0.618, 0.707, 0.786, 0.841, 0.886, 1.0, 1.128, 1.272, 1.414, 1.5, 1.618, 2.0, 2.414, 2.618, 4.0};
string fitxt[]={ ".382", "0.5", ".618", ".707", ".786", ".841", ".886", "1.0", "1.128", "1.272", "1.414", "1.5", "1.618", "2.0", "2.414", "2.618", "4.0" };
string nameObj,nameObjtxt;
//      afr -       +   -  
// afrl - , afrh - 
int afr[]={0,0,0,0,0};
double afrl[]={0.0,0.0,0.0,0.0,0.0}, afrh[]={0.0,0.0,0.0,0.0,0.0};
bool afrm=true;
double HL,HLp,kk,kj,Angle;
// LowPrim,HighPrim,LowLast,HighLast -     
double LowPrim,HighPrim,LowLast,HighLast;
// numLowPrim,numHighPrim,numLowLast,numHighLast - 
int numLowPrim,numHighPrim,numLowLast,numHighLast,k,k1,k2,ki,countLow1,countHigh1,shift,shift1;
//        
int timeFr1,timeFr1new,timeFr2Low,timeFr2High;
//  ,          
int countLineFr1;
//  
int countFr;
// ,         
int countBarEnd=0;
// ,       
int numBar=0;
//  
int numOb;
//M      (  )
double hFr1, lFr1, hFr2, lFr2;
// 
// flagFrNew=true -          . =false -  .
// flagFr=true -   . false -   .
bool flagLow,flagHigh,flagFr,flagFrNew=false;
int counted_bars;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
   IndicatorBuffers(5);
//---- drawing settings
   SetIndexStyle(0,DRAW_SECTION);
//---- indicator buffers mapping
   SetIndexBuffer(0,zz);
   SetIndexBuffer(1,ExtMapBuffer);
   SetIndexBuffer(2,ExtMapBuffer2);
   SetIndexEmptyValue(0,0.0);
   ArraySetAsSeries(zz,true);
   ArraySetAsSeries(ExtMapBuffer,true);
   ArraySetAsSeries(ExtMapBuffer2,true);
//---- indicator short name
   IndicatorShortName("ZZ("+ExtDepth+")");
//     
   if (countBarEnd==0)
     {
      if (ExtDelta<=0) ExtDelta=0.001;
      if (ExtDelta>1) ExtDelta=0.999;

      if (ExtHidden<0) ExtHidden=0;
      if (ExtHidden>4) ExtHidden=4;
 
      if (ExtDeltaType<0) ExtDeltaType=0;
      if (ExtDeltaType>3) ExtDeltaType=3;

      if (ExtFractalEnd>0)
        {
         if (ExtFractalEnd<5) ExtFractalEnd=5;

         if (countLow1>ExtFractalEnd) countLow1=ExtFractalEnd;
         if (countHigh1>ExtFractalEnd) countHigh1=ExtFractalEnd;
        }
     }
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| .       
//+------------------------------------------------------------------+
int deinit(){ ObjectsDeleteAll(0,2); ObjectsDeleteAll(0,21); ObjectDelete("Fibo"); return(0);}
//********************************************************
int start()
  {
   counted_bars=IndicatorCounted();

   if( counted_bars<0 )
   {
      Alert("  ");
      return(-1);
   }

//-----------------------------------------
//
//     1.
//
//   . 
// zz[] - ,        ZigZag-a
// ExtMapBuffer[] -   
// ExtMapBuffer2[] -   
// . 
//-----------------------------------------   
//
//     ,
//     .
//      ,
//    .
//
//   ,    .
//
//-----------------------------------------

   ZigZag_();
//-----------------------------------------
//   . .
//-----------------------------------------   


//-----------------------------------------
//
//     2.
//
//   . .
//-----------------------------------------   


//   . .
//
//  flagFrNew=true    numBar .
//    .     numBar .

   countFractal(flagFrNew, numBar);
//   . .


   if ((Bars - counted_bars>2 || flagFrNew)&& ExtHidden>0)
     {

      //  
      matriza();
      //   ,       
      if (countBarEnd==0)
        {
         if (ExtFractalEnd>0)
           {
            k=ExtFractalEnd;
            for (shift=0; shift<Bars && k>0; shift++) if (zz[shift]>0 && ExtMapBuffer2[shift]>0) {countBarEnd=shift; k--;}
           }
         else countBarEnd=Bars-3;
        }
     }
//-----------------------------------------
//   . .
//-----------------------------------------   



//-----------------------------------------
//
//     3.
//
//     , 
//  . .
//-----------------------------------------   

   if (Bars - counted_bars<3 && ExtHidden>0)


//     . .

  {

   //     ,    
   for (shift=0; shift<Bars; shift++) 
     {
      if (zz[shift]>0.0) 
       {
        timeFr1new=Time[shift];
        break;
       }
     }
   //  ,     
   shift=iBarShift(Symbol(),Period(),timeFr1); 
  //      ,   


  //   
  if (timeFr1new!=timeFr1)
    {
     flagFrNew=true;
//     if (shift>numBar) 
     numBar=shift;

     timeFr1=Time[shift];
     afrm=true;
    }

  //       
  if (hFr1>0 && zz[shift]==0.0)
    {
     flagFrNew=true;
//     if (shift>numBar) 
     numBar=shift;
     timeFr1=Time[shift];
     afrm=true;
    }
  //       
  if (lFr1>0 && zz[shift]==0.0)
    {
     flagFrNew=true;
//     if (shift>numBar) 
     numBar=shift;
     timeFr1=Time[shift];
     afrm=true;
    }


//-----------3    ,      . .

//============= 1  . .
if (hFr1-High[shift]!=0 && hFr1>0)
  {

   numLowPrim=0; numLowLast=0;
   numHighPrim=shift; numHighLast=0;

   LowPrim=0.0; LowLast=0.0;
   HighPrim=High[shift]; HighLast=0.0;
   
   flagHigh=false;
   Angle=-100;

   for (k=shift+1; k<Bars; k++)
     {

      if (ExtMapBuffer[k]>0.0 && LowPrim==0.0 && ExtMapBuffer[k]==zz[k]) {LowPrim=ExtMapBuffer[k]; numLowPrim=k;}
      if (ExtMapBuffer[k]>0.0 && ExtMapBuffer[k]<LowPrim && ExtMapBuffer[k]==zz[k]) {LowPrim=ExtMapBuffer[k]; numLowPrim=k;}
      if (ExtMapBuffer2[k]>0.0  && ExtMapBuffer2[k]==zz[k])
        {
         if (HighLast>0) 
           {
            if (flagHigh)
              {
               if (ExtMapBuffer2[k]>HighLast) {HighLast=High[k]; numHighLast=k;}
              }
            else
              {
               if (ExtMapBuffer2[k]>HighPrim) flagHigh=true;
               HighLast=High[k];
               numHighLast=k;
              }
           }
         else {numHighLast=k; HighLast=High[k];}
         HL=High[numHighLast]-Low[numLowPrim];
         kj=(HighPrim-HighLast)*1000/(numHighLast-numHighPrim);
         if (HL>0 && (Angle>kj || Angle==-100))  //    
           {
            Angle=kj;
//  
            HLp=High[numHighPrim]-Low[numLowPrim];
            k1=MathCeil((shift+numHighLast)/2);
            kj=HLp/HL;
//                     

            nameObj="ph" + Time[numHighPrim] + "_" + Time[numHighLast];
            nameObjtxt="phtxt" + Time[numHighPrim] + "_" + Time[numHighLast];

            numOb=ObjectFind(nameObj);

            if (numOb>-1)
              {
               if (kj>0.21 && kj<=5)
                 {
                  //  
                  ObjectMove(nameObj,0,Time[numHighPrim],High[numHighPrim]);
                  ObjectMove(nameObjtxt,0,Time[k1],MathAbs((High[numHighPrim]+High[numHighLast])/2));

                  //    ( ). %   
                  kk=kj;
                  k2=1;

                  if (ExtDeltaType==2) for (ki=16;ki>=0;ki--) {if (MathAbs((fi[ki]-kj)/fi[ki])<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}
                  if (ExtDeltaType==1) for (ki=16;ki>=0;ki--) {if (MathAbs(fi[ki]-kj)<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}

                  if (k2<0)
                    //    
                    if (ExtHidden!=4 && ExtHidden>0)
                      {
                       if (kk==0.886)
                         ObjectSetText(nameObjtxt,fitxt[ki],7,"Arial", ExtGartley866);
                       else
                         ObjectSetText(nameObjtxt,fitxt[ki],7,"Arial",ExtPesavento);
                      }
                    else
                    //   ( )
                      if (ExtHidden==1 || ExtHidden==4)
                        ObjectSetText(nameObjtxt,""+DoubleToStr(kk,2),7,"Arial",ExtNotFibo);
                 }
               else
                 {
                  ObjectDelete(nameObj); 
                  ObjectDelete(nameObjtxt);
                 }
              }
            else
              {
//*******   ,   .
               if (kj>0.21 && kj<=5)
                 {
                  //    ( ). %   
                  kk=kj;
                  k2=1;

                  if (ExtDeltaType==1) for (ki=16;ki>=0;ki--) {if (MathAbs(fi[ki]-kj)<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}
                  if (ExtDeltaType==2) for (ki=16;ki>=0;ki--) {if (MathAbs((fi[ki]-kj)/fi[ki])<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}

                  if (k2<0)
                    //      0.866
                    {
                     if (ExtHidden!=4 && ExtHidden>0)                  
                       {
                        ObjectCreate(nameObjtxt,OBJ_TEXT,0,Time[k1],MathAbs((High[numHighPrim]+High[numHighLast])/2));
                        if (kk==0.886) // Gartley
                          ObjectSetText(nameObjtxt,fitxt[ki],7,"Arial", ExtGartley866);
                        else
                          ObjectSetText(nameObjtxt,fitxt[ki],7,"Arial",ExtPesavento);
                       }
                    }
                  else
                    //   (   0.866)
                    {
                     if (ExtHidden==1 || ExtHidden==4)
                       {
                        ObjectCreate(nameObjtxt,OBJ_TEXT,0,Time[k1],MathAbs((High[numHighPrim]+High[numHighLast])/2));
                        ObjectSetText(nameObjtxt,""+DoubleToStr(kk,2),7,"Arial",ExtNotFibo);
                       }
                    }
                  if ((ExtHidden==2 && k2<0) || (ExtHidden!=0 && ExtHidden!=2))
                    {
                     ObjectCreate(nameObj,OBJ_TREND,0,Time[numHighPrim],High[numHighPrim],Time[numHighLast],High[numHighLast]);
                     ObjectSet(nameObj,OBJPROP_RAY,false);
                     ObjectSet(nameObj,OBJPROP_STYLE,STYLE_DOT);
                     ObjectSet(nameObj,OBJPROP_COLOR,ExtLine);
                    }
                 }
//*******
               }
             }
        }
     }
     hFr1=High[shift];
     timeFr1=Time[shift];
   }
//============= 1  . .
//
//============= 1  . .
if (lFr1-Low[shift]!=0 && lFr1>0)
  {

   numLowPrim=0; numLowLast=0;
   numHighPrim=shift; numHighLast=0;

   LowPrim=Low[shift]; LowLast=0.0;
   HighPrim=0.0; HighLast=0.0;
   
   flagLow=false;
   Angle=-100;
   for (k=shift+1; k<Bars; k++)
     {
      if (ExtMapBuffer2[k]>HighPrim) {HighPrim=High[k]; numHighPrim=k;}
      if (ExtMapBuffer[k]>0.0 && ExtMapBuffer[k]==zz[k]) 
        {
         if (LowLast>0) 
           {
            if (flagLow)
              {
               if (ExtMapBuffer[k]<LowLast) {LowLast=Low[k]; numLowLast=k;}
              }
            else
              {
               if (ExtMapBuffer[k]<LowPrim) flagLow=true;
               LowLast=Low[k];
               numLowLast=k;
              }
           }
         else {numLowLast=k; LowLast=Low[k];}
         HL=High[numHighPrim]-Low[numLowLast];
         kj=(LowPrim-LowLast)*1000/(numLowLast-numLowPrim);
         if (HL>0 && (Angle<kj || Angle==-100))  //    
           {
            Angle=kj;

            HLp=High[numHighPrim]-Low[numLowPrim];
            k1=MathCeil((numLowPrim+numLowLast)/2);
            kj=HLp/HL;
//                     

            nameObj="pl" + Time[numLowPrim] + "_" + Time[numLowLast];
            nameObjtxt="pltxt" + Time[numLowPrim] + "_" + Time[numLowLast];

            numOb=ObjectFind(nameObj);
            if (numOb>-1)
              {
               if (kj>0.21 && kj<=5)
                 {
                  //  
                  ObjectMove(nameObj,0,Time[numLowPrim],Low[numLowPrim]);
                  ObjectMove(nameObjtxt,0,Time[k1],MathAbs((Low[numLowPrim]+Low[numLowLast])/2));

                  //    ( ). %   
                  kk=kj;
                  k2=1;

                  if (ExtDeltaType==2) for (ki=16;ki>=0;ki--) {if (MathAbs((fi[ki]-kj)/fi[ki])<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}
                  if (ExtDeltaType==1) for (ki=16;ki>=0;ki--) {if (MathAbs(fi[ki]-kj)<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}

                  if (k2<0)
                  //      0.866
                    {
                     if (ExtHidden!=4 && ExtHidden>0)                  
                       {
                        if (kk==0.886) // Gartley
                          ObjectSetText(nameObjtxt,fitxt[ki],7,"Arial", ExtGartley866);
                        else
                          ObjectSetText(nameObjtxt,fitxt[ki],7,"Arial",ExtPesavento);
                       }
                    }
                  else 
                    //   (   0.866)
                    if (ExtHidden==1 || ExtHidden==4)
                      ObjectSetText(nameObjtxt,""+DoubleToStr(kk,2),7,"Arial",ExtNotFibo);
                 }           
               else
                 {
                  ObjectDelete(nameObj); 
                  ObjectDelete(nameObjtxt);
                 }
              }  
            else
              {
//*******   ,   .
               if (kj>0.21 && kj<=5)
                 {
                  //    ( ). %   
                  kk=kj;
                  k2=1;

                  if (ExtDeltaType==2) for (ki=16;ki>=0;ki--) {if (MathAbs((fi[ki]-kj)/fi[ki])<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}
                  if (ExtDeltaType==1) for (ki=16;ki>=0;ki--) {if (MathAbs(fi[ki]-kj)<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}

                  if (k2<0)
                    //      0.866
                    {
                     if (ExtHidden!=4 && ExtHidden>0)                  
                       {
                        nameObj="pltxt" + Time[numLowPrim] + "_" + Time[numLowLast];
                     
                        ObjectCreate(nameObj,OBJ_TEXT,0,Time[k1],MathAbs((Low[numLowPrim]+Low[numLowLast])/2));
                        if (kk==0.886) // Gartley
                          ObjectSetText(nameObj,fitxt[ki],7,"Arial", ExtGartley866);
                        else
                          ObjectSetText(nameObj,fitxt[ki],7,"Arial",ExtPesavento);
                       }
                    }
                  else 
                    //   (   0.866)
                    { 
                     if (ExtHidden==1 || ExtHidden==4)
                       nameObj="pltxt" + Time[numLowPrim] + "_" + Time[numLowLast];
                     
                       ObjectCreate(nameObj,OBJ_TEXT,0,Time[k1],MathAbs((Low[numLowPrim]+Low[numLowLast])/2));
                       ObjectSetText(nameObj,""+DoubleToStr(kk,2),7,"Arial",ExtNotFibo);
                    }
                    if ((ExtHidden==2 && k2<0) || (ExtHidden!=0 && ExtHidden!=2))
                      {
                       nameObj="pl" + Time[numLowPrim] + "_" + Time[numLowLast];
                     
                       ObjectCreate(nameObj,OBJ_TREND,0,Time[numLowPrim],Low[numLowPrim],Time[numLowLast],Low[numLowLast]);
                       ObjectSet(nameObj,OBJPROP_RAY,false);
                       ObjectSet(nameObj,OBJPROP_STYLE,STYLE_DOT);
                       ObjectSet(nameObj,OBJPROP_COLOR,ExtLine);
                      }
                 }           
//*******
                }
             }
        }
     }
     lFr1=Low[shift];
     timeFr1=Time[shift];
   }
//============= 1  . .
//-----------3    ,      . .


   //      ,    . .
   for (k=0; k<5; k++)
     {

      //  .
      if (afrh[k]>0)
        {
         //  ,     
         shift=iBarShift(Symbol(),Period(),afr[k]); 
         if (zz[shift]==0)
//         if (zz[shift]==0 || zz[shift]>0 && ExtMapBuffer2[shift]==0 && ExtMapBuffer[shift]>0)
           {
            flagFrNew=true;
            if (shift>numBar) numBar=shift;
            afrm=true;
            numHighPrim=shift; numHighLast=0;HighLast=0.0;
            for (k1=shift+1; k1<Bars; k1++)
              {
               if (ExtMapBuffer2[k1]>HighLast) 
                 {
                  HighLast=High[k1]; numHighLast=k1;

                  nameObj="ph" + Time[numHighPrim] + "_" + Time[numHighLast];

                  numOb=ObjectFind(nameObj);
                  if (numOb>-1)
                    {
                     ObjectDelete(nameObj); 

                     nameObjtxt="phtxt" + Time[numHighPrim] + "_" + Time[numHighLast];

                     ObjectDelete(nameObjtxt);
                    }
                 }
              }

           }
        }
      
      //  .
      if (afrl[k]>0)
        {
         //  ,     
         shift=iBarShift(Symbol(),Period(),afr[k]); 
         if (zz[shift]==0)
//         if (zz[shift]==0 || zz[shift]>0 && ExtMapBuffer[shift]==0 && ExtMapBuffer2[shift]>0)
           {
            flagFrNew=true;
            if (shift>numBar) numBar=shift;

            afrm=true;
            numLowPrim=shift; numLowLast=0;LowLast=10000000;
            for (k1=shift+1; k1<Bars; k1++)
              {
               if (ExtMapBuffer[k1]<LowLast && ExtMapBuffer[k1]>0) 
                 {
                  LowLast=Low[k1]; numLowLast=k1;

                  nameObj="pl" + Time[numLowPrim] + "_" + Time[numLowLast];

                  numOb=ObjectFind(nameObj);
                  if (numOb>-1)
                    {
                     ObjectDelete(nameObj); 

                     nameObjtxt="pltxt" + Time[numLowPrim] + "_" + Time[numLowLast];

                     ObjectDelete(nameObjtxt);
                    }
                 }
              }
           }
        }

     }
   //      ,    . .

   //  . .
   matriza ();
   //  . .

// . .
  }


//-----------------------------------------
//     , 
//  . .
//-----------------------------------------   


//   . .
//
//  flagFrNew=true    numBar .
//    .     numBar .

   countFractal(flagFrNew, numBar);
//   . .




//-----------------------------------------
//
//     4.
//
//    . .
//-----------------------------------------   

//-----------1  . .
//+--------------------------------------------------------------------------+
//|        0.866   ZigZag-a
//|     
//+--------------------------------------------------------------------------+
   if (Bars - counted_bars>2 && ExtHidden>0)
{
   numLowPrim=0; numLowLast=0;
   numHighPrim=0; numHighLast=0;

   LowPrim=0.0; LowLast=0.0;
   HighPrim=0.0; HighLast=0.0;
   
   flagHigh=false;
   Angle=-100;
   
   if (flagFrNew) countFr=1;
   else countFr=ExtFractal;
   
   for (k=0; (k<Bars-1 && countHigh1>0 && countFr>0); k++)
     {
      if (ExtMapBuffer[k]>0.0 && LowPrim==0.0 && HighPrim>0 && ExtMapBuffer[k]==zz[k]) {LowPrim=ExtMapBuffer[k]; numLowPrim=k;}
      if (ExtMapBuffer[k]>0.0 && ExtMapBuffer[k]<LowPrim && HighPrim>0 && ExtMapBuffer[k]==zz[k]) {LowPrim=ExtMapBuffer[k]; numLowPrim=k;}
      if (ExtMapBuffer2[k]>0.0 && ExtMapBuffer2[k]==zz[k])
        {
         if (HighPrim>0) 
           {
            if (HighLast>0) 
              {
               if (flagHigh)
                 {
                  if (ExtMapBuffer2[k]>HighLast) {HighLast=High[k]; numHighLast=k;}
                 }
               else
                 {
                  if (ExtMapBuffer2[k]>HighPrim) flagHigh=true;
                  HighLast=High[k];
                  numHighLast=k;
                 }
              }
            else {numHighLast=k; HighLast=High[k];}

              HL=High[numHighLast]-Low[numLowPrim];
              kj=(HighPrim-HighLast)*10000/(numHighLast-numHighPrim);
              if (HL>0 && (Angle>kj || Angle==-100))  //    
                {
                 Angle=kj;
                 //     
                 HLp=High[numHighPrim]-Low[numLowPrim];
                 k1=MathCeil((numHighPrim+numHighLast)/2);
                 kj=HLp/HL;
 
                 if (kj>0.21 && kj<=5)
                   {
                    //    ( ). %   
                    kk=kj;
                    k2=1;

                    if (ExtDeltaType==2) for (ki=16;ki>=0;ki--) {if (MathAbs((fi[ki]-kj)/fi[ki])<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}
                    if (ExtDeltaType==1) for (ki=16;ki>=0;ki--) {if (MathAbs(fi[ki]-kj)<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}

                    if (k2<0)
                      //      0.866
                      {
                      if (ExtHidden!=4 && ExtHidden>0)                  
                        {
                         nameObj="phtxt" + Time[numHighPrim] + "_" + Time[numHighLast];

                         ObjectCreate(nameObj,OBJ_TEXT,0,Time[k1],MathAbs((High[numHighPrim]+High[numHighLast])/2));
                         if (kk==0.886) // Gartley
                           ObjectSetText(nameObj,fitxt[ki],7,"Arial", ExtGartley866);
                         else
                           ObjectSetText(nameObj,fitxt[ki],7,"Arial",ExtPesavento);
                        }
                       }
                    else
                      //   (   0.866)
                      {
                       if (ExtHidden==1 || ExtHidden==4)
                         {
                          nameObj="phtxt" + Time[numHighPrim] + "_" + Time[numHighLast];

                          ObjectCreate(nameObj,OBJ_TEXT,0,Time[k1],MathAbs((High[numHighPrim]+High[numHighLast])/2));
                          ObjectSetText(nameObj,""+DoubleToStr(kk,2),7,"Arial",ExtNotFibo);
                         }
                      }
                      if ((ExtHidden==2 && k2<0) || (ExtHidden!=0 && ExtHidden!=2))
                        {
                         nameObj="ph" + Time[numHighPrim] + "_" + Time[numHighLast];

                         ObjectCreate(nameObj,OBJ_TREND,0,Time[numHighPrim],High[numHighPrim],Time[numHighLast],High[numHighLast]);
                         ObjectSet(nameObj,OBJPROP_RAY,false);
                         ObjectSet(nameObj,OBJPROP_STYLE,STYLE_DOT);
                         ObjectSet(nameObj,OBJPROP_COLOR,ExtLine);
                        }
                   }
                }
           }
         else 
            {numHighPrim=k; HighPrim=High[k];}
        }
       //    
       if (k>countBarEnd) 
//       if (k>Bars-3) 
         {
          k=numHighPrim+1; countHigh1--; countFr--;
          numLowPrim=0; numLowLast=0;
          numHighPrim=0; numHighLast=0;

          LowPrim=0.0; LowLast=0.0;
          HighPrim=0.0; HighLast=0.0;
   
          flagHigh=false;
          Angle=-100;
         }
     }
//-----------1  . .

//-----------2  . .
//+-------------------------------------------------------------------------+
//|        0.866   ZigZag-a
//|     
//+-------------------------------------------------------------------------+

   numLowPrim=0; numLowLast=0;
   numHighPrim=0; numHighLast=0;

   LowPrim=0.0; LowLast=0.0;
   HighPrim=0.0; HighLast=0.0;
   
   flagLow=false; 
   Angle=-100;

   if (flagFrNew) countFr=1;
   else countFr=ExtFractal;

   for (k=0; (k<Bars && countLow1>0 && countFr>0); k++)
     {
      if (ExtMapBuffer2[k]>HighPrim && LowPrim>0) {HighPrim=High[k]; numHighPrim=k;}
      if (ExtMapBuffer[k]>0.0 && ExtMapBuffer[k]==zz[k]) 
        {
         if (LowPrim>0) 
           {
            if (LowLast>0) 
              {
               if (flagLow)
                 {
                  if (ExtMapBuffer[k]<LowLast) {LowLast=Low[k]; numLowLast=k;}
                 }
               else
                 {
                  if (ExtMapBuffer[k]<LowPrim) flagLow=true;
                  LowLast=Low[k];
                  numLowLast=k;
                 }
              }
            else {numLowLast=k; LowLast=Low[k];}
              //      ( )
              HL=High[numHighPrim]-Low[numLowLast];
              kj=(LowPrim-LowLast)*1000/(numLowLast-numLowPrim);
              if (HL>0 && (Angle<kj || Angle==-100))  //    
                {
                 Angle=kj;

                 HLp=High[numHighPrim]-Low[numLowPrim];
                 k1=MathCeil((numLowPrim+numLowLast)/2);
                 kj=HLp/HL;

                 if (kj>0.21 && kj<=5)
                   {
                    //    ( ). %   
                    kk=kj;
                    k2=1;

                    if (ExtDeltaType==2) for (ki=16;ki>=0;ki--) {if (MathAbs((fi[ki]-kj)/fi[ki])<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}
                    if (ExtDeltaType==1) for (ki=16;ki>=0;ki--) {if (MathAbs(fi[ki]-kj)<=ExtDelta) {kk=fi[ki]; k2=-1; break;}}

                    if (k2<0)
                    //      0.866
                      {
                       if (ExtHidden!=4 && ExtHidden>0)                  
                         {
                          nameObj="pltxt" + Time[numLowPrim] + "_" + Time[numLowLast];

                          ObjectCreate(nameObj,OBJ_TEXT,0,Time[k1],MathAbs((Low[numLowPrim]+Low[numLowLast])/2));
                          if (kk==0.886) // Gartley
                            ObjectSetText(nameObj,fitxt[ki],7,"Arial", ExtGartley866);
                          else
                            ObjectSetText(nameObj,fitxt[ki],7,"Arial",ExtPesavento);
                         }
                      }
                    else 
                    //   (   0.866)
                      { 
                       if (ExtHidden==1 || ExtHidden==4)
                         nameObj="pltxt" + Time[numLowPrim] + "_" + Time[numLowLast];

                         ObjectCreate(nameObj,OBJ_TEXT,0,Time[k1],MathAbs((Low[numLowPrim]+Low[numLowLast])/2));
                         ObjectSetText(nameObj,""+DoubleToStr(kk,2),7,"Arial",ExtNotFibo);
                      }
                      if ((ExtHidden==2 && k2<0) || (ExtHidden!=0 && ExtHidden!=2))
                        {
                         nameObj="pl" + Time[numLowPrim] + "_" + Time[numLowLast];

                         ObjectCreate(nameObj,OBJ_TREND,0,Time[numLowPrim],Low[numLowPrim],Time[numLowLast],Low[numLowLast]);
                         ObjectSet(nameObj,OBJPROP_RAY,false);
                         ObjectSet(nameObj,OBJPROP_STYLE,STYLE_DOT);
                         ObjectSet(nameObj,OBJPROP_COLOR,ExtLine);
                        }
                   }
                }
           }
         else {numLowPrim=k; LowPrim=Low[k];}
        }
       //    
       if (k>countBarEnd) 
//       if (k>Bars-3) 
         {
          k=numLowPrim+1; countLow1--; countFr--;

          numLowPrim=0; numLowLast=0;
          numHighPrim=0; numHighLast=0;

          LowPrim=0.0; LowLast=0.0;
          HighPrim=0.0; HighLast=0.0;
  
          flagLow=false;
          Angle=-100;
         }
     }

  flagFrNew=false;
  numBar=0;
//-----------2  . .
  }

//-----------------------------------------
//    . .
//-----------------------------------------   


// end
}

//----------------------------------------------------
//    
//----------------------------------------------------


//----------------------------------------------------
//  ZigZag ( 4  ). .
//----------------------------------------------------
void ZigZag_()
  {
//  ZigZag  . .
   int    shift, back,lasthighpos,lastlowpos;
   double val,res;
   double curlow,curhigh,lasthigh,lastlow;

   for(shift=Bars-ExtDepth; shift>=0; shift--)
     {
      val=Low[Lowest(NULL,0,MODE_LOW,ExtDepth,shift)];
      if(val==lastlow) val=0.0;
      else 
        { 
         lastlow=val; 
         if((Low[shift]-val)>(ExtDeviation*Point)) val=0.0;
         else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
               res=ExtMapBuffer[shift+back];
               if((res!=0)&&(res>val)) ExtMapBuffer[shift+back]=0.0; 
              }
           }
        } 
      ExtMapBuffer[shift]=val;
      //--- high
      val=High[Highest(NULL,0,MODE_HIGH,ExtDepth,shift)];
      if(val==lasthigh) val=0.0;
      else 
        {
         lasthigh=val;
         if((val-High[shift])>(ExtDeviation*Point)) val=0.0;
         else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
               res=ExtMapBuffer2[shift+back];
               if((res!=0)&&(res<val)) ExtMapBuffer2[shift+back]=0.0; 
              } 
           }
        }
      ExtMapBuffer2[shift]=val;
     }

   // final cutting 
   lasthigh=-1; lasthighpos=-1;
   lastlow=-1;  lastlowpos=-1;

   for(shift=Bars-ExtDepth; shift>=0; shift--)
     {
      curlow=ExtMapBuffer[shift];
      curhigh=ExtMapBuffer2[shift];
      if((curlow==0)&&(curhigh==0)) continue;
      //---
      if(curhigh!=0)
        {
         if(lasthigh>0) 
           {
            if(lasthigh<curhigh) ExtMapBuffer2[lasthighpos]=0;
            else ExtMapBuffer2[shift]=0;
           }
         //---
         if(lasthigh<curhigh || lasthigh<0)
           {
            lasthigh=curhigh;
            lasthighpos=shift;
           }
         lastlow=-1;
        }
      //----
      if(curlow!=0)
        {
         if(lastlow>0)
           {
            if(lastlow>curlow) ExtMapBuffer[lastlowpos]=0;
            else ExtMapBuffer[shift]=0;
           }
         //---
         if((curlow<lastlow)||(lastlow<0))
           {
            lastlow=curlow;
            lastlowpos=shift;
           } 
         lasthigh=-1;
        }
     }
  
   for(shift=Bars-1; shift>=0; shift--)
     {
      zz[shift]=ExtMapBuffer[shift];
      if(shift>=Bars-ExtDepth) {ExtMapBuffer2[shift]=0.0;ExtMapBuffer[shift]=0.0; zz[shift]=0.0;}
      else
        {
         res=ExtMapBuffer2[shift];
         if(res!=0.0) zz[shift]=res;
        }
     }

   return;
  }
//--------------------------------------------------------
// ZigZag  . . 
//--------------------------------------------------------


//--------------------------------------------------------
//   .   . .
//--------------------------------------------------------
void countFractal (bool flagFrNew, int numBar)
  {
   int shift;
   countLow1=0;
   countHigh1=0;
   if (flagFrNew)
     {
      for(shift=0; shift<=numBar; shift++)
        {
         if (ExtMapBuffer[shift]>0.0) {countLow1++;}
         if (ExtMapBuffer2[shift]>0.0) {countHigh1++;}    
        }  
      counted_bars=3;
     }
   else
     {
      for(shift=0; shift<=Bars-1; shift++)
        {
         if (ExtMapBuffer[shift]>0.0) {countLow1++;}
         if (ExtMapBuffer2[shift]>0.0) {countHigh1++;}
        }
     }
   return ;
  }
//--------------------------------------------------------
//   .   . .
//--------------------------------------------------------



//--------------------------------------------------------
//  . .
//
//      .
//       ZigZag-a.
//--------------------------------------------------------
void matriza()
  {
   int shift,k;
   if (afrm)
     {
      k=0;
      for (shift=0; shift<Bars && k<5; shift++)
        {
         if (zz[shift]>0)
           {
            afr[k]=Time[shift];
            //    . ,     .
            //        .
            if (k==0)
              {
               timeFr1=Time[shift];

               if (ExtMapBuffer[shift]==zz[shift]) {lFr1=Low[shift]; hFr1=0.0;}
               if (ExtMapBuffer2[shift]==zz[shift]) {hFr1=High[shift]; lFr1=0.0;}

              }

            if (zz[shift]==ExtMapBuffer[shift]) {afrl[k]=Low[shift]; afrh[k]=0.0;}
            if (zz[shift]==ExtMapBuffer2[shift]) {afrh[k]=High[shift]; afrl[k]=0.0;}
            k++;
           }
        }
      afrm=false;
      if (ExtFibo)
        {
         if (afrl[1]>0) ObjectCreate("fibo",OBJ_FIBO,0,afr[2],afrh[2],afr[1],afrl[1]);
         else ObjectCreate("fibo",OBJ_FIBO,0,afr[2],afrl[2],afr[1],afrh[1]);
        }
     }
  }
//--------------------------------------------------------
//  . .
//--------------------------------------------------------

