//+------------------------------------------------------------------+
//|                                                    EMA_Pivot.mq4 |
//|                                       Copyright  2006, Akuma99. |
//|                                    http://www.beginnertrader.com |
//+------------------------------------------------------------------+
#property copyright "Copyright  2006, Akuma99."
#property link      "http://www.beginnertrader.com"

#property indicator_chart_window
#property indicator_buffers 2
#property indicator_color1 Blue
#property indicator_color2 Red
//---- buffers
double ExtMapBuffer1[];
double ExtMapBuffer2[];
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- indicators
   SetIndexStyle(0,DRAW_ARROW);
   SetIndexArrow(0,233);
   SetIndexBuffer(0,ExtMapBuffer1);
   SetIndexEmptyValue(0,0.0);
   SetIndexStyle(1,DRAW_ARROW);
   SetIndexArrow(1,234);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexEmptyValue(1,0.0);
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//----
   
//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   int    counted_bars=IndicatorCounted();
   int    limit=Bars-counted_bars;
   int    i;
//----
   
   for(i=0; i<limit; i++){
   
      clearBuffers(i);
   
      double ema1 = iMA(NULL,0,4,0,MODE_EMA,PRICE_CLOSE,i);
      
      if (Low[i] > ema1+5*Point) { // down
         
         ExtMapBuffer2[i] = High[i]+15*Point;
         
      } else if (High[i] < ema1-5*Point) { //up
      
         ExtMapBuffer1[i] = Low[i]-15*Point;
      
      }
   }
   
//----
   return(0);
  }
//+------------------------------------------------------------------+

void clearBuffers(int i) {
   
   ExtMapBuffer2[i] = NULL;
   ExtMapBuffer1[i] = NULL;
      
}