
#property indicator_separate_window
#property indicator_buffers 7
#property indicator_color1 Aqua
#property indicator_color2 Blue
#property indicator_color3 Red
#property indicator_color4 Yellow 
#property indicator_color5 Orange
#property indicator_color6 Green
#property indicator_color7 Black

//-------   --------------------------------------

//-------    -------------------------------
extern string NameCross    = "EURUSD"; //  
extern string NameMain1    = "EURCHF"; //    1
extern string NameMain2    = "USDCHF"; //    2
extern string NameMain3    = "EURGBP"; //    3
extern string NameMain4    = "GBPUSD"; //    4
extern string NameMain5    = "EURJPY"; //    5
extern string NameMain6    = "USDJPY"; //    6
extern string NameMain7    = "EURCAD"; //    7
extern string NameMain8    = "USDCAD"; //    8
extern string NameMain9    = "EURAUD"; //    9
extern string NameMain10   = "AUDUSD"; //    10
extern string NameMain11   = "EURNZD"; //    11
extern string NameMain12   = "NZDUSD"; //    12
extern int    NumberOfBars = 100;      //    

//-------   ------------------------------------------
double buf0[], buf1[], buf2[], buf3[], buf4[], buf5[], buf6[]; 

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
void init() {
  SetIndexBuffer(0, buf0);
  SetIndexLabel (0, NameCross);
  SetIndexStyle (0, DRAW_LINE, STYLE_SOLID, 2);
  SetIndexEmptyValue(0, 0);

  SetIndexBuffer(1, buf1);
  SetIndexLabel (1, NameMain1+"/"+NameMain2);
  SetIndexStyle (1, DRAW_LINE, STYLE_SOLID, 2);
  SetIndexEmptyValue(1, 0);
  
  SetIndexBuffer(2, buf2);
  SetIndexLabel (2, NameMain3+"*"+NameMain4);
  SetIndexStyle (2, DRAW_LINE, STYLE_SOLID, 2);
  SetIndexEmptyValue(2, 0);
  
  SetIndexBuffer(3, buf3);
  SetIndexLabel (3, NameMain5+"/"+NameMain6);
  SetIndexStyle (3, DRAW_LINE, STYLE_SOLID, 2);
  SetIndexEmptyValue(3, 0);
  
  
  SetIndexBuffer(4, buf4);
  SetIndexLabel (4, NameMain7+"/"+NameMain8);
  SetIndexStyle (4, DRAW_LINE, STYLE_SOLID, 2);
  SetIndexEmptyValue(4, 0);
  
  
  SetIndexBuffer(5, buf5);
  SetIndexLabel (5, NameMain9+"*"+NameMain10);
  SetIndexStyle (5, DRAW_LINE, STYLE_SOLID, 2);
  SetIndexEmptyValue(5, 0);
  
  
  SetIndexBuffer(6, buf6);
  SetIndexLabel (6, NameMain11+"*"+NameMain12);
  SetIndexStyle (6, DRAW_LINE, STYLE_SOLID, 2);
  SetIndexEmptyValue(6, 0);
}

bool first=true;

//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
void deinit() {
  Comment("");
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
void start() {
  int sh, limit;
  int counted_bars=IndicatorCounted();

  if(counted_bars>0) counted_bars--;
  limit=Bars-counted_bars+1;
  if(first) { limit=NumberOfBars; first=false; }
  for (sh=limit; sh>=0; sh--)
  {
    buf0[sh]=iClose(NameCross, 0, sh);
    buf1[sh]=iClose(NameMain1, 0, sh)/iClose(NameMain2, 0, sh);
    buf2[sh]=iClose(NameMain3, 0, sh)*iClose(NameMain4, 0, sh);
    buf3[sh]=iClose(NameMain5, 0, sh)/iClose(NameMain6, 0, sh);
    buf4[sh]=iClose(NameMain7, 0, sh)/iClose(NameMain8, 0, sh);
    buf5[sh]=iClose(NameMain9, 0, sh)*iClose(NameMain10, 0, sh);
    buf6[sh]=iClose(NameMain11, 0, sh)*iClose(NameMain12, 0, sh);
  }
}
//+------------------------------------------------------------------+

