//+------------------------------------------------------------------+
//|                                         EM5-Cross.mq4            |
//|         Copyright  2005, Harmeet Singh                          |
//|                   grabapip@yahoo.com                             |
//+------------------------------------------------------------------+


#property copyright "Harmeet Singh"
#property link      "grabapip@yahoo.com"

#property indicator_chart_window
#property indicator_buffers 5
#property indicator_color1 Blue
#property indicator_color2 Yellow
#property indicator_color3 Orange
#property indicator_color4 Aqua
#property indicator_color5 Red
#property indicator_width1 2
#property indicator_width2 2
#property indicator_width3 2
#property indicator_width4 4
#property indicator_width5 4

extern int AllBars=250;

double ExtMapBuffer[];
extern bool Use12_21_Cross = false;
double CrossUp12_21[];
double CrossDown12_21[];
extern int FasterEMA = 12;
extern int SlowerEMA = 21;

double CrossUp12_89[];
double CrossDown12_89[];
extern int FastEMA = 12;
extern int SlowEMA = 89;

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  {
//---- drawing settings
   SetIndexStyle(0,DRAW_LINE);
   SetIndexShift(0,0);
   IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));
   
//---- indicators
   SetIndexStyle(1, DRAW_ARROW, EMPTY);
   SetIndexArrow(1, 233);
   SetIndexBuffer(1, CrossUp12_21);
   SetIndexStyle(2, DRAW_ARROW, EMPTY);
   SetIndexArrow(2, 234);
   SetIndexBuffer(2, CrossDown12_21);


   SetIndexStyle(3, DRAW_ARROW, EMPTY);
   SetIndexArrow(3, 233);
   SetIndexBuffer(3, CrossUp12_89);
   SetIndexStyle(4, DRAW_ARROW, EMPTY);
   SetIndexArrow(4, 234);
   SetIndexBuffer(4, CrossDown12_89);
   //---- indicator short name
   IndicatorShortName("EMA_12-89");
   SetIndexDrawBegin(0,240);
//---- indicator buffers mapping
   SetIndexBuffer(0,ExtMapBuffer);
//---- initialization done
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator deinitialization function                       |
//+------------------------------------------------------------------+
int deinit()
  {
//---- 

//----
   return(0);
  }
//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start() {
   int i, counter;
   
   double fasterEMAnow, slowerEMAnow, fasterEMAprevious, slowerEMAprevious, fasterEMAafter, slowerEMAafter, cu;
   double fastEMAnow, slowEMAnow, fastEMAprevious, slowEMAprevious, fastEMAafter, slowEMAafter;
   double Range, AvgRange;
   int counted_bars=IndicatorCounted();
//---- check for possible errors
   if(counted_bars<0) return(-1);
//---- last counted bar will be recounted
   if(counted_bars>0) counted_bars--;
   int limit = Bars-counted_bars-1;
   if (limit > AllBars) limit = AllBars;
   
   for(i=limit; i > 0; i--) {
   
      counter=i;
      Range=0;
      AvgRange=0;
            
      for (counter=i ;counter<=i+9;counter++)
      {
         AvgRange=AvgRange+MathAbs(High[counter]-Low[counter]);
      }
      Range=AvgRange/10;
       
      if (Use12_21_Cross)
      {
         fasterEMAnow = iMA(NULL, 0, FasterEMA, 0, MODE_EMA, PRICE_CLOSE, i);
         fasterEMAprevious = iMA(NULL, 0, FasterEMA, 0, MODE_EMA, PRICE_CLOSE, i+1);
         fasterEMAafter = iMA(NULL, 0, FasterEMA, 0, MODE_EMA, PRICE_CLOSE, i-1);

         slowerEMAnow = iMA(NULL, 0, SlowerEMA, 0, MODE_EMA, PRICE_CLOSE, i);
         slowerEMAprevious = iMA(NULL, 0, SlowerEMA, 0, MODE_EMA, PRICE_CLOSE, i+1);
         slowerEMAafter = iMA(NULL, 0, SlowerEMA, 0, MODE_EMA, PRICE_CLOSE, i-1);
      }
      
      fastEMAnow = iMA(NULL, 0, FastEMA, 0, MODE_EMA, PRICE_CLOSE, i);
      fastEMAprevious = iMA(NULL, 0, FastEMA, 0, MODE_EMA, PRICE_CLOSE, i+1);
      fastEMAafter = iMA(NULL, 0, FastEMA, 0, MODE_EMA, PRICE_CLOSE, i-1);

      slowEMAnow = iMA(NULL, 0, SlowEMA, 0, MODE_EMA, PRICE_CLOSE, i);
      slowEMAprevious = iMA(NULL, 0, SlowEMA, 0, MODE_EMA, PRICE_CLOSE, i+1);
      slowEMAafter = iMA(NULL, 0, SlowEMA, 0, MODE_EMA, PRICE_CLOSE, i-1);
      
      if (Use12_21_Cross)
      {
         if ((fasterEMAnow > slowerEMAnow) && (fasterEMAprevious < slowerEMAprevious) && (fasterEMAafter > slowerEMAafter)) {
            CrossUp12_21[i] = Low[i] - Range*0.5; 
//          if(limit<=2)
//            {
//            Alert (Symbol()," ",Period(),"-Min. BUY Crossed Up at ",  CrossUp12_21[i]);
//            }
         
         }
         else if ((fasterEMAnow < slowerEMAnow) && (fasterEMAprevious > slowerEMAprevious) && (fasterEMAafter < slowerEMAafter)) {
            CrossDown12_21[i] = High[i] + Range*0.5; 
         
//           if(limit<=2)
//           {
//            Alert (Symbol()," ",Period(),"-Min. SELL Crossed Down at ",  CrossDown12_21[i]);
//           }
      
         }
      }
      
      if ((fastEMAnow > slowEMAnow) && (fastEMAprevious < slowEMAprevious) && (fastEMAafter > slowEMAafter)) {
         CrossUp12_89[i] = Low[i] - Range*0.5;
//       if(limit<=2)
//            {
//            Alert (Symbol()," ",Period(),"-Min. BUY Crossed Up at ",  CrossUp12_89[i]);
//            }
      }
      else if ((fastEMAnow < slowEMAnow) && (fastEMAprevious > slowEMAprevious) && (fastEMAafter < slowEMAafter)) {
         CrossDown12_89[i] = High[i] + Range*0.5;
//        if(limit<=2)
//           {
//          Alert (Symbol()," ",Period(),"-Min. SELL Crossed Down at ",  CrossDown12_89[i]);
//         }
      }
       
   }
   return(0);
}

