//+------------------------------------------------------------------+
//|                                                     e-man123.mq4 |
//|                                                   man123 & KimIV |
//|                                              http://www.kimiv.ru |
//|                                                                  |
//|  16.02.2006       .   |
//+------------------------------------------------------------------+
#property copyright "man123 & KimIV"
#property link      "http://www.kimiv.ru"

//-------    --------------------------------
extern string _P_Expert = "----------  ";
extern double Lots       = 0.1;
extern int    StopLoss   = 0;
extern int    TakeProfit = 0;
extern int    MAGIC      = 20060216;
extern bool   UseAddPos  = True;
extern string _P1 = "----------  1- ";
extern int    K1         = 10;
extern double Kstop1     = 0.5;
extern int    Kperiod1   = 50;
extern int    PerADX1    = 14;
extern int    CountBars1 = 50;
extern string _P2 = "----------  2- ";
extern int    K2         = 20;
extern double Kstop2     = 0.5;
extern int    Kperiod2   = 100;
extern int    PerADX2    = 14;
extern int    CountBars2 = 50;
extern string _P3 = "----------  3- ";
extern int    K3         = 30;
extern double Kstop3     = 0.5;
extern int    Kperiod3   = 150;
extern int    PerADX3    = 14;
extern int    CountBars3 = 50;

//-------    ----------------------------
int   Slippage    = 3;
color clOpenBuy   = LightBlue;
color clOpenSell  = LightCoral;
color clCloseBuy  = Blue;
color clCloseSell = Red;
int   prevTimeBar;


//+------------------------------------------------------------------+
//| expert start function                                            |
//+------------------------------------------------------------------+
void start() {
  if (prevTimeBar!=Time[0]) OpenPositions();
  prevTimeBar=Time[0];
}

//+------------------------------------------------------------------+
//|                                                   |
//+------------------------------------------------------------------+
void OpenPositions() {
  double ldStop=0, ldTake=0;
  int    bs=GetTradeSignal();

  if (bs>0) {
    if (ExistPositionByOP(OP_SELL)) CloseAllPositions();
    if (!ExistPositionByOP(OP_BUY) || UseAddPos) {
      if (StopLoss!=0) ldStop=Ask-StopLoss*Point;
      if (TakeProfit!=0) ldTake=Ask+TakeProfit*Point;
      OpenPosition(OP_BUY, ldStop, ldTake);
    }
  }
  if (bs<0) {
    if (ExistPositionByOP(OP_BUY)) CloseAllPositions();
    if (!ExistPositionByOP(OP_SELL) || UseAddPos) {
      if (StopLoss!=0) ldStop=Bid+StopLoss*Point;
      if (TakeProfit!=0) ldTake=Bid-TakeProfit*Point;
      OpenPosition(OP_SELL, ldStop, ldTake);
    }
  }
}

//+------------------------------------------------------------------+
//|   :                                      |
//|    1 -                                                    |
//|    0 - ,                                           |
//|   -1 -                                                   |
//+------------------------------------------------------------------+
int GetTradeSignal() {
  int    bs=0;
  double b1=iCustom(NULL, 0, "AltrTrend_Signal_v2_2", K1, Kstop1, Kperiod1, PerADX1, CountBars1, 0, 1);
  double b2=iCustom(NULL, 0, "AltrTrend_Signal_v2_2", K2, Kstop2, Kperiod2, PerADX2, CountBars2, 0, 1);
  double b3=iCustom(NULL, 0, "AltrTrend_Signal_v2_2", K3, Kstop3, Kperiod3, PerADX3, CountBars3, 0, 1);
  double s1=iCustom(NULL, 0, "AltrTrend_Signal_v2_2", K1, Kstop1, Kperiod1, PerADX1, CountBars1, 1, 1);
  double s2=iCustom(NULL, 0, "AltrTrend_Signal_v2_2", K2, Kstop2, Kperiod2, PerADX2, CountBars2, 1, 1);
  double s3=iCustom(NULL, 0, "AltrTrend_Signal_v2_2", K3, Kstop3, Kperiod3, PerADX3, CountBars3, 1, 1);

  if (b1>0 && b2>0 && b3>0) bs=1;
  if (s1>0 && s2>0 && s3>0) bs=-1;

  return(bs);
}

//+------------------------------------------------------------------+
//|                                |
//+------------------------------------------------------------------+
bool ExistPositionByOP(int op) {
  for (int i=0; i<OrdersTotal(); i++) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderSymbol()==Symbol() && OrderMagicNumber()==MAGIC) {
        if (OrderType()==op) return(True);
      }
    }
  }
  return(False);
}

//+------------------------------------------------------------------+
//|                                                   |
//| :                                                       |
//|   op     -                                               |
//|   ldStop -                                            |
//|   ldTake -                                            |
//+------------------------------------------------------------------+
void OpenPosition(int op, double ldStop, double ldTake) {
  color  clOpen;
  double pp;

  if (op==OP_BUY) {
    clOpen=clOpenBuy; pp=Ask;
  } else {
    clOpen=clOpenSell; pp=Bid;
  }
  pp=NormalizeDouble(pp, Digits);
  OrderSend(Symbol(),op,Lots,pp,Slippage,ldStop,ldTake,"",MAGIC,0,clOpen);
}

//+------------------------------------------------------------------+
//|                                 |
//+------------------------------------------------------------------+
void CloseAllPositions() {
  for (int i=OrdersTotal()-1; i>=0; i--) {
    if (OrderSelect(i, SELECT_BY_POS, MODE_TRADES)) {
      if (OrderSymbol()==Symbol() && OrderMagicNumber()==MAGIC) {
        if (OrderType()==OP_BUY) {
          OrderClose(OrderTicket(), OrderLots(), Bid, Slippage, clCloseBuy);
        }
        if (OrderType()==OP_SELL) {
          OrderClose(OrderTicket(), OrderLots(), Ask, Slippage, clCloseSell);
        }
      }
    }
  }
}
//+------------------------------------------------------------------+

