//+------------------------------------------------------------------+
//| T3.mq4 |
//| MojoFX |
//| http://groups.yahoo.com/group/MetaTrader_Experts_and_Indicators/ |
//+------------------------------------------------------------------+
#property copyright "MojoFX - Conversion only"
#property link "http://groups.yahoo.com/group/MetaTrader_Experts_and_Indicators/"

#property indicator_chart_window
#property indicator_buffers 3
#property indicator_color1 Green
#property indicator_color2 Blue
#property indicator_color3 Black

extern int MA_Period1 = 4;
extern int MA_Period2 = 8;
extern int MA_Period3 = 12;
extern double b = 0.6128;


double MapBuffer1[];
double MapBuffer2[];
double MapBuffer3[];

double e1[],e2[],e3[],e4[],e5[],e6[],e12[],e22[],e32[],e42[],e52[],e62[],e13[],e23[],e33[],e43[],e53[],e63[];
double c1,c2,c3,c4;
double n1,n2,n3,w1,w2,b2,b3,w12,w22,w13,w23;

//+------------------------------------------------------------------+
//| Custom indicator initialization function |
//+------------------------------------------------------------------+
int init()
{
//---- indicators setting
SetIndexStyle(0,DRAW_LINE,STYLE_SOLID,1,indicator_color1);
IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));
IndicatorShortName("T3_"+MA_Period1);
SetIndexDrawBegin(0,100);
SetIndexBuffer(0,MapBuffer1);

SetIndexStyle(1,DRAW_LINE,STYLE_SOLID,1,indicator_color2);
IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));
IndicatorShortName("T3_"+MA_Period2);
SetIndexDrawBegin(1,100);
SetIndexBuffer(1,MapBuffer2);

SetIndexStyle(2,DRAW_LINE,STYLE_SOLID,1,indicator_color3);
IndicatorDigits(MarketInfo(Symbol(),MODE_DIGITS));
IndicatorShortName("T3_"+MA_Period3);
SetIndexDrawBegin(2,100);
SetIndexBuffer(2,MapBuffer3);


//---- variable reset
//e2=0; e3=0; e4=0; e5=0; e6=0;
c1=0; c2=0; c3=0; c4=0; 
n1=0; n2=0; n3=0; 
w1=0; w2=0; w12=0; w22=0; w13=0; w23=0;
b2=0; b3=0;

b2=b*b;
b3=b2*b;
c1=-b3;
c2=(3*(b2+b3));
c3=-3*(2*b2+b+b3);
c4=(1+3*b+b3+3*b2);
n1=MA_Period1;
n2=MA_Period2;
n3=MA_Period3;

if (n1<1) n1=1;
n1 = 1 + 0.5*(n1-1);
w1 = 2 / (n1 + 1);
w2 = 1 - w1;

if (n2<1) n2=1;
n2 = 1 + 0.5*(n2-1);
w12 = 2 / (n2 + 1);
w22 = 1 - w12;

if (n3<1) n3=1;
n3 = 1 + 0.5*(n3-1);
w13 = 2 / (n3 + 1);
w23 = 1 - w13;

//----
return(0);
}

//+------------------------------------------------------------------+
//| Custom indicator iteration function |
//+------------------------------------------------------------------+
int start()
{
int limit;
int counted_bars=IndicatorCounted();
if (counted_bars<0) return (-1);
if (counted_bars>0) counted_bars--;
limit=(Bars-counted_bars)-1;

//---- indicator calculation
ArrayResize(e1, Bars+1);
ArrayResize(e2, Bars+1);
ArrayResize(e3, Bars+1);
ArrayResize(e4, Bars+1);
ArrayResize(e5, Bars+1);
ArrayResize(e6, Bars+1);

ArrayResize(e12, Bars+1);
ArrayResize(e22, Bars+1);
ArrayResize(e32, Bars+1);
ArrayResize(e42, Bars+1);
ArrayResize(e52, Bars+1);
ArrayResize(e62, Bars+1);

ArrayResize(e13, Bars+1);
ArrayResize(e23, Bars+1);
ArrayResize(e33, Bars+1);
ArrayResize(e43, Bars+1);
ArrayResize(e53, Bars+1);
ArrayResize(e63, Bars+1);


for(int i=limit; i>=0; i--)
{
   e1[Bars-i] = w1*Close[i] + w2*e1[(Bars-i)-1];
   e2[Bars-i] = w1*e1[Bars-i] + w2*e2[(Bars-i)-1];
   e3[Bars-i] = w1*e2[Bars-i] + w2*e3[(Bars-i)-1];
   e4[Bars-i] = w1*e3[Bars-i] + w2*e4[(Bars-i)-1];
   e5[Bars-i] = w1*e4[Bars-i] + w2*e5[(Bars-i)-1];
   e6[Bars-i] = w1*e5[Bars-i] + w2*e6[(Bars-i)-1];
   //Print ("I- ",i, "Bars-I ",Bars-i);
   MapBuffer1[i]=c1*e6[Bars-i] + c2*e5[Bars-i] + c3*e4[Bars-i] + c4*e3[Bars-i];
} 


for(i=limit; i>=0; i--)
{
   e12[Bars-i] = w12*Close[i] + w22*e12[(Bars-i)-1];
   e22[Bars-i] = w12*e12[Bars-i] + w22*e22[(Bars-i)-1];
   e32[Bars-i] = w12*e22[Bars-i] + w22*e32[(Bars-i)-1];
   e42[Bars-i] = w12*e32[Bars-i] + w22*e42[(Bars-i)-1];
   e52[Bars-i] = w12*e42[Bars-i] + w22*e52[(Bars-i)-1];
   e62[Bars-i] = w12*e52[Bars-i] + w22*e62[(Bars-i)-1];
   //Print ("I- ",i, "Bars-I ",Bars-i);

   MapBuffer2[i]=c1*e62[Bars-i] + c2*e52[Bars-i] + c3*e42[Bars-i] + c4*e32[Bars-i];
} 


for(i=limit; i>=0; i--)
{
   e13[Bars-i] = w13*Close[i] + w23*e13[(Bars-i)-1];
   e23[Bars-i] = w13*e13[Bars-i] + w23*e23[(Bars-i)-1];
   e33[Bars-i] = w13*e23[Bars-i] + w23*e33[(Bars-i)-1];
   e43[Bars-i] = w13*e33[Bars-i] + w23*e43[(Bars-i)-1];
   e53[Bars-i] = w13*e43[Bars-i] + w23*e53[(Bars-i)-1];
   e63[Bars-i] = w13*e53[Bars-i] + w23*e63[(Bars-i)-1];
   //Print ("I- ",i, "Bars-I ",Bars-i);

   MapBuffer3[i]=c1*e63[Bars-i] + c2*e53[Bars-i] + c3*e43[Bars-i] + c4*e33[Bars-i];
} 
//----
return(0);
}
//+------------------------------------------------------------------+

