//+------------------------------------------------------------------+
//|                                                     WAVE_123.mq4 |
//|                      Copyright  2005, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+

#property copyright "Copyright  2005, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"



#property indicator_chart_window
#property indicator_buffers 1
#property indicator_color1 Green
//---- indicator parameters
extern int ExtDepth=24;
extern int ExtDeviation=3;
extern int ExtBackstep=3;

//---- indicator buffers
double ExtMapBuffer[];
double ExtMapBuffer2[];
double pos3,pos2,posC,pos1,posX;
double top2,bot2,top3,bot3,topC,botC,top1,bot1,topX,botX,pos1ex,pos2ex,pos3ex;
double XA,AB,BC,CD;
double XAAB,ABBC,BCCD;
datetime TimeX,TimeC,Time3,Time2,Time1,TS1,TS2,TS3,TT1,TT2,TT3;
double PS1,PT1,PS2,PT2,PS3,PT3;
double Fib1High,Fib1Low,Fib2High,Fib2Low,Fib3High,Fib3Low;
double level_array[6]={100,161.8,2.058,2.618};
string leveldesc_array[6]={"100%","161.8%","205.8%","261.80%"};
int level_count;
string level_name;
double text_y;

//TS1: time source of fibo1
//PS1: price source of fibo1
//TT1: time target of fibo1
//PT1: price target of fibo1
//etc...

//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+
int init()
  { 
   IndicatorBuffers(2);
//---- drawing settings
   SetIndexStyle(0,DRAW_SECTION);
//---- indicator buffers mapping
   SetIndexBuffer(0,ExtMapBuffer);
   SetIndexBuffer(1,ExtMapBuffer2);
   SetIndexEmptyValue(0,0.0);
   ArraySetAsSeries(ExtMapBuffer,true);
   ArraySetAsSeries(ExtMapBuffer2,true);
//---- indicator short name
   IndicatorShortName("Fibodrawer");
//---- initialization done
   return(0);
  }
  
int deinit() {
	ObjectDelete("Fibo1");
	ObjectDelete("Fibo2");
	ObjectDelete("Fibo3");
	ObjectDelete("X");
	ObjectDelete("1");
	ObjectDelete("2");
	ObjectDelete("3");
	ObjectDelete("C");
}
//+------------------------------------------------------------------+
//|                                                                  |
//+------------------------------------------------------------------+
int start()
  {   double Points = MarketInfo (Symbol(), MODE_POINT);
      int    shift, back,lasthighpos,lastlowpos;
      double val,res;
      double curlow,curhigh,lasthigh,lastlow;

      for(shift=Bars-ExtDepth; shift>=0; shift--)
         {
            val=Low[Lowest(NULL,0,MODE_LOW,ExtDepth,shift)];
            if(val==lastlow) val=0.0;
            else 
            { 
            lastlow=val; 
            if((Low[shift]-val)>(ExtDeviation*Point)) val=0.0;
            else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
               res=ExtMapBuffer[shift+back];
               if((res!=0)&&(res>val)) ExtMapBuffer[shift+back]=0.0; 
              }
           }
        } 
      ExtMapBuffer[shift]=val;
      //--- high
      val=High[Highest(NULL,0,MODE_HIGH,ExtDepth,shift)];
      if(val==lasthigh) val=0.0;
      else 
        {
         lasthigh=val;
         if((val-High[shift])>(ExtDeviation*Point)) val=0.0;
         else
           {
            for(back=1; back<=ExtBackstep; back++)
              {
               res=ExtMapBuffer2[shift+back];
               if((res!=0)&&(res<val)) ExtMapBuffer2[shift+back]=0.0; 
              } 
           }
        }
      ExtMapBuffer2[shift]=val;
     }

   // final cutting 
   lasthigh=-1; lasthighpos=-1;
   lastlow=-1;  lastlowpos=-1;

   for(shift=Bars-ExtDepth; shift>=0; shift--)
     {
      curlow=ExtMapBuffer[shift];
      curhigh=ExtMapBuffer2[shift];
      if((curlow==0)&&(curhigh==0)) continue;
      //---
      if(curhigh!=0)
        {
         if(lasthigh>0) 
           {
            if(lasthigh<curhigh) ExtMapBuffer2[lasthighpos]=0;
            else ExtMapBuffer2[shift]=0;
           }
         //---
         if(lasthigh<curhigh || lasthigh<0)
           {
            lasthigh=curhigh;
            lasthighpos=shift;
           }
         lastlow=-1;
        }
      //----
      if(curlow!=0)
        {
         if(lastlow>0)
           {
            if(lastlow>curlow) ExtMapBuffer[lastlowpos]=0;
            else ExtMapBuffer[shift]=0;
           }
         //---
         if((curlow<lastlow)||(lastlow<0))
           {
            lastlow=curlow;
            lastlowpos=shift;
           } 
         lasthigh=-1;
        }
     }
  
   for(shift=Bars-1; shift>=0; shift--)
     {
      if(shift>=Bars-ExtDepth) ExtMapBuffer[shift]=0.0;
      else
        {
         res=ExtMapBuffer2[shift];
         if(res!=0.0) ExtMapBuffer[shift]=res;
        }

     }
     
  	int i=0;
  	int LastZigZag, PreviousZigZag,PreviousZigZag2,PreviousZigZag3,PreviousZigZag4;
   
   int h=0;
   while ( ExtMapBuffer[h]==0 && ExtMapBuffer2[h]==0) 
         {h++;}
   LastZigZag=h;
   h++;
   while(ExtMapBuffer[h]==0 && ExtMapBuffer2[h]==0) 
         {h++;}
   PreviousZigZag=h;
   h++;
   while(ExtMapBuffer[h]==0 && ExtMapBuffer2[h]==0) 
      {h++;}
   PreviousZigZag2=h;
   h++;
   while(ExtMapBuffer[h]==0 && ExtMapBuffer2[h]==0) 
      {h++;}
   PreviousZigZag3=h;
   h++;
   while(ExtMapBuffer[h]==0 && ExtMapBuffer2[h]==0) 
      {h++;}
   PreviousZigZag4=h;
   
 
   topC=High[LastZigZag];
   botC=Low[LastZigZag];
   top3=High[PreviousZigZag];
   bot3=Low[PreviousZigZag];
   top2=High[PreviousZigZag2];
   bot2=Low[PreviousZigZag2];
   top1=High[PreviousZigZag3];
   bot1=Low[PreviousZigZag3];
   topX=High[PreviousZigZag4];
   botX=Low[PreviousZigZag4];
   TimeC=Time[LastZigZag];
   Time3=Time[PreviousZigZag];
   Time2=Time[PreviousZigZag2];
   Time1=Time[PreviousZigZag3];
   TimeX=Time[PreviousZigZag4];
   
   
 
      
      
      
      
  // CREATE X,A,B,C,D TEXTS
  if(top1>top3 && bot3>bot2 && bot1>bot2 )// bot2 IS A TROUGH
      {//Alert("cas 1");
      
      
      pos2=bot2;
      pos1=top3+11*Points;
      pos3=top1+11*Points;
      posX=botX;
      pos1ex=top3;
      pos2ex=bot2;
      pos3ex=top1;
      
      //XA=Bars-topA;
      //AB=(topA-botB)/Bars;
      //BC=(topC-botB)/Bars;
      //CD=(topC-bot1)/Bars;
      
     //Comment("XA= ",XA," AB=",AB," BC=",BC," CD=",CD);
      }
  if(bot1<bot3 &&  bot2 > bot3 && top1<top2 )// D IS A PEAK
      {//Alert("cas 2");
      
     
      pos3=bot1;
      pos2=top2+11*Points;
      pos1=bot3;
      posX=topX;
      pos3ex=bot1;
      pos2ex=top2;
      pos1ex=bot3;
      //XA=(topX-botA)/Bars;
      //AB=(topB-botA)/Bars;
      //BC=(topB-botC)/Bars;
      //CD=(top1-botC)/Bars;
      //XAAB=AB/XA;
      //ABBC=BC/AB;
      //BCCD=CD/BC;
      //Comment("XA= ",XA," AB=",AB," BC=",BC," CD=",CD," AB/XA=",XAAB," BC/AB=",ABBC," CD/BC=",BCCD);
      }   
   
   ObjectCreate("X", OBJ_TEXT, 0, Time[PreviousZigZag4],posX);  
   ObjectSetText("X", "X", 14, "Arial", Yellow); 
   
   ObjectCreate("1", OBJ_TEXT, 0, Time[PreviousZigZag3],pos3);  
   ObjectSetText("1", "1", 14, "Arial", Yellow);
   
   ObjectCreate("2", OBJ_TEXT, 0, Time[PreviousZigZag2],pos2);  
   ObjectSetText("2", "2", 14, "Arial", Yellow);
   
   ObjectCreate("3", OBJ_TEXT, 0, Time[PreviousZigZag],pos1);  
   ObjectSetText("3", "3", 14, "Arial", Yellow);
   
   
   // END OF TEXT CREATION
   
  
        
     // START DRAWING FIBS
ObjectCreate("Fibo1",OBJ_EXPANSION,0,Time1,pos3ex,Time2,pos2ex,Time3,pos1ex);
   ObjectSet("Fibo1", OBJPROP_FIBOLEVELS, level_array);
   
   	   
       //  ObjectCreate("Fibo2", OBJ_REGRESSION, 0,TimeB,topB,TimeC,topC);
        // ObjectSet("Fibo2", OBJPROP_RAY, 1);
        // ObjectSet("Fibo2", OBJPROP_COLOR, Yellow);
   	//   ObjectSet("Fibo2", OBJPROP_STYLE, STYLE_SOLID);
   	  // if (PS3>0)// if fib3 is defined 
   	    // {  
   	      
   level_count=ArraySize(level_array);
   //Alert(level_count);
   
   //ObjectSet("Fibo1", OBJPROP_FIBOLEVELS, level_count);
   //ObjectSet("Fibo2", OBJPROP_FIBOLEVELS, level_count);
   ObjectSet("Fibo3", OBJPROP_FIBOLEVELS, level_count);
   
   for(int j=0; j<level_count; j++)
   {//Print(j," ",level_array[j]);
   //ObjectSet("Fibo1", OBJPROP_FIRSTLEVEL+j, level_array[j]);
   //ObjectSetFiboDescription("Fibo1",j,leveldesc_array[j]);

   ObjectSet("Fibo1", OBJPROP_FIRSTLEVEL+j, level_array[j]);
   ObjectSetFiboDescription("Fibo1",j,leveldesc_array[j]+"           ");
   ObjectSet("Fibo3", OBJPROP_FIRSTLEVEL+j, level_array[j]);
   ObjectSetFiboDescription("Fibo3",j,leveldesc_array[j]+"                      ");
   //level_name="essai"+j;
   //text_y=PS1+(PT1-PS1)*level_array[j];
   Print(level_array[j]," ",text_y);
   ObjectDelete(level_name);
   ObjectCreate(level_name, OBJ_TEXT, 0, Time[1],text_y);  
   ObjectSetText(level_name, leveldesc_array[j], 8, "Arial", Yellow);
   //FiboLC = FiboL + (FiboH - FiboL)*0.236;
   }

  ObjectSet("Fibo1", OBJPROP_FIBOLEVELS, 4);
  ObjectSet("Fibo1", OBJPROP_FIRSTLEVEL+0, 1);
  ObjectSet("Fibo1", OBJPROP_FIRSTLEVEL+1, 1.618);
  ObjectSet("Fibo1", OBJPROP_FIRSTLEVEL+2, 2.058);
  ObjectSet("Fibo1", OBJPROP_FIRSTLEVEL+3, 2.618); 
   
   ObjectSet("Fibo2", OBJPROP_FIBOLEVELS, 7);
   ObjectSet("Fibo2", OBJPROP_FIRSTLEVEL+0, 0);
   ObjectSet("Fibo2", OBJPROP_FIRSTLEVEL+1, 1);
   ObjectSet("Fibo2", OBJPROP_FIRSTLEVEL+2, 2);
   ObjectSet("Fibo2", OBJPROP_FIRSTLEVEL+3, 3);
   ObjectSet("Fibo2", OBJPROP_FIRSTLEVEL+4, 5);
   ObjectSet("Fibo2", OBJPROP_FIRSTLEVEL+5, 8);
   ObjectSet("Fibo2", OBJPROP_FIRSTLEVEL+6, 13);
   
   ObjectSet("Fibo3", OBJPROP_FIBOLEVELS, 11);
   ObjectSet("Fibo3", OBJPROP_FIRSTLEVEL+0, 0);
   ObjectSet("Fibo3", OBJPROP_FIRSTLEVEL+1, 0.236);
   ObjectSet("Fibo3", OBJPROP_FIRSTLEVEL+2, 0.382);
   ObjectSet("Fibo3", OBJPROP_FIRSTLEVEL+3, 0.5);
   ObjectSet("Fibo3", OBJPROP_FIRSTLEVEL+4, 0.618);
   ObjectSet("Fibo3", OBJPROP_FIRSTLEVEL+5, 0.786);
   ObjectSet("Fibo3", OBJPROP_FIRSTLEVEL+6, 1);
   ObjectSet("Fibo3", OBJPROP_FIRSTLEVEL+7, 1.276);
   ObjectSet("Fibo3", OBJPROP_FIRSTLEVEL+8, 1.618);
   ObjectSet("Fibo3", OBJPROP_FIRSTLEVEL+9, 2.058);
   ObjectSet("Fibo3", OBJPROP_FIRSTLEVEL+10, 261.8);  
   
   
     
}
  
   