//+------------------------------------------------------------------+
//|                                          X_Perriods_High_Low.mq4 |
//|                      Copyright  2007, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2007, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"



#property indicator_chart_window
//---- input parameters
extern int       DAYS=4;
extern int       TimeFrame=1440;
extern int       Pips=15;
extern bool AlertWindow = true;
//+------------------------------------------------------------------+
//| Custom indicator initialization function                         |
//+------------------------------------------------------------------+

int init()
  {
//---- indicators

//---- indicators

   

//----
   return(0);
  }

//+------------------------------------------------------------------+
//| Custom indicator iteration function                              |
//+------------------------------------------------------------------+
int start()
  {
   double daily_high[20];
   double daily_low[20];
   double yesterday_close;
   double phigh,plow;
   int i=1;

//---- TODO: add your code here
ArrayResize(daily_high,DAYS);
ArrayResize(daily_low,DAYS);
ArrayInitialize(daily_high,0);
ArrayInitialize(daily_low,0);

ArrayCopySeries(daily_low, MODE_LOW, Symbol(), TimeFrame);
ArrayCopySeries(daily_high, MODE_HIGH, Symbol(), TimeFrame);

/* initialise */
plow=daily_low[1];
phigh=daily_high[1];

for(i=1;i<DAYS;i++)
{
   if(plow>daily_low[i])
   {
      plow =daily_low[i];
   }
}

for(i=1;i<DAYS;i++)
{
   if(phigh<daily_high[i])
   {
      phigh =daily_high[i];
   }
}

Comment("\n5dayH ",phigh,"\n5dayL ",plow);

if(Bid>= phigh-Pips*Point)
                 {
                   if(AlertWindow == true)
                     {
                       Alert( Symbol(), " im Kaufbereich Ausbruch Long ",">", 
                             
                        
                             DoubleToStr(phigh-Pips*Point, Digits));
                     }
}

if(Ask<= plow+Pips*Point)
                 {
                   if(AlertWindow == true)
                     {
                       Alert( Symbol(), "im  Verkaufsbereich Ausbruch Short ","<", 
                             
                        
                             DoubleToStr(plow+Pips*Point, Digits));
                     }
}
ObjectDelete("5dayHigh");
ObjectDelete("5dayLow");
ObjectDelete("5dayHigh2");
ObjectDelete("5dayLow2");

ObjectCreate("5dayHigh", OBJ_HLINE,0, CurTime(),phigh);
ObjectSet("5dayHigh",OBJPROP_COLOR,SpringGreen);
ObjectSet("5dayHigh",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("5dayHigh",OBJPROP_WIDTH,2);

ObjectCreate("5dayHigh2", OBJ_HLINE,0, CurTime(),phigh-Pips*Point);
ObjectSet("5dayHigh2",OBJPROP_COLOR,SpringGreen);
ObjectSet("5dayHigh2",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("5dayHigh2",OBJPROP_WIDTH,2);

ObjectCreate("5dayLow", OBJ_HLINE,0, CurTime(),plow);
ObjectSet("5dayLow",OBJPROP_COLOR,Red);
ObjectSet("5dayLow",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("5dayLow",OBJPROP_WIDTH,2);

ObjectCreate("5dayLow2", OBJ_HLINE,0, CurTime(),plow+Pips*Point);
ObjectSet("5dayLow2",OBJPROP_COLOR,Red);
ObjectSet("5dayLow2",OBJPROP_STYLE,STYLE_SOLID);
ObjectSet("5dayLow2",OBJPROP_WIDTH,2);
ObjectsRedraw();

   return(0);
  }
//+------------------------------------------------------------------